/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.XMLIterator;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class Array {
    protected Object[] data;
    protected int count = 0;
    protected boolean sorted = false;

    public Array(int initialCapacity) {
        this.data = new Object[initialCapacity];
    }

    public Array() {
        this(10);
    }

    public synchronized void copyInto(Object[] array) {
        System.arraycopy(this.data, 0, array, 0, this.count);
    }

    public synchronized void trimToSize() {
        if (this.data.length != this.count) {
            Object[] array = new Object[this.count];
            System.arraycopy(this.data, 0, array, 0, this.count);
            this.data = array;
        }
    }

    public void ensure(int capacity) {
        if (capacity > this.data.length) {
            int cap = Math.max(this.data.length << 1, capacity);
            Object[] array = new Object[cap];
            if (this.count > 0) {
                System.arraycopy(this.data, 0, array, 0, this.count);
            }
            this.data = array;
        }
    }

    public synchronized void ensureCapacity(int capacity) {
        this.ensure(capacity);
    }

    public synchronized void setSize(int size) {
        if (size < this.data.length) {
            Array.arrayclean(this.data, size, this.count - size);
        } else {
            this.ensure(size);
        }
        this.count = size;
    }

    public int capacity() {
        return this.data.length;
    }

    public int size() {
        return this.count;
    }

    public int count() {
        return this.count;
    }

    public boolean isEmpty() {
        return this.count == 0;
    }

    public synchronized XMLIterator elements() {
        if (this.count == 0) {
            return XMLIterator.empty;
        }
        return new ArrayIterator();
    }

    public Object[] internal() {
        return this.data;
    }

    public boolean contains(Object obj) {
        return this.indexOf(obj, 0) >= 0;
    }

    public int indexOf(Object obj) {
        return this.indexOf(obj, 0);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int indexOf(Object obj, int idx) {
        if (!this.sorted) ** GOTO lbl6
        return this.indexOfSorted(obj, idx);
lbl-1000:
        // 1 sources

        {
            if (this.isEqual(obj, this.data[idx])) {
                return idx;
            }
            ++idx;
lbl6:
            // 2 sources

            ** while (idx < this.count)
        }
lbl7:
        // 1 sources

        return -1;
    }

    public int indexOfSorted(Object obj) {
        return this.indexOfSorted(obj, 0);
    }

    public synchronized int indexOfSorted0(Object obj, int idx) {
        int low = idx;
        int high = this.count;
        while ((idx = low + high >> 1) != high) {
            if (this.isGreaterOrEqual(this.data[idx], obj)) {
                high = idx;
                continue;
            }
            low = idx + 1;
        }
        return idx;
    }

    public synchronized int indexOfSorted(Object obj, int idx) {
        if ((idx = this.indexOfSorted0(obj, idx)) >= this.count || !this.isEqual(obj, this.data[idx])) {
            return -1;
        }
        return idx;
    }

    public int indexOfID(Object obj) {
        return this.indexOfID(obj, 0);
    }

    public int indexOfID(Object obj, int idx) {
        while (idx < this.count) {
            if (obj == this.data[idx]) {
                return idx;
            }
            ++idx;
        }
        return -1;
    }

    public int lastIndexOf(Object obj) {
        return this.lastIndexOf(obj, this.count - 1);
    }

    /*
     * Unable to fully structure code
     */
    public synchronized int lastIndexOf(Object obj, int idx) {
        if (!this.sorted) ** GOTO lbl10
        pos = this.indexOfSorted(obj, 0);
        while (pos < idx && this.isEqual(obj, this.data[pos + 1])) {
            ++pos;
        }
        return pos;
lbl-1000:
        // 1 sources

        {
            if (this.isEqual(obj, this.data[idx])) {
                return idx;
            }
            --idx;
lbl10:
            // 2 sources

            ** while (idx >= 0)
        }
lbl11:
        // 1 sources

        return -1;
    }

    public int lastIndexOfID(Object obj) {
        return this.lastIndexOfID(obj, this.count - 1);
    }

    public int lastIndexOfID(Object obj, int idx) {
        while (idx >= 0) {
            if (obj == this.data[idx]) {
                return idx;
            }
            --idx;
        }
        return -1;
    }

    public Object at(int idx) {
        if (idx >= this.count) {
            throw new ArrayIndexOutOfBoundsException(idx + " >= " + this.count);
        }
        return this.data[idx];
    }

    public Object get(int idx) {
        return this.at(idx);
    }

    public synchronized Object elementAt(int idx) {
        return this.at(idx);
    }

    public synchronized Object firstElement() {
        return this.first();
    }

    public Object first() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.data[0];
    }

    public synchronized Object lastElement() {
        return this.last();
    }

    public Object last() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        return this.data[this.count - 1];
    }

    public synchronized void setElementAt(Object obj, int idx) {
        this.set(obj, idx);
    }

    public void set(Object obj, int idx) {
        if (idx >= this.count) {
            throw new ArrayIndexOutOfBoundsException(idx + " >= " + this.count);
        }
        this.data[idx] = obj;
    }

    public synchronized void removeElementAt(int idx) {
        this.remove(idx);
    }

    public void remove(int idx) {
        if ((idx & Integer.MAX_VALUE) >= this.count) {
            throw new ArrayIndexOutOfBoundsException(idx + " >= " + this.count);
        }
        int len = this.count - idx - 1;
        if (len > 0) {
            System.arraycopy(this.data, idx + 1, this.data, idx, len);
        }
        this.data[--this.count] = null;
    }

    public synchronized void insertElementAt(Object obj, int idx) {
        this.insert(obj, idx);
    }

    public void insert(Object obj, int idx) {
        if (idx > this.count) {
            throw new ArrayIndexOutOfBoundsException(idx + " > " + this.count);
        }
        if (this.count + 1 > this.data.length) {
            int cap = Math.max(this.data.length << 1, this.count + 1);
            Object[] array = new Object[cap];
            if (idx < this.count) {
                System.arraycopy(this.data, idx, array, idx + 1, this.count - idx);
            }
            if (idx > 0) {
                System.arraycopy(this.data, 0, array, 0, idx);
            }
            this.data = array;
        } else if (idx < this.count) {
            System.arraycopy(this.data, idx, this.data, idx + 1, this.count - idx);
        }
        this.data[idx] = obj;
        ++this.count;
    }

    public void add(Object obj) {
        if (this.sorted) {
            this.insert(obj, this.indexOfSorted0(obj, 0));
        } else {
            if (this.count >= this.data.length) {
                this.ensure(this.count + 1);
            }
            this.data[this.count++] = obj;
        }
    }

    public synchronized void addElement(Object obj) {
        this.add(obj);
    }

    public void addAll(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.add(enumeration.nextElement());
        }
    }

    public void addAll(Object[] objects) {
        int idx = 0;
        while (idx < objects.length) {
            this.add(objects[idx]);
            ++idx;
        }
    }

    public synchronized boolean removeElement(Object obj) {
        return this.remove(obj);
    }

    public boolean remove(Object obj) {
        int idx = this.indexOf(obj);
        if (idx >= 0) {
            this.removeElementAt(idx);
            return true;
        }
        return false;
    }

    public boolean replace(Object old, Object obj) {
        int idx = this.indexOf(old);
        if (idx >= 0) {
            this.data[idx] = obj;
            return true;
        }
        return false;
    }

    public void removeAll(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.remove(enumeration.nextElement());
        }
    }

    public synchronized void removeAllElements() {
        this.removeAll();
    }

    public void removeAll() {
        Array.arrayclean(this.data, 0, this.count);
        this.count = 0;
    }

    public Object push(Object obj) {
        this.add(obj);
        return obj;
    }

    public Object pop() {
        if (this.count == 0) {
            throw new NoSuchElementException();
        }
        Object res = this.data[--this.count];
        this.data[this.count] = null;
        return res;
    }

    public Object peek() {
        return this.count > 0 ? this.data[this.count - 1] : null;
    }

    public Object peek(int depth) {
        return this.count > depth ? this.data[this.count - 1 - depth] : null;
    }

    public void sort() {
        this.quickSort(this.data, 0, this.count);
        this.sorted = true;
    }

    public void ensureSorted() {
        if (!this.sorted) {
            this.sort();
        }
    }

    public void setUnsorted() {
        this.sorted = false;
    }

    protected boolean isEqual(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            return false;
        }
        return obj1.equals(obj2);
    }

    protected boolean isGreaterOrEqual(Object obj1, Object obj2) {
        if (obj1 == obj2) {
            return true;
        }
        if (obj1 == null) {
            return true;
        }
        if (obj2 == null) {
            return false;
        }
        return obj1.toString().compareTo(obj2.toString()) >= 0;
    }

    /*
     * Unable to fully structure code
     */
    public void quickSort(Object[] field, int lo0, int hi0) {
        block5: {
            lo = lo0;
            hi = --hi0;
            if (hi0 <= lo0) break block5;
            pivot = field[lo0 + hi0 >> 1];
            ** GOTO lbl16
            {
                ++lo;
                do {
                    if (lo < hi0 && !this.isGreaterOrEqual(field[lo], pivot)) continue block0;
                    while (hi > lo0 && !this.isGreaterOrEqual(pivot, field[hi])) {
                        --hi;
                    }
                    if (lo > hi) continue;
                    tmp = field[lo];
                    field[lo++] = field[hi];
                    field[hi--] = tmp;
lbl16:
                    // 3 sources

                } while (lo <= hi);
            }
        }
        if (lo0 < hi) {
            this.quickSort(field, lo0, hi + 1);
        }
        if (lo < hi0) {
            this.quickSort(field, lo, hi0 + 1);
        }
    }

    public static void arrayclean(Object[] array, int from, int length) {
        Array.arrayfill(array, null, from, length);
    }

    public static void arrayfill(Object[] array, Object value, int from, int length) {
        if (length < 10) {
            while (length-- > 0) {
                array[from + length] = value;
            }
        } else {
            array[from++] = value;
            array[from++] = value;
            array[from++] = value;
            array[from++] = value;
            array[from++] = value;
            array[from++] = value;
            array[from++] = value;
            array[from++] = value;
            int run = 8;
            from -= 8;
            while (run << 1 < length) {
                System.arraycopy(array, from, array, from + run, run);
                run <<= 1;
            }
            System.arraycopy(array, from, array, from + run, length - run);
        }
    }

    class ArrayIterator
    implements XMLIterator {
        int idx = 0;

        ArrayIterator() {
        }

        public boolean hasMoreElements() {
            return this.idx < Array.this.count;
        }

        public Object nextElement() {
            return Array.this.at(this.idx++);
        }

        public int available() {
            return Array.this.count - this.idx;
        }

        public XMLIterator reset() {
            this.idx = 0;
            return this;
        }
    }
}

