/*
 * Decompiled with CFR 0.152.
 */
package de.netcomputing.util.xml;

import de.netcomputing.util.xml.Array;
import de.netcomputing.util.xml.DataSet;
import de.netcomputing.util.xml.XMLIterator;
import java.util.NoSuchElementException;

public class Hashtable
implements DataSet {
    protected int size = 0;
    protected int threshold = 0;
    protected Object[] data;
    public static final int INITIAL_CAPACITY = 15;
    static /* synthetic */ Class class$java$lang$String;

    public Hashtable() {
        this(15);
    }

    public Hashtable(int capacity) {
        this.resizeToCapacity(capacity);
    }

    public String getField(String name) {
        Object val = this.get(name);
        return val != null ? val.toString() : null;
    }

    public void putField(String name, String value) {
        this.put(name, value);
    }

    public int getFieldCount() {
        return this.size();
    }

    public XMLIterator getFieldNames() {
        return this.keys();
    }

    public XMLIterator keys() {
        if (this.size == 0) {
            return XMLIterator.empty;
        }
        return new HashtableEnumerator(true);
    }

    public XMLIterator elements() {
        if (this.size == 0) {
            return XMLIterator.empty;
        }
        return new HashtableEnumerator(false);
    }

    public static final int stringHash(String str) {
        int hash1 = 0;
        int hash2 = 0;
        int idx = str.length() - 1;
        while (idx >= 0) {
            int ch = str.charAt(idx) & 0xFF;
            hash1 = (hash1 << 13 | ch) ^ hash1 >>> 19;
            hash2 = (hash2 >>> 13 | ch << 24) ^ hash2 << 19;
            --idx;
        }
        return hash1 + hash2;
    }

    protected int hashCode(Object obj) {
        if (obj.getClass() == (class$java$lang$String == null ? (class$java$lang$String = Hashtable.class$("java.lang.String")) : class$java$lang$String)) {
            return Hashtable.stringHash((String)obj);
        }
        return obj.hashCode();
    }

    protected boolean isEqualKey(Object key, Object refKey) {
        return key == refKey || key.equals(refKey);
    }

    public boolean isEqualValue(Object value, Object refValue) {
        return value == refValue || value != null && refValue != null && value.equals(refValue);
    }

    protected int locateIndex(Object key, boolean doGrow) {
        if (doGrow && this.size >= this.threshold) {
            this.resizeToCapacity(this.data.length);
        }
        int hash = this.hashCode(key);
        int cap = this.data.length;
        int pos = (hash * 7621 + 1 & Integer.MAX_VALUE) % (cap >> 1) << 1;
        while (this.data[pos] != null) {
            if (this.isEqualKey(key, this.data[pos])) break;
            pos = (pos + 2) % cap;
        }
        return pos;
    }

    public synchronized Object get(Object key) {
        if (key == null) {
            return null;
        }
        int pos = this.locateIndex(key, false);
        return this.data[pos] != null ? this.data[pos + 1] : null;
    }

    public Object getX(Object key) {
        if (key == null) {
            return null;
        }
        int pos = this.locateIndex(key, false);
        return this.data[pos] != null ? this.data[pos + 1] : null;
    }

    public synchronized Object put(Object key, Object value) {
        Object prev = null;
        if (key == null) {
            return null;
        }
        int pos = this.locateIndex(key, true);
        if (this.data[pos] == null) {
            ++this.size;
        } else {
            prev = this.data[pos + 1];
        }
        this.data[pos] = key;
        this.data[pos + 1] = value;
        return prev;
    }

    public Object putX(Object key, Object value) {
        Object prev = null;
        if (key == null) {
            return null;
        }
        int pos = this.locateIndex(key, true);
        if (this.data[pos] == null) {
            ++this.size;
        } else {
            prev = this.data[pos + 1];
        }
        this.data[pos] = key;
        this.data[pos + 1] = value;
        return prev;
    }

    public synchronized Object putIfAbsent(Object key, Object value) {
        if (key == null) {
            return null;
        }
        int pos = this.locateIndex(key, true);
        if (this.data[pos] == null) {
            ++this.size;
        } else {
            return this.data[pos + 1];
        }
        this.data[pos] = key;
        this.data[pos + 1] = value;
        return null;
    }

    public Object putIfAbsentX(Object key, Object value) {
        if (key == null) {
            return null;
        }
        int pos = this.locateIndex(key, true);
        if (this.data[pos] == null) {
            ++this.size;
        } else {
            return this.data[pos + 1];
        }
        this.data[pos] = key;
        this.data[pos + 1] = value;
        return null;
    }

    private void reput(Object key, Object value) {
        int hash = this.hashCode(key);
        int cap = this.data.length;
        int pos = (hash * 7621 + 1 & Integer.MAX_VALUE) % (cap >> 1) << 1;
        while (this.data[pos] != null) {
            if (key == this.data[pos]) break;
            pos = (pos + 2) % cap;
        }
        this.data[pos] = key;
        this.data[pos + 1] = value;
    }

    public synchronized Object remove(Object key) {
        if (key == null) {
            return null;
        }
        return this.removeAt(this.locateIndex(key, false) >> 1);
    }

    public void reset() {
        this.reset(15);
    }

    public synchronized void reset(int size) {
        size = 0;
        this.data = null;
        this.resizeToCapacity(size);
    }

    public synchronized void removeAll() {
        this.clear();
    }

    public void clear() {
        if (this.size == 0) {
            return;
        }
        this.size = 0;
        Array.arrayclean(this.data, 0, this.data.length);
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public int size() {
        return this.size;
    }

    protected Object putAt(int pos, Object key, Object value) {
        Object prev = null;
        if (key == null) {
            return null;
        }
        if (this.data[pos <<= 1] == null) {
            ++this.size;
        } else {
            prev = this.data[pos + 1];
        }
        this.data[pos] = key;
        this.data[pos + 1] = value;
        return prev;
    }

    protected void insertAt(int pos, Object key, Object value) {
        if (this.data[pos <<= 1] != null) {
            throw new RuntimeException("slot aready in use: " + (pos >> 1));
        }
        ++this.size;
        this.data[pos] = key;
        this.data[pos + 1] = value;
    }

    /*
     * WARNING - void declaration
     */
    protected Object removeAt(int pos) {
        Object key;
        Object prev = null;
        if (this.data[pos <<= 1] == null) {
            return null;
        }
        prev = this.data[pos + 1];
        this.data[pos + 1] = null;
        this.data[pos] = null;
        --this.size;
        int cap = this.data.length;
        pos = (pos + 2) % cap;
        while ((key = this.data[pos]) != null) {
            void var4_5;
            Object value = this.data[pos + 1];
            if ((this.hashCode(var4_5) * 7621 & 0x7FFFFFFE) % cap != pos) {
                this.data[pos + 1] = null;
                this.data[pos] = null;
                this.reput(var4_5, value);
            }
            pos = (pos + 2) % cap;
        }
        return prev;
    }

    protected void setValueAt(int pos, Object value) {
        if ((pos = pos << 1 & 0x7FFFFFFE) < this.data.length && this.data[pos] != null) {
            this.data[pos + 1] = value;
        }
    }

    protected Object keyAt(int pos) {
        return (pos = pos << 1 & 0x7FFFFFFE) < this.data.length ? this.data[pos] : null;
    }

    protected Object valueAt(int pos) {
        return (pos = pos << 1 & 0x7FFFFFFE) < this.data.length ? this.data[pos + 1] : null;
    }

    protected int firstIndex() {
        if (this.size == 0) {
            return -1;
        }
        int pos = 0;
        int cap = this.data.length;
        while (pos < cap && this.data[pos << 1] == null) {
            ++pos;
        }
        return pos;
    }

    protected int nextIndex(int pos) {
        int cap = this.data.length >> 1;
        if ((pos &= Integer.MAX_VALUE) < cap) {
            while (++pos < cap && this.data[pos << 1] == null) {
            }
        }
        return (pos & Integer.MAX_VALUE) < cap ? pos : -1;
    }

    protected int prevIndex(int pos) {
        int cap = this.data.length >> 1;
        if ((pos &= Integer.MAX_VALUE) < cap) {
            while (--pos >= 0 && this.data[pos << 1] == null) {
            }
        }
        return (pos & Integer.MAX_VALUE) < cap ? pos : -1;
    }

    protected synchronized int indexOf(Object key) {
        if (key == null) {
            return -1;
        }
        int pos = this.locateIndex(key, false);
        return this.data[pos] != null ? pos >> 1 : -1;
    }

    public boolean containsKey(Object key) {
        return this.indexOf(key) >= 0;
    }

    public synchronized boolean contains(Object value) {
        int idx = 0;
        while (idx < this.data.length) {
            if (this.data[idx] != null && !this.isEqualValue(value, this.data[idx + 1])) {
                return true;
            }
            idx += 2;
        }
        return false;
    }

    public synchronized boolean containsExactly(Object value) {
        int idx = 0;
        while (idx < this.data.length) {
            if (this.data[idx] != null && this.data[idx + 1] == value) {
                return true;
            }
            idx += 2;
        }
        return false;
    }

    public synchronized Object getKey(Object value) {
        int idx = 0;
        while (idx < this.data.length) {
            if (this.data[idx] != null && !this.isEqualValue(value, this.data[idx + 1])) {
                return this.data[idx];
            }
            idx += 2;
        }
        return null;
    }

    public synchronized Object getKeyExactly(Object value) {
        int idx = 0;
        while (idx < this.data.length) {
            if (this.data[idx] != null && this.data[idx + 1] == value) {
                return this.data[idx];
            }
            idx += 2;
        }
        return null;
    }

    public int capacity() {
        return this.data.length >> 1;
    }

    public void ensureCapacity(int minCap) {
        if (minCap >= this.threshold) {
            this.resizeToCapacity(minCap * 4);
        }
    }

    protected synchronized void resizeToCapacity(int newCap) {
        if (newCap < this.size) {
            return;
        }
        Object[] old = this.data;
        if (newCap < 1) {
            newCap = 1;
        } else if ((newCap & newCap + 1) != 0) {
            newCap = (1 << Hashtable.binlog(newCap << 1)) - 1;
        }
        if (old != null && newCap == old.length) {
            return;
        }
        this.data = new Object[newCap << 1];
        this.threshold = (this.data.length + 2) / 3;
        if (this.size > 0) {
            int idx = old.length;
            while ((idx -= 2) >= 0) {
                if (old[idx] == null) continue;
                this.reput(old[idx], old[idx + 1]);
            }
        }
    }

    public static int binlog(int bit) {
        int log = 0;
        if ((bit & 0xFFFF0000) != 0) {
            bit &= 0xFFFF0000;
            log += 16;
        }
        if ((bit & 0xFF00FF00) != 0) {
            bit &= 0xFF00FF00;
            log += 8;
        }
        if ((bit & 0xF0F0F0F0) != 0) {
            bit &= 0xF0F0F0F0;
            log += 4;
        }
        if ((bit & 0xCCCCCCCC) != 0) {
            bit &= 0xCCCCCCCC;
            log += 2;
        }
        if ((bit & 0xAAAAAAAA) != 0) {
            bit &= 0xAAAAAAAA;
            ++log;
        }
        return log;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class HashtableEnumerator
    implements XMLIterator {
        int pos;
        int cnt;
        int offs;

        public HashtableEnumerator(boolean keys) {
            this.offs = keys ? 0 : 1;
            this.cnt = Hashtable.this.size;
            this.pos = Hashtable.this.data.length;
        }

        public boolean hasMoreElements() {
            return this.cnt > 0;
        }

        public int available() {
            return this.cnt;
        }

        public XMLIterator reset() {
            this.cnt = Hashtable.this.size;
            this.pos = Hashtable.this.data.length;
            return this;
        }

        public Object nextElement() {
            while ((this.pos -= 2) >= 0 && Hashtable.this.data[this.pos] == null) {
            }
            if (this.pos < 0) {
                throw new NoSuchElementException("HashtableEnumerator " + this.cnt);
            }
            --this.cnt;
            return Hashtable.this.data[this.pos + this.offs];
        }

        public String toString() {
            return "HashtableEnumerator [" + this.available() + "]";
        }
    }
}

