/*
 * Decompiled with CFR 0.152.
 */
package editapp;

import JCollections.JArray;
import JCollections.JSortedArray;
import JWVFile.VFile;
import de.netcomputing.anyj.AJIDEOptions;
import de.netcomputing.anyj.filenodes.FileType;
import de.netcomputing.anyj.jwidgets.BrightnessFilter;
import de.netcomputing.anyj.jwidgets.IListItem;
import de.netcomputing.anyj.jwidgets.ListItem;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.anyj.jwidgets.NCPanel;
import de.netcomputing.anyj.services.ServiceUtilities;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import editapp.FieldsNode;
import editapp.FileEntry;
import editapp.FileRegistry;
import editapp.IndexEntry;
import editapp.SourceBase;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.FilteredImageSource;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Enumeration;
import jxeplugins.FileSetupEntry;
import netcomputing.tools.Platforms;

public class ProjectNode
extends ListItem
implements FilenameFilter {
    String file;
    boolean hasContent = false;
    Image openImage;
    FileType myType;
    int cachedType = -1;
    static final int IsWebAppHome = 1;
    static final int IsModuleDeploy = 2;
    static final int IsHome = 3;
    static final int IsWebApp = 4;
    static final int IsEJBModule = 5;
    static final int IsNoType = 6;

    public ProjectNode(File f) {
        super(f);
        this.file = f.getAbsolutePath();
        if (this.file != null && (this.isDir() || this.file.endsWith(")"))) {
            this.hasContent = true;
            this.im = null;
            FileSetupEntry fse = EditApp.App.getOptionsFor(this.file);
            if (fse != null) {
                if (fse.checkForChanges && fse.doScan()) {
                    this.im = NCApplication.GetImage("lbox-ws-active");
                    this.openImage = NCApplication.GetImage("lbox-ws-active");
                } else if (fse.doScan()) {
                    this.im = NCApplication.GetImage("lbox-ws");
                    this.openImage = NCApplication.GetImage("lbox-ws-open");
                } else if (fse.checkForChanges && !fse.doScan()) {
                    this.im = NCApplication.GetImage("lbox-arrow-active");
                    this.openImage = NCApplication.GetImage("lbox-arrow-active-open");
                }
            }
            if (this.im == null) {
                if (this.file.toLowerCase().endsWith(".jar") || this.file.toLowerCase().endsWith(".zip")) {
                    this.openImage = this.im = NCApplication.GetImage("/images/filetypes/jar.gif");
                    this.hasContent = false;
                } else {
                    this.im = NCApplication.GetImage("lbox-arrow");
                    this.openImage = NCApplication.GetImage("lbox-arrow-open");
                }
            }
        } else if (this.file != null) {
            FileSetupEntry fse;
            String ext = VFile.Extension(this.file);
            FileType type = FileType.Named(ext.toLowerCase());
            String basicImage = type == null ? ext : type.getImageName();
            int modtype = 0;
            if (!new File(this.file).canWrite()) {
                modtype |= 1;
            }
            if ((fse = EditApp.App.getOptionsFor(this.file)) != null && type != null && (type.getExtension().equals("java") || type.getExtension().equals("jar") || type.getExtension().equals("class") || type.getExtension().equals("zip"))) {
                if (fse.doScan()) {
                    this.hasContent = AJIDEOptions.This.getExpandFileTree() || type.getExtension().equals("jar") || type.getExtension().equals("zip");
                } else {
                    this.hasContent = false;
                    modtype |= 2;
                }
                if (fse.checkForChanges) {
                    modtype |= 4;
                }
            } else if (type != null) {
                this.myType = type;
                this.hasContent = this.myType.hasContent();
            }
            this.im = NCApplication.GetImage("/images/filetypes/" + basicImage + ".gif");
            this.im = this.getColoredIcon(this.im, modtype);
        }
    }

    public Image getImage() {
        this.setOptImage();
        return super.getImage();
    }

    void setOptImage() {
        if (this.file != null && (this.isDir() || this.file.endsWith(")"))) {
            File tmpFile = new File(this.file);
            if (tmpFile.isDirectory()) {
                this.hasContent = true;
            }
            this.im = null;
            FileSetupEntry fse = EditApp.App.getOptionsFor(this.file);
            if (fse != null) {
                if (this.file.endsWith(".jar") || this.file.endsWith(".zip")) {
                    this.hasContent = false;
                }
                if (fse.checkForChanges && fse.doScan()) {
                    this.im = NCApplication.GetImage("lbox-ws-active");
                    this.openImage = NCApplication.GetImage("lbox-ws-active");
                } else if (fse.doScan()) {
                    this.im = NCApplication.GetImage("lbox-ws");
                    this.openImage = NCApplication.GetImage("lbox-ws-open");
                    this.hasContent = true;
                } else if (fse.checkForChanges && !fse.doScan()) {
                    this.im = NCApplication.GetImage("lbox-arrow-active");
                    this.openImage = NCApplication.GetImage("lbox-arrow-active-open");
                } else if (this.cachedType != 6) {
                    if (this.cachedType == 1 || ServiceUtilities.IsWebAppHome(tmpFile)) {
                        this.im = NCApplication.GetImage("/images/webapphome.gif");
                        this.openImage = NCApplication.GetImage("/images/webapphome-open.gif");
                        this.cachedType = 1;
                    } else if (this.cachedType == 2 || ServiceUtilities.IsModuleDeploy(tmpFile)) {
                        this.im = NCApplication.GetImage("/images/webapp.gif");
                        this.openImage = NCApplication.GetImage("/images/webapp-open.gif");
                        this.cachedType = 2;
                    } else if (this.cachedType == 3 || tmpFile.getName().equals("ROOT") && tmpFile.getParentFile().getName().equals("webapps")) {
                        this.im = NCApplication.GetImage("/images/home.gif");
                        this.openImage = NCApplication.GetImage("/images/home.gif");
                        this.cachedType = 3;
                    } else if (this.cachedType == 4 || ServiceUtilities.IsWebApp(tmpFile)) {
                        this.im = NCApplication.GetImage("/images/webapp.gif");
                        this.openImage = NCApplication.GetImage("/images/webapp-open.gif");
                        this.cachedType = 4;
                    } else if (this.cachedType == 5 || ServiceUtilities.IsEJBModule(tmpFile)) {
                        this.im = NCApplication.GetImage("/images/ejbmodule.gif");
                        this.openImage = NCApplication.GetImage("/images/ejbmodule-open.gif");
                        this.cachedType = 5;
                    } else {
                        this.cachedType = 6;
                    }
                }
            }
            if (this.im == null) {
                if (this.file.toLowerCase().endsWith(".jar") || this.file.toLowerCase().endsWith(".zip")) {
                    this.openImage = this.im = NCApplication.GetImage("/images/filetypes/jar.gif");
                } else if (!this.file.endsWith(")")) {
                    this.im = NCApplication.GetImage("lbox-arrow");
                    this.openImage = NCApplication.GetImage("lbox-arrow-open");
                } else {
                    this.im = NCApplication.GetImage("lbox-ws");
                    this.openImage = NCApplication.GetImage("lbox-ws-open");
                }
            }
        }
    }

    Image getColoredIcon(Image im, int type) {
        if (im == null) {
            im = NCApplication.GetImage("/images/filetypes/default.gif");
        }
        if (im != null) {
            Image realIm = im;
            if ((type & 1) == 1) {
                realIm = EditApp.App.jol.fileList.createImage(new FilteredImageSource(im.getSource(), new BrightnessFilter(50, 50, 120, 20)));
            } else if ((type & 2) == 2) {
                realIm = im;
            } else {
                return im;
            }
            NCApplication.WaitForImage(realIm);
            im = realIm;
        }
        return im;
    }

    public Image getOpenImage() {
        if (this.openImage != null) {
            return this.openImage;
        }
        return this.getImage();
    }

    public FileType getType() {
        if (this.isDir()) {
            return null;
        }
        return FileType.Named(VFile.Extension(this.file));
    }

    public boolean isDir() {
        return new File(this.file).isDirectory() || this.file.endsWith(".zip") || this.file.endsWith(".jar");
    }

    public void itemHasCollapsed() {
        this.cont = null;
    }

    public IListItem[] contents() {
        this.constructContent();
        return super.contents();
    }

    public boolean isSourceFile() {
        return FileType.Named(VFile.Extension(this.file)).isSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void constructContent() {
        String fname = this.file;
        if (fname.endsWith(".jar") || fname.endsWith(".zip") || fname.endsWith(".JAR") || fname.endsWith(".ZIP")) {
            Tracer.This.println(" jar zip opened ...");
            Enumeration en = FileRegistry.This.enumerate();
            JSortedArray arr = new JSortedArray(new JArray(100), JArray.StringSortFunc());
            while (en.hasMoreElements()) {
                FileEntry fe = (FileEntry)en.nextElement();
                if (!fe.fullPath.startsWith(fname) || fe.size() <= 0) continue;
                arr.add(fe.fullPath);
            }
            if (arr.size() == 0 && !EditApp.Resetting && !FileRegistry.This.get(fname).isUpToDate() && EditApp.App.getOptionsFor(fname).doScan()) {
                try {
                    EditApp.App.jol.scanJarWithPopup(fname, arr);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.cont = new IListItem[arr.size()];
            int n = 0;
            while (n < arr.size()) {
                ProjectNode newOne = new ProjectNode(new File(arr.at(n).toString())){

                    public String getDisplayString() {
                        String s = super.getDisplayString();
                        int i = s.indexOf("(");
                        if (i >= 0) {
                            s = s.substring(i);
                        }
                        return s;
                    }
                };
                this.cont[n] = newOne;
                newOne.hasContent = true;
                ++n;
            }
        } else if (this.isDir()) {
            Object[] files = new File(this.file).list(this);
            this.cont = new IListItem[files.length];
            JArray arr = new JArray(files.length + 1);
            arr.addAll(files);
            JArray.QuickSort(arr, JArray.UpperCaseStringSortFunc());
            int n = 0;
            while (n < arr.size()) {
                arr.setAt(n, new ProjectNode(new File(this.file, arr.at(n).toString())));
                ++n;
            }
            int contCnt = 0;
            int n2 = 0;
            while (n2 < arr.size()) {
                if (((ProjectNode)arr.at(n2)).isDir()) {
                    this.cont[contCnt++] = (IListItem)arr.at(n2);
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < arr.size()) {
                if (!((ProjectNode)arr.at(n3)).isDir()) {
                    this.cont[contCnt++] = (IListItem)arr.at(n3);
                }
                ++n3;
            }
        } else if (this.myType != null) {
            this.cont = this.myType.constructContent(new File(this.file));
        } else if (AJIDEOptions.This.getExpandFileTree()) {
            int i;
            String fileAbsolutePath = this.file;
            if (fileAbsolutePath.endsWith(")") && (i = fileAbsolutePath.lastIndexOf("(")) >= 0) {
                fileAbsolutePath = fileAbsolutePath.substring(0, i) + fileAbsolutePath.substring(i).replace('\\', '/');
            }
            JArray res = SourceBase.This().classDefinitionsIn(fileAbsolutePath);
            Tracer.This.println("query classDefinitionsIn" + fileAbsolutePath);
            if (res.size() == 0 || SourceBase.This().shouldUpdate(new File(this.file))) {
                try {
                    EditApp.App.jol.cursorWait();
                    SourceBase.This().update(fileAbsolutePath, true);
                    res = SourceBase.This().classDefinitionsIn(fileAbsolutePath);
                    Object var9_17 = null;
                }
                catch (Throwable throwable) {
                    Object var9_18 = null;
                    EditApp.App.jol.cursorDefault();
                    throw throwable;
                }
                EditApp.App.jol.cursorDefault();
                {
                }
            }
            this.cont = new IListItem[res.size()];
            if (res.size() == 1 && !fname.endsWith(")")) {
                Tracer.This.println("weg 1");
                this.cont = FieldsNode.methodItemsOf(((IndexEntry)res.at(0)).fieldName(), ((IndexEntry)res.at(0)).realPackage());
            } else {
                Tracer.This.println("weg 2");
                int n = 0;
                while (n < res.size()) {
                    IndexEntry ie = (IndexEntry)res.at(n);
                    this.cont[n] = new FieldsNode(ie.fieldName(), ie);
                    ((ListItem)this.cont[n]).im = NCApplication.GetImage("lbox-class");
                    ++n;
                }
            }
        }
        if (this.cont == null) {
            this.cont = new IListItem[0];
            this.hasContent = false;
        }
    }

    public void paint(Graphics g, NCPanel sender, boolean selected, boolean isExpanded, int index) {
        super.paint(g, sender, selected, isExpanded, index);
    }

    public String getDisplayString() {
        String display = null;
        if (this.isDir()) {
            display = this.getDepth() > 1 ? VFile.NameWithExtension(this.file) : this.file;
        } else {
            display = VFile.NameWithExtension(this.file);
            if (display.endsWith(")")) {
                display = this.file;
            }
        }
        return display;
    }

    public boolean hasContent() {
        return this.hasContent;
    }

    public boolean accept(File dir, String _name) {
        if (EditApp.App.jol.fileView.showAll()) {
            return true;
        }
        String name = Platforms.IsLinux() ? _name : _name.toLowerCase();
        File f = new File(dir, name);
        FileSetupEntry fse = EditApp.App.getOptionsFor(f.getAbsolutePath());
        if (name.endsWith(".java") || name.endsWith(".class")) {
            if (fse == null) {
                return name.endsWith(".java");
            }
            return !fse.scanClasses && name.endsWith(".java") || fse.scanClasses && name.endsWith(".class");
        }
        return f.isDirectory() && FileType.This.acceptDir(dir, name) || FileType.This.accept(dir, name);
    }
}

