/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.ComboBoxItem;
import horst.ContextChecker;
import horst.Element;
import horst.FormProcessor;
import horst.HTMLPane;
import horst.TagStack;
import horst.TextAttributes;
import horst.Utilities;
import horst.parser.ParserCallback;
import horst.parser.Tag;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class HTMLDocument
implements ParserCallback {
    protected String m_title = "";
    protected Color m_linkColor = Color.blue;
    protected Color m_textColor = Color.black;
    protected Color m_alinkColor = Color.red;
    protected URL m_url;
    protected URL m_baseURL;
    protected TagStack m_tagStack = new TagStack();
    protected Stack m_characterStack = new Stack();
    protected Element m_rootElement;
    protected Element m_baseElement;
    protected HTMLDocument m_thisDoc;
    protected String[] m_fontList;
    protected Object m_formModel;
    protected ComboBoxItem m_comboItem;
    protected boolean m_bInOption = false;
    protected boolean m_bInAnchor = false;
    protected boolean m_bInTextArea = false;
    protected boolean m_bInIFrame = false;
    protected boolean m_bInTitle = false;
    protected boolean m_bInPreformat = false;
    protected Vector m_relatedElements = new Vector();
    protected Vector m_formProcessors = new Vector();
    protected HTMLPane m_renderer;
    protected FormProcessor m_form;
    protected StringBuffer m_textbuffer;
    protected Vector m_mapElements = new Vector();
    protected File m_sourceFile;
    protected URL m_refreshURL;
    protected Vector m_anchors = new Vector();
    protected boolean m_bPrintTree = false;
    private static PrintWriter pwOut;
    private static int indent;

    public HTMLDocument(HTMLPane renderer) {
        this.m_renderer = renderer;
        this.m_fontList = Toolkit.getDefaultToolkit().getFontList();
        this.m_bInOption = false;
        this.m_thisDoc = this;
        this.m_baseElement = new Element(53);
        this.m_textbuffer = new StringBuffer();
    }

    final void checkOptionContext() {
        if (this.m_bInOption && this.m_formModel instanceof DefaultComboBoxModel && this.m_comboItem != null) {
            ((DefaultComboBoxModel)this.m_formModel).addElement(this.m_comboItem);
        }
    }

    public static void closeLog() {
        if (pwOut != null) {
            pwOut.close();
            pwOut = null;
        }
    }

    protected TextAttributes createDefaultTextAttributes() {
        TextAttributes atts = new TextAttributes(this.m_renderer.m_props.m_defaultFont);
        atts.color = this.m_textColor;
        return atts;
    }

    protected void doStartElementTrap(Element elem) {
        int type = elem.getType();
        switch (type) {
            default: {
                break;
            }
            case 39: {
                int idx;
                String content;
                String httpequiv = (String)elem.getAttribute("http-equiv");
                if (httpequiv == null || !httpequiv.equalsIgnoreCase("Refresh") || (content = (String)elem.getAttribute("content")) == null || (idx = (content = content.toLowerCase()).indexOf("url=")) < 0) break;
                String urlStr = content.substring(idx + 4).trim();
                this.m_refreshURL = Utilities.getURL(urlStr);
                break;
            }
            case 47: {
                this.m_mapElements.addElement(elem);
                break;
            }
            case 50: {
                this.m_anchors.addElement(elem);
            }
        }
    }

    public Element findElement(int type, String attribute, String value) {
        if (this.m_rootElement != null) {
            return this.getElement(this.m_rootElement, type, attribute, value);
        }
        return null;
    }

    public void finishedParsing() {
        if (this.m_rootElement != null) {
            int nChildCount = this.m_rootElement.getElementCount();
            if (nChildCount == 1) {
                this.m_rootElement = this.m_rootElement.getElementAt(0);
            } else {
                this.m_rootElement.m_type = 0;
            }
            this.m_rootElement.setDocument(this);
            if (this.m_rootElement.getType() != 0) {
                Element save = this.m_rootElement;
                this.m_rootElement = new Element(0);
                this.m_rootElement.addChild(save);
            }
            if (this.m_bPrintTree) {
                this.printTree(this.m_rootElement, 0);
            }
        }
        HTMLDocument.closeLog();
    }

    public Element getAnchor(String name) {
        Enumeration enumeration = this.m_anchors.elements();
        while (enumeration.hasMoreElements()) {
            Element elem = (Element)enumeration.nextElement();
            String val = (String)elem.getAttribute("name");
            if (val == null || !val.equalsIgnoreCase(name)) continue;
            return elem;
        }
        return null;
    }

    public Enumeration getAnchors() {
        return this.m_anchors.elements();
    }

    public Element getBaseElement() {
        return this.m_baseElement;
    }

    public URL getBaseURL() {
        return this.m_baseURL;
    }

    protected String getDefaultFontFace() {
        return this.m_renderer.m_props.m_defaultFont.getFamily();
    }

    protected int getDefaultFontSize() {
        return this.m_renderer.m_props.m_defaultFont.getSize();
    }

    private Element getElement(Element e, int type, String attribute, String value) {
        if (e.getType() == type && e.isAttributeDefined(attribute) && ((String)e.getAttribute(attribute)).equals(value)) {
            return e;
        }
        int nChildren = e.getElementCount();
        int i = 0;
        while (i < nChildren) {
            Element result = this.getElement(e.getElementAt(i), type, attribute, value);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    protected String getElementName(Element e) {
        return e.getName();
    }

    public Vector getFormProcessors() {
        return this.m_formProcessors;
    }

    public Color getLinkColor() {
        return this.m_linkColor;
    }

    public Element getMapElement(Element areaElem) {
        Enumeration enumeration = this.m_mapElements.elements();
        while (enumeration.hasMoreElements()) {
            Element elem = (Element)enumeration.nextElement();
            Vector v = elem.getChildren();
            int i = 0;
            while (i < v.size()) {
                if (v.elementAt(i) == areaElem) {
                    return elem;
                }
                ++i;
            }
        }
        return null;
    }

    public Enumeration getMapElements() {
        return this.m_mapElements.elements();
    }

    public Element getRootElement() {
        return this.m_rootElement;
    }

    protected TextAttributes getTextAttributes(Tag t) {
        TextAttributes atts = null;
        atts = !this.m_characterStack.empty() ? new TextAttributes((TextAttributes)this.m_characterStack.peek()) : this.createDefaultTextAttributes();
        atts.lastTag = t;
        return atts;
    }

    public StringBuffer getTextBuffer() {
        return this.m_textbuffer;
    }

    public Color getTextColor() {
        return this.m_textColor;
    }

    public String getTitle() {
        return this.m_title;
    }

    public URL getURL() {
        return this.m_url;
    }

    protected TextAttributes handleAnchor(Tag t, boolean bStart) {
        this.m_bInAnchor = bStart;
        TextAttributes atts = null;
        if (bStart) {
            String target;
            atts = this.getTextAttributes(t);
            String href = (String)t.getAttribute("href");
            if (href != null) {
                atts.color = this.m_linkColor;
                atts.bUnderline = true;
                URL u = Utilities.getURL(this.m_baseURL, href);
                atts.href = u != null ? u.toString() : href;
            }
            if ((target = (String)t.getAttribute("target")) != null) {
                atts.target = target;
            }
        } else {
            int sz;
            int j;
            Object[] elems = new Element[this.m_relatedElements.size()];
            this.m_relatedElements.copyInto(elems);
            if (elems.length > 1) {
                int i = 0;
                while (i < elems.length) {
                    Object currentElem = elems[i];
                    j = 0;
                    while (j < elems.length) {
                        if (currentElem != elems[j]) {
                            ((Element)elems[j]).addRelatedElement((Element)currentElem);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            if (elems.length > 0 && (sz = this.m_anchors.size()) > 0) {
                Element currAnchor = (Element)this.m_anchors.elementAt(sz - 1);
                j = 0;
                while (j < elems.length) {
                    currAnchor.addRelatedElement((Element)elems[j]);
                    ((Element)elems[j]).m_anchor = currAnchor;
                    ++j;
                }
            }
            this.m_relatedElements.removeAllElements();
            if (!this.m_characterStack.empty()) {
                this.m_characterStack.pop();
            }
        }
        if (bStart) {
            Element elem = new Element(t.getID());
            this.setBufferPointers(elem);
            elem.setDocument(this);
            elem.setAttributes(t.getAttributesCopy());
            this.m_anchors.addElement(elem);
            if (!this.m_tagStack.empty()) {
                ((Element)this.m_tagStack.peek()).addChild(elem);
            } else {
                this.m_tagStack.push(elem);
            }
        }
        return atts;
    }

    protected void handleBlockEnd(Tag t) {
        switch (t.getID()) {
            case 32: {
                this.m_bInTextArea = false;
                this.m_formModel = null;
                break;
            }
            case 54: {
                this.checkOptionContext();
                this.m_bInOption = false;
                this.m_comboItem = null;
                break;
            }
            case 31: {
                this.m_formModel = null;
                break;
            }
            case 67: {
                this.m_bInIFrame = false;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 64: {
                if (this.m_characterStack.empty()) break;
                this.m_characterStack.pop();
                break;
            }
            case 13: {
                this.m_bInTitle = false;
                return;
            }
        }
        if (!this.m_tagStack.empty()) {
            Element stackElem = (Element)this.m_tagStack.peek();
            if (stackElem.getType() == t.getID()) {
                this.m_tagStack.pop();
            } else {
                switch (t.getID()) {
                    case 3: 
                    case 5: 
                    case 8: 
                    case 12: {
                        if (stackElem.getType() != 6 || this.m_tagStack.size() <= 1) break;
                        Element paraElem = (Element)this.m_tagStack.pop();
                        stackElem = (Element)this.m_tagStack.peek();
                        if (stackElem.getType() == t.getID()) {
                            this.m_tagStack.pop();
                            break;
                        }
                        this.m_tagStack.push(paraElem);
                        break;
                    }
                    case 6: {
                        break;
                    }
                    case 1: {
                        int[] tagIDs = new int[]{1, 0};
                        Element e = this.m_tagStack.getFirstElementType(tagIDs);
                        if (e == null || e.getType() != 1) break;
                        this.m_tagStack.popElement(e);
                        break;
                    }
                    default: {
                        Element ee = this.m_tagStack.getElementType(t.getID());
                        if (ee == null) break;
                        this.m_tagStack.popElement(ee);
                        break;
                    }
                }
            }
        }
    }

    protected void handleBlockStart(Tag t) {
        int contextCheck;
        int sz;
        if (this.m_tagStack.empty() && t.getID() != 1 && t.getID() != 0) {
            this.m_rootElement = new Element(0);
            this.setBufferPointers(this.m_rootElement);
            this.m_tagStack.push(this.m_rootElement);
        }
        switch (t.getID()) {
            default: {
                break;
            }
            case 2: 
            case 5: {
                this.m_characterStack.push(this.createDefaultTextAttributes());
                break;
            }
            case 4: {
                TextAttributes textAtts = this.createDefaultTextAttributes();
                textAtts.font = new Font(this.getDefaultFontFace(), 1, this.getDefaultFontSize());
                this.m_characterStack.push(textAtts);
                break;
            }
            case 27: {
                Element stackElem;
                if (this.m_tagStack.empty() || (stackElem = (Element)this.m_tagStack.peek()).getType() != 27) break;
                this.m_tagStack.pop();
                break;
            }
            case 30: {
                Component c = Utilities.createFormComponent(this.m_thisDoc, t);
                if (c != null) {
                    t.setAttribute("component", c);
                }
                if (this.m_form == null) break;
                Element formElem = new Element(t.getID());
                this.setBufferPointers(formElem);
                formElem.setAttributes(t.getAttributesCopy());
                this.m_form.addComponent(formElem);
                break;
            }
            case 32: {
                Component cc = Utilities.createFormComponent(this.m_thisDoc, t);
                if (cc != null) {
                    this.m_formModel = ((JTextArea)cc).getDocument();
                    JScrollPane pane = new JScrollPane(cc, 22, 32);
                    t.setAttribute("component", pane);
                }
                this.m_bInTextArea = true;
                break;
            }
            case 54: {
                this.checkOptionContext();
                this.m_bInOption = true;
                this.m_comboItem = new ComboBoxItem(t);
                break;
            }
            case 31: {
                this.handleSelect(t);
                break;
            }
            case 67: {
                if (this.m_renderer.m_preferences.bIFramesEnabled) {
                    this.m_bInIFrame = true;
                    break;
                }
                return;
            }
            case 1: {
                this.m_linkColor = Utilities.setColorProperty(Color.blue, "link", t.getAttributes());
                this.m_textColor = Utilities.setColorProperty(Color.black, "text", t.getAttributes());
                this.m_alinkColor = Utilities.setColorProperty(Color.red, "alink", t.getAttributes());
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                this.handleHeadingStart(t);
                break;
            }
            case 64: {
                TextAttributes currentAtts = this.getTextAttributes(t);
                currentAtts.font = new Font("SansSerif", 2, 12);
                this.m_characterStack.push(currentAtts);
                break;
            }
            case 13: {
                this.m_bInTitle = true;
                return;
            }
        }
        Element elem = new Element(t.getID());
        this.setBufferPointers(elem);
        elem.setDocument(this);
        elem.setAttributes(t.getAttributesCopy());
        this.setTextAttributes(elem);
        if (this.m_bInAnchor && (sz = this.m_anchors.size()) > 0) {
            Element anchor = (Element)this.m_anchors.elementAt(sz - 1);
            anchor.addRelatedElement(elem);
        }
        if ((contextCheck = ContextChecker.checkContext(elem, this.m_tagStack, this.m_characterStack)) == 0) {
            this.doStartElementTrap(elem);
            if (!this.m_tagStack.empty()) {
                ((Element)this.m_tagStack.peek()).addChild(elem);
            }
            if (t.isBlockTag()) {
                if (this.m_tagStack.empty()) {
                    this.m_rootElement = elem;
                }
                this.m_tagStack.push(elem);
            }
        }
    }

    protected void handleCharacterEnd(Tag t) {
        switch (t.getID()) {
            case 10: {
                this.handleAnchor(t, false);
                break;
            }
            default: {
                if (this.m_characterStack.empty()) break;
                this.m_characterStack.pop();
            }
        }
    }

    protected void handleCharacterStart(Tag t) {
        TextAttributes currentAtts = this.getTextAttributes(t);
        int style = currentAtts.font.getStyle();
        switch (t.getID()) {
            case 68: {
                currentAtts.font = new Font("SansSerif", 0, 12);
                break;
            }
            case 59: {
                currentAtts.setAttribute("superscript", "true");
                break;
            }
            case 58: {
                currentAtts.setAttribute("subscript", "true");
                break;
            }
            case 28: 
            case 56: 
            case 57: {
                currentAtts.font = new Font("Monospaced", 0, 12);
                break;
            }
            case 38: 
            case 60: {
                currentAtts.font = new Font(currentAtts.font.getName(), style |= 2, currentAtts.font.getSize());
                break;
            }
            case 40: 
            case 42: {
                currentAtts.font = new Font(currentAtts.font.getName(), style |= 1, currentAtts.font.getSize());
                break;
            }
            case 41: {
                currentAtts.font = new Font(currentAtts.font.getFamily(), currentAtts.font.getStyle(), currentAtts.font.getSize() - 1);
                break;
            }
            case 48: {
                currentAtts.font = new Font(currentAtts.font.getFamily(), currentAtts.font.getStyle(), currentAtts.font.getSize() + 1);
                break;
            }
            case 55: {
                currentAtts.bUnderline = true;
                break;
            }
            case 52: 
            case 72: {
                currentAtts = this.handleFont(t);
                break;
            }
            case 10: {
                currentAtts = this.handleAnchor(t, true);
                break;
            }
            default: {
                return;
            }
        }
        if (currentAtts != null) {
            this.m_characterStack.push(currentAtts);
        }
    }

    public void handleContent(StringBuffer buf) {
        if (this.m_bInTitle) {
            this.m_title = this.m_title + buf.toString();
            return;
        }
        if (this.m_bInIFrame) {
            return;
        }
        if (this.m_bInOption && this.m_formModel != null) {
            String s;
            if (this.m_formModel instanceof DefaultComboBoxModel && this.m_comboItem != null) {
                this.m_comboItem.m_text = this.m_comboItem.m_text + buf.toString();
            } else if (this.m_formModel instanceof DefaultListModel && !Utilities.isBlankSpaces(s = buf.toString())) {
                ((DefaultListModel)this.m_formModel).addElement(buf.toString());
            }
        } else if (this.m_bInTextArea && this.m_formModel != null) {
            if (this.m_formModel instanceof Document) {
                Document d = (Document)this.m_formModel;
                try {
                    d.insertString(d.getLength(), buf.toString(), null);
                }
                catch (BadLocationException ex) {}
            }
        } else {
            Element elem = new Element(9);
            this.setBufferPointers(elem, buf);
            elem.setDocument(this);
            this.setTextAttributes(elem);
            if (this.m_bInAnchor) {
                this.m_relatedElements.addElement(elem);
            }
            if (this.m_tagStack.empty()) {
                this.m_rootElement = new Element(0);
                this.setBufferPointers(this.m_rootElement);
                this.m_tagStack.push(this.m_rootElement);
            }
            Element e = (Element)this.m_tagStack.peek();
            e.addChild(elem);
        }
    }

    protected TextAttributes handleFont(Tag t) {
        int fs;
        Color c;
        TextAttributes currentAtts = this.getTextAttributes(t);
        String color = (String)t.getAttribute("color");
        if (color != null && (c = Utilities.stringToColor(color)) != null) {
            currentAtts.color = c;
        }
        String face = currentAtts.font.getFamily();
        String value = (String)t.getAttribute("face");
        if (value != null) {
            value = value.toLowerCase();
            String fontName = this.getDefaultFontFace();
            StringTokenizer st = new StringTokenizer(value, ",");
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                if (tok.equals("arial")) {
                    fontName = "SansSerif";
                    break;
                }
                if (this.haveFont(tok)) {
                    fontName = tok;
                    break;
                }
                if (tok.equals("courier") || tok.equals("monospaced")) {
                    fontName = "courier";
                    break;
                }
                if (!tok.equals("helvetica")) continue;
                fontName = "SansSerif";
                break;
            }
            face = fontName;
        }
        int size = currentAtts.font.getSize();
        value = (String)t.getAttribute("size");
        if (value != null && (fs = TextAttributes.getFontSize(this.getDefaultFontSize(), value)) != -1) {
            size = fs;
        }
        int style = currentAtts.font.getStyle();
        value = (String)t.getAttribute("style");
        if (value != null) {
            int idx;
            do {
                if ((idx = value.indexOf(59)) == -1 && (idx != -1 || value.length() <= 0)) continue;
                String s = idx != -1 ? value.substring(0, idx) : value;
                int colonIndex = s.indexOf(58);
                if (colonIndex != -1) {
                    String keyValue = null;
                    String key = s.substring(0, colonIndex).trim();
                    if (colonIndex != s.length() - 1) {
                        keyValue = s.substring(colonIndex + 1).trim();
                    }
                    if (keyValue != null) {
                        Color c2;
                        if (key.equalsIgnoreCase("font-size")) {
                            int ptIdx = keyValue.indexOf("pt");
                            if (ptIdx != -1) {
                                try {
                                    size = Integer.parseInt(keyValue.substring(0, ptIdx));
                                }
                                catch (NumberFormatException ex) {}
                            }
                        } else if (key.equalsIgnoreCase("color") && (c2 = Utilities.stringToColor(keyValue)) != null) {
                            currentAtts.color = c2;
                        }
                    }
                }
                if (idx == -1) continue;
                if (idx == value.length() - 1) break;
                value = value.substring(idx + 1);
            } while (idx != -1);
        }
        currentAtts.font = new Font(face, style, size);
        return currentAtts;
    }

    protected void handleHeadingStart(Tag t) {
        int size;
        TextAttributes currentAtts = this.getTextAttributes(t);
        String face = currentAtts.font.getFamily();
        int style = 1;
        int defaultSize = this.getDefaultFontSize();
        switch (t.getID()) {
            case 14: {
                size = defaultSize + 6;
                break;
            }
            case 15: {
                size = defaultSize + 4;
                break;
            }
            case 16: {
                size = defaultSize + 2;
                break;
            }
            case 17: {
                size = defaultSize;
                break;
            }
            case 18: {
                size = defaultSize - 1;
                break;
            }
            case 19: {
                size = defaultSize - 2;
                break;
            }
            default: {
                size = defaultSize;
            }
        }
        currentAtts.font = new Font(face, style, size);
        this.m_characterStack.push(currentAtts);
    }

    public void handleNoBreakSpace() {
        if (this.m_bInIFrame) {
            return;
        }
        Element elem = new Element(101);
        this.setBufferPointers(elem);
        elem.setDocument(this);
        this.setTextAttributes(elem);
        if (this.m_bInAnchor) {
            this.m_relatedElements.addElement(elem);
        }
        if (!this.m_tagStack.empty()) {
            Element e = (Element)this.m_tagStack.peek();
            e.addChild(elem);
        }
    }

    protected void handleSelect(Tag t) {
        JComponent c = null;
        if (t.isAttributeDefined("multiple")) {
            this.m_formModel = new DefaultListModel();
            JList list = new JList((DefaultListModel)this.m_formModel);
            c = new JScrollPane(list);
        } else {
            this.m_formModel = new DefaultComboBoxModel();
            c = new JComboBox((ComboBoxModel)this.m_formModel);
        }
        t.setAttribute("component", c);
        if (this.m_form != null) {
            Element e = new Element(t.getID());
            this.setBufferPointers(e);
            e.setAttributes(t.getAttributesCopy());
            this.m_form.addComponent(e);
        }
    }

    public void handleTag(Tag t, boolean bStartTag) {
        if (this.m_bInIFrame && (t.getID() != 67 || bStartTag)) {
            return;
        }
        switch (t.getID()) {
            case 34: 
            case 63: 
            case 75: 
            case 76: 
            case 77: 
            case 78: {
                return;
            }
            case 66: {
                if (bStartTag) {
                    this.m_form = new FormProcessor(this.m_renderer, t.getAttributesCopy());
                } else if (this.m_form != null) {
                    this.m_formProcessors.addElement(this.m_form);
                    this.m_form = null;
                }
                return;
            }
            case 28: {
                this.m_bInPreformat = bStartTag;
            }
            case 10: 
            case 38: 
            case 40: 
            case 41: 
            case 42: 
            case 46: 
            case 48: 
            case 52: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 59: 
            case 60: 
            case 65: 
            case 68: 
            case 72: 
            case 73: 
            case 74: {
                if (bStartTag) {
                    this.handleCharacterStart(t);
                    break;
                }
                this.handleCharacterEnd(t);
                break;
            }
            case 53: {
                this.m_baseElement.setAttributes(t.getAttributesCopy());
                URL u = Utilities.setURLProperty(null, "href", t.getAttributes());
                if (u != null) {
                    this.m_baseURL = u;
                }
            }
            default: {
                if (bStartTag) {
                    this.handleBlockStart(t);
                    break;
                }
                this.handleBlockEnd(t);
            }
        }
    }

    protected boolean haveFont(String face) {
        if (this.m_fontList != null) {
            int i = 0;
            while (i < this.m_fontList.length) {
                if (this.m_fontList[i].equalsIgnoreCase(face)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    void printTree(Element e, int index) {
        String indent = "";
        int i = 0;
        while (i < index) {
            indent = indent + ' ';
            ++i;
        }
        String attStr = "";
        Hashtable atts = e.getAttributes();
        Enumeration enumeration = atts.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            Object value = atts.get(key);
            if (value == null) continue;
            attStr = attStr + " " + key + "=" + value;
        }
        if (e.getType() == 9) {
            String style = "";
            Font f = e.getFont();
            if (f != null) {
                style = String.valueOf(f.getStyle());
            }
            String str = new String(e.getCharData());
            HTMLDocument.toLog(indent + this.getElementName(e) + " : " + str + " (" + attStr + ") style= " + style, 0);
        } else {
            HTMLDocument.toLog(indent + this.getElementName(e) + "  (" + attStr + ")", 0);
        }
        index += 2;
        int i2 = 0;
        while (i2 < e.getElementCount()) {
            this.printTree(e.getElementAt(i2), index);
            ++i2;
        }
    }

    public void resetElements() {
        if (this.m_rootElement != null) {
            this.m_rootElement.reset();
        }
    }

    protected void setBufferPointers(Element elem) {
        int p0 = this.m_textbuffer.length();
        elem.setTextPointers(p0, p0);
    }

    protected void setBufferPointers(Element elem, StringBuffer buffer) {
        int p0;
        int p1 = p0 = this.m_textbuffer.length();
        char[] data = new char[buffer.length()];
        buffer.getChars(0, buffer.length(), data, 0);
        this.m_textbuffer.append(data);
        p1 = this.m_textbuffer.length() - 1;
        elem.setTextPointers(p0, p1);
    }

    protected void setTextAttributes(Element elem) {
        TextAttributes atts = null;
        atts = !this.m_characterStack.empty() ? (TextAttributes)this.m_characterStack.peek() : this.createDefaultTextAttributes();
        atts.multiplexAttributes(elem);
        elem.m_focusColor = this.m_alinkColor;
        elem.setFont(atts.font);
        elem.m_bInPreformat = this.m_bInPreformat;
    }

    public void startingParsing(URL u) {
        this.m_url = u;
        this.m_baseURL = u;
        this.m_textbuffer.setLength(0);
        this.m_rootElement = new Element(100);
        this.m_tagStack.removeAllElements();
        this.m_tagStack.push(this.m_rootElement);
        this.m_renderer.notifyStatusListeners(1, this.m_baseURL);
    }

    public static void toLog(String str, int nIndent) {
        if (pwOut == null) {
            try {
                String dir = System.getProperty("user.dir");
                FileOutputStream fOut = new FileOutputStream(dir + "\\parser.log");
                pwOut = new PrintWriter(fOut);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (nIndent > 0) {
            indent += nIndent;
        }
        String identStr = "";
        int i = 0;
        while (i < indent) {
            identStr = identStr + " ";
            ++i;
        }
        pwOut.println(identStr + str);
        if (nIndent < 0) {
            indent += nIndent;
        }
    }
}

