/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.HTMLPane;
import horst.HTMLPaneStatusListener;
import horst.View;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JScrollPane;

public class HTMLWindow
extends JScrollPane
implements HTMLPaneStatusListener {
    protected HTMLPane m_renderer = new HTMLPane();
    protected String m_findText = "";
    protected int m_lastFindPos;

    public HTMLWindow() {
        this.setViewportView(this.m_renderer);
        this.setBackground(Color.white);
    }

    public int find(String text) {
        int pos = this.m_renderer.findText(text, -1);
        if (pos > -1) {
            this.m_lastFindPos = pos;
            this.m_findText = text;
            this.highlightText(pos);
        }
        return pos;
    }

    public int findNext() {
        int pos = this.m_renderer.findText(this.m_findText, this.m_lastFindPos);
        if (pos > this.m_lastFindPos) {
            this.m_lastFindPos = pos;
            this.highlightText(pos);
        }
        return pos;
    }

    public HTMLPane getHTMLPane() {
        return this.m_renderer;
    }

    protected void highlightText(int pos) {
        View v = this.m_renderer.m_rootView.modelToView(pos);
        if (v != null) {
            this.m_renderer.m_props.selectStartPosition = pos;
            this.m_renderer.m_props.selectEndPosition = pos + this.m_findText.length() - 1;
            Rectangle vb = v.getBounds();
            Rectangle vr = this.getViewport().getViewRect();
            if (vr.x <= vb.x && vr.y <= vb.y && vr.x + vr.width >= vb.x + vb.width && vr.y + vr.height >= vb.y + vb.height) {
                this.repaint();
            } else {
                this.scrollToPosition(pos);
            }
        }
    }

    public void scrollToPosition(int pos) {
        Rectangle r;
        View v = this.m_renderer.m_rootView.modelToView(pos);
        if (v != null && (r = v.getBounds()) != null) {
            int diff;
            Rectangle docRect = this.m_renderer.m_rootView.getBounds();
            Dimension portDim = this.getViewport().getExtentSize();
            int yOffset = 20;
            int xOffset = 20;
            int portY = Math.max(0, r.y - yOffset);
            int portX = Math.max(0, r.x - xOffset);
            if (portX + portDim.width > docRect.width && (portX -= (diff = portX + portDim.width - docRect.width)) < 0) {
                portX = 0;
            }
            this.getViewport().setViewPosition(new Point(portX, portY));
        }
    }

    public void scrollToVisible(int pos) {
        View v = this.m_renderer.m_rootView.modelToView(pos);
        if (v != null) {
            Rectangle vb = v.getBounds();
            Rectangle vr = this.getViewport().getViewRect();
            if (vr.x <= vb.x && vr.y <= vb.y && vr.x + vr.width >= vb.x + vb.width && vr.y + vr.height >= vb.y + vb.height) {
                this.repaint();
            } else {
                this.scrollToPosition(pos);
            }
        }
    }

    public void setHTMLPane(HTMLPane pane) {
        this.m_renderer = pane;
        this.setViewportView(this.m_renderer);
    }

    public boolean statusChanged(int status, Object info) {
        switch (status) {
            case 5: {
                this.m_lastFindPos = 0;
            }
        }
        return true;
    }
}

