/*
 * Decompiled with CFR 0.152.
 */
package horst;

import horst.Element;
import horst.HTMLPane;
import horst.LayoutInfo;
import horst.Utilities;
import horst.View;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import javax.swing.SwingUtilities;

public class ImageView
extends View
implements ImageObserver,
Runnable {
    Image m_image;
    int m_horzInsets;
    int m_vertInsets;
    int m_width;
    int m_height;
    int m_altWidth;
    int m_borderSize;
    String m_alt;
    boolean m_bHavePixels = false;
    Color m_borderColor;
    static Font m_altFont;
    static int ICON_DRAWING_SIZE;

    public ImageView(View parent, Element e, HTMLPane container) {
        super(parent, e, container);
    }

    void drawMissingImageIcon(Graphics g, int x, int y, int w, int h) {
        int missingIconWidth = 15;
        Color brightColor = Color.decode("#dcdcdc");
        Color darkColor = brightColor.darker().darker();
        int xOffset = (w - missingIconWidth) / 2;
        int yOffset = (h - missingIconWidth) / 2;
        g.setColor(brightColor);
        g.drawLine(x + xOffset, y + yOffset, x + xOffset + missingIconWidth, y + yOffset);
        g.drawLine(x + xOffset, y + yOffset, x + xOffset, y + yOffset + missingIconWidth);
        g.setColor(darkColor);
        g.drawLine(x + xOffset, y + yOffset + missingIconWidth, x + xOffset + missingIconWidth, y + yOffset + missingIconWidth);
        g.drawLine(x + xOffset + missingIconWidth, y + yOffset, x + xOffset + missingIconWidth, y + yOffset + missingIconWidth);
        g.setColor(Color.red);
        int iconOffset = (missingIconWidth - 5) / 2;
        int xStart = x + xOffset + iconOffset;
        int yStart = y + yOffset + iconOffset;
        g.drawLine(xStart, yStart, xStart + 1, yStart);
        g.drawLine(xStart + 4, yStart, xStart + 5, yStart);
        g.drawLine(xStart + 1, yStart + 1, xStart + 4, yStart + 1);
        g.drawLine(xStart + 2, yStart + 2, xStart + 3, yStart + 2);
        g.drawLine(xStart + 1, yStart + 3, xStart + 4, yStart + 3);
        g.drawLine(xStart, yStart + 4, xStart + 1, yStart + 4);
        g.drawLine(xStart + 4, yStart + 4, xStart + 5, yStart + 4);
    }

    protected void flushResources() {
        if (this.m_image != null) {
            this.m_image.flush();
            this.m_image = null;
        }
    }

    protected int getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    protected int getPreferredSpan(int axis) {
        switch (axis) {
            case 1: {
                if (this.m_prefWidth != -1) {
                    return this.m_prefWidth;
                }
                if (this.m_width > 0) {
                    this.m_prefWidth = this.m_width + this.m_horzInsets;
                } else {
                    if (this.m_image != null) {
                        return Math.max(this.m_image.getWidth(null), 0) + this.m_vertInsets;
                    }
                    this.m_prefWidth = ICON_DRAWING_SIZE + this.m_altWidth + this.m_horzInsets;
                }
                return this.m_prefWidth;
            }
            case 0: {
                if (this.m_prefHeight != -1) {
                    return this.m_prefHeight;
                }
                if (this.m_height > 0) {
                    this.m_prefHeight = this.m_height + this.m_vertInsets;
                } else {
                    if (this.m_image != null) {
                        return Math.max(this.m_image.getHeight(null), 0) + this.m_vertInsets;
                    }
                    this.m_prefHeight = ICON_DRAWING_SIZE + this.m_vertInsets;
                }
                return this.m_prefHeight;
            }
        }
        return 30;
    }

    protected String getToolTipText() {
        return this.m_alt == null ? "" : this.m_alt;
    }

    public boolean imageUpdate(Image img, int flags, int x, int y, int width, int height) {
        if (this.m_image == null) {
            return false;
        }
        if ((flags & 0xC0) != 0) {
            this.m_image = null;
            return false;
        }
        boolean resized = false;
        if ((flags & 2) != 0 && this.m_height == -1) {
            this.m_height = height;
            resized = true;
        }
        if ((flags & 1) != 0 && this.m_width == -1) {
            this.m_width = width;
            resized = true;
        }
        if (resized) {
            SwingUtilities.invokeLater(this);
            return true;
        }
        if ((flags & 0x38) != 0) {
            this.m_bHavePixels = true;
            this.m_container.repaint(this.m_bounds);
        }
        return true;
    }

    protected void init() {
        this.m_alignment = Utilities.setAlignmentProperty(false, -1, "align", this.m_elem.getAttributes());
        String content = (String)this.m_elem.getAttribute("imagecontent");
        if (content != null && content.equals("true")) {
            this.setInsets(5, 5, 5, 5);
        } else if (this.isFloater()) {
            this.setInsets(3, 3, 3, 3);
        } else {
            this.setInsets(0, 0, 0, 0);
            this.m_insets.left = this.m_insets.right = Utilities.setIntegerProperty(0, "hspace", this.m_elem.getAttributes());
            this.m_insets.top = this.m_insets.bottom = Utilities.setIntegerProperty(0, "vspace", this.m_elem.getAttributes());
        }
        this.m_borderColor = Utilities.setColorProperty(Color.black, "color", this.m_elem.getAttributes());
        this.m_alt = (String)this.m_elem.getAttribute("alt");
        this.m_altWidth = 0;
        if (m_altFont == null) {
            m_altFont = new Font("Dialog", 2, 10);
        }
        if (this.m_alt != null) {
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(m_altFont);
            this.m_altWidth = fm.stringWidth(this.m_alt);
        }
        this.m_width = Utilities.setIntegerProperty(-1, "width", this.m_elem.getAttributes());
        this.m_height = Utilities.setIntegerProperty(-1, "height", this.m_elem.getAttributes());
        this.m_borderSize = Utilities.setIntegerProperty(-1, "border", this.m_elem.getAttributes());
        if (this.m_borderSize == -1) {
            this.m_borderSize = this.isLink() ? 2 : 0;
        }
        this.m_horzInsets = this.m_insets.left + this.m_insets.right + 2 * this.m_borderSize;
        this.m_vertInsets = this.m_insets.top + this.m_insets.bottom + 2 * this.m_borderSize;
    }

    protected boolean isContainerView() {
        return false;
    }

    protected boolean isFloater() {
        return this.m_alignment == 0 || this.m_alignment == 2;
    }

    protected boolean isLink() {
        boolean bLink = super.isLink();
        if (!bLink) {
            bLink = this.m_elem.isAttributeDefined("ismap") || this.m_elem.isAttributeDefined("usemap");
        }
        return bLink;
    }

    protected Rectangle layout(int x, int y, int width, LayoutInfo info) {
        this.m_bounds = new Rectangle(x, y, this.getPreferredSpan(1), this.getPreferredSpan(0));
        return this.m_bounds;
    }

    protected void loadResources() {
        if (!this.m_container.m_preferences.bLoadImages) {
            return;
        }
        URL u = null;
        String src = (String)this.m_elem.getAttribute("src");
        if (src != null && src.length() > 0) {
            u = Utilities.getURL(this.m_elem.getDocument().getBaseURL(), src);
        }
        if (u != null) {
            this.m_image = Toolkit.getDefaultToolkit().getImage(u);
            if (this.m_image != null) {
                if (this.m_container.m_preferences.bProgressiveDisplay) {
                    if (this.m_height > 0 && this.m_width > 0) {
                        this.m_bHavePixels = Toolkit.getDefaultToolkit().prepareImage(this.m_image, this.m_width, this.m_height, this);
                    } else {
                        this.m_bHavePixels = Toolkit.getDefaultToolkit().prepareImage(this.m_image, -1, -1, this);
                        if (this.m_bHavePixels) {
                            this.m_prefWidth = Math.max(this.m_image.getWidth(null), 0) + this.m_horzInsets;
                            this.m_prefHeight = Math.max(this.m_image.getHeight(null), 0) + this.m_vertInsets;
                        }
                    }
                } else {
                    MediaTracker tracker = new MediaTracker(this.m_container);
                    try {
                        if (this.m_height > 0 && this.m_width > 0) {
                            tracker.addImage(this.m_image, 0, this.m_width, this.m_height);
                        } else {
                            tracker.addImage(this.m_image, 0);
                        }
                        tracker.waitForID(0);
                        boolean bl = this.m_bHavePixels = !tracker.isErrorAny();
                        if (!this.m_bHavePixels) {
                            this.m_image = null;
                        }
                    }
                    catch (InterruptedException ex) {
                        this.m_image = null;
                    }
                }
            }
        }
    }

    public void paint(Graphics g, Shape alloc) {
        if (!this.m_bounds.intersects(alloc.getBounds())) {
            return;
        }
        int x = this.m_bounds.x + this.m_insets.left + this.m_borderSize;
        int y = this.m_bounds.y + this.m_insets.top + this.m_borderSize;
        int w = this.m_bounds.width - this.m_insets.left - this.m_insets.right - 2 * this.m_borderSize;
        int h = this.m_bounds.height - this.m_insets.top - this.m_insets.bottom - 2 * this.m_borderSize;
        if (this.m_image != null && this.m_bHavePixels) {
            if (this.m_elem.isAttributeDefined("imagecontent")) {
                g.drawImage(this.m_image, x, y, this);
            } else {
                g.drawImage(this.m_image, x, y, w, h, this);
            }
            if (this.m_borderSize > 0) {
                Color c = this.isLink() ? this.m_elem.getDocument().getLinkColor() : this.m_elem.getDocument().getTextColor();
                g.setColor(c);
                int i = 1;
                while (i <= this.m_borderSize) {
                    g.drawRect(x - i, y - i, w - 1 + i + i, h - 1 + i + i);
                    ++i;
                }
            }
        } else {
            int borderSize = 1;
            if (this.m_image != null) {
                g.setColor(Color.black);
                g.drawRect(this.m_bounds.x, this.m_bounds.y, this.m_bounds.width - 1, this.m_bounds.height - 1);
            } else {
                Utilities.drawBorder(g, this.m_bounds);
            }
            int xOffset = 0;
            int padding = 5;
            int twoPadding = 2 * padding;
            if (this.m_image == null && this.m_bounds.width > ICON_DRAWING_SIZE + twoPadding && this.m_bounds.height > ICON_DRAWING_SIZE + twoPadding) {
                this.drawMissingImageIcon(g, x + padding, y + padding, ICON_DRAWING_SIZE, ICON_DRAWING_SIZE);
                xOffset = twoPadding + ICON_DRAWING_SIZE;
            }
            String text = "";
            if (this.m_image == null && this.m_alt != null) {
                text = this.m_alt;
            } else if (this.m_image != null) {
                text = "Loading...";
            }
            FontMetrics fm = Toolkit.getDefaultToolkit().getFontMetrics(m_altFont);
            int len = fm.stringWidth(text);
            int xSpace = this.m_bounds.width - 2 * borderSize - this.m_insets.left - this.m_insets.right - xOffset - len;
            int ySpace = this.m_bounds.height - 2 * borderSize - this.m_insets.top - this.m_insets.bottom - fm.getHeight();
            if (xSpace > 0 && ySpace > 0) {
                Font oldFont = g.getFont();
                Color oldColor = g.getColor();
                g.setFont(m_altFont);
                g.setColor(Color.black);
                int fheight = fm.getHeight();
                if (text.length() > 0) {
                    g.setColor(this.m_container.m_document.getTextColor());
                    g.drawString(text, this.m_bounds.x + borderSize + this.m_insets.left + xOffset, this.m_bounds.y + borderSize + this.m_insets.top + ySpace / 2 + fm.getHeight() / 2);
                }
                g.setFont(oldFont);
                g.setColor(oldColor);
            }
        }
        this.drawDebugBox(g, Color.blue);
    }

    protected void paintFocusBox(Graphics g, Shape alloc) {
        if (this.m_elem.getDrawFocusBox() && this.m_bounds.intersects(alloc.getBounds())) {
            Utilities.drawFocusBorder(g, this.m_bounds);
        }
    }

    public void run() {
        Utilities.debugOut("ImageView calling forceLayout");
        this.forceLayout();
    }

    static {
        ICON_DRAWING_SIZE = 15;
    }
}

