/*
 * Decompiled with CFR 0.152.
 */
package jazzware.freestyle;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import jazzware.freestyle.JW2DMatrix;
import jazzware.freestyle.JWBasicICP;
import jazzware.freestyle.JWUtil;

public class JWGradientVisual
extends JWBasicICP {
    public static float PI = (float)Math.PI;
    public static float PI2 = (float)Math.PI * 2;
    protected Color startcolor;
    protected Color endcolor;
    protected int[] line;
    protected float rotation;
    protected int srgb;
    protected int ergb;
    protected JW2DMatrix mtx = null;
    protected int dither = 1;
    static int rand = (int)System.currentTimeMillis();

    public JWGradientVisual(Color startcolor, Color endcolor) {
        this.setColors(startcolor, endcolor);
    }

    public JWGradientVisual() {
        this(Color.white, Color.black);
    }

    public void setColors(Color startcolor, Color endcolor) {
        if (JWUtil.changed(this.startcolor, startcolor) || JWUtil.changed(this.endcolor, endcolor)) {
            this.invalidate();
        }
        this.startcolor = startcolor;
        this.endcolor = endcolor;
    }

    public Color getStartColor() {
        return this.startcolor;
    }

    public Color getEndColor() {
        return this.endcolor;
    }

    public float getRotation() {
        return this.rotation;
    }

    public void setRotation(int degrees) {
        this.setRotation((float)degrees * PI2 / 360.0f);
    }

    public void setRotation(float radiant) {
        if (this.rotation != (radiant = (float)((double)PI2 * ((double)(radiant / PI2) - Math.floor(radiant / PI2))))) {
            this.invalidate();
        }
        this.rotation = radiant;
    }

    public int getDither() {
        return this.dither;
    }

    public void setDither(int dither) {
        if (this.dither != dither) {
            this.invalidate();
        }
        this.dither = dither;
    }

    protected void preProduction() {
        double d;
        double d2;
        double d3;
        this.offset = 0;
        if (this.line == null || this.line.length != this.width) {
            this.line = new int[this.width];
        }
        if (this.startcolor != null && this.endcolor != null) {
            this.srgb = this.startcolor.getRGB();
            this.ergb = this.endcolor.getRGB();
        }
        this.mtx = new JW2DMatrix().rotate(this.rotation).getReversed();
        double max = 0.0;
        double min = 0.0;
        double tmp = this.mtx.transformY(0, this.height);
        if (d3 > max) {
            max = tmp;
        } else if (tmp < min) {
            min = tmp;
        }
        tmp = this.mtx.transformY(this.width, 0);
        if (d2 > max) {
            max = tmp;
        } else if (tmp < min) {
            min = tmp;
        }
        tmp = this.mtx.transformY(this.width, this.height);
        if (d > max) {
            max = tmp;
        } else if (tmp < min) {
            min = tmp;
        }
        this.mtx.translate(0.0, -min);
        this.mtx.scale(1000.0 / (max - min));
    }

    protected int[] produceLine(int y) {
        if (this.dither > 0) {
            int idx = 0;
            while (idx < this.width) {
                this.line[idx] = this.getDitherRGB(idx, y, this.dither);
                ++idx;
            }
        } else {
            int idx = 0;
            while (idx < this.width) {
                this.line[idx] = this.getRGB(idx, y);
                ++idx;
            }
        }
        return this.line;
    }

    public boolean producesSeperateLines() {
        return true;
    }

    public Color getColor(int x, int y) {
        if (this.width <= 0 || this.height <= 0) {
            return Color.white;
        }
        return JWUtil.fakeAlphaColor(this.startcolor, this.endcolor, this.mtx.transformY(x, y), 1000);
    }

    public int getRGB(int x, int y) {
        return JWUtil.fakeAlphaColor(this.srgb, this.ergb, this.mtx.transformY(x, y), 1000);
    }

    public int getDitherRGB(int x, int y, int dither) {
        rand = rand * 7621 + 1 & Short.MAX_VALUE;
        if ((y = this.mtx.transformY(x, y) + (rand & 0x1F) - 8) < 0) {
            y = 0;
        }
        if (y > 1000) {
            y = 1000;
        }
        return JWUtil.fakeAlphaColor(this.srgb, this.ergb, y, 1000);
    }

    public boolean prepareImage(Dimension size) {
        this.setDimensions(size.width, size.height);
        if (this.needsRepaint()) {
            this.image = this.createImage();
            JWUtil.readImage(this.image);
            return true;
        }
        return false;
    }

    public void paint(Graphics g, int width, int height, int x, int y, int w, int h) {
        if (this.image == null || this.width != width || this.height != height) {
            this.setDimensions(width, height);
            if (this.image != null) {
                this.image.flush();
            }
            this.image = this.createImage();
        }
        super.paint(g, width, height, x, y, w, h);
    }

    public Dimension minimumSize() {
        return JWUtil.zeroDimension;
    }

    public boolean isOpaque() {
        return true;
    }
}

