/*
 * Decompiled with CFR 0.152.
 */
package koala.dynamicjava.classinfo;

import koala.dynamicjava.classinfo.ClassFinder;
import koala.dynamicjava.classinfo.ClassInfo;
import koala.dynamicjava.classinfo.JavaClassInfo;
import koala.dynamicjava.tree.ArrayType;
import koala.dynamicjava.tree.PrimitiveType;
import koala.dynamicjava.tree.ReferenceType;
import koala.dynamicjava.tree.visitor.VisitorObject;

public class TypeVisitor
extends VisitorObject {
    private ClassFinder classFinder;
    private ClassInfo context;

    public TypeVisitor(ClassFinder classFinder, ClassInfo classInfo) {
        this.classFinder = classFinder;
        this.context = classInfo;
    }

    public Object visit(PrimitiveType primitiveType) {
        return new JavaClassInfo(primitiveType.getValue());
    }

    public Object visit(ReferenceType referenceType) {
        return this.lookupClass(referenceType.getRepresentation(), this.context);
    }

    public Object visit(ArrayType arrayType) {
        ClassInfo classInfo = (ClassInfo)arrayType.getElementType().acceptVisitor(this);
        return classInfo.getArrayType();
    }

    private ClassInfo lookupClass(String string, ClassInfo classInfo) {
        try {
            if (classInfo != null) {
                return this.classFinder.lookupClass(string, classInfo);
            }
            return this.classFinder.lookupClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

