/*
 * Decompiled with CFR 0.152.
 */
package netcomputing.beans;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class NCClassloader
extends ClassLoader {
    static NCClassloader This;
    public static final String urlPrefix = "SIMPLE";
    private static final String protocolPathProp = "java.protocol.handler.pkgs";
    Vector classPath = new Vector(1);

    public static NCClassloader This() {
        return This;
    }

    public static void Reset() {
        Vector old = NCClassloader.This.classPath;
        This = new NCClassloader();
        This.setClassPath(old);
    }

    public void setClassPath(Vector classPath) {
        this.classPath = classPath;
    }

    public Class findOrLoad(String name) throws ClassNotFoundException {
        return this.loadClass(name, true);
    }

    protected Class loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> cl = this.findLoadedClass(name = name.replace('/', '.'));
        if (cl == null) {
            try {
                cl = this.findSystemClass(name);
                return cl;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (cl == null) {
            byte[] b = this.classpathLookUp(name.replace('.', '/') + ".class");
            if (b == null) {
                throw new ClassNotFoundException(name);
            }
            cl = this.defineClass(b, 0, b.length);
        }
        if (cl == null) {
            throw new ClassNotFoundException(name);
        }
        if (resolve) {
            this.resolveClass(cl);
        }
        return cl;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream back = ClassLoader.getSystemResourceAsStream(name);
        if (back != null) {
            return back;
        }
        byte[] o = this.classpathLookUp(name);
        if (o != null) {
            if (o instanceof String) {
                throw new SecurityException("No access through getResource() to .class in 1.1");
            }
            byte[] buf = o;
            return new ByteArrayInputStream(buf);
        }
        return null;
    }

    public URL getResource(String name) {
        URL back = ClassLoader.getSystemResource(name);
        if (back != null) {
            return back;
        }
        byte[] o = this.classpathLookUp(name);
        if (o != null) {
            try {
                URL url = new URL("simpleresource", "", "/SIMPLE/+/" + name);
                return url;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    protected byte[] classpathLookUp(String fullName) {
        String str = this.classpathLookUpFile(fullName);
        File f = null;
        if (str != null) {
            if (str.endsWith(".jar") || str.endsWith(".JAR") || str.endsWith(".zip") || str.endsWith(".ZIP")) {
                try {
                    ZipFile fi = new ZipFile(str);
                    ZipEntry ze = fi.getEntry(fullName.replace('\\', '/'));
                    int len = this.getZipEntrySize(fi, ze);
                    InputStream zis = fi.getInputStream(ze);
                    byte[] buf = new byte[len];
                    int nn = 0;
                    while (nn < buf.length) {
                        buf[nn] = (byte)zis.read();
                        ++nn;
                    }
                    zis.close();
                    fi.close();
                    return buf;
                }
                catch (Exception ex) {}
            } else {
                try {
                    f = new File(str);
                    byte[] b = new byte[(int)f.length()];
                    FileInputStream in = new FileInputStream(f);
                    in.read(b);
                    in.close();
                    return b;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    int getZipEntrySize(ZipFile zf, ZipEntry ze) {
        try {
            InputStream in = zf.getInputStream(ze);
            int count = 0;
            try {
                while (in.read() >= 0) {
                    ++count;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            in.close();
            return count;
        }
        catch (Exception e) {
            e.printStackTrace();
            return (int)ze.getSize();
        }
    }

    String classpathLookUpFile(String fullName) {
        int n = 0;
        while (n < this.classPath.size()) {
            try {
                String dir = this.classPath.elementAt(n).toString();
                if (dir.endsWith(".jar") || dir.endsWith(".JAR") || dir.endsWith(".ZIP") || dir.endsWith(".zip")) {
                    try {
                        ZipFile fi = new ZipFile(dir);
                        if (fi.getEntry(fullName.replace('\\', '/')) != null) {
                            return dir;
                        }
                        fi.close();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                } else {
                    File f = new File(dir + File.separator + fullName.replace('/', File.separatorChar));
                    if (f.exists()) {
                        return f.getAbsolutePath();
                    }
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ++n;
        }
        return null;
    }

    static {
        Properties newP = new Properties(System.getProperties());
        newP.put(protocolPathProp, newP.getProperty(protocolPathProp) + "|netcomputing.beans");
        System.setProperties(newP);
        This = new NCClassloader();
    }
}

