/*
 * Decompiled with CFR 0.152.
 */
package plugins;

import JWVFile.VFile;
import Jxe.TextDocument;
import de.netcomputing.anyj.application.JDialog;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.anyj.jwidgets.ConfirmDiag;
import de.netcomputing.anyj.jwidgets.JWidgetsUtil;
import de.netcomputing.anyj.jwidgets.NCApplication;
import de.netcomputing.cvswrap.commands.RemoveWrapper;
import de.netcomputing.cvswrap.gui.CVSCheckout;
import de.netcomputing.cvswrap.gui.CVSCommit;
import de.netcomputing.cvswrap.gui.CVSConfig;
import de.netcomputing.cvswrap.gui.CVSCreate;
import de.netcomputing.cvswrap.gui.CVSDiff;
import de.netcomputing.cvswrap.gui.CVSTag;
import de.netcomputing.runtime.ApplicationHelper;
import de.netcomputing.util.Tracer;
import editapp.EditApp;
import java.awt.Component;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.File;
import java.util.Date;
import jxeplugins.JEBasicPlugin;
import jxeplugins.JEBasicService;
import netcomputing.tools.Platforms;
import netcomputing.tools.PropWriter;

public class CVSPlugin
extends JEBasicPlugin {
    public static CVSPlugin This;
    public static boolean CVSLocked;
    JDialog cvsCreateFrame;
    JDialog cvsDiffFrame;
    JDialog cvsCheckoutFrame;
    JDialog cvsTagFrame;
    CVSCreate cvsCreate;
    CVSDiff cvsDiff;
    CVSCommit cvsCommit;
    CVSConfig cvsConfig;
    CVSCheckout cvsCheckout;
    CVSTag cvsTag;

    public CVSPlugin() {
        This = this;
    }

    public JDialog getTagGUI() {
        if (this.cvsTag == null) {
            this.cvsTag = new CVSTag();
            this.cvsTagFrame = new JDialog(EditApp.App.getMainWindow(), this.cvsTag);
            this.cvsTagFrame.init();
            this.cvsTagFrame.pack();
            this.cvsTagFrame.setCanClose(true);
            ApplicationHelper.Singleton().centerWindow(this.cvsTagFrame);
            this.cvsTagFrame.setTitle("CVS - Tag");
        }
        return this.cvsTagFrame;
    }

    public CVSDiff getCvsDiff() {
        return this.cvsDiff;
    }

    public JDialog getCheckoutGUI() {
        if (this.cvsCheckout == null) {
            this.cvsCheckout = new CVSCheckout();
            this.cvsCheckoutFrame = new JDialog(EditApp.App.getMainWindow(), this.cvsCheckout);
            this.cvsCheckoutFrame.init();
            this.cvsCheckoutFrame.pack();
            this.cvsCheckoutFrame.setCanClose(true);
            ApplicationHelper.Singleton().centerWindow(this.cvsCheckoutFrame);
            this.cvsCheckoutFrame.setTitle("CVS - Checkout");
        }
        return this.cvsCheckoutFrame;
    }

    public JDialog getCreateGUI() {
        if (this.cvsCreate == null) {
            this.cvsCreate = new CVSCreate();
            this.cvsCreateFrame = new JDialog(EditApp.App.getMainWindow(), this.cvsCreate);
            this.cvsCreateFrame.init();
            this.cvsCreateFrame.pack();
            this.cvsCreateFrame.setCanClose(true);
            ApplicationHelper.Singleton().centerWindow(this.cvsCreateFrame);
            this.cvsCreateFrame.setTitle("CVS - Create a project");
        }
        return this.cvsCreateFrame;
    }

    public JDialog getDiffGUI() {
        if (Platforms.IsReallyLinux() && this.cvsDiff != null) {
            this.cvsDiffFrame.getContentPane().remove(this.cvsDiff);
            Rectangle bounds = this.cvsDiffFrame.getBounds();
            String title = this.cvsDiffFrame.getTitle();
            this.cvsDiffFrame.dispose();
            this.cvsDiffFrame = new JDialog(EditApp.App.getMainWindow(), this.cvsDiff);
            this.cvsDiffFrame.init();
            this.cvsDiffFrame.setCanClose(true);
            this.cvsDiffFrame.setTitle(title);
            this.cvsDiffFrame.setBounds(bounds);
        }
        if (this.cvsDiff == null) {
            this.cvsDiff = new CVSDiff();
            this.cvsDiffFrame = new JDialog(EditApp.App.getMainWindow(), this.cvsDiff);
            this.cvsDiffFrame.init();
            this.cvsDiffFrame.pack();
            this.cvsDiffFrame.setCanClose(true);
            ApplicationHelper.Singleton().centerWindow(this.cvsDiffFrame);
            this.cvsDiffFrame.setTitle("CVS - Differences");
        }
        return this.cvsDiffFrame;
    }

    public CVSCommit getCommitGUI() {
        if (this.cvsCommit == null) {
            this.cvsCommit = new CVSCommit();
        }
        return this.cvsCommit;
    }

    public void addProperties(EditApp app) {
        super.addProperties(app);
        EditApp.App.addCustomPanel("CVS Commit & Update", this.getCommitGUI(), EditApp.GetImage("/images/menus/cvs commit and update center.gif"));
    }

    public void init(EditApp app) {
        super.init(app);
        JEBasicService ser = new JEBasicService("CVS", "Create CVS project", 80){

            public boolean canProcess(Object selection, Object selector) {
                return !CVSLocked && selection instanceof File && ((File)selection).isDirectory() && !new File((File)selection, "CVS").exists();
            }

            public void doProcess(Object selection, Object selector) {
                CVSPlugin.this.getCreateGUI().show();
                CVSPlugin.this.cvsCreate.setBaseDir(((File)selection).getAbsolutePath());
            }
        };
        app.addService(ser);
        ser = new JEBasicService("CVS", "Initial CVS Checkout", 80){

            public boolean canProcess(Object selection, Object selector) {
                return !CVSLocked;
            }

            public void doProcess(Object selection, Object selector) {
                CVSPlugin.this.getCheckoutGUI().show();
                JWidgetsUtil.AddJob(new Runnable(this, selection){
                    private final /* synthetic */ Object val$selection;
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$selection = val$selection;
                    }

                    public void run() {
                        if (this.val$selection instanceof File && ((File)this.val$selection).isDirectory()) {
                            2.access$000(this.this$1).cvsCheckout.setBaseDir(((File)this.val$selection).getAbsolutePath());
                        } else {
                            2.access$000(this.this$1).cvsCheckout.setBaseDir(VFile.ResolveName("#actproject"));
                        }
                        2.access$000(this.this$1).cvsCheckout.retrieveProjects(2.access$000(this.this$1).cvsConfig.getCVSRoot());
                    }
                });
            }

            static /* synthetic */ CVSPlugin access$000(2 x0) {
                return x0.CVSPlugin.this;
            }
        };
        app.addService(ser);
        ser = new JEBasicService("CVS", "Create New Repository", 80){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                ((CVSConfig)CVSPlugin.this.getConfigPanel()).initRepository();
            }
        };
        app.addService(ser);
        ser = new JEBasicService("CVS", "CVS Differences", 80){

            public boolean canProcess(Object selection, Object selector) {
                return selection instanceof File && !((File)selection).isDirectory() && new File(((File)selection).getParent(), "CVS").exists();
            }

            public void doProcess(Object selection, Object selector) {
                CVSPlugin.this.getDiffGUI().show();
                JWidgetsUtil.AddJob(new Runnable(this, selection){
                    private final /* synthetic */ Object val$selection;
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$selection = val$selection;
                    }

                    public void run() {
                        5.access$100(this.this$1).cvsDiff.setFile((File)this.val$selection);
                    }
                });
            }

            static /* synthetic */ CVSPlugin access$100(5 x0) {
                return x0.CVSPlugin.this;
            }
        };
        app.addService(ser);
        ser = new JEBasicService("CVS", "CVS Commit and Update Center", 86){

            public boolean canProcess(Object selection, Object selector) {
                return !CVSLocked && selection instanceof File && ((File)selection).isDirectory() && new File((File)selection, "CVS").exists();
            }

            public void doProcess(Object selection, Object selector) {
                EditApp.App.showCard("CVS Commit & Update");
                CVSPlugin.this.cvsCommit.initFromUpdate(((File)selection).getAbsolutePath());
            }
        };
        app.addService(ser);
        ser = new JEBasicService("CVS", "Set CVS RTag", 70){

            public boolean canProcess(Object selection, Object selector) {
                return true;
            }

            public void doProcess(Object selection, Object selector) {
                JWidgetsUtil.AddLongRunningJob(new Runnable(this){
                    private final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        8.access$200(this.this$1).getTagGUI().show();
                        8.access$200(this.this$1).cvsTag.reInit();
                        8.access$200(this.this$1).cvsTag.retrieveProjects(8.access$200(this.this$1).cvsConfig.getCVSRoot());
                    }
                });
            }

            static /* synthetic */ CVSPlugin access$200(8 x0) {
                return x0.CVSPlugin.this;
            }
        };
        app.addService(ser);
        ser = new JEBasicService("CVS", "Remove from CVS Repository", 80){

            public boolean canProcess(Object selection, Object selector) {
                return !CVSLocked && selection instanceof File && !((File)selection).isDirectory() && new File(((File)selection).getParent(), "CVS").exists();
            }

            public void doProcess(Object selection, Object selector) {
                JWidgetsUtil.AddLongRunningJob(new Runnable(this, selection){
                    private final /* synthetic */ Object val$selection;
                    private final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$selection = val$selection;
                    }

                    public void run() {
                        10.access$300(this.this$1).performRemove((File)this.val$selection, false);
                    }
                });
            }

            static /* synthetic */ CVSPlugin access$300(10 x0) {
                return x0.CVSPlugin.this;
            }
        };
        app.addService(ser);
        ser = new JEBasicService("CVS", "Remove recursive from CVS Repository", 80){

            public boolean canProcess(Object selection, Object selector) {
                return !CVSLocked && selection instanceof File && ((File)selection).isDirectory() && new File(((File)selection).getParent(), "CVS").exists();
            }

            public void doProcess(Object selection, Object selector) {
                boolean i = Confirm.ModalConfirm("Really remove ?", new String[]{"This will remove all files and directories", "residing in (sub-)directories from the repository.", "Files are deleted physically from your harddrive !", "[" + ((File)selection).getAbsolutePath() + "]"});
                if (i) {
                    JWidgetsUtil.AddLongRunningJob(new Runnable(this, selection){
                        private final /* synthetic */ Object val$selection;
                        private final /* synthetic */ 12 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$selection = val$selection;
                        }

                        public void run() {
                            12.access$400(this.this$1).performRemove((File)this.val$selection, true);
                        }
                    });
                }
            }

            static /* synthetic */ CVSPlugin access$400(12 x0) {
                return x0.CVSPlugin.this;
            }
        };
        app.addService(ser);
    }

    public void addLogEntry(String s) {
        if (this.cvsCommit == null) {
            this.getCommitGUI();
        }
        this.cvsCommit.addLogEntry(s);
    }

    public void performRemove(File f, boolean recursive) {
        this.performRemove(f, recursive, true);
    }

    public void performRemove(final File f, final boolean recursive, final boolean showmsg) {
        JWidgetsUtil.AddLongRunningJob(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    CVSLocked = true;
                    CVSPlugin.this.addLogEntry("Removing file  - " + new Date());
                    if (!f.isDirectory()) {
                        String renamed = f.getAbsolutePath() + "~";
                        while (new File(renamed).exists()) {
                            renamed = renamed + "~";
                        }
                        File renFile = new File(renamed);
                        try {
                            f.renameTo(renFile);
                            if (f.exists()) {
                                throw new RuntimeException("File renaming failed " + f.getAbsolutePath());
                            }
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            CVSPlugin.this.addLogEntry("(failed) " + f.getName());
                            Confirm.ModalMsg("Removal Failure", new String[]{"unable to rename local copy"});
                            Object var5_4 = null;
                            CVSLocked = false;
                            return;
                        }
                    }
                    RemoveWrapper addw = new RemoveWrapper(null);
                    String msg = null;
                    msg = addw.runRemove(f.getAbsolutePath(), recursive);
                    if (msg != null) {
                        Confirm.ModalMsg("Remove Failure", msg);
                        CVSPlugin.this.addLogEntry("(failed)   " + f.getName());
                    } else if (f.isDirectory()) {
                        CVSPlugin.this.addLogEntry("(removed)   " + f.getName() + (recursive ? " recursive" : ""));
                    } else {
                        CVSPlugin.this.addLogEntry("(scheduled for rem) " + f.getName());
                    }
                    CVSPlugin.this.addLogEntry(" ");
                    if (showmsg) {
                        Confirm.ModalMsg("CVS Remove", new String[]{"File scheduled for removal", "Please Commit to remove the files permanently."});
                    }
                    Object var5_5 = null;
                    CVSLocked = false;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    CVSLocked = false;
                    throw throwable;
                }
            }
        });
    }

    public void actionRequested(Object selection) {
        if (selection instanceof TextDocument) {
            if (new File(((TextDocument)selection).getFile().getParent(), "CVS").exists()) {
                final File selFile = ((TextDocument)selection).getFile();
                this.getDiffGUI().show();
                JWidgetsUtil.AddJob(new Runnable(){

                    public void run() {
                        CVSPlugin.this.cvsDiff.setFile(selFile);
                    }
                });
            } else {
                ConfirmDiag.Msg((Window)EditApp.App.getMainWindow(), new String[]{"This file is not version controled", "Create a project first.", "You can create a CVS project by selecting a directory", "and choosing 'CVS|Create project' from the popup menu.", "Alternatively you may get an existing project using", "CVS|Initial Checkout"});
            }
        }
    }

    public Image getEditorIcon() {
        return NCApplication.GetImage("javacPlugin-compile");
    }

    public String getEditorIconTTip() {
        return "Diff Tool";
    }

    public String getGlobalMenuName() {
        return "CVS Update Center";
    }

    public String getActionIconTTip() {
        return "CVS Commit & Update Center";
    }

    public Image getActionIcon() {
        return NCApplication.GetImage("vcontrol");
    }

    public String getPropertyPath() {
        return "Workspace.CVS (Version Control)";
    }

    public void storeProperty(PropWriter pw) throws Exception {
        try {
            this.getConfigPanel();
            this.getCommitGUI().storeProperty(pw);
            this.cvsConfig.storeProperty(pw);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void loadProperty(PropWriter pw) throws Exception {
        try {
            this.getConfigPanel();
            this.getCommitGUI().loadProperty(pw);
            this.cvsConfig.loadProperty(pw);
        }
        catch (Exception ex) {
            ex.printStackTrace(Tracer.This);
        }
    }

    public Component getConfigPanel() {
        if (this.cvsConfig == null) {
            this.cvsConfig = new CVSConfig();
        }
        return this.cvsConfig;
    }

    public String getDescription() {
        return "adds CVS version control";
    }

    static {
        CVSLocked = false;
    }
}

