/*
 * Decompiled with CFR 0.152.
 */
package versioncontrol;

import Jxe.AttributedTextLine;
import Jxe.TextDocument;
import de.netcomputing.util.Tracer;
import java.io.RandomAccessFile;
import java.util.Date;

public class FileDiffEntry {
    String displayString;
    public String fileName;
    public long date;
    public String comment;
    public boolean[] directions;
    public int[] lineNums;
    public String[] lines;

    public FileDiffEntry(RandomAccessFile fi, boolean last) throws Exception {
        this.readFrom(fi, last);
    }

    public void readFrom(RandomAccessFile fi, boolean last) throws Exception {
        this.date = fi.readLong();
        this.comment = fi.readUTF();
        this.fileName = fi.readUTF();
        int entriesA = 0;
        int entriesB = 0;
        if (!last) {
            entriesA = fi.readInt();
            entriesB = fi.readInt();
        } else {
            entriesA = 0;
            entriesB = 0;
        }
        this.directions = new boolean[entriesA + entriesB];
        this.lineNums = new int[entriesA + entriesB];
        this.lines = new String[entriesA + entriesB];
        int n = 0;
        while (n < entriesA) {
            this.directions[n] = false;
            this.lineNums[n] = fi.readInt();
            this.lines[n] = fi.readUTF();
            ++n;
        }
        int n2 = entriesA;
        while (n2 < entriesA + entriesB) {
            this.directions[n2] = true;
            this.lineNums[n2] = fi.readInt();
            this.lines[n2] = fi.readUTF();
            ++n2;
        }
    }

    public void applyBackwardTo(TextDocument doc) {
        int n = this.directions.length - 1;
        while (n >= 0) {
            if (this.directions[n]) {
                doc.remLineWithoutUndoAt(this.lineNums[n]);
            }
            --n;
        }
        int n2 = 0;
        while (n2 < this.directions.length) {
            try {
                if (!this.directions[n2]) {
                    doc.addLineWithoutUndoAt(this.lineNums[n2], new AttributedTextLine(this.lines[n2]));
                }
            }
            catch (Exception e) {
                doc.addLineWithoutUndoAt(doc.size(), new AttributedTextLine("!" + this.lineNums[n2] + "!" + this.lines[n2]));
            }
            ++n2;
        }
    }

    public void dump() {
        Tracer.This.println("File: " + this.fileName);
        Tracer.This.println("Comment: " + this.comment);
        Tracer.This.println("Date   : " + new Date(this.date));
        Tracer.This.println("Changes: " + this.directions.length);
    }
}

