/*
 * Decompiled with CFR 0.152.
 */
package versioncontrol;

import JCollections.DirIterator;
import JCollections.JIterationFunc;
import JCollections.JUnsafeArray;
import JWVFile.VFile;
import JWVFile.VVolume;
import Jxe.TextDocument;
import de.netcomputing.anyj.jwidgets.Confirm;
import de.netcomputing.util.Tracer;
import java.awt.Frame;
import java.io.File;
import java.io.FilenameFilter;
import java.io.RandomAccessFile;
import java.util.Vector;
import versioncontrol.FileDiffEntry;

public class VersionControl
implements FilenameFilter {
    Vector fileTypes;

    public void setFileTypes(Vector fileTypes) {
        this.fileTypes = fileTypes;
    }

    public Vector getFileTypes() {
        return this.fileTypes;
    }

    public String normalizeDir(String filePath) {
        if (File.separatorChar != '/') {
            filePath = filePath.replace('/', File.separatorChar);
        }
        if (File.separatorChar != '\\') {
            filePath = filePath.replace('\\', File.separatorChar);
        }
        return filePath;
    }

    public String getVCFileFor(String filePath, String extension, boolean doCreate) {
        filePath = this.normalizeDir(filePath);
        String file2 = VFile.ExtractDir(filePath) + File.separator + "JSRS" + File.separator;
        if (doCreate) {
            try {
                new File(file2).mkdirs();
            }
            catch (Exception e) {
                Confirm.ModalMsg(new Frame(), "Fatal error", new String[]{"Unable to create the VersionControl directory:", file2 + "  .", "Ensure write access is enabled."});
                e.printStackTrace();
                return null;
            }
        }
        String name = VFile.NameWithExtension(filePath);
        filePath = file2 + this.codeName(name) + extension;
        return filePath;
    }

    public void checkIn(File file2, String comment) throws Exception {
        this.makeVersion(file2, comment, System.currentTimeMillis());
    }

    public void checkOut(File file2, String comment) throws Exception {
    }

    public void makeVersion(File file2, String comment) throws Exception {
        this.makeVersion(file2, comment, System.currentTimeMillis());
    }

    void makeVersion(File file2, String comment, long when) throws Exception {
        if (file2.isDirectory()) {
            this.makeVersionDir(file2, comment, when);
            return;
        }
        TextDocument doc = new TextDocument();
        doc.init(null);
        File former = new File(this.getVCFileFor(file2.getAbsolutePath(), ".last", true));
        if ("system".equals(comment) && former.lastModified() >= file2.lastModified()) {
            return;
        }
        File original = null;
        if (!former.exists()) {
            VFile.Copy(file2, former);
            original = file2;
            Tracer.This.println("FIRST FILE former:" + former.getAbsolutePath() + " " + file2.getAbsolutePath());
            this.saveDiffs(comment, original, when, new File(this.getVCFileFor(file2.getAbsolutePath(), ".diff", true)), null, null, null);
        } else {
            TextDocument docNew = new TextDocument();
            docNew.init(null);
            doc.coreLoad(former);
            docNew.coreLoad(file2);
            original = file2;
            Tracer.This.println("doc.diffTo former: " + former.getAbsolutePath() + " \n       other:" + file2.getAbsolutePath());
            int[][] diffs = doc.diffTo(docNew);
            JUnsafeArray ja = new JUnsafeArray(diffs.length);
            int n = 0;
            while (n < diffs.length) {
                ja.add(diffs[n]);
                ++n;
            }
            Tracer.This.println("diff length " + diffs.length);
            Tracer.This.println("diffvector size " + ja.size());
            int n2 = 1;
            while (n2 < ja.size()) {
                if (((int[])ja.at(n2))[0] <= ((int[])ja.at(n2 - 1))[0]) {
                    Tracer.This.println("vcontrol:: fehler in diff links" + ((int[])ja.at(n2))[0] + "=>" + ((int[])ja.at(n2))[1]);
                    Tracer.This.println();
                    Tracer.This.println();
                    Tracer.This.println();
                    Tracer.This.println();
                    ja.remAt(n2);
                    --n2;
                }
                if (((int[])ja.at(n2))[1] <= ((int[])ja.at(n2 - 1))[1]) {
                    Tracer.This.println("vcontrol:: fehler in diff rechts" + ((int[])ja.at(n2))[0] + "=>" + ((int[])ja.at(n2))[1]);
                    Tracer.This.println();
                    Tracer.This.println();
                    Tracer.This.println();
                    Tracer.This.println();
                    ja.remAt(n2);
                    --n2;
                }
                ++n2;
            }
            VFile.Copy(file2, former);
            this.saveDiffs(comment, original, when, new File(this.getVCFileFor(file2.getAbsolutePath(), ".diff", false)), ja, doc, docNew);
        }
    }

    public TextDocument restoreDocument(JUnsafeArray history, int targetIndex, String baseDir) {
        String file2 = this.normalizeDir(((FileDiffEntry)history.at((int)targetIndex)).fileName);
        String finame = file2 = VFile.NameWithExtension(this.normalizeDir(file2));
        file2 = baseDir + File.separator + file2;
        File diff = new File(this.getVCFileFor(file2, ".last", false));
        TextDocument doc = new TextDocument();
        doc.init(null);
        doc.coreLoad(diff);
        int n = history.size() - 1;
        while (n >= targetIndex) {
            String name = ((FileDiffEntry)history.at((int)n)).fileName;
            name = this.normalizeDir(name);
            if ((name = VFile.NameWithExtension(this.normalizeDir(name))).equals(finame)) {
                ((FileDiffEntry)history.at(n)).applyBackwardTo(doc);
            }
            --n;
        }
        return doc;
    }

    public TextDocument restoreDocument(JUnsafeArray history, int targetIndex) {
        String file2 = ((FileDiffEntry)history.at((int)targetIndex)).fileName;
        return this.restoreDocument(history, targetIndex, file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDiffs(String comment, File original, long time, File file2, JUnsafeArray arr, TextDocument docA, TextDocument docB) throws Exception {
        RandomAccessFile fi = new RandomAccessFile(file2, "rw");
        try {
            long markPos = 0L;
            long len = fi.length();
            if (len > 0L) {
                fi.seek(len - 8L);
                markPos = fi.readLong();
                fi.seek(len - 8L);
            } else {
                fi.seek(len);
            }
            int arrCnt = 0;
            int entries = 0;
            if (docA != null) {
                int n = 0;
                while (n < docA.size()) {
                    if (arrCnt < arr.size() && ((int[])arr.at(arrCnt))[0] == n) {
                        ++arrCnt;
                    } else {
                        ++entries;
                    }
                    ++n;
                }
                fi.writeInt(entries);
                arrCnt = 0;
                entries = 0;
                int n2 = 0;
                while (n2 < docB.size()) {
                    if (arrCnt < arr.size() && ((int[])arr.at(arrCnt))[1] == n2) {
                        ++arrCnt;
                    } else {
                        ++entries;
                    }
                    ++n2;
                }
                fi.writeInt(entries);
                arrCnt = 0;
                int n3 = 0;
                while (n3 < docA.size()) {
                    if (arrCnt < arr.size() && ((int[])arr.at(arrCnt))[0] == n3) {
                        ++arrCnt;
                    } else {
                        fi.writeInt(n3);
                        fi.writeUTF(docA.lineAt(n3).toString());
                    }
                    ++n3;
                }
                arrCnt = 0;
                int n4 = 0;
                while (n4 < docB.size()) {
                    if (arrCnt < arr.size() && ((int[])arr.at(arrCnt))[1] == n4) {
                        ++arrCnt;
                    } else {
                        fi.writeInt(n4);
                        fi.writeUTF(docB.lineAt(n4).toString());
                    }
                    ++n4;
                }
                long tmp = fi.getFilePointer();
                fi.seek(markPos);
                fi.writeLong(tmp);
                fi.seek(fi.length());
            }
            long mark = fi.getFilePointer();
            fi.writeLong(-1L);
            fi.writeLong(time);
            fi.writeUTF(comment);
            fi.writeUTF(original.getAbsolutePath());
            fi.writeLong(mark);
            Object var23_19 = null;
        }
        catch (Throwable throwable) {
            Object var23_20 = null;
            fi.close();
            throw throwable;
        }
        fi.close();
    }

    void makeVersionDir(File dir, String comment, long when) throws Exception {
        this.makeVersionDir(dir, comment, when, true);
    }

    void makeVersionDir(File dir, final String comment, final long when, boolean recurse) throws Exception {
        DirIterator.Iterate(dir, new JIterationFunc(){

            public boolean func(Object o) {
                try {
                    VersionControl.this.makeVersion((File)o, comment, when);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return false;
            }
        }, recurse, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterate(String fileName, JIterationFunc func) throws Exception {
        RandomAccessFile fi = new RandomAccessFile(this.getVCFileFor(fileName, ".diff", false), "r");
        try {
            long mark = 0L;
            long len = fi.length();
            FileDiffEntry df = null;
            do {
                fi.seek(mark);
                mark = fi.readLong();
                df = new FileDiffEntry(fi, mark < 0L);
                if (func.func(df)) break;
            } while (mark >= 0L);
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            fi.close();
            throw throwable;
        }
        fi.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void iterateCoded(String fileName, JIterationFunc func) throws Exception {
        RandomAccessFile fi = new RandomAccessFile(VFile.StripDoubleSeps(fileName, File.separatorChar).toString(), "r");
        try {
            long mark = 0L;
            long len = fi.length();
            FileDiffEntry df = null;
            do {
                fi.seek(mark);
                mark = fi.readLong();
                df = new FileDiffEntry(fi, mark < 0L);
                if (func.func(df)) break;
            } while (mark >= 0L);
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            fi.close();
            throw throwable;
        }
        fi.close();
    }

    public JUnsafeArray historyFor(String fileName) throws Exception {
        if (new File(fileName).isDirectory()) {
            this.makeVersionDir(new File(fileName), "system", System.currentTimeMillis(), false);
            File dir = new File(fileName + File.separator + "JSRS");
            String[] list = dir.list();
            final JUnsafeArray res = new JUnsafeArray(200);
            int n = 0;
            while (n < list.length) {
                if (list[n].endsWith(".diff")) {
                    this.iterateCoded(dir.getAbsolutePath() + File.separatorChar + list[n], new JIterationFunc(){

                        public boolean func(Object o) {
                            res.add(o);
                            return false;
                        }
                    });
                }
                ++n;
            }
            return res;
        }
        JUnsafeArray res = new JUnsafeArray(30);
        this.makeVersion(new File(fileName), "system");
        this.internalHistoryFor(fileName, Long.MIN_VALUE, res);
        return res;
    }

    void internalHistoryFor(String fileName, final long startDate, final JUnsafeArray arr) throws Exception {
        this.iterate(fileName, new JIterationFunc(){

            public boolean func(Object o) {
                if (((FileDiffEntry)o).date >= startDate) {
                    arr.add(o);
                }
                return false;
            }
        });
    }

    String codeName(String name) {
        name = VFile.StripDoubleSeps(name, File.separator.charAt(0)).toString();
        name = name.replace(File.separator.charAt(0), '_');
        name = name.replace('.', '_');
        name = name.replace(':', '_');
        return name;
    }

    public static void main(String[] arg) {
        TextDocument doc = new TextDocument();
        doc.init(null);
        VVolume.New("history", "g:\\tmp");
        doc.coreLoad(new File("g:\\j11\\projects\\Edit\\EditApp.java"));
        VersionControl vc = new VersionControl();
        try {
            vc.makeVersion(doc.getFile(), "1st");
            JUnsafeArray ar = vc.historyFor(doc.getFile().getAbsolutePath());
            int n = 0;
            while (n < ar.size()) {
                ((FileDiffEntry)ar.at(n)).dump();
                ++n;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean accept(File dir, String name) {
        String na = name.toLowerCase();
        if (new File(dir, name).isDirectory()) {
            return true;
        }
        int n = 0;
        while (n < this.fileTypes.size()) {
            if (na.endsWith(this.fileTypes.elementAt(n).toString())) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

