/******************************************************
 * File: CCCTool.java
 * created 04.03.2002 11:48:21 by moelrue
 */
package harvestgui.scripts;
import de.netcomputing.anyj.scripting.*;
import java.io.*;
import java.util.*;
import javax.swing.*;

public class CCCTool 
{
    
    private static void  createSQLScriptFile( String proj , String path)
    {
        String sep = System.getProperty("line.separator");
        String p1 = "set define off;" + sep +
        " select haritems1.itemname,"+ sep +
        "harpathfullname1.pathfullname"+ sep +
        "from haritems haritems1,"+ sep +
        "harversions harversions1,"+ sep +
        "harpathfullname harpathfullname1,"+ sep +
        "harpackage harpackage1,"+ sep +
        "harenvironment harenvironment1,"+ sep +
        "harversioninview harversioninview1,"+ sep +
        "harview harview1"+ sep +
        "where haritems1.itemtype=1"+ sep +
        "and harversions1.itemobjid=haritems1.itemobjid"+ sep +
        "and harpathfullname1.itemobjid=haritems1.parentobjid"+ sep +
        "and harversions1.packageobjid=harpackage1.packageobjid"+ sep +
        "and harpackage1.envobjid=harenvironment1.envobjid"+ sep +
        "and harview1.envobjid=harenvironment1.envobjid"+ sep +
        "and harview1.viewobjid=harversioninview1.viewobjid"+ sep +
        "and harversioninview1.versionobjid=harversions1.versionobjid"+ sep +
        "and harenvironment1.environmentname='";
        
        String p2 = "'" + sep + " and harview1.viewname='Implementation Phase'"+ sep +
        "and harversions1.versionstatus='D'"+ sep +
        "and not exists ( select harversions2.itemobjid from harversions harversions2, haritems haritems2, harpackage harpackage2,"+ sep +
        "harenvironment harenvironment2, harview harview2, harversioninview harversioninview2"+ sep +
        "where cast(harversions2.mappedversion as integer) > cast(harversions1.mappedversion as integer) "+ sep +
        "and harversions1.itemobjid=harversions2.itemobjid"+ sep +
        "and harversions2.itemobjid=haritems2.itemobjid"+ sep +
        "and harversions2.packageobjid=harpackage2.packageobjid"+ sep +
        "and harpackage2.envobjid=harenvironment2.envobjid"+ sep +
        "and harview2.envobjid=harenvironment2.envobjid"+ sep +
        "and harview2.viewobjid=harversioninview2.viewobjid"+ sep +
        "and harversioninview2.versionobjid=harversions2.versionobjid"+ sep +
        "and harenvironment2.environmentname=harenvironment1.environmentname"+ sep +
        "and harview2.viewname=harview1.viewname "+ sep +
        " )"+ sep +
        "order by haritems1.itemname, harpathfullname1.pathfullname;"+ sep ;
        
        try{
            File f = new File( path );
            if( f.exists() )
            {
                f.delete(); 
            }
            f.getParentFile().mkdirs();
            FileWriter fw = new FileWriter( f );
            fw.write( p1 + proj + p2);
            fw.close();
        } catch ( Exception ex ) {
            ex.printStackTrace();
        }
    
    }
    
    
   public static List getSourcePathAsList(){
        List paths  = new ArrayList();
        String sourcepath =(String) AnyJAPI.This().getEnvironment().get("SourcePath");
        if( sourcepath != null )
        {
            StringTokenizer tokenizer = new StringTokenizer(sourcepath,";",false);
            while(tokenizer.hasMoreTokens() )
            {
                paths.add( tokenizer.nextToken() );
            }
        }
        return paths;
    }
    
    
    /**
     * gets a List of deleted files in repository and checks if they exist locally. If yes, they will be deleted.
     */
   public static List checkDeletedFileList(String panelName, String directory, boolean justReturnList)
    {
        if( !justReturnList )
        {
            int res = JOptionPane.showConfirmDialog( AnyJAPI.This().getMainWindow(), "Check for deleted files in repository ?" );
            if ( res != JOptionPane.OK_OPTION )
            {
                return null; 
            }
        }
        AnyJAPI.This().getOrCreateOutputPanel( panelName ).printLine("Checking for deleted Files in :"+directory);
        String proj=null;
        String pack=null;
        File dir = new File( directory );
        String[] projPack = CCCGet.FindAJHarvestSigFile( dir );
        String logFileName = "D:"+ File.separator +  "deletedModulesInView.log";  
        if ( projPack != null )
        {
            proj = projPack[0];
            pack = projPack[1];
        }
        
        createSQLScriptFile( proj, AnyJAPI.This().getEnvironment().get("workspaceDir") + File.separator + "scripts" + File.separator+"deletedModulesInView.sql");
        String reposRoot = dir.getAbsolutePath().substring((""+AnyJAPI.This().getEnvironment().get("ccch_localroot")).length());
        
        String command = "hsql -b " +AnyJAPI.This().getEnvironment().get("ccch_repository") + 
        " -f " + AnyJAPI.This().getEnvironment().get("workspaceDir") + File.separator + "scripts" + File.separator+"deletedModulesInView.sql" +
        " -usr "+AnyJAPI.This().getEnvironment().get("ccch_user") +
        " -pw " +AnyJAPI.This().getEnvironment().get("ccch_pwd") +
        " -o " + logFileName +
        " -nh -t";
        // hsql -b xeomoon/XE -f "u:\tools\sql\deletedModulesInView.sql" -usr <username> -pw <password> -o "u:\tools\sql\deletedModulesInView.log" -nh -t
        // the command:  hsv -b xeomoon/XE -usr user -pw password -en "XFEurex6.0" -st "Implementation Phase" -it rm -iv lv -vp /XFEurex -s "*"
        
        AnyJAPI.This().getOrCreateOutputPanel( panelName ).printLine( command);
        AnyJAPI.This().executeExternalProcess( panelName, File.separator, command );
        try{ 
            Thread.sleep(2000);
        } catch ( Exception ex ) {
            ex.printStackTrace();
        }
        List deletedFiles = new ArrayList();
        try{
            DataInputStream in = new DataInputStream( new FileInputStream(logFileName) );
            String s = null;
            while( (s=in.readLine()) != null )
            {
                if( s.indexOf(".java")>=0 )
                {
                    s = parseLine( s );
                    deletedFiles.add(s );
                }
            }
            in.close();
            new File ( logFileName).delete();
        } catch ( Exception ex ) {
            ex.printStackTrace();
        }
        
        
        
        AnyJAPI.This().getOrCreateOutputPanel( panelName ).printLine( "DEBUG:"+deletedFiles.size() +" "+justReturnList );
        if( deletedFiles.size()>0 && !justReturnList )
        {
            confirmFileDeletion(deletedFiles);
        }
        if(deletedFiles.size()<= 0)
        {
            AnyJAPI.This().getOrCreateOutputPanel( panelName ).printLine( "Project is up to date !" );
            JOptionPane.showMessageDialog( AnyJAPI.This().getMainWindow(), "Project is up to date !" );
        }
        
        return deletedFiles;
    }
    
    public static void confirmFileDeletion(List fileList)
    {
        List toDelete = new ArrayList();
        StringBuffer confirmString = new StringBuffer();
        String lineSep = System.getProperty("line.separator");
        confirmString.append( "Files deleted in repository, but locally available.");
        confirmString.append(lineSep );
        confirmString.append(lineSep );
        confirmString.append("Should this file(s) be deleted locally ??");
        confirmString.append(lineSep );
        confirmString.append(lineSep );
        
        if( fileList.size()>0 )
        {
            Iterator it = fileList.iterator();
            while( it.hasNext() )
            {
                String name = (String) it.next();
                try{
                    File f = new File(name);
                    if( f.exists() )
                    {
                        confirmString.append(name);
                        confirmString.append(lineSep );
                        toDelete.add( f); 
                    }
                } catch ( Exception ex ) {
                    // file does not exist, do nothing
                }
            }
        }
        if( toDelete.size() <= 0 )
        {
            JOptionPane.showMessageDialog( AnyJAPI.This().getMainWindow(), "Project is up to date !" );
            
            return; // nothing to delete .. 
        }
        //int result = JOptionPane.showConfirmDialog( AnyJAPI.This().getMainWindow(), confirmString.toString() );
        toDelete = AnyJAPI.This().chooseFromList( "Delete Files ?", "Deleted in repository, del locally ?", toDelete, toDelete, 640, 400 );
        if( toDelete != null && toDelete.size() > 0 )
        {
            Iterator ite = toDelete.iterator();
            while( ite.hasNext() )
            {
                File fi = (File) ite.next();
                
                try{
                    fi.delete();
                } catch ( Exception ex ) {
                    ex.printStackTrace();
                    AnyJAPI.This().getOrCreateOutputPanel( "Interpret" ).printLine(ex+"");
                    AnyJAPI.This().getOrCreateOutputPanel( "Interpret").printLine(ex.getMessage() );
                }
            }
        }
    }
    
    
    /**
     * parses a line of the log file from harvest. concatenates the local root , the path and fileName.
     * a absolute path of the file is returned.
     */
    public static String parseLine(String line)
    {
        String root = (String)AnyJAPI.This().getEnvironment().get("ccch_localroot");
        StringTokenizer tok = new StringTokenizer( line, "\t",false );
        String fileName = tok.nextToken();
        String path = tok.nextToken();
        return root + path + File.separator + fileName;
    }
    
    ///////////////////////////////////////////////////////////////////////////////////////////////
    // LogReader Tryst
    //////////////////////////////////////////////////////////////////////////////////////////////
    public static class LogReader extends Thread{ 
        String fileName = File.separator+"hco.log";
        String panelName = "LogReader";
        public boolean isRunning;
        
        public LogReader(String file, String panel)
        {
            fileName = file;
            panelName = panel;
        }
        public LogReader(){
        
        }
        
        public void setFileName(String name){
            fileName = name; 
        }
        public void setPanelName(String name)
        {
            panelName = name;
        }
        public void setRunning(boolean runs)
        {
            if( !runs )
            {
                try {
                    Thread.sleep( 2000 );
                } catch ( Exception ex ) {
                    ex.printStackTrace();
                }
            
            }
            isRunning = runs;
        }
        
        public void run ()
        {
            int errorCount = 0;
            try {
                AJSOutput out = AnyJAPI.This().getOrCreateOutputPanel( panelName );
                File logFile = new File(fileName);
                while( !logFile.exists() )
                {
                    try {
                        Thread.sleep( 3000 );
                    } catch ( Exception ex ) {
                        ex.printStackTrace();
                    }
                }
                DataInputStream in = new DataInputStream( new FileInputStream( fileName ) );
                String s = "";
                
                while(  s != null  && isRunning )
                {
                    s=in.readLine();
                    if ( s != null )
                    {
                        if ( s.indexOf( "Error:" ) >= 0 || s.toLowerCase().indexOf( "not found" )>= 0 || s.toLowerCase().indexOf( "not find" )>= 0)
                            errorCount++;
                        out.printLine( s );
                    }
                    else 
                    {
                        try {
                            Thread.sleep( 200 );
                        } catch ( Exception ex ) {
                            ex.printStackTrace();
                        }
                        s= "";
                    }
                }
                in.close();
                logFile.delete();
            } catch ( Exception ex ) {
                AnyJAPI.This().getOrCreateOutputPanel( panelName ).printLine( "FINISHED READING OUTPUT:"+ex.getClass().getName() );
                AnyJAPI.This().getOrCreateOutputPanel( panelName ).printLine( fileName );
            }
            AnyJAPI.This().getOrCreateOutputPanel( panelName ).printLine( "--DONE With:"+errorCount+" Errors" );
            AnyJAPI.This().getOrCreateOutputPanel( panelName ).printLine( "" );
            AnyJAPI.This().updateFileTree(); 
        }
    }



}
