/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.cvsclient.util;

import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import org.netbeans.lib.cvsclient.util.ByteArray;
import org.netbeans.lib.cvsclient.util.Logger;

public class LoggedDataInputStream
extends FilterInputStream {
    private long counter;

    public LoggedDataInputStream(InputStream in) {
        super(in);
    }

    public String readLine() throws IOException {
        return this.readLineBytes().getStringFromBytes();
    }

    public ByteArray readLineBytes() throws IOException {
        boolean throwEOF = true;
        ByteArray byteArray = new ByteArray();
        block6: while (true) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                break;
            }
            if (this.in.available() == 0) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException iex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            int ch = this.in.read();
            ++this.counter;
            switch (ch) {
                case -1: {
                    if (throwEOF) {
                        throw new EOFException();
                    }
                }
                case 10: {
                    break block6;
                }
                default: {
                    byteArray.add((byte)ch);
                    throwEOF = false;
                }
            }
        }
        byte[] bytes = byteArray.getBytes();
        Logger.logInput(bytes);
        Logger.logInput('\n');
        return byteArray;
    }

    public byte[] readBytes(int len) throws IOException {
        ByteArray byteArray = new ByteArray();
        block5: while (len != 0) {
            if (Thread.interrupted()) {
                Thread.currentThread().interrupt();
                break;
            }
            if (this.in.available() == 0) {
                try {
                    Thread.sleep(100L);
                    continue;
                }
                catch (InterruptedException iex) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
            int ch = this.in.read();
            ++this.counter;
            switch (ch) {
                case -1: {
                    break block5;
                }
                default: {
                    byteArray.add((byte)ch);
                    --len;
                }
            }
        }
        byte[] bytes = byteArray.getBytes();
        Logger.logInput(bytes);
        return bytes;
    }

    public void close() throws IOException {
        this.in.close();
    }

    public int read(byte[] b) throws IOException {
        int read = this.in.read(b);
        if (read != -1) {
            Logger.logInput(b, 0, read);
            this.counter += (long)read;
        }
        return read;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        int read = this.in.read(b, off, len);
        if (read != -1) {
            Logger.logInput(b, off, read);
            this.counter += (long)read;
        }
        return read;
    }

    public long skip(long n) throws IOException {
        long skip = super.skip(n);
        if (skip > 0L) {
            Logger.logInput(new String("<skipped " + skip + " bytes>").getBytes("utf8"));
            this.counter += skip;
        }
        return skip;
    }

    public int read() throws IOException {
        while (this.in.available() == 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException iex) {
                Thread.currentThread().interrupt();
                throw new InterruptedIOException();
            }
        }
        int i = super.read();
        if (i != -1) {
            Logger.logInput((char)i);
            ++this.counter;
        }
        return i;
    }

    public InputStream getUnderlyingStream() {
        return this.in;
    }

    public void setUnderlyingStream(InputStream is) {
        this.in = is;
    }

    public long getCounter() {
        return this.counter;
    }
}

