/*
 * Decompiled with CFR 0.152.
 */
package com.pi4j.io.gpio.tasks.impl;

import com.pi4j.io.gpio.GpioPin;
import com.pi4j.io.gpio.GpioPinInput;
import com.pi4j.io.gpio.PinState;
import com.pi4j.io.gpio.event.GpioPinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.GpioPinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.GpioPinListener;
import com.pi4j.io.gpio.event.GpioPinListenerAnalog;
import com.pi4j.io.gpio.event.GpioPinListenerDigital;
import com.pi4j.io.gpio.event.PinAnalogValueChangeEvent;
import com.pi4j.io.gpio.event.PinDigitalStateChangeEvent;
import com.pi4j.io.gpio.event.PinEvent;
import com.pi4j.io.gpio.event.PinEventType;
import com.pi4j.io.gpio.trigger.GpioTrigger;

public class GpioEventDispatchTaskImpl
implements Runnable {
    private final GpioPinInput pin;
    private final PinEvent event;

    public GpioEventDispatchTaskImpl(GpioPinInput pin, PinEvent event) {
        this.event = event;
        this.pin = pin;
    }

    @Override
    public void run() {
        block3: {
            block4: {
                if (!this.pin.getPin().equals(this.event.getPin())) break block3;
                if (this.event.getEventType() != PinEventType.DIGITAL_STATE_CHANGE) break block4;
                PinState state = ((PinDigitalStateChangeEvent)this.event).getState();
                for (GpioPinListener listener : this.pin.getListeners()) {
                    if (!(listener instanceof GpioPinListenerDigital)) continue;
                    ((GpioPinListenerDigital)listener).handleGpioPinDigitalStateChangeEvent(new GpioPinDigitalStateChangeEvent(this.event.getSource(), (GpioPin)this.pin, state));
                }
                for (GpioTrigger trigger : this.pin.getTriggers()) {
                    if (!trigger.hasPinState(state)) continue;
                    trigger.invoke(this.pin, state);
                }
                break block3;
            }
            if (this.event.getEventType() != PinEventType.ANALOG_VALUE_CHANGE) break block3;
            double value = ((PinAnalogValueChangeEvent)this.event).getValue();
            for (GpioPinListener listener : this.pin.getListeners()) {
                if (!(listener instanceof GpioPinListenerAnalog)) continue;
                ((GpioPinListenerAnalog)listener).handleGpioPinAnalogValueChangeEvent(new GpioPinAnalogValueChangeEvent(this.event.getSource(), (GpioPin)this.pin, value));
            }
        }
    }
}

