/*
 * Decompiled with CFR 0.152.
 */
package bluej.classmgr;

import bluej.utility.Utility;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;

public final class BPClassLoader
extends URLClassLoader {
    private boolean loadsForJavaMEproject;
    private List<URL> javaMEcoreLibs;
    private List<URL> javaMEoptLibs;

    public BPClassLoader(URL[] urls, ClassLoader parent) {
        this(urls, parent, false);
    }

    public BPClassLoader(URL[] urls, ClassLoader parent, boolean meFlag) {
        super(urls, parent);
        this.loadsForJavaMEproject = meFlag;
    }

    public boolean loadsForJavaMEproject() {
        return this.loadsForJavaMEproject;
    }

    public final boolean sameUrls(URL[] compare) {
        URL[] original = this.getURLs();
        if (original == null) {
            return false;
        }
        if (original.length != compare.length) {
            return false;
        }
        for (int index = 0; index < original.length; ++index) {
            if (original[index].equals(compare[index])) continue;
            return false;
        }
        return true;
    }

    public String getClassPathAsString() {
        return Utility.toClasspathString(this.getClassPathAsFiles());
    }

    public final File[] getClassPathAsFiles() {
        return Utility.urlsToFiles(this.getURLs());
    }

    public String toString() {
        return "BPClassLoader path=" + this.getClassPathAsString();
    }

    public void setJavaMEcoreLibs(List<URL> list) {
        this.javaMEcoreLibs = list;
    }

    public void setJavaMEoptLibs(List<URL> list) {
        this.javaMEoptLibs = list;
    }

    public List<URL> getJavaMEcoreLibs() {
        return this.javaMEcoreLibs;
    }

    public List<URL> getJavaMEoptLibs() {
        return this.javaMEoptLibs;
    }

    public File[] getJavaMElibsAsFiles() {
        ArrayList<URL> urls = new ArrayList<URL>(this.javaMEcoreLibs);
        urls.addAll(this.javaMEoptLibs);
        return Utility.urlsToFiles(urls.toArray(new URL[urls.size()]));
    }

    public String getJavaMElibsAsPath() {
        return Utility.toClasspathString(this.getJavaMElibsAsFiles());
    }
}

