/*
 * Decompiled with CFR 0.152.
 */
package bluej.extmgr;

import bluej.extmgr.ExtensionMenu;
import bluej.extmgr.ExtensionWrapper;
import bluej.extmgr.ExtensionsManager;
import bluej.pkgmgr.Project;
import java.util.LinkedList;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public final class MenuManager
implements PopupMenuListener {
    private final ExtensionsManager extMgr = ExtensionsManager.getInstance();
    private final JPopupMenu.Separator menuSeparator;
    private final JPopupMenu popupMenu;
    private ExtensionMenu menuGenerator;

    public MenuManager(JPopupMenu aPopupMenu) {
        this.popupMenu = aPopupMenu;
        this.popupMenu.addPopupMenuListener(this);
        this.menuSeparator = new JPopupMenu.Separator();
    }

    public void addExtensionMenu(Project onThisProject) {
        LinkedList<JMenuItem> menuItems = this.extMgr.getMenuItems(this.menuGenerator, onThisProject);
        MenuElement[] elements = this.popupMenu.getSubElements();
        for (int index = 0; index < elements.length; ++index) {
            ExtensionWrapper aWrapper;
            JComponent aComponent = (JComponent)elements[index].getComponent();
            if (aComponent == null || !(aComponent instanceof JMenuItem) || (aWrapper = (ExtensionWrapper)aComponent.getClientProperty("bluej.extmgr.ExtensionWrapper")) == null) continue;
            this.popupMenu.remove(aComponent);
        }
        this.popupMenu.remove(this.menuSeparator);
        if (menuItems.isEmpty()) {
            return;
        }
        this.popupMenu.add(this.menuSeparator);
        for (JMenuItem menuItem : menuItems) {
            this.popupMenu.add(menuItem);
        }
    }

    public void setMenuGenerator(ExtensionMenu menuGenerator) {
        this.menuGenerator = menuGenerator;
    }

    @Override
    public void popupMenuWillBecomeVisible(PopupMenuEvent event) {
        int itemsCount = 0;
        JPopupMenu aPopup = (JPopupMenu)event.getSource();
        MenuElement[] elements = aPopup.getSubElements();
        for (int index = 0; index < elements.length; ++index) {
            ExtensionWrapper aWrapper;
            JComponent aComponent = (JComponent)elements[index].getComponent();
            if (aComponent == null || !(aComponent instanceof JMenuItem) || (aWrapper = (ExtensionWrapper)aComponent.getClientProperty("bluej.extmgr.ExtensionWrapper")) == null) continue;
            if (!aWrapper.isValid()) {
                this.popupMenu.remove(aComponent);
                continue;
            }
            aWrapper.safePostMenuItem(this.menuGenerator, (JMenuItem)aComponent);
            ++itemsCount;
        }
        if (itemsCount <= 0) {
            this.popupMenu.remove(this.menuSeparator);
        }
    }

    @Override
    public void popupMenuWillBecomeInvisible(PopupMenuEvent event) {
    }

    @Override
    public void popupMenuCanceled(PopupMenuEvent event) {
    }
}

