/*
 * Decompiled with CFR 0.152.
 */
package bluej.parser.nodes;

import bluej.editor.moe.MoeSyntaxDocument;
import bluej.parser.nodes.NodeStructureListener;
import bluej.parser.nodes.NodeTree;
import bluej.parser.nodes.ParsedNode;
import javax.swing.text.Document;

public abstract class ParentParsedNode
extends ParsedNode {
    protected ParentParsedNode() {
    }

    public ParentParsedNode(ParsedNode myParent) {
        super(myParent);
    }

    @Override
    public int textInserted(MoeSyntaxDocument document, int nodePos, int insPos, int length, NodeStructureListener listener) {
        int newSize = this.getSize() + length;
        this.resize(newSize);
        NodeTree.NodeAndPosition<ParsedNode> child = this.getNodeTree().findNodeAtOrAfter(insPos, nodePos);
        if (child != null && (child.getPosition() < insPos || child.getPosition() == insPos && child.getNode().growsForward())) {
            ParsedNode cnode = child.getNode();
            int r = cnode.textInserted(document, child.getPosition(), insPos, length, listener);
            if (r == 1 || r == 2) {
                newSize = child.getNode().getSize();
                child = new NodeTree.NodeAndPosition<ParsedNode>(cnode, child.getPosition(), newSize);
                this.childResized(document, nodePos, child);
                document.scheduleReparse(child.getPosition() + newSize, 0);
                return 0;
            }
            if (r == 3) {
                this.removeChild(child, listener);
                document.scheduleReparse(child.getPosition(), child.getSize());
                return 0;
            }
            return 0;
        }
        if (child != null) {
            child.getNode().getContainingNodeTree().slideNode(length);
        }
        return this.handleInsertion((Document)document, nodePos, insPos, length, listener);
    }

    protected int handleInsertion(Document document, int nodePos, int insPos, int length, NodeStructureListener listener) {
        ((MoeSyntaxDocument)document).scheduleReparse(insPos, length);
        return 0;
    }

    @Override
    public int textRemoved(MoeSyntaxDocument document, int nodePos, int delPos, int length, NodeStructureListener listener) {
        NodeTree.NodeAndPosition<ParsedNode> child;
        int newSize = this.getSize() - length;
        this.resize(newSize);
        int endPos = delPos + length;
        for (child = this.getNodeTree().findNodeAtOrAfter(delPos, nodePos); child != null && child.getEnd() == delPos; child = child.nextSibling()) {
            if (child.getNode().marksOwnEnd()) continue;
            child.getNode().setComplete(false);
        }
        if (child != null && child.getPosition() < delPos) {
            int reparseOffset;
            int r;
            int childEndPos = child.getEnd();
            if (childEndPos >= endPos) {
                int r2 = child.getNode().textRemoved(document, child.getPosition(), delPos, length, listener);
                if (r2 == 3) {
                    this.removeChild(child, listener);
                    document.scheduleReparse(child.getPosition(), child.getSize());
                } else if (r2 != 0) {
                    newSize = child.getNode().getSize();
                    if (newSize < child.getSize()) {
                        document.scheduleReparse(child.getPosition() + newSize, child.getSize() - newSize);
                    } else {
                        document.scheduleReparse(child.getPosition() + newSize, 0);
                    }
                }
                return 0;
            }
            int rlength = childEndPos - delPos;
            NodeTree.NodeAndPosition<ParsedNode> next = child.nextSibling();
            while (next != null && next.getPosition() < endPos) {
                NodeTree.NodeAndPosition<ParsedNode> nnext = next.nextSibling();
                this.removeChild(next, listener);
                next = nnext;
            }
            if (next != null) {
                next.getNode().slide(rlength - length);
            }
            if ((r = child.getNode().textRemoved(document, child.getPosition(), delPos, rlength, listener)) == 3) {
                reparseOffset = child.getPosition();
                this.removeChild(child, listener);
            } else {
                reparseOffset = child.getPosition() + child.getNode().getSize();
            }
            return this.handleDeletion((Document)document, nodePos, reparseOffset, listener);
        }
        while (child != null && child.getPosition() < endPos) {
            NodeTree.NodeAndPosition<ParsedNode> nextChild = child.nextSibling();
            this.removeChild(child, listener);
            child = nextChild;
        }
        if (child != null) {
            child.slide(-length);
            if (child.getPosition() == delPos && child.getNode().growsForward()) {
                this.removeChild(child, listener);
            }
        }
        return this.handleDeletion((Document)document, nodePos, delPos, listener);
    }

    protected int handleDeletion(Document document, int nodePos, int dpos, NodeStructureListener listener) {
        if (nodePos + this.getSize() == dpos && this.marksOwnEnd()) {
            this.complete = false;
        }
        ((MoeSyntaxDocument)document).scheduleReparse(dpos, 0);
        return 0;
    }

    @Override
    protected int reparseNode(Document document, int nodePos, int offset, int maxParse, NodeStructureListener listener) {
        return 3;
    }

    @Override
    protected boolean growChild(Document document, NodeTree.NodeAndPosition<ParsedNode> child, NodeStructureListener listener) {
        return false;
    }
}

