/*
 * Decompiled with CFR 0.152.
 */
package org.bluej.extensions.submitter.properties;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.bluej.extensions.submitter.Stat;

public class TreeNode
extends DefaultMutableTreeNode {
    private static final List configItems = Arrays.asList(".transport", ".file.include", ".file.exclude", ".file.essential", ".file.jar", ".insert");
    private Stat stat;
    private List[] configuration;
    private final String title;
    static int indent;

    public TreeNode(Stat i_stat, String i_title) {
        this.stat = i_stat;
        this.title = i_title;
        this.configuration = new List[configItems.size()];
        int n = this.configuration.length;
        for (int i = 0; i < n; ++i) {
            this.configuration[i] = new ArrayList();
        }
    }

    public String getTitle() {
        return this.title;
    }

    void addConfig(String key, String value) {
        this.stat.aDbg.debug(4, "Node.addConfig: Node.title=" + this.title + " key=" + key + " value=" + value);
        int keyIndex = configItems.indexOf(key);
        if (keyIndex == -1) {
            throw new IllegalArgumentException("Unknown configuration item: " + key);
        }
        List conf = this.configuration[keyIndex];
        if (conf.size() > 0 && key.equals(".transport")) {
            throw new IllegalArgumentException(key + " already set in this node");
        }
        if (key.startsWith(".file.")) {
            int start;
            int end = value.length();
            int index = conf.size();
            do {
                start = value.lastIndexOf(44, end - 1);
                conf.add(index, value.substring(start + 1, end).trim());
                end = start;
            } while (start > 0);
            return;
        }
        if (key.startsWith(".insert")) {
            this.stat.aDbg.debug(4, "Node.addConfig: .insert Node.title=" + this.title + " key=" + key + " value=" + value);
            this.stat.treeData.loadUrl(this, value);
            return;
        }
        conf.add(value);
    }

    public Collection getConfig(String key) {
        int keyIndex = configItems.indexOf(key);
        if (keyIndex == -1) {
            throw new IllegalArgumentException("Unknown configuration item: " + key);
        }
        ArrayList build = new ArrayList(this.configuration[keyIndex]);
        if (this.parent != null) {
            build.addAll(((TreeNode)this.parent).getConfig(key));
        }
        return build;
    }

    boolean isValidKey(String key) {
        return configItems.indexOf(key) != -1;
    }

    public String infoString() {
        if (this.parent == null) {
            indent = 0;
        }
        StringBuffer buf = new StringBuffer();
        for (int ii = 0; ii < indent; ++ii) {
            buf.append(' ');
        }
        buf.append("Node: " + this.title + "\n");
        for (int i = 0; i < this.configuration.length; ++i) {
            List conf = this.configuration[i];
            if (conf.isEmpty()) continue;
            Iterator it = conf.iterator();
            while (it.hasNext()) {
                for (int ii = 0; ii < indent; ++ii) {
                    buf.append(' ');
                }
                buf.append(configItems.get(i) + "=");
                buf.append((String)it.next() + '\n');
            }
        }
        ++indent;
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            buf.append((TreeNode)it.next());
        }
        --indent;
        return buf.toString();
    }

    public String toString() {
        return this.title;
    }

    public Object getUserObject() {
        return this.title;
    }
}

