/*
 * Decompiled with CFR 0.152.
 */
package bluej.editor.moe;

import bluej.Config;
import bluej.editor.moe.BlueJSyntaxView;
import bluej.editor.moe.MoeSyntaxDocument;
import bluej.editor.moe.NaviView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.ViewFactory;

public class NaviviewView
extends BlueJSyntaxView {
    private static final boolean SCOPE_HIGHLIGHTING = true;
    private static final boolean HIGHLIGHT_METHODS_ONLY = true;
    private static final boolean SYNTAX_COLOURING = false;
    private static final int DARKEN_AMOUNT = Config.isMacOS() ? (Config.isMacOSSnowLeopard() ? 2 : 3) : 1;
    private NaviView naviView;

    public NaviviewView(Element elem, NaviView naviView) {
        super(elem, 0);
        this.naviView = naviView;
    }

    @Override
    protected void paintTaggedLine(Segment line, int lineIndex, Graphics g, int x, int y, MoeSyntaxDocument document, Color def, Element lineElement, TabExpander tx) {
        try {
            int lineHeight = this.metrics.getHeight();
            int endPos = lineElement.getEndOffset() - 1;
            Rectangle dummyShape = new Rectangle(0, 0, 0, 0);
            int endX = this.modelToView((int)endPos, (Shape)dummyShape, (Position.Bias)Position.Bias.Forward).getBounds().x;
            int beginX = this.modelToView((int)lineElement.getStartOffset(), (Shape)dummyShape, (Position.Bias)Position.Bias.Forward).getBounds().x;
            int width = endX - beginX;
            if (width <= 0) {
                return;
            }
            Rectangle clipBounds = g.getClipBounds();
            width = Math.min(width, clipBounds.width);
            BufferedImage img = g instanceof Graphics2D ? ((Graphics2D)g).getDeviceConfiguration().createCompatibleImage(width, lineHeight, 3) : new BufferedImage(width, lineHeight, 2);
            Graphics2D imgG = img.createGraphics();
            imgG.setFont(g.getFont());
            imgG.setColor(g.getColor());
            this.paintPlainLine(lineIndex, imgG, x - clipBounds.x, this.metrics.getAscent());
            for (int iy = 0; iy < img.getHeight(); ++iy) {
                for (int ix = 0; ix < img.getWidth(); ++ix) {
                    int argb = img.getRGB(ix, iy);
                    int alpha = argb >>> 24 << DARKEN_AMOUNT;
                    if (alpha > 255) {
                        alpha = 255;
                    }
                    img.setRGB(ix, iy, alpha << 24 | argb & 0xFFFFFF);
                }
            }
            g.drawImage(img, clipBounds.x, y - this.metrics.getAscent(), null);
        }
        catch (BadLocationException ble) {
            // empty catch block
        }
    }

    @Override
    public void paint(Graphics g, Shape a) {
        MoeSyntaxDocument document;
        Rectangle bounds = a.getBounds();
        Rectangle clip = g.getClipBounds();
        if (clip == null) {
            clip = a.getBounds();
        }
        if ((document = (MoeSyntaxDocument)((Object)this.getDocument())).getParsedNode() != null) {
            int spos = this.viewToModel(bounds.x, clip.y, a, new Position.Bias[1]);
            int epos = this.viewToModel(bounds.x, clip.y + clip.height - 1, a, new Position.Bias[1]);
            Element map = this.getElement();
            int firstLine = map.getElementIndex(spos);
            int lastLine = map.getElementIndex(epos);
            this.paintScopeMarkers(this.naviView.getScalingImgBufferGraphics(g), document, a, firstLine, lastLine, true, true);
        }
        super.paint(g, a);
    }

    @Override
    protected void updateDamage(DocumentEvent changes, Shape a, ViewFactory f) {
        Element[] removedChildren;
        Element[] addedChildren;
        DocumentEvent.ElementChange ec = changes.getChange(this.getDocument().getDefaultRootElement());
        if (ec != null && (addedChildren = ec.getChildrenAdded()).length != (removedChildren = ec.getChildrenRemoved()).length) {
            this.naviView.documentChangedLength();
        }
        super.updateDamage(changes, a, f);
    }
}

