/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.attributes;

import edu.rice.cs.cunit.classFile.attributes.AAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.util.Types;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AMultipleAnnotationsAttributeInfo
extends AAnnotationsAttributeInfo {
    public AMultipleAnnotationsAttributeInfo(AUTFPoolInfo name, byte[] data, ConstantPool cp) {
        super(name, data, cp);
    }

    public short getEntityCount() throws ClassFormatError {
        return this._data[0];
    }

    public List<AAnnotationsAttributeInfo.Annotation[]> getEntityAnnotations() throws ClassFormatError {
        ArrayList<AAnnotationsAttributeInfo.Annotation[]> entityAnnots = new ArrayList<AAnnotationsAttributeInfo.Annotation[]>();
        int index = 1;
        for (int entity = 0; entity < this.getEntityCount(); ++entity) {
            int count = Types.ushortFromBytes(this._data, index);
            assert (count <= 65535);
            index += 2;
            AAnnotationsAttributeInfo.Annotation[] ann = new AAnnotationsAttributeInfo.Annotation[count];
            for (int i = 0; i < count; i = (int)((short)(i + 1))) {
                ann[i] = new AAnnotationsAttributeInfo.Annotation(this._constantPool, this._data, index);
                index += ann[i].getSize();
            }
            entityAnnots.add(ann);
        }
        return entityAnnots;
    }

    public void setEntityAnnotations(List<AAnnotationsAttributeInfo.Annotation[]> entityAnnots) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.write((byte)entityAnnots.size());
        for (AAnnotationsAttributeInfo.Annotation[] ann : entityAnnots) {
            baos.write(Types.bytesFromShort((short)ann.length));
            for (int i = 0; i < ann.length; ++i) {
                ann[i].writeToByteArrayOutputStream(this._constantPool, baos);
            }
        }
        this.setData(baos.toByteArray());
    }

    @Override
    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(this._name);
        x.append(" <");
        x.append(this.getEntityCount());
        x.append(" ");
        x.append(this.getEntityName());
        x.append("(s) { ");
        boolean first = true;
        for (AAnnotationsAttributeInfo.Annotation[] entityAnnot : this.getEntityAnnotations()) {
            if (first) {
                first = false;
            } else {
                x.append(", ");
            }
            boolean firstAnn = true;
            for (AAnnotationsAttributeInfo.Annotation ann : entityAnnot) {
                if (firstAnn) {
                    firstAnn = false;
                } else {
                    x.append(", ");
                }
                x.append(ann.toString());
            }
            x.append(" }");
        }
        x.append(" } >");
        return x.toString();
    }

    public abstract String getEntityName();

    @Override
    public void adjustPC(int startPC, int deltaPC) {
    }

    @Override
    public void translatePC(int index, int deltaIndex, LineNumberTable oldLnt, LineNumberTable newLnt) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

