/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.code.instructions;

import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.AInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.LineNumberTable;
import java.util.Arrays;

public class GenericInstruction
extends AInstruction {
    protected byte[] _code;

    public GenericInstruction(byte ... code) {
        switch (code[0]) {
            case -103: 
            case -102: 
            case -101: 
            case -100: 
            case -99: 
            case -98: 
            case -97: 
            case -96: 
            case -95: 
            case -94: 
            case -93: 
            case -92: 
            case -91: 
            case -90: 
            case -89: 
            case -88: 
            case -86: 
            case -85: 
            case -60: 
            case -58: 
            case -57: 
            case -56: 
            case -55: {
                throw new IllegalArgumentException("Invalid generic opcode");
            }
        }
        this._code = code;
    }

    public byte getOpcode() {
        return this._code[0];
    }

    public int getBytecodeLength(int pc) {
        return Opcode.getInstrSize(this._code, 0, 0);
    }

    public GenericInstruction(byte[] bytecode, int pc, int paddingPC, LineNumberTable lnt) {
        this._code = new byte[Opcode.getInstrSize(bytecode, pc, paddingPC)];
        System.arraycopy(bytecode, pc, this._code, 0, this._code.length);
    }

    public byte[] getBytecode(int pc, LineNumberTable lnt) {
        return this.getBytecode();
    }

    public byte[] getBytecode() {
        byte[] b = new byte[this._code.length];
        System.arraycopy(this._code, 0, b, 0, this._code.length);
        return b;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenericInstruction)) {
            return false;
        }
        GenericInstruction genericInstruction = (GenericInstruction)o;
        return Arrays.equals(this._code, genericInstruction._code);
    }

    public int hashCode() {
        return this._code[0];
    }

    public int[] getBranchTargets() {
        return new int[0];
    }

    public void setBranchTargets(int[] branchTargets) {
        if (branchTargets.length != 0) {
            throw new IllegalArgumentException("Generic instruction cannot have a target");
        }
    }

    public String toString() {
        StringBuilder x = new StringBuilder();
        x.append(Opcode.getOpcodeName(this._code[0]));
        x.append(" ");
        for (int i = 1; i < this._code.length; ++i) {
            x.append(String.format("%02x", new Byte(this._code[i])) + " ");
        }
        return x.toString();
    }
}

