/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.classFile.constantPool;

import edu.rice.cs.cunit.classFile.constantPool.ASCIIPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ClassPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ConstantPool;
import edu.rice.cs.cunit.classFile.constantPool.DoublePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.FieldPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.FloatPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.IntegerPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.InterfaceMethodPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.LongPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.MethodPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.NameAndTypePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.StringPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.UnicodePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.IPoolInfoVisitor;
import edu.rice.cs.cunit.util.PositionDataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APoolInfo {
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_Utf8_ASCII = 1;
    public static final int CONSTANT_Utf8_Unicode = 2;
    protected int _type;
    protected ConstantPool _constantPool;

    public APoolInfo(int type, ConstantPool cp) {
        this._type = type;
        this._constantPool = cp;
    }

    public static APoolInfo read(PositionDataInputStream dis, ConstantPool cp) throws IOException, ClassFormatError {
        APoolInfo item;
        byte type = dis.readByte();
        switch (type) {
            case 7: {
                item = new ClassPoolInfo(dis, cp);
                break;
            }
            case 9: {
                item = new FieldPoolInfo(dis, cp);
                break;
            }
            case 10: {
                item = new MethodPoolInfo(dis, cp);
                break;
            }
            case 11: {
                item = new InterfaceMethodPoolInfo(dis, cp);
                break;
            }
            case 12: {
                item = new NameAndTypePoolInfo(dis, cp);
                break;
            }
            case 8: {
                item = new StringPoolInfo(dis, cp);
                break;
            }
            case 3: {
                item = new IntegerPoolInfo(dis, cp);
                break;
            }
            case 4: {
                item = new FloatPoolInfo(dis, cp);
                break;
            }
            case 5: {
                item = new LongPoolInfo(dis, cp);
                break;
            }
            case 6: {
                item = new DoublePoolInfo(dis, cp);
                break;
            }
            case 1: {
                item = new ASCIIPoolInfo(dis, cp);
                break;
            }
            case 2: {
                item = new UnicodePoolInfo(dis, cp);
                break;
            }
            default: {
                throw new ClassFormatError("Unknown constant pool item type: " + type + ", offset: " + (dis.getPosition() - 1L));
            }
        }
        return item;
    }

    public APoolInfo inPool(ConstantPool pool) {
        for (APoolInfo cpi : pool) {
            if (!this.equals(cpi)) continue;
            return cpi;
        }
        return null;
    }

    public abstract void write(DataOutputStream var1) throws IOException;

    public abstract void resolve();

    public abstract void reindex();

    public abstract String toStringVerbose();

    public abstract String toString();

    public abstract int hashCode();

    public abstract boolean equals(Object var1);

    public abstract <R, D> R execute(IPoolInfoVisitor<R, D> var1, D var2);
}

