/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.concJUnit;

import edu.rice.cs.cunit.concJUnit.MultithreadedTestError;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;

public abstract class CreationContextError
extends MultithreadedTestError {
    protected StackTraceElement[] _stes;

    public CreationContextError(String message) {
        this(message, new StackTraceElement[0]);
    }

    public CreationContextError(String message, StackTraceElement[] stes) {
        super(message);
        this._stes = stes;
        this.setStackTrace(stes);
    }

    public CreationContextError(String message, String cc) {
        this(message, CreationContextError.parseCreationContextString(cc));
    }

    public StackTraceElement[] getCreationContext() {
        return this._stes;
    }

    public static StackTraceElement[] parseCreationContextString(String cc) {
        ArrayList<StackTraceElement> stes = new ArrayList<StackTraceElement>();
        if (cc != null) {
            try {
                String line;
                BufferedReader br = new BufferedReader(new StringReader(cc));
                while ((line = br.readLine()) != null) {
                    String className;
                    int parenPos;
                    String beforeParen;
                    int lastDot;
                    String methodName = "???";
                    String fileName = null;
                    int lineNumber = -1;
                    if (line.startsWith("\tat ")) {
                        line = line.substring("\tat ".length());
                    }
                    if ((lastDot = (beforeParen = (parenPos = line.indexOf(40)) >= 0 ? line.substring(0, parenPos) : line).lastIndexOf(46)) >= 0) {
                        className = beforeParen.substring(0, lastDot);
                        methodName = beforeParen.substring(lastDot + 1);
                    } else {
                        className = beforeParen;
                    }
                    if (parenPos >= 0) {
                        String inParen = line.substring(parenPos + 1, line.length() - 1);
                        int colonPos = inParen.lastIndexOf(58);
                        if (colonPos >= 0) {
                            fileName = inParen.substring(0, colonPos);
                            String ln = inParen.substring(colonPos + 1);
                            try {
                                lineNumber = new Integer(ln);
                            }
                            catch (NumberFormatException nfe) {}
                        } else {
                            fileName = inParen;
                        }
                    }
                    stes.add(new StackTraceElement(className, methodName, fileName, lineNumber));
                }
            }
            catch (IOException ie) {
                return new StackTraceElement[0];
            }
        }
        return stes.toArray(new StackTraceElement[stes.size()]);
    }
}

