/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.concJUnit;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.classFile.code.Opcode;
import edu.rice.cs.cunit.classFile.code.instructions.GenericInstruction;
import edu.rice.cs.cunit.classFile.code.instructions.ReferenceInstruction;
import edu.rice.cs.cunit.instrumentors.util.AInsertAtOpcodeStrategy;
import edu.rice.cs.cunit.util.IPredicate;

public class ConcJUnitThreadStrategy
extends AInsertAtOpcodeStrategy {
    public ConcJUnitThreadStrategy() {
        super(new IPredicate<ClassFile>(){

            @Override
            public Boolean apply(ClassFile param) {
                return param.getThisClassName().equals("java.lang.Thread");
            }
        }, new IPredicate.Binary<ClassFile, MethodInfo>(){

            @Override
            public Boolean apply(ClassFile cf, MethodInfo param) {
                return param.getName().toString().equals("start") && param.getDescriptor().toString().equals("()V") || param.getName().toString().equals("join") && param.getDescriptor().toString().equals("(J)V");
            }
        }, new IPredicate.Ternary<ClassFile, MethodInfo, InstructionList>(){

            @Override
            public Boolean apply(ClassFile cf, MethodInfo mi, InstructionList il) {
                return Opcode.isReturn(il.getOpcode());
            }
        }, OPCODE_NEVER);
    }

    public void insertInstructionsBefore(ClassFile cf, MethodInfo mi, InstructionList il) {
        ReferenceInstruction getFlagInstr = new ReferenceInstruction(-78, 0);
        boolean getFlagIndex = false;
        ReferenceInstruction addThreadCallInstr = new ReferenceInstruction(-72, 0);
        int addThreadCallIndex = 0;
        String methodName = "addThreadStarted";
        if (mi.getName().toString().equals("join")) {
            methodName = "addThreadJoined";
        }
        addThreadCallIndex = cf.addMethodToConstantPool("edu/rice/cs/cunit/concJUnit/ThreadSets", methodName, "(Ljava/lang/Thread;)V");
        addThreadCallInstr.setReference(addThreadCallIndex);
        il.insertInstr(new GenericInstruction(42), mi.getCodeAttributeInfo());
        boolean result = il.advanceIndex();
        assert (result);
        il.insertInstr(addThreadCallInstr, mi.getCodeAttributeInfo());
        result = il.advanceIndex();
        assert (result);
    }

    public void insertInstructionsAfter(ClassFile cf, MethodInfo mi, InstructionList il) {
    }

    public boolean insertEndOfMethod(ClassFile cf, MethodInfo mi, InstructionList il, boolean insertBefore, boolean insertAfter) {
        return true;
    }

    public void modifyStackAndLocals(ClassFile cf, MethodInfo mi, InstructionList il, boolean insertBefore, boolean insertAfter, boolean insertEndOfMethod) {
        CodeAttributeInfo.CodeProperties cProps = mi.getCodeAttributeInfo().getProperties();
        cProps.maxStack = Math.max(1, cProps.maxStack);
        mi.getCodeAttributeInfo().setProperties(cProps.maxStack, cProps.maxLocals);
    }

    public void done() {
    }
}

