/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.threadCheck;

import edu.rice.cs.cunit.FileInstrumentor;
import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.ClassFileTools;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.AAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.AAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.ASingleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.AnnotationDefaultAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.InnerClassesAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.LocalVariableTableAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeInvisibleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.RuntimeVisibleAnnotationsAttributeInfo;
import edu.rice.cs.cunit.classFile.attributes.visitors.ADefaultAttributeVisitor;
import edu.rice.cs.cunit.classFile.constantPool.APoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.ASCIIPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.AUTFPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.IntegerPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.LongPoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.UnicodePoolInfo;
import edu.rice.cs.cunit.classFile.constantPool.visitors.ADefaultPoolInfoVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckIntegerVisitor;
import edu.rice.cs.cunit.classFile.constantPool.visitors.CheckUTFVisitor;
import edu.rice.cs.cunit.instrumentors.IInstrumentationStrategy;
import edu.rice.cs.cunit.instrumentors.threadCheck.BadPredicateAnnotationWarning;
import edu.rice.cs.cunit.instrumentors.threadCheck.ClassNotFoundWarning;
import edu.rice.cs.cunit.instrumentors.threadCheck.PredicateAnnotationRecord;
import edu.rice.cs.cunit.instrumentors.util.IScannerStrategy;
import edu.rice.cs.cunit.threadCheck.Combine;
import edu.rice.cs.cunit.threadCheck.OnlyRunBy;
import edu.rice.cs.cunit.threadCheck.PredicateLink;
import edu.rice.cs.cunit.threadCheck.ThreadCheckException;
import edu.rice.cs.cunit.threadCheck.ThreadDesc;
import edu.rice.cs.cunit.util.Debug;
import edu.rice.cs.cunit.util.Ref;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AThreadCheckStrategy
implements IInstrumentationStrategy {
    public static final String CLASS_PATH_PARAM_PREFIX = "class-path=";
    public static final String DEFAULT_XML_PATH_PREFIX = "concutest/threadcheck/";
    public static final String DEFAULT_XML_CONC_DEF_PATH_PREFIX = "concutest/threadcheck:def/";
    public static final String XML_ANNOT_PARAM_PREFIX = "xml-annot=";
    public static final String XML_ANNOT_FORMAT_PARAM = "xml-concdef-annot-format";
    public static final String UPDATE_PARAM_ORDER_PREFIX = "update-param-order=";
    public static final String CLASS_SIG_SEPARATOR_STRING = "::";
    SharedData _sharedData;

    public AThreadCheckStrategy(List<String> parameters, SharedData shared) {
        this._sharedData = shared;
    }

    protected void extractLists(String typeName, ArrayList<AAttributeInfo> attributesList, HashSet<String> threadNames, HashSet<Long> threadIds, HashSet<String> threadGroups, Ref<OnlyRunBy.EVENT_THREAD> eventThread) {
        for (AAttributeInfo ai : attributesList) {
            if (!ai.getName().toString().equals(RuntimeInvisibleAnnotationsAttributeInfo.getAttributeName()) && !ai.getName().toString().equals(RuntimeVisibleAnnotationsAttributeInfo.getAttributeName())) continue;
            ASingleAnnotationsAttributeInfo aa = (ASingleAnnotationsAttributeInfo)ai;
            for (AAnnotationsAttributeInfo.Annotation annot : aa.getAnnotations()) {
                if (!annot.getType().equals(typeName.replace('.', '/') + ";")) continue;
                for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : annot.getPairs()) {
                    if (nvp.getName().toString().equals("value")) {
                        Ref<Object> eThr = new Ref<Object>(null);
                        this.extractAnnotationArray(nvp.getValue(), threadNames, threadIds, threadGroups, eventThread);
                        if (eThr.get() == null || eventThread.get() == null) continue;
                        throw new ThreadCheckException("eventThread may only be specified once");
                    }
                    if (nvp.getName().toString().equals("threadNames")) {
                        this.extractStringArray(nvp.getValue(), threadNames);
                        continue;
                    }
                    if (nvp.getName().toString().equals("threadIds")) {
                        this.extractLongArray(nvp.getValue(), threadIds);
                        continue;
                    }
                    if (nvp.getName().toString().equals("threadGroups")) {
                        this.extractStringArray(nvp.getValue(), threadGroups);
                        continue;
                    }
                    if (eventThread != null && nvp.getName().toString().equals("eventThread")) {
                        if (eventThread.get() != null) {
                            throw new ThreadCheckException("eventThread may only be specified once");
                        }
                        AAnnotationsAttributeInfo.Annotation.EnumMemberValue ev = nvp.getValue().execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.EnumMemberValue, Object>(){

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.EnumMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                                throw new ThreadCheckException("eventThread should be a OnlyRunBy.EVENT_THREAD");
                            }

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.EnumMemberValue enumMemberCase(AAnnotationsAttributeInfo.Annotation.EnumMemberValue host, Object o) {
                                return host;
                            }
                        }, null);
                        AUTFPoolInfo str = ev.getConstValue().execute(new ADefaultPoolInfoVisitor<AUTFPoolInfo, Object>(){

                            @Override
                            public AUTFPoolInfo defaultCase(APoolInfo host, Object o) {
                                throw new ThreadCheckException("eventThread should be a OnlyRunBy.EVENT_THREAD");
                            }

                            @Override
                            public AUTFPoolInfo unicodeCase(UnicodePoolInfo host, Object o) {
                                return host;
                            }

                            @Override
                            public AUTFPoolInfo asciizCase(ASCIIPoolInfo host, Object o) {
                                return host;
                            }
                        }, null);
                        if (str.toString().equals("NO")) {
                            eventThread.set(OnlyRunBy.EVENT_THREAD.NO);
                            continue;
                        }
                        if (str.toString().equals("ONLY")) {
                            eventThread.set(OnlyRunBy.EVENT_THREAD.ONLY);
                            continue;
                        }
                        if (str.toString().equals("ONLY_AFTER_REALIZED")) {
                            eventThread.set(OnlyRunBy.EVENT_THREAD.ONLY_AFTER_REALIZED);
                            continue;
                        }
                        throw new ThreadCheckException("eventThread should be a OnlyRunBy.EVENT_THREAD");
                    }
                    throw new ThreadCheckException("Unknown field in " + typeName + " annotation: " + nvp.getName());
                }
            }
        }
    }

    protected void extractAnnotationArray(AAnnotationsAttributeInfo.Annotation.AMemberValue mv, HashSet<String> threadNames, HashSet<Long> threadIds, HashSet<String> threadGroups, Ref<OnlyRunBy.EVENT_THREAD> eventThread) {
        AAnnotationsAttributeInfo.Annotation.ArrayMemberValue arr = mv.execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.ArrayMemberValue, Object>(){

            @Override
            public AAnnotationsAttributeInfo.Annotation.ArrayMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                throw new ThreadCheckException("value should be an array of @ThreadDesc annotations");
            }

            @Override
            public AAnnotationsAttributeInfo.Annotation.ArrayMemberValue arrayMemberCase(AAnnotationsAttributeInfo.Annotation.ArrayMemberValue host, Object o) {
                return host;
            }
        }, null);
        for (AAnnotationsAttributeInfo.Annotation.AMemberValue arrEntry : arr.getEntries()) {
            AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue av = arrEntry.execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue, Object>(){

                @Override
                public AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                    throw new ThreadCheckException("value should be an array of @ThreadDesc annotations");
                }

                @Override
                public AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue annotationMemberCase(AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue host, Object o) {
                    return host;
                }
            }, null);
            String name = null;
            Long id = null;
            String group = null;
            OnlyRunBy.EVENT_THREAD eThrd = null;
            if (av.getAnnotation().getType().equals("L" + ThreadDesc.class.getName().replace('.', '/') + ";")) {
                for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : av.getAnnotation().getPairs()) {
                    AUTFPoolInfo str;
                    AAnnotationsAttributeInfo.Annotation.ConstantMemberValue cvp;
                    if (nvp.getName().toString().equals("name")) {
                        cvp = nvp.getValue().execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.ConstantMemberValue, Object>(){

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                                throw new ThreadCheckException("@ThreadDesc name should be a string");
                            }

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue constantMemberCase(AAnnotationsAttributeInfo.Annotation.ConstantMemberValue host, Object o) {
                                return host;
                            }
                        }, null);
                        str = cvp.getConstValue().execute(new ADefaultPoolInfoVisitor<AUTFPoolInfo, Object>(){

                            @Override
                            public AUTFPoolInfo defaultCase(APoolInfo host, Object o) {
                                throw new ThreadCheckException("@ThreadDesc name should be a string");
                            }

                            @Override
                            public AUTFPoolInfo asciizCase(ASCIIPoolInfo host, Object o) {
                                return host;
                            }

                            @Override
                            public AUTFPoolInfo unicodeCase(UnicodePoolInfo host, Object o) {
                                return host;
                            }
                        }, null);
                        name = str.toString();
                        continue;
                    }
                    if (nvp.getName().toString().equals("id")) {
                        cvp = nvp.getValue().execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.ConstantMemberValue, Object>(){

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                                throw new ThreadCheckException("@ThreadDesc id should be a long");
                            }

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue constantMemberCase(AAnnotationsAttributeInfo.Annotation.ConstantMemberValue host, Object o) {
                                return host;
                            }
                        }, null);
                        LongPoolInfo l = cvp.getConstValue().execute(new ADefaultPoolInfoVisitor<LongPoolInfo, Object>(){

                            @Override
                            public LongPoolInfo defaultCase(APoolInfo host, Object o) {
                                throw new ThreadCheckException("@ThreadDesc id should be a long");
                            }

                            @Override
                            public LongPoolInfo longCase(LongPoolInfo host, Object o) {
                                return host;
                            }
                        }, null);
                        id = l.getLongValue();
                        continue;
                    }
                    if (nvp.getName().toString().equals("group")) {
                        cvp = nvp.getValue().execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.ConstantMemberValue, Object>(){

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                                throw new ThreadCheckException("@ThreadDesc group should be a string");
                            }

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue constantMemberCase(AAnnotationsAttributeInfo.Annotation.ConstantMemberValue host, Object o) {
                                return host;
                            }
                        }, null);
                        str = cvp.getConstValue().execute(new ADefaultPoolInfoVisitor<AUTFPoolInfo, Object>(){

                            @Override
                            public AUTFPoolInfo defaultCase(APoolInfo host, Object o) {
                                throw new ThreadCheckException("@ThreadDesc group should be a string");
                            }

                            @Override
                            public AUTFPoolInfo asciizCase(ASCIIPoolInfo host, Object o) {
                                return host;
                            }

                            @Override
                            public AUTFPoolInfo unicodeCase(UnicodePoolInfo host, Object o) {
                                return host;
                            }
                        }, null);
                        group = str.toString();
                        continue;
                    }
                    if (eventThread != null && nvp.getName().toString().equals("eventThread")) {
                        AAnnotationsAttributeInfo.Annotation.EnumMemberValue ev = nvp.getValue().execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.EnumMemberValue, Object>(){

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.EnumMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                                throw new ThreadCheckException("eventThread should be a OnlyRunBy.EVENT_THREAD");
                            }

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.EnumMemberValue enumMemberCase(AAnnotationsAttributeInfo.Annotation.EnumMemberValue host, Object o) {
                                return host;
                            }
                        }, null);
                        str = ev.getConstValue().execute(new ADefaultPoolInfoVisitor<AUTFPoolInfo, Object>(){

                            @Override
                            public AUTFPoolInfo defaultCase(APoolInfo host, Object o) {
                                throw new ThreadCheckException("eventThread should be a OnlyRunBy.EVENT_THREAD");
                            }

                            @Override
                            public AUTFPoolInfo unicodeCase(UnicodePoolInfo host, Object o) {
                                return host;
                            }

                            @Override
                            public AUTFPoolInfo asciizCase(ASCIIPoolInfo host, Object o) {
                                return host;
                            }
                        }, null);
                        if (str.toString().equals("NO")) {
                            eThrd = OnlyRunBy.EVENT_THREAD.NO;
                            continue;
                        }
                        if (str.toString().equals("ONLY")) {
                            eThrd = OnlyRunBy.EVENT_THREAD.ONLY;
                            continue;
                        }
                        if (str.toString().equals("ONLY_AFTER_REALIZED")) {
                            eThrd = OnlyRunBy.EVENT_THREAD.ONLY_AFTER_REALIZED;
                            continue;
                        }
                        throw new ThreadCheckException("eventThread should be a OnlyRunBy.EVENT_THREAD");
                    }
                    throw new ThreadCheckException("Unknown field in @ThreadDesk: " + nvp.getName());
                }
                if (name != null) {
                    if (id != null || group != null || eThrd != null) {
                        throw new ThreadCheckException("Only exactly one attribute (name,id,group,eventThread) may be used.");
                    }
                    threadNames.add(name);
                    continue;
                }
                if (id != null) {
                    if (name != null || group != null || eThrd != null) {
                        throw new ThreadCheckException("Only exactly one attribute (name,id,group,eventThread) may be used.");
                    }
                    threadIds.add(id);
                    continue;
                }
                if (group != null) {
                    if (name != null || id != null || eThrd != null) {
                        throw new ThreadCheckException("Only exactly one attribute (name,id,group,eventThread) may be used.");
                    }
                    threadGroups.add(group);
                    continue;
                }
                if (eThrd == null) continue;
                if (name != null || id != null || group != null) {
                    throw new ThreadCheckException("Only exactly one attribute (name,id,group,eventThread) may be used.");
                }
                eventThread.set(eThrd);
                continue;
            }
            throw new ThreadCheckException("value should be an array of @ThreadDesc annotations");
        }
    }

    protected void extractStringArray(AAnnotationsAttributeInfo.Annotation.AMemberValue mv, HashSet<String> set) {
        AAnnotationsAttributeInfo.Annotation.ArrayMemberValue arr = mv.execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.ArrayMemberValue, Object>(){

            @Override
            public AAnnotationsAttributeInfo.Annotation.ArrayMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                throw new ThreadCheckException("threadNames/threadGroups should be an array of strings");
            }

            @Override
            public AAnnotationsAttributeInfo.Annotation.ArrayMemberValue arrayMemberCase(AAnnotationsAttributeInfo.Annotation.ArrayMemberValue host, Object o) {
                return host;
            }
        }, null);
        for (AAnnotationsAttributeInfo.Annotation.AMemberValue arrEntry : arr.getEntries()) {
            AAnnotationsAttributeInfo.Annotation.ConstantMemberValue cv = arrEntry.execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.ConstantMemberValue, Object>(){

                @Override
                public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                    throw new ThreadCheckException("threadNames/threadGroups should be an array of strings");
                }

                @Override
                public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue constantMemberCase(AAnnotationsAttributeInfo.Annotation.ConstantMemberValue host, Object o) {
                    return host;
                }
            }, null);
            AUTFPoolInfo str = cv.getConstValue().execute(new ADefaultPoolInfoVisitor<AUTFPoolInfo, Object>(){

                @Override
                public AUTFPoolInfo defaultCase(APoolInfo host, Object o) {
                    throw new ThreadCheckException("threadNames/threadGroups should be an array of strings");
                }

                @Override
                public AUTFPoolInfo asciizCase(ASCIIPoolInfo host, Object o) {
                    return host;
                }

                @Override
                public AUTFPoolInfo unicodeCase(UnicodePoolInfo host, Object o) {
                    return host;
                }
            }, null);
            set.add(str.toString());
        }
    }

    protected void extractLongArray(AAnnotationsAttributeInfo.Annotation.AMemberValue mv, HashSet<Long> set) {
        AAnnotationsAttributeInfo.Annotation.ArrayMemberValue arr = mv.execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.ArrayMemberValue, Object>(){

            @Override
            public AAnnotationsAttributeInfo.Annotation.ArrayMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                throw new ThreadCheckException("threadIds should be an array of longs");
            }

            @Override
            public AAnnotationsAttributeInfo.Annotation.ArrayMemberValue arrayMemberCase(AAnnotationsAttributeInfo.Annotation.ArrayMemberValue host, Object o) {
                return host;
            }
        }, null);
        for (AAnnotationsAttributeInfo.Annotation.AMemberValue arrEntry : arr.getEntries()) {
            AAnnotationsAttributeInfo.Annotation.ConstantMemberValue cv = arrEntry.execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.ConstantMemberValue, Object>(){

                @Override
                public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                    throw new ThreadCheckException("threadIds should be an array of longs");
                }

                @Override
                public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue constantMemberCase(AAnnotationsAttributeInfo.Annotation.ConstantMemberValue host, Object o) {
                    return host;
                }
            }, null);
            LongPoolInfo l = cv.getConstValue().execute(new ADefaultPoolInfoVisitor<LongPoolInfo, Object>(){

                @Override
                public LongPoolInfo defaultCase(APoolInfo host, Object o) {
                    throw new ThreadCheckException("threadIds should be an array of longs");
                }

                @Override
                public LongPoolInfo longCase(LongPoolInfo host, Object o) {
                    return host;
                }
            }, null);
            set.add(l.getLongValue());
        }
    }

    protected void extractPredicateSet(ArrayList<AAttributeInfo> attributesList, ArrayList<PredicateAnnotationRecord> predicateSet, String methodSig) {
        for (AAttributeInfo ai : attributesList) {
            if (!ai.getName().toString().equals(RuntimeInvisibleAnnotationsAttributeInfo.getAttributeName()) && !ai.getName().toString().equals(RuntimeVisibleAnnotationsAttributeInfo.getAttributeName())) continue;
            ASingleAnnotationsAttributeInfo aa = (ASingleAnnotationsAttributeInfo)ai;
            for (AAnnotationsAttributeInfo.Annotation annot : aa.getAnnotations()) {
                PredicateAnnotationRecord par = this.processAnnotation(annot);
                if (par == null) continue;
                predicateSet.add(par);
            }
        }
    }

    protected AAnnotationsAttributeInfo.Annotation getPredicateLink(ArrayList<AAttributeInfo> attributesList) {
        for (AAttributeInfo ai : attributesList) {
            if (!ai.getName().toString().equals(RuntimeInvisibleAnnotationsAttributeInfo.getAttributeName()) && !ai.getName().toString().equals(RuntimeVisibleAnnotationsAttributeInfo.getAttributeName())) continue;
            ASingleAnnotationsAttributeInfo aa = (ASingleAnnotationsAttributeInfo)ai;
            for (AAnnotationsAttributeInfo.Annotation annot : aa.getAnnotations()) {
                if (!annot.getType().equals("L" + PredicateLink.class.getName().replace('.', '/') + ";")) continue;
                return annot;
            }
        }
        return null;
    }

    protected AAnnotationsAttributeInfo.Annotation getCombineMode(ArrayList<AAttributeInfo> attributesList) {
        for (AAttributeInfo ai : attributesList) {
            if (!ai.getName().toString().equals(RuntimeInvisibleAnnotationsAttributeInfo.getAttributeName()) && !ai.getName().toString().equals(RuntimeVisibleAnnotationsAttributeInfo.getAttributeName())) continue;
            ASingleAnnotationsAttributeInfo aa = (ASingleAnnotationsAttributeInfo)ai;
            for (AAnnotationsAttributeInfo.Annotation annot : aa.getAnnotations()) {
                if (!annot.getType().equals("L" + Combine.class.getName().replace('.', '/') + ";")) continue;
                return annot;
            }
        }
        return null;
    }

    protected PredicateAnnotationRecord processAnnotation(AAnnotationsAttributeInfo.Annotation annot) {
        PredicateAnnotationRecord par;
        APoolInfo mpi;
        String cn;
        AAnnotationsAttributeInfo.Annotation.AMemberValue cmv;
        Ref<Object> refCL = new Ref<Object>(null);
        Ref<Object> refPredicateLink = new Ref<Object>(null);
        Ref<Object> refCombineAnnot = new Ref<Object>(null);
        if (!this.getAnnotationClassFile(annot.getType(), refCL, refPredicateLink, refCombineAnnot) || refCL.get() == null) {
            return null;
        }
        final ClassFile cf = ((ClassFileTools.ClassLocation)refCL.get()).getClassFile();
        String predicateClass = null;
        String predicateMethod = "check";
        boolean passArguments = false;
        Combine.Mode combineMode = Combine.Mode.OR;
        ClassFile predicateCF = null;
        if (refPredicateLink.get() != null) {
            ClassFileTools.ClassLocation cl;
            try {
                for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : ((AAnnotationsAttributeInfo.Annotation)refPredicateLink.get()).getPairs()) {
                    if (nvp.getName().toString().equals("value")) {
                        cmv = nvp.getValue().execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.ClassMemberValue, Object>(){

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.ClassMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object param) {
                                throw new BadPredicateAnnotationWarning("@PredicateLink's value member should be a class constant in " + cf.getThisClassName() + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")");
                            }

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.ClassMemberValue classMemberCase(AAnnotationsAttributeInfo.Annotation.ClassMemberValue host, Object param) {
                                return host;
                            }
                        }, null);
                        cn = ((AAnnotationsAttributeInfo.Annotation.ClassMemberValue)cmv).getClassName().toString();
                        predicateClass = cn.substring(1, cn.length() - 1).replace('/', '.');
                        continue;
                    }
                    if (nvp.getName().toString().equals("method")) {
                        cmv = nvp.getValue().execute(AAnnotationsAttributeInfo.Annotation.CheckConstantMemberVisitor.singleton(), null);
                        mpi = ((AAnnotationsAttributeInfo.Annotation.ConstantMemberValue)cmv).getConstValue().execute(new ADefaultPoolInfoVisitor<AUTFPoolInfo, Object>(){

                            @Override
                            public AUTFPoolInfo defaultCase(APoolInfo host, Object param) {
                                throw new BadPredicateAnnotationWarning("@PredicateLink's value member should be a string constant in " + cf.getThisClassName() + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")");
                            }

                            @Override
                            public AUTFPoolInfo asciizCase(ASCIIPoolInfo host, Object param) {
                                return host;
                            }

                            @Override
                            public AUTFPoolInfo unicodeCase(UnicodePoolInfo host, Object param) {
                                return host;
                            }
                        }, null);
                        predicateMethod = ((AUTFPoolInfo)mpi).toString();
                        continue;
                    }
                    if (!nvp.getName().toString().equals("arguments") || ((IntegerPoolInfo)(mpi = ((AAnnotationsAttributeInfo.Annotation.ConstantMemberValue)(cmv = nvp.getValue().execute(AAnnotationsAttributeInfo.Annotation.CheckConstantMemberVisitor.singleton(), null))).getConstValue().execute(new ADefaultPoolInfoVisitor<IntegerPoolInfo, Object>(){

                        @Override
                        public IntegerPoolInfo defaultCase(APoolInfo host, Object param) {
                            throw new BadPredicateAnnotationWarning("@PredicateLink's value arguments should be a boolean constant in " + cf.getThisClassName() + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")");
                        }

                        @Override
                        public IntegerPoolInfo intCase(IntegerPoolInfo host, Object param) {
                            return host;
                        }
                    }, null))).getIntValue() == 0) continue;
                    passArguments = true;
                }
            }
            catch (BadPredicateAnnotationWarning bpaw) {
                this._sharedData.addBadPredicateAnnotWarning(bpaw);
                return null;
            }
            if (predicateClass == null) {
                this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("Predicate class not specified in " + cf.getThisClassName() + " (processing " + this._sharedData.getCurrentClassName() + ")"));
            }
            if ((cl = ClassFileTools.findClassFile(predicateClass, this._sharedData._classPath)) == null) {
                this._sharedData.addClassNotFoundWarning(new ClassNotFoundWarning(predicateClass, this._sharedData.getCurrentClassName()));
                return null;
            }
            predicateCF = cl.getClassFile();
            try {
                cl.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            cl = null;
        }
        if (refCombineAnnot.get() != null) {
            try {
                for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : ((AAnnotationsAttributeInfo.Annotation)refCombineAnnot.get()).getPairs()) {
                    if (nvp.getName().toString().equals("value")) {
                        AAnnotationsAttributeInfo.Annotation.EnumMemberValue emv = nvp.getValue().execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.EnumMemberValue, Object>(){

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.EnumMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object param) {
                                throw new BadPredicateAnnotationWarning("@Combine's value member should be an enum constant in " + cf.getThisClassName() + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")");
                            }

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.EnumMemberValue enumMemberCase(AAnnotationsAttributeInfo.Annotation.EnumMemberValue host, Object param) {
                                return host;
                            }
                        }, null);
                        if (!emv.getTypeName().toString().equals("L" + Combine.Mode.class.getName().replace('.', '/') + ";")) {
                            throw new BadPredicateAnnotationWarning("@Combine's value member should be an enum constant of type " + Combine.Mode.class.getName() + " in " + cf.getThisClassName() + " (processing " + this._sharedData.getCurrentClassName() + ")");
                        }
                        cn = emv.getConstValue().toString();
                        if (cn.equals(Combine.Mode.AND.toString())) {
                            combineMode = Combine.Mode.AND;
                            continue;
                        }
                        if (cn.equals(Combine.Mode.OR.toString())) {
                            combineMode = Combine.Mode.OR;
                            continue;
                        }
                        if (cn.equals(Combine.Mode.NOT.toString())) {
                            combineMode = Combine.Mode.NOT;
                            continue;
                        }
                        if (cn.equals(Combine.Mode.XOR.toString())) {
                            combineMode = Combine.Mode.XOR;
                            continue;
                        }
                        if (cn.equals(Combine.Mode.IMPLIES.toString())) {
                            combineMode = Combine.Mode.IMPLIES;
                            continue;
                        }
                        throw new BadPredicateAnnotationWarning("@Combine's value member (" + cn + ") was not recognized; " + "it should be an enum constant of type " + Combine.Mode.class.getName() + " in " + cf.getThisClassName() + " (processing " + this._sharedData.getCurrentClassName() + ")");
                    }
                    if (!nvp.getName().toString().equals("arguments") || ((IntegerPoolInfo)(mpi = ((AAnnotationsAttributeInfo.Annotation.ConstantMemberValue)(cmv = nvp.getValue().execute(AAnnotationsAttributeInfo.Annotation.CheckConstantMemberVisitor.singleton(), null))).getConstValue().execute(new ADefaultPoolInfoVisitor<IntegerPoolInfo, Object>(){

                        @Override
                        public IntegerPoolInfo defaultCase(APoolInfo host, Object param) {
                            throw new BadPredicateAnnotationWarning("@Combine's value arguments should be a boolean constant in " + cf.getThisClassName() + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")");
                        }

                        @Override
                        public IntegerPoolInfo intCase(IntegerPoolInfo host, Object param) {
                            return host;
                        }
                    }, null))).getIntValue() == 0) continue;
                    passArguments = true;
                }
            }
            catch (BadPredicateAnnotationWarning bpaw) {
                this._sharedData.addBadPredicateAnnotWarning(bpaw);
                return null;
            }
        }
        try {
            par = this.getPredicateAnnotationRecord(annot, refCL.get(), predicateCF, predicateMethod, combineMode, passArguments);
        }
        catch (BadPredicateAnnotationWarning bpaw) {
            this._sharedData.addBadPredicateAnnotWarning(bpaw);
            return null;
        }
        if (par == null) {
            this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("Predicate method " + predicateMethod + " in class " + predicateClass + " not found in " + cf.getThisClassName() + " (processing " + this._sharedData.getCurrentClassName() + ")"));
            return null;
        }
        return par;
    }

    protected boolean getAnnotationClassFile(String annotType, Ref<ClassFileTools.ClassLocation> refCL, Ref<AAnnotationsAttributeInfo.Annotation> predicateLink, Ref<AAnnotationsAttributeInfo.Annotation> combineAnnot) {
        String className = annotType.substring(1, annotType.length() - 1).replace('/', '.');
        ClassFileTools.ClassLocation cl = ClassFileTools.findClassFile(className, this._sharedData._classPath);
        if (cl == null) {
            this._sharedData.addClassNotFoundWarning(new ClassNotFoundWarning(className, this._sharedData.getCurrentClassName()));
            return false;
        }
        refCL.set(cl);
        try {
            cl.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        if ((cl.getClassFile().getClassAccessFlags() & 0x2000) == 0) {
            this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning(className + " is not an annotation " + " (processing " + this._sharedData.getCurrentClassName() + ")"));
            return false;
        }
        predicateLink.set(this.getPredicateLink(cl.getClassFile().getAttributes()));
        combineAnnot.set(this.getCombineMode(cl.getClassFile().getAttributes()));
        if (predicateLink.get() == null && combineAnnot.get() == null) {
            return false;
        }
        if (predicateLink.get() != null && combineAnnot.get() != null) {
            this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("@PredicateLink and @Combine are mutually exclusive, but both were provided in " + className + " (processing " + this._sharedData.getCurrentClassName() + ")"));
            return false;
        }
        return true;
    }

    protected PredicateAnnotationRecord getPredicateAnnotationRecord(final AAnnotationsAttributeInfo.Annotation annot, ClassFileTools.ClassLocation annotCL, ClassFile predicateCF, String predicateMethod, Combine.Mode combineMode, boolean passArguments) {
        String t;
        ClassFile annotCF = annotCL.getClassFile();
        if (predicateCF != null) {
            if (predicateCF.getAttribute("EnclosingMethod") != null) {
                this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("Predicate method class " + predicateCF.getThisClassName() + " is not accessible from everywhere (anonymous inner class)" + " (processing " + this._sharedData.getCurrentClassName() + ")"));
            } else if (this.checkPublicStaticIfNestedClass(predicateCF, predicateCF) && (predicateCF.getClassAccessFlags() & 1) == 0) {
                this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("Predicate method class " + predicateCF.getThisClassName() + " is not accessible from everywhere (not public)" + " (processing " + this._sharedData.getCurrentClassName() + ")"));
            }
            this.checkPredicateMembers(annotCF, passArguments);
            for (final AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : annot.getPairs()) {
                nvp.getValue().execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<Object, Object>(){

                    @Override
                    public Object defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object param) {
                        return null;
                    }

                    @Override
                    public Object annotationMemberCase(AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue host, Object param) {
                        String t = annot.getType();
                        AThreadCheckStrategy.this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("Annotation " + t.substring(1, t.length() - 1) + " has meta-annotation @Predicate, " + "but contains a member that is an annotation: " + nvp.getName() + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")"));
                        return null;
                    }

                    @Override
                    public Object arrayMemberCase(AAnnotationsAttributeInfo.Annotation.ArrayMemberValue host, Object param) {
                        for (AAnnotationsAttributeInfo.Annotation.AMemberValue mv : host.getEntries()) {
                            mv.execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<Object, Object>(){

                                @Override
                                public Object defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object param) {
                                    return null;
                                }

                                @Override
                                public Object annotationMemberCase(AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue host, Object param) {
                                    String t = annot.getType();
                                    AThreadCheckStrategy.this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("Annotation " + t.substring(1, t.length() - 1) + " has meta-annotation @Predicate, " + "but contains a member that is an array of annotations: " + nvp.getName() + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")"));
                                    return null;
                                }
                            }, null);
                        }
                        return null;
                    }
                }, null);
            }
            ArrayList<String> paramNames = null;
            int parenIndex = predicateMethod.indexOf(40);
            if (parenIndex >= 0) {
                if (!predicateMethod.endsWith(")")) {
                    this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("Annotation " + annot.getType().substring(1, annot.getType().length() - 1) + " has meta-annotation @Predicate, " + "with a bad method value whose parameter list does not end with a ')' " + " (processing " + this._sharedData.getCurrentClassName() + ")"));
                    return null;
                }
                paramNames = new ArrayList<String>();
                String s = predicateMethod.substring(parenIndex + 1, predicateMethod.length() - 1);
                if (s.length() > 0) {
                    String[] specifiedOrder;
                    for (String name : specifiedOrder = s.split(",")) {
                        if (name.length() <= 0) continue;
                        paramNames.add(name);
                    }
                }
                predicateMethod = predicateMethod.substring(0, parenIndex);
            }
            for (MethodInfo mi : predicateCF.getMethods()) {
                AAttributeInfo caAttr;
                if (!mi.getName().toString().equals(predicateMethod)) continue;
                String desc = mi.getDescriptor().toString();
                if ((mi.getAccessFlags() & 1) == 0 || (mi.getAccessFlags() & 8) == 0 || (mi.getAccessFlags() & 0x400) != 0) continue;
                String prefix = "(Ljava/lang/Object;" + (passArguments ? "[Ljava/lang/Object;" : "");
                if (!desc.startsWith(prefix)) continue;
                String suffix = ")Z";
                if (!desc.endsWith(")Z")) continue;
                String paramString = desc.substring(prefix.length(), desc.length() - ")Z".length());
                List<String> paramTypeList = ClassFileTools.getSignatures(paramString);
                if (annotCF.getMethods().size() != paramTypeList.size()) continue;
                CodeAttributeInfo ca = mi.getCodeAttributeInfo();
                LocalVariableTableAttributeInfo lvarTable = null;
                AAttributeInfo[] arr$ = ca.getAttributes();
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$ && (lvarTable = (caAttr = arr$[i$]).execute(new ADefaultAttributeVisitor<LocalVariableTableAttributeInfo, Object>(){

                    @Override
                    public LocalVariableTableAttributeInfo defaultCase(AAttributeInfo host, Object param) {
                        return null;
                    }

                    @Override
                    public LocalVariableTableAttributeInfo localVariableTableCase(LocalVariableTableAttributeInfo host, Object param) {
                        return host;
                    }
                }, null)) == null; ++i$) {
                }
                if (paramNames == null) {
                    String retType;
                    String noParamPrefix;
                    String annotDesc;
                    boolean mismatch;
                    paramNames = new ArrayList(annotCF.getMethods().size());
                    if (lvarTable == null) {
                        this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("No LocalVariableTable for method " + predicateMethod + desc + " in class " + predicateCF.getThisClassName() + "; matching by order, not names" + " (processing " + this._sharedData.getCurrentClassName() + ")"));
                        int paramIndex = 0;
                        mismatch = false;
                        for (MethodInfo annotMI : annotCF.getMethods()) {
                            annotDesc = annotMI.getDescriptor().toString();
                            if ((annotMI.getAccessFlags() & 1) == 0) {
                                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has non-public method " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
                            }
                            if ((annotMI.getAccessFlags() & 0x400) == 0) {
                                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has non-abstract method " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
                            }
                            noParamPrefix = "()";
                            if (!annotDesc.startsWith("()")) {
                                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has method taking arguments " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
                            }
                            retType = annotDesc.substring("()".length());
                            if (!retType.equals(paramTypeList.get(paramIndex++))) {
                                mismatch = true;
                                break;
                            }
                            paramNames.add(annotMI.getName().toString());
                        }
                        if (mismatch) {
                            continue;
                        }
                    } else {
                        ArrayList<LocalVariableTableAttributeInfo.LocalVariableRecord> predicateParams = new ArrayList<LocalVariableTableAttributeInfo.LocalVariableRecord>();
                        for (LocalVariableTableAttributeInfo.LocalVariableRecord lvr : lvarTable.getLocalVariables()) {
                            if (lvr.startPC != 0 || lvr.length != ca.getCode().length) continue;
                            predicateParams.add(lvr);
                        }
                        Collections.sort(predicateParams, new Comparator<LocalVariableTableAttributeInfo.LocalVariableRecord>(){

                            @Override
                            public int compare(LocalVariableTableAttributeInfo.LocalVariableRecord o1, LocalVariableTableAttributeInfo.LocalVariableRecord o2) {
                                return o1.index - o2.index;
                            }
                        });
                        if (((LocalVariableTableAttributeInfo.LocalVariableRecord)predicateParams.get((int)0)).index != 0) {
                            throw new BadPredicateAnnotationWarning("Predicate method " + mi.getName().toString() + mi.getDescriptor().toString() + " in class " + predicateCF.getThisClassName() + " has parameters not starting at index 0" + " (processing " + this._sharedData.getCurrentClassName() + ")");
                        }
                        if (!((LocalVariableTableAttributeInfo.LocalVariableRecord)predicateParams.get((int)0)).descriptor.toString().equals("L" + Object.class.getName().replace('.', '/') + ";")) {
                            throw new BadPredicateAnnotationWarning("Predicate method " + mi.getName().toString() + mi.getDescriptor().toString() + " in class " + predicateCF.getThisClassName() + " does not have Object as parameter at index 0: " + ((LocalVariableTableAttributeInfo.LocalVariableRecord)predicateParams.get((int)0)).descriptor + " (processing " + this._sharedData.getCurrentClassName() + ")");
                        }
                        predicateParams.remove(0);
                        if (passArguments) {
                            predicateParams.remove(0);
                        }
                        if (annotCF.getMethods().size() != predicateParams.size()) {
                            throw new BadPredicateAnnotationWarning("Predicate method " + mi.getName().toString() + mi.getDescriptor().toString() + " in class " + predicateCF.getThisClassName() + " has wrong number of parameters" + " (processing " + this._sharedData.getCurrentClassName() + ")");
                        }
                        mismatch = false;
                        for (MethodInfo annotMI : annotCF.getMethods()) {
                            annotDesc = annotMI.getDescriptor().toString();
                            if ((annotMI.getAccessFlags() & 1) == 0) {
                                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has non-public method " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
                            }
                            if ((annotMI.getAccessFlags() & 0x400) == 0) {
                                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has non-abstract method " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
                            }
                            noParamPrefix = "()";
                            if (!annotDesc.startsWith("()")) {
                                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has method taking arguments " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
                            }
                            retType = annotDesc.substring("()".length());
                            boolean found = false;
                            for (LocalVariableTableAttributeInfo.LocalVariableRecord lvr : predicateParams) {
                                if (!retType.equals(lvr.descriptor.toString()) || !annotMI.getName().toString().equals(lvr.name.toString())) continue;
                                found = true;
                                break;
                            }
                            if (found) continue;
                            mismatch = true;
                            break;
                        }
                        if (mismatch) continue;
                        for (LocalVariableTableAttributeInfo.LocalVariableRecord lvr : predicateParams) {
                            paramNames.add(lvr.name.toString());
                        }
                    }
                    if (this._sharedData.getIncludePredicateMethodParameterOrder() && annotCL.getJarFile() == null) {
                        this.includePredicateMethodParameterOrder(predicateMethod, paramNames, annotCL);
                    }
                }
                ArrayList<AAnnotationsAttributeInfo.Annotation.AMemberValue> valueList = new ArrayList<AAnnotationsAttributeInfo.Annotation.AMemberValue>();
                for (int paramNameIndex = 0; paramNameIndex < paramNames.size(); ++paramNameIndex) {
                    String name = (String)paramNames.get(paramNameIndex);
                    AAnnotationsAttributeInfo.Annotation.AMemberValue mv = null;
                    for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : annot.getPairs()) {
                        if (!nvp.getName().toString().equals(name)) continue;
                        mv = nvp.getValue();
                        break;
                    }
                    if (mv == null) {
                        AnnotationDefaultAttributeInfo adAttr = null;
                        for (MethodInfo annotMI : annotCF.getMethods()) {
                            if (annotMI.getName().toString().equals(name)) {
                                AAttributeInfo annotAttr;
                                Iterator<AAttributeInfo> i$ = annotMI.getAttributes().iterator();
                                while (i$.hasNext() && (adAttr = (annotAttr = i$.next()).execute(new ADefaultAttributeVisitor<AnnotationDefaultAttributeInfo, Object>(){

                                    @Override
                                    public AnnotationDefaultAttributeInfo defaultCase(AAttributeInfo host, Object param) {
                                        return null;
                                    }

                                    @Override
                                    public AnnotationDefaultAttributeInfo annotationDefaultCase(AnnotationDefaultAttributeInfo host, Object param) {
                                        return host;
                                    }
                                }, null)) == null) {
                                }
                            }
                            if (adAttr == null) continue;
                            break;
                        }
                        if (adAttr == null) {
                            throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has no value for member " + name + " (processing " + this._sharedData.getCurrentClassName() + ")");
                        }
                        mv = adAttr.getDefaultValue();
                    }
                    valueList.add(mv);
                }
                HashMap<String, String> paramTypes = new HashMap<String, String>();
                for (int i = 0; i < paramNames.size(); ++i) {
                    paramTypes.put((String)paramNames.get(i), paramTypeList.get(i - 0));
                }
                if ((mi.getAccessFlags() & 1) == 0 || (mi.getAccessFlags() & 8) == 0) {
                    throw new BadPredicateAnnotationWarning("Predicate method " + mi.getName() + mi.getDescriptor() + " in class " + predicateCF.getThisClassName() + " is not public static." + " (processing " + this._sharedData.getCurrentClassName() + ")");
                }
                return new PredicateAnnotationRecord(annot, predicateCF.getThisClassName(), mi, paramNames, paramTypes, valueList, passArguments, null, new HashMap<String, ArrayList<PredicateAnnotationRecord>>());
            }
            throw new BadPredicateAnnotationWarning("Could not find predicate method " + predicateMethod + " in " + predicateCF.getThisClassName() + " that is suitable for annotation " + annot.getType() + " (processing " + this._sharedData.getCurrentClassName() + ")");
        }
        this.checkCombineMembers(annotCF, passArguments);
        final HashMap<String, ArrayList<PredicateAnnotationRecord>> combinedPredicates = new HashMap<String, ArrayList<PredicateAnnotationRecord>>();
        final HashSet allSet = new HashSet();
        HashMap<String, String> paramTypes = new HashMap<String, String>();
        for (final MethodInfo annotMI : annotCF.getMethods()) {
            String annotDesc = annotMI.getDescriptor().toString();
            String noParamPrefix = "()";
            if (!annotDesc.startsWith("()")) {
                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has method taking arguments " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
            }
            String retType = annotDesc.substring("()".length());
            paramTypes.put(annotMI.getName().toString(), retType);
            AAnnotationsAttributeInfo.Annotation.AMemberValue mv = null;
            for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : annot.getPairs()) {
                if (!nvp.getName().toString().equals(annotMI.getName().toString())) continue;
                mv = nvp.getValue();
                break;
            }
            if (mv == null) {
                AAttributeInfo annotAttr;
                AnnotationDefaultAttributeInfo adAttr = null;
                Iterator<AAttributeInfo> i$ = annotMI.getAttributes().iterator();
                while (i$.hasNext() && (adAttr = (annotAttr = i$.next()).execute(new ADefaultAttributeVisitor<AnnotationDefaultAttributeInfo, Object>(){

                    @Override
                    public AnnotationDefaultAttributeInfo defaultCase(AAttributeInfo host, Object param) {
                        return null;
                    }

                    @Override
                    public AnnotationDefaultAttributeInfo annotationDefaultCase(AnnotationDefaultAttributeInfo host, Object param) {
                        return host;
                    }
                }, null)) == null) {
                }
                if (adAttr == null) {
                    throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has no value for member " + annotMI.getName().toString() + " (processing " + this._sharedData.getCurrentClassName() + ")");
                }
                mv = adAttr.getDefaultValue();
            }
            mv.execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<Object, Object>(){

                @Override
                public Object defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object param) {
                    String t = annot.getType();
                    throw new BadPredicateAnnotationWarning("Annotation " + t.substring(1, t.length() - 1) + " has meta-annotation @Combine, " + "but contains a member that is not a Thread Checker annotation or an array thereof: " + annotMI.getName().toString() + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")");
                }

                @Override
                public Object annotationMemberCase(AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue host, Object param) {
                    PredicateAnnotationRecord par = AThreadCheckStrategy.this.processAnnotation(host.getAnnotation());
                    if (par == null) {
                        String t = annot.getType();
                        throw new BadPredicateAnnotationWarning("Annotation " + t.substring(1, t.length() - 1) + " has meta-annotation @Combine, " + "but contains an annotation as member that is not a Thread Checker annotation: " + annotMI.getName().toString() + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")");
                    }
                    allSet.add(par);
                    ArrayList<PredicateAnnotationRecord> elementList = new ArrayList<PredicateAnnotationRecord>();
                    elementList.add(par);
                    combinedPredicates.put(annotMI.getName().toString(), elementList);
                    return null;
                }

                @Override
                public Object arrayMemberCase(AAnnotationsAttributeInfo.Annotation.ArrayMemberValue host, Object param) {
                    final ArrayList elementList = new ArrayList();
                    for (AAnnotationsAttributeInfo.Annotation.AMemberValue mv : host.getEntries()) {
                        mv.execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<Object, Object>(){

                            @Override
                            public Object defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object param) {
                                throw new BadPredicateAnnotationWarning("Annotation " + annot.getType() + " has meta-annotation @Combine, " + "but contains a member that is not a Thread Checker annotation or an array thereof: " + annotMI.getName().toString() + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")");
                            }

                            @Override
                            public Object annotationMemberCase(AAnnotationsAttributeInfo.Annotation.AnnotationMemberValue host, Object param) {
                                PredicateAnnotationRecord par = AThreadCheckStrategy.this.processAnnotation(host.getAnnotation());
                                if (par == null) {
                                    String t = annot.getType();
                                    throw new BadPredicateAnnotationWarning("Annotation " + t.substring(1, t.length() - 1) + " has meta-annotation @Combine, " + "but contains an array of annotations as member whose elements are not a Thread Checker annotations: " + annotMI.getName().toString() + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")");
                                }
                                allSet.add(par);
                                elementList.add(par);
                                return null;
                            }
                        }, null);
                    }
                    combinedPredicates.put(annotMI.getName().toString(), elementList);
                    return null;
                }
            }, null);
        }
        if (combineMode == Combine.Mode.NOT && (paramTypes.size() != 1 || combinedPredicates.size() != 1)) {
            t = annot.getType();
            throw new BadPredicateAnnotationWarning("Annotation " + t.substring(1, t.length() - 1) + " has meta-annotation @Combine " + "with mode NOT, but has more than one member annotations (" + paramTypes.size() + ")" + " (processing " + this._sharedData.getCurrentClassName() + ")");
        }
        if (combineMode == Combine.Mode.IMPLIES && (paramTypes.size() != 1 || combinedPredicates.size() != 1)) {
            t = annot.getType();
            throw new BadPredicateAnnotationWarning("Annotation " + t.substring(1, t.length() - 1) + " has meta-annotation @Combine " + "with mode IMPLIES, but has more than one member annotations (" + paramTypes.size() + ")" + " (processing " + this._sharedData.getCurrentClassName() + ")");
        }
        String key = combinedPredicates.keySet().toArray(new String[0])[0];
        if (combineMode == Combine.Mode.IMPLIES && ((ArrayList)combinedPredicates.get(key)).size() != 2) {
            String t2 = annot.getType();
            throw new BadPredicateAnnotationWarning("Annotation " + t2.substring(1, t2.length() - 1) + " has meta-annotation @Combine " + "with mode IMPLIES, but does not have an array with exactly two member annotations (" + allSet.size() + ")" + " (processing " + this._sharedData.getCurrentClassName() + ")");
        }
        return new PredicateAnnotationRecord(annot, null, null, new ArrayList<String>(), paramTypes, new ArrayList<AAnnotationsAttributeInfo.Annotation.AMemberValue>(), passArguments, combineMode, combinedPredicates);
    }

    protected boolean checkPublicStaticIfNestedClass(final ClassFile predicateCF, final ClassFile cf) {
        AAttributeInfo attr = cf.getAttribute("InnerClasses");
        if (attr == null) {
            return true;
        }
        InnerClassesAttributeInfo ic = attr.execute(new ADefaultAttributeVisitor<InnerClassesAttributeInfo, Object>(){

            @Override
            public InnerClassesAttributeInfo defaultCase(AAttributeInfo host, Object param) {
                AThreadCheckStrategy.this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("Could not check if predicate method class " + predicateCF.getThisClassName() + " is not accessible from everywhere (InnerClasses attribute of class " + cf.getThisClassName() + " not well-formed)" + " (processing " + AThreadCheckStrategy.this._sharedData.getCurrentClassName() + ")"));
                return null;
            }

            @Override
            public InnerClassesAttributeInfo innerClassesCase(InnerClassesAttributeInfo host, Object param) {
                return host;
            }
        }, null);
        if (ic == null) {
            return false;
        }
        for (InnerClassesAttributeInfo.InnerClassesRecord icr : ic.getInnerClasses()) {
            if (!icr.innerClass.toString().equals(cf.getThisClassName().replace('.', '/'))) continue;
            if ((icr.innerFlags & 1) == 0 || (icr.innerFlags & 8) == 0) {
                this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("Predicate method class " + predicateCF.getThisClassName() + " is not accessible from everywhere (inner class " + cf.getThisClassName() + " not public static)" + " (processing " + this._sharedData.getCurrentClassName() + ")"));
                return false;
            }
            ClassFileTools.ClassLocation cl = ClassFileTools.findClassFile(icr.outerClass.toString().replace('/', '.'), this._sharedData._classPath);
            if (cl == null) {
                this._sharedData.addBadPredicateAnnotWarning(new BadPredicateAnnotationWarning("Could not check if predicate method class " + predicateCF.getThisClassName() + " is not accessible from everywhere (class " + cf.getThisClassName() + " not found)" + " (processing " + this._sharedData.getCurrentClassName() + ")"));
                return false;
            }
            ClassFile outerCF = cl.getClassFile();
            try {
                cl.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            cl = null;
            if (this.checkPublicStaticIfNestedClass(predicateCF, outerCF)) continue;
            return false;
        }
        return true;
    }

    protected void checkCombineMembers(ClassFile annotCF, boolean passMethods) {
        for (MethodInfo annotMI : annotCF.getMethods()) {
            String memberType;
            String annotDesc = annotMI.getDescriptor().toString();
            if ((annotMI.getAccessFlags() & 1) == 0) {
                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has non-public method " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
            }
            if ((annotMI.getAccessFlags() & 0x400) == 0) {
                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has non-abstract method " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
            }
            String noParamPrefix = "()";
            if (!annotDesc.startsWith("()")) {
                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has method taking arguments " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
            }
            String retType = annotDesc.substring("()".length());
            if (retType.charAt(0) != 'L' && retType.charAt(0) != '[') {
                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has meta-annotation @Combine, " + "but contains a member that is not a Thread Checker annotation or an array thereof: " + annotMI.getName() + " (processing " + this._sharedData.getCurrentClassName() + ")");
            }
            if (retType.charAt(0) == 'L') {
                memberType = retType;
            } else {
                memberType = retType.substring(1);
                if (memberType.charAt(0) != 'L') {
                    throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has meta-annotation @Combine, " + "but contains a member that is not a Thread Checker annotation or an array thereof: " + annotMI.getName() + " (processing " + this._sharedData.getCurrentClassName() + ")");
                }
            }
            Ref<Object> refCL = new Ref<Object>(null);
            Ref<Object> refPredicateLink = new Ref<Object>(null);
            Ref<Object> refCombineAnnot = new Ref<Object>(null);
            if (!this.getAnnotationClassFile(memberType, refCL, refPredicateLink, refCombineAnnot) || refCL.get() == null) {
                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has meta-annotation @Combine, " + "but contains a member that is not a Thread Checker annotation or an array thereof: " + annotMI.getName() + " (processing " + this._sharedData.getCurrentClassName() + ")");
            }
            if (!passMethods) {
                List<AAnnotationsAttributeInfo.Annotation.NameValuePair> nvpList = null;
                if (refPredicateLink.get() != null) {
                    nvpList = ((AAnnotationsAttributeInfo.Annotation)refPredicateLink.get()).getPairs();
                } else if (refCombineAnnot.get() != null) {
                    nvpList = ((AAnnotationsAttributeInfo.Annotation)refCombineAnnot.get()).getPairs();
                }
                if (nvpList != null) {
                    for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : nvpList) {
                        if (!nvp.getName().toString().equals("arguments")) continue;
                        AAnnotationsAttributeInfo.Annotation.ConstantMemberValue cvp = nvp.getValue().execute(new AAnnotationsAttributeInfo.Annotation.ADefaultMemberValueVisitor<AAnnotationsAttributeInfo.Annotation.ConstantMemberValue, Object>(){

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue defaultCase(AAnnotationsAttributeInfo.Annotation.AMemberValue host, Object o) {
                                throw new ThreadCheckException("The arguments value should be a boolean");
                            }

                            @Override
                            public AAnnotationsAttributeInfo.Annotation.ConstantMemberValue constantMemberCase(AAnnotationsAttributeInfo.Annotation.ConstantMemberValue host, Object o) {
                                return host;
                            }
                        }, null);
                        if (cvp.getTag() != 'Z') {
                            throw new ThreadCheckException("The arguments value should be a boolean");
                        }
                        if (cvp.getConstValue().execute(CheckIntegerVisitor.singleton(), null).getIntValue() == 0) break;
                        throw new BadPredicateAnnotationWarning("A member annotation " + ClassFileTools.getTypeString(memberType, "") + "of " + annotCF.getThisClassName() + " has arguments=true, but the containing annotation does not.");
                    }
                }
            }
            ClassFile cf = ((ClassFileTools.ClassLocation)refCL.get()).getClassFile();
            if (refPredicateLink.get() != null) {
                this.checkPredicateMembers(cf, passMethods);
                continue;
            }
            this.checkCombineMembers(cf, passMethods);
        }
    }

    protected void checkPredicateMembers(ClassFile annotCF, boolean passMethods) {
        for (MethodInfo annotMI : annotCF.getMethods()) {
            String memberType;
            String annotDesc = annotMI.getDescriptor().toString();
            if ((annotMI.getAccessFlags() & 1) == 0) {
                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has non-public method " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
            }
            if ((annotMI.getAccessFlags() & 0x400) == 0) {
                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has non-abstract method " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
            }
            String noParamPrefix = "()";
            if (!annotDesc.startsWith("()")) {
                throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has method taking arguments " + annotMI.getName().toString() + annotDesc + " (processing " + this._sharedData.getCurrentClassName() + ")");
            }
            String retType = annotDesc.substring("()".length());
            if (retType.charAt(0) != 'L' && retType.charAt(0) != '[') continue;
            if (retType.charAt(0) == 'L') {
                memberType = retType;
            } else {
                memberType = retType.substring(1);
                if (memberType.charAt(0) != 'L') continue;
            }
            String className = memberType.substring(1, memberType.length() - 1).replace('/', '.');
            ClassFileTools.ClassLocation cl = ClassFileTools.findClassFile(className, this._sharedData._classPath);
            if (cl == null) {
                this._sharedData.addClassNotFoundWarning(new ClassNotFoundWarning(className, this._sharedData.getCurrentClassName()));
                continue;
            }
            ClassFile cf = cl.getClassFile();
            try {
                cl.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            if (cf == null || (cf.getClassAccessFlags() & 0x2000) == 0) continue;
            throw new BadPredicateAnnotationWarning("Annotation " + annotCF.getThisClassName() + " has meta-annotation @PredicateLink, " + "but contains a member that is an annotation or an array of annotations: " + annotMI.getName() + " (processing " + this._sharedData.getCurrentClassName() + ")");
        }
    }

    protected void includePredicateMethodParameterOrder(String predicateMethod, ArrayList<String> paramNames, ClassFileTools.ClassLocation annotCL) {
        ClassFile annotCF = annotCL.getClassFile();
        StringBuilder sb = new StringBuilder();
        sb.append(predicateMethod);
        sb.append('(');
        boolean notFirst = false;
        for (int pi = 0; pi < paramNames.size(); ++pi) {
            if (notFirst) {
                sb.append(',');
            } else {
                notFirst = true;
            }
            sb.append(paramNames.get(pi));
        }
        sb.append(')');
        AUTFPoolInfo newPoolItem = new ASCIIPoolInfo(sb.toString(), annotCF.getConstantPool());
        int[] l = annotCF.addConstantPoolItems(new APoolInfo[]{newPoolItem});
        newPoolItem = annotCF.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        ASingleAnnotationsAttributeInfo origAnnotAttrib = null;
        int index = 0;
        AAnnotationsAttributeInfo.Annotation pl = null;
        for (AAttributeInfo ai : annotCF.getAttributes()) {
            if (!ai.getName().toString().equals(RuntimeInvisibleAnnotationsAttributeInfo.getAttributeName()) && !ai.getName().toString().equals(RuntimeVisibleAnnotationsAttributeInfo.getAttributeName())) continue;
            ASingleAnnotationsAttributeInfo aa = (ASingleAnnotationsAttributeInfo)ai;
            for (AAnnotationsAttributeInfo.Annotation annot : aa.getAnnotations()) {
                if (annot.getType().equals("L" + PredicateLink.class.getName().replace('.', '/') + ";")) {
                    origAnnotAttrib = aa;
                    pl = annot;
                    break;
                }
                ++index;
            }
            if (pl == null) continue;
            break;
        }
        if (pl == null) {
            throw new BadPredicateAnnotationWarning("@PredicateLink of annotation " + annotCF.getThisClassName() + " not found when updating predicate method parameter order.");
        }
        ArrayList<AAnnotationsAttributeInfo.Annotation.NameValuePair> pairs = new ArrayList<AAnnotationsAttributeInfo.Annotation.NameValuePair>();
        for (AAnnotationsAttributeInfo.Annotation.NameValuePair nvp : pl.getPairs()) {
            if (nvp.getName().toString().equals("method")) {
                nvp = new AAnnotationsAttributeInfo.Annotation.NameValuePair(nvp.getName(), new AAnnotationsAttributeInfo.Annotation.ConstantMemberValue('s', newPoolItem));
            }
            pairs.add(nvp);
        }
        AUTFPoolInfo annotType = new ASCIIPoolInfo(pl.getType(), annotCF.getConstantPool());
        l = annotCF.addConstantPoolItems(new APoolInfo[]{annotType});
        annotType = annotCF.getConstantPoolItem(l[0]).execute(CheckUTFVisitor.singleton(), null);
        AAnnotationsAttributeInfo.Annotation newpl = new AAnnotationsAttributeInfo.Annotation(annotType, (short)pairs.size(), pairs.toArray(new AAnnotationsAttributeInfo.Annotation.NameValuePair[0]));
        AAnnotationsAttributeInfo.Annotation[] annotations = origAnnotAttrib.getAnnotations();
        annotations[index] = newpl;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            origAnnotAttrib.setAnnotations(annotations);
            baos.reset();
            annotCF.write(baos);
            FileOutputStream fos = new FileOutputStream(annotCL.getFile());
            fos.write(baos.toByteArray());
            fos.close();
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    @Override
    public void done() {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SharedData
    implements IScannerStrategy {
        private HashSet<BadPredicateAnnotationWarning> _badPredicateAnnotWarnings = new HashSet();
        private HashSet<ClassNotFoundWarning> _classNotFoundWarnings = new HashSet();
        private String _xmlFileName = null;
        private boolean _xmlConcDefFormat = false;
        private List<String> _classPath = new ArrayList<String>();
        private String _currentClassName = "<unknown>";
        private boolean _includePredicateMethodParameterOrder = true;

        public String getXmlFileName() {
            return this._xmlFileName;
        }

        public void setXmlFileName(String xmlFileName) {
            this._xmlFileName = xmlFileName;
        }

        public boolean isXmlConcDefFormat() {
            return this._xmlConcDefFormat;
        }

        public List<String> getClassPath() {
            return new ArrayList<String>(this._classPath);
        }

        public void addClassNotFoundWarning(ClassNotFoundWarning classNotFoundWarning) {
            this._classNotFoundWarnings.add(classNotFoundWarning);
        }

        public void addBadPredicateAnnotWarning(BadPredicateAnnotationWarning badPredicateAnnotWarning) {
            this._badPredicateAnnotWarnings.add(badPredicateAnnotWarning);
        }

        public boolean getIncludePredicateMethodParameterOrder() {
            return this._includePredicateMethodParameterOrder;
        }

        public SharedData(List<String> parameters) {
            for (String p : parameters) {
                if (p.toLowerCase().startsWith(AThreadCheckStrategy.CLASS_PATH_PARAM_PREFIX)) {
                    String[] paths;
                    String cp = p.substring(AThreadCheckStrategy.CLASS_PATH_PARAM_PREFIX.length());
                    for (String path : paths = cp.split(System.getProperty("path.separator"))) {
                        this._classPath.add(path);
                    }
                    continue;
                }
                if (p.toLowerCase().startsWith(AThreadCheckStrategy.XML_ANNOT_PARAM_PREFIX)) {
                    this._xmlFileName = p.substring(AThreadCheckStrategy.XML_ANNOT_PARAM_PREFIX.length());
                    continue;
                }
                if (p.equalsIgnoreCase(AThreadCheckStrategy.XML_ANNOT_FORMAT_PARAM)) {
                    this._xmlConcDefFormat = true;
                    continue;
                }
                if (!p.toLowerCase().startsWith(AThreadCheckStrategy.UPDATE_PARAM_ORDER_PREFIX)) continue;
                this._includePredicateMethodParameterOrder = Boolean.valueOf(p.substring(AThreadCheckStrategy.UPDATE_PARAM_ORDER_PREFIX.length()));
            }
            if (this._classPath.size() == 0) {
                String[] paths;
                String cp = System.getProperty("java.class.path");
                for (String path : paths = cp.split(System.getProperty("path.separator"))) {
                    this._classPath.add(path);
                }
                cp = FileInstrumentor.getDefaultSourceRtJarName();
                for (String path : paths = cp.split(System.getProperty("path.separator"))) {
                    this._classPath.add(path);
                }
            }
            Debug.out.println("Using as class path:");
            for (String path : this._classPath) {
                Debug.out.println("\t" + path);
            }
            Debug.out.println("Include predicate method parameter order: " + this._includePredicateMethodParameterOrder);
        }

        @Override
        public List<? extends IScannerStrategy.IScanResult> getScanResults() {
            ArrayList<ClassNotFoundWarning> cnflist = new ArrayList<ClassNotFoundWarning>(this._classNotFoundWarnings);
            Collections.sort(cnflist);
            ArrayList<BadPredicateAnnotationWarning> baflist = new ArrayList<BadPredicateAnnotationWarning>(this._badPredicateAnnotWarnings);
            Collections.sort(baflist);
            ArrayList<ClassNotFoundWarning> list = new ArrayList<ClassNotFoundWarning>(cnflist);
            list.addAll(baflist);
            return list;
        }

        @Override
        public void instrument(ClassFile cf) {
        }

        public String getCurrentClassName() {
            return this._currentClassName;
        }

        public void setCurrentClassName(String currentClassName) {
            this._currentClassName = currentClassName;
        }

        @Override
        public void done() {
        }
    }
}

