/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.instrumentors.util;

import edu.rice.cs.cunit.classFile.ClassFile;
import edu.rice.cs.cunit.classFile.MethodInfo;
import edu.rice.cs.cunit.classFile.attributes.CodeAttributeInfo;
import edu.rice.cs.cunit.classFile.code.InstructionList;
import edu.rice.cs.cunit.instrumentors.IInstrumentationStrategy;
import edu.rice.cs.cunit.util.IPredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AInsertAtOpcodeStrategy
implements IInstrumentationStrategy {
    protected IPredicate<ClassFile> _classPredicate;
    protected IPredicate.Binary<ClassFile, MethodInfo> _methodPredicate;
    protected IPredicate.Ternary<ClassFile, MethodInfo, InstructionList> _beforeOpcodePredicate;
    protected IPredicate.Ternary<ClassFile, MethodInfo, InstructionList> _afterOpcodePredicate;
    protected static final IPredicate.Ternary<ClassFile, MethodInfo, InstructionList> OPCODE_NEVER = new IPredicate.Ternary<ClassFile, MethodInfo, InstructionList>(){

        @Override
        public Boolean apply(ClassFile classFile, MethodInfo methodInfo, InstructionList instructionList) {
            return false;
        }
    };

    protected AInsertAtOpcodeStrategy(IPredicate<ClassFile> classPredicate, IPredicate.Binary<ClassFile, MethodInfo> methodPredicate, IPredicate.Ternary<ClassFile, MethodInfo, InstructionList> beforeOpcodePredicate, IPredicate.Ternary<ClassFile, MethodInfo, InstructionList> afterOpcodePredicate) {
        this._classPredicate = classPredicate;
        this._methodPredicate = methodPredicate;
        this._beforeOpcodePredicate = beforeOpcodePredicate;
        this._afterOpcodePredicate = afterOpcodePredicate;
    }

    @Override
    public void instrument(ClassFile cf) {
        if ((cf.getClassAccessFlags() & 0x200) == 0 && ((Boolean)this._classPredicate.apply(cf)).booleanValue()) {
            for (MethodInfo mi : cf.getMethods()) {
                if ((mi.getAccessFlags() & 0x400) != 0 || (mi.getAccessFlags() & 0x100) != 0 || !((Boolean)this._methodPredicate.apply(cf, mi)).booleanValue()) continue;
                CodeAttributeInfo codeAttr = mi.getCodeAttributeInfo();
                InstructionList il = new InstructionList(codeAttr.getCode());
                boolean insertBefore = false;
                boolean insertAfter = false;
                do {
                    if (((Boolean)this._beforeOpcodePredicate.apply(cf, mi, il)).booleanValue()) {
                        insertBefore = true;
                        this.insertInstructionsBefore(cf, mi, il);
                    }
                    if (!((Boolean)this._afterOpcodePredicate.apply(cf, mi, il)).booleanValue()) continue;
                    insertAfter = true;
                    this.insertInstructionsAfter(cf, mi, il);
                } while (il.advanceIndex());
                boolean insertEndOfMethod = this.insertEndOfMethod(cf, mi, il, insertBefore, insertAfter);
                if (!insertBefore && !insertAfter && !insertEndOfMethod) continue;
                codeAttr.setCode(il.getCode());
                this.modifyStackAndLocals(cf, mi, il, insertBefore, insertAfter, insertEndOfMethod);
            }
        }
    }

    public abstract void insertInstructionsBefore(ClassFile var1, MethodInfo var2, InstructionList var3);

    public abstract void insertInstructionsAfter(ClassFile var1, MethodInfo var2, InstructionList var3);

    public abstract boolean insertEndOfMethod(ClassFile var1, MethodInfo var2, InstructionList var3, boolean var4, boolean var5);

    public abstract void modifyStackAndLocals(ClassFile var1, MethodInfo var2, InstructionList var3, boolean var4, boolean var5, boolean var6);

    @Override
    public void done() {
    }
}

