/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.util;

import java.util.Arrays;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface ILambda<R, P> {
    public R apply(P var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NaryAdaptor<R, P>
    implements ILambda<R, P> {
        private Nary<R, P> _decoree;

        public NaryAdaptor(Nary<R, P> decoree) {
            this._decoree = decoree;
        }

        @Override
        public R apply(P param) {
            R retval = this._decoree.apply(param);
            return retval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Nary<R, P> {
        public R apply(P ... var1);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Min<T extends Comparable<T>>
        implements Nary<T, T> {
            @Override
            public T apply(T ... param) {
                if (param.length == 0) {
                    throw new IllegalArgumentException("N-ary Min needs at least one argument.");
                }
                T accum = param[0];
                for (int i = 1; i < param.length; ++i) {
                    if (param[i].compareTo(accum) >= 0) continue;
                    accum = param[i];
                }
                return accum;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Max<T extends Comparable<T>>
        implements Nary<T, T> {
            @Override
            public T apply(T ... param) {
                if (param.length == 0) {
                    throw new IllegalArgumentException("N-ary Max needs at least one argument.");
                }
                T accum = param[0];
                for (int i = 1; i < param.length; ++i) {
                    if (param[i].compareTo(accum) <= 0) continue;
                    accum = param[i];
                }
                return accum;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class BindK<R, P>
        implements Nary<R, P> {
            private int[] _indices;
            private P[] _constants;
            private Nary<R, P> _decoree;

            public BindK(Nary<R, P> decoree, int[] indices, P ... constants) {
                if (indices.length != constants.length) {
                    throw new IllegalArgumentException("Indices and constants arrays need to be the same length.");
                }
                this._indices = indices;
                this._constants = constants;
                this._decoree = decoree;
            }

            @Override
            public R apply(P ... param) {
                LinkedList<P> ps = new LinkedList<P>(Arrays.asList(param));
                for (int i = 0; i < this._indices.length; ++i) {
                    ps.add(this._indices[i], this._constants[i]);
                }
                return this._decoree.apply(ps.toArray(param));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind<R, P>
        implements Nary<R, P> {
            private int _index;
            private P _constant;
            private Nary<R, P> _decoree;

            public Bind(Nary<R, P> decoree, int index, P constant) {
                this._index = index;
                this._constant = constant;
                this._decoree = decoree;
            }

            @Override
            public R apply(P ... param) {
                LinkedList<P> ps = new LinkedList<P>(Arrays.asList(param));
                ps.add(this._index, this._constant);
                return this._decoree.apply(ps.toArray(param));
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class TernaryAdaptor<R, P>
        implements Nary<R, P> {
            private Ternary<R, P, P, P> _decoree;

            public TernaryAdaptor(Ternary<R, P, P, P> decoree) {
                this._decoree = decoree;
            }

            @Override
            public R apply(P ... param) {
                if (param.length != 3) {
                    throw new IllegalArgumentException("TernaryAdapter.apply expects exactly three arguments.");
                }
                return this._decoree.apply(param[0], param[1], param[2]);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class BinaryAdaptor<R, P>
        implements Nary<R, P> {
            private Binary<R, P, P> _decoree;

            public BinaryAdaptor(Binary<R, P, P> decoree) {
                this._decoree = decoree;
            }

            @Override
            public R apply(P ... param) {
                if (param.length != 2) {
                    throw new IllegalArgumentException("BinaryAdapter.apply expects exactly two arguments.");
                }
                return this._decoree.apply(param[0], param[1]);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class UnaryAdaptor<R, P>
        implements Nary<R, P> {
            private ILambda<R, P> _decoree;

            public UnaryAdaptor(ILambda<R, P> decoree) {
                this._decoree = decoree;
            }

            @Override
            public R apply(P ... param) {
                if (param.length != 1) {
                    throw new IllegalArgumentException("UnaryAdapter.apply expects exactly one argument.");
                }
                return this._decoree.apply(param[0]);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Ternary<R, P, Q, S> {
        public R apply(P var1, Q var2, S var3);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Min<T extends Comparable<T>>
        implements Ternary<T, T, T, T> {
            @Override
            public T apply(T param1, T param2, T param3) {
                T temp12 = param1.compareTo(param2) < 0 ? param1 : param2;
                return temp12.compareTo(param3) < 0 ? temp12 : param3;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Max<T extends Comparable<T>>
        implements Ternary<T, T, T, T> {
            @Override
            public T apply(T param1, T param2, T param3) {
                T temp12 = param1.compareTo(param2) > 0 ? param1 : param2;
                return temp12.compareTo(param3) > 0 ? temp12 : param3;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class NaryAdaptor<R, P>
        implements Ternary<R, P, P, P> {
            private Nary<R, P> _decoree;

            public NaryAdaptor(Nary<R, P> decoree) {
                this._decoree = decoree;
            }

            @Override
            public R apply(P param1, P param2, P param3) {
                R retval = this._decoree.apply(param1, param2, param3);
                return retval;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind2nd3rd<R, P, Q, S>
        extends Binary.Bind2nd<R, P, Q> {
            public Bind2nd3rd(Ternary<R, P, Q, S> decoree, Q constant2, S constant3) {
                super(new Bind3rd<R, P, Q, S>(decoree, constant3), constant2);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind1st3rd<R, P, Q, S>
        extends Binary.Bind1st<R, P, Q> {
            public Bind1st3rd(Ternary<R, P, Q, S> decoree, P constant1, S constant3) {
                super(new Bind3rd<R, P, Q, S>(decoree, constant3), constant1);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind1st2nd<R, P, Q, S>
        extends Binary.Bind1st<R, P, S> {
            public Bind1st2nd(Ternary<R, P, Q, S> decoree, P constant1, Q constant2) {
                super(new Bind2nd<R, P, Q, S>(decoree, constant2), constant1);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind3rd<R, P, Q, S>
        implements Binary<R, P, Q> {
            private S _constant;
            private Ternary<R, P, Q, S> _decoree;

            public Bind3rd(Ternary<R, P, Q, S> decoree, S constant) {
                this._constant = constant;
                this._decoree = decoree;
            }

            @Override
            public R apply(P param1, Q param2) {
                return this._decoree.apply(param1, param2, this._constant);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind2nd<R, P, Q, S>
        implements Binary<R, P, S> {
            private Q _constant;
            private Ternary<R, P, Q, S> _decoree;

            public Bind2nd(Ternary<R, P, Q, S> decoree, Q constant) {
                this._constant = constant;
                this._decoree = decoree;
            }

            @Override
            public R apply(P param1, S param3) {
                return this._decoree.apply(param1, this._constant, param3);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind1st<R, P, Q, S>
        implements Binary<R, Q, S> {
            private P _constant;
            private Ternary<R, P, Q, S> _decoree;

            public Bind1st(Ternary<R, P, Q, S> decoree, P constant) {
                this._constant = constant;
                this._decoree = decoree;
            }

            @Override
            public R apply(Q param2, S param3) {
                return this._decoree.apply(this._constant, param2, param3);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Binary<R, P, Q> {
        public R apply(P var1, Q var2);

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Min<T extends Comparable<T>>
        implements Binary<T, T, T> {
            @Override
            public T apply(T param1, T param2) {
                return param1.compareTo(param2) < 0 ? param1 : param2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Max<T extends Comparable<T>>
        implements Binary<T, T, T> {
            @Override
            public T apply(T param1, T param2) {
                return param1.compareTo(param2) > 0 ? param1 : param2;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class NaryAdaptor<R, P>
        implements Binary<R, P, P> {
            private Nary<R, P> _decoree;

            public NaryAdaptor(Nary<R, P> decoree) {
                this._decoree = decoree;
            }

            @Override
            public R apply(P param1, P param2) {
                R retval = this._decoree.apply(param1, param2);
                return retval;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind2nd<R, P, Q>
        implements ILambda<R, P> {
            private Q _constant;
            private Binary<R, P, Q> _decoree;

            public Bind2nd(Binary<R, P, Q> decoree, Q constant) {
                this._constant = constant;
                this._decoree = decoree;
            }

            @Override
            public R apply(P param) {
                return this._decoree.apply(param, this._constant);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static class Bind1st<R, P, Q>
        implements ILambda<R, Q> {
            private P _constant;
            private Binary<R, P, Q> _decoree;

            public Bind1st(Binary<R, P, Q> decoree, P constant) {
                this._constant = constant;
                this._decoree = decoree;
            }

            @Override
            public R apply(Q param) {
                return this._decoree.apply(this._constant, param);
            }
        }
    }
}

