/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.util;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuotedStringTokenizer
extends StringTokenizer
implements Iterable<String> {
    private StreamTokenizer _tok;
    private boolean _returnDelims;
    private String _delim;
    private final String _origStr;
    private final String _origDelim;
    private String _remainder;
    public static final String DEFAULT_DELIM = " \t\n\r\f";

    public QuotedStringTokenizer(String str, String delim, boolean returnDelims) {
        super(str, delim, returnDelims);
        this._origStr = str;
        this._origDelim = delim;
        this._returnDelims = returnDelims;
        this.reset();
    }

    public QuotedStringTokenizer(String str, String delim) {
        this(str, delim, false);
    }

    public QuotedStringTokenizer(String str) {
        this(str, DEFAULT_DELIM, false);
    }

    public QuotedStringTokenizer(String str, boolean returnDelims) {
        this(str, DEFAULT_DELIM, returnDelims);
    }

    public void reset() {
        this._remainder = this._origStr;
        this._tok = new StreamTokenizer(new StringReader(this._remainder));
        this.setDelimiters(this._origDelim, false, false);
    }

    private void setDelimiters(String delim, boolean singleQuote, boolean doubleQuote) {
        this._delim = delim;
        this._tok.resetSyntax();
        this._tok.wordChars(0, 255);
        if (singleQuote) {
            this._tok.quoteChar(39);
            this._tok.wordChars(34, 34);
        } else if (doubleQuote) {
            this._tok.quoteChar(34);
            this._tok.wordChars(39, 39);
        } else if (!singleQuote && !doubleQuote) {
            this._tok.ordinaryChar(39);
            this._tok.ordinaryChar(34);
        } else {
            throw new IllegalArgumentException("singleQuote and doubleQuote are mutually exclusive");
        }
        if (this._returnDelims) {
            for (char ch : delim.toCharArray()) {
                this._tok.ordinaryChar(ch);
            }
        } else {
            for (char ch : delim.toCharArray()) {
                this._tok.whitespaceChars(ch, ch);
            }
        }
    }

    @Override
    public boolean hasMoreTokens() {
        try {
            int tok = this._tok.nextToken();
            this._tok.pushBack();
            return tok != -1;
        }
        catch (IOException e) {
            throw new TokenizerException(e);
        }
    }

    @Override
    public String nextToken() {
        try {
            int tok = this._tok.nextToken();
            switch (tok) {
                case -1: {
                    throw new NoSuchElementException("No more tokens in this tokenizer's string");
                }
                case -3: {
                    this._remainder = this._remainder.substring(this._remainder.indexOf(this._tok.sval) + this._tok.sval.length());
                    return this._tok.sval;
                }
                case 39: {
                    this._tok = new StreamTokenizer(new StringReader(this._remainder));
                    this.setDelimiters(this._delim, true, false);
                    tok = this._tok.nextToken();
                    String nt = '\'' + this._tok.sval + '\'';
                    this._remainder = this._remainder.substring(this._remainder.indexOf(this._tok.sval) + this._tok.sval.length() + 1);
                    this._tok = new StreamTokenizer(new StringReader(this._remainder));
                    this.setDelimiters(this._delim, false, false);
                    return nt;
                }
                case 34: {
                    this._tok = new StreamTokenizer(new StringReader(this._remainder));
                    this.setDelimiters(this._delim, false, true);
                    tok = this._tok.nextToken();
                    String nt = '\"' + this._tok.sval + '\"';
                    this._remainder = this._remainder.substring(this._remainder.indexOf(this._tok.sval) + this._tok.sval.length() + 1);
                    this._tok = new StreamTokenizer(new StringReader(this._remainder));
                    this.setDelimiters(this._delim, false, false);
                    return nt;
                }
            }
            this._remainder = this._remainder.substring(1);
            return String.valueOf((char)tok);
        }
        catch (IOException e) {
            throw new TokenizerException(e);
        }
    }

    @Override
    public String nextToken(String delim) {
        this.setDelimiters(delim, false, false);
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMoreTokens();
    }

    @Override
    public Object nextElement() {
        return this.nextToken();
    }

    @Override
    public int countTokens() {
        QuotedStringTokenizer temp = new QuotedStringTokenizer(this._remainder, this._delim, this._returnDelims);
        int i = 0;
        while (temp.hasMoreTokens()) {
            ++i;
            temp.nextToken();
        }
        return i;
    }

    @Override
    public Iterator<String> iterator() {
        return new QSTIterator();
    }

    public static class QuotedStringTokenizerTest
    extends TestCase {
        public void testSimple() {
            QuotedStringTokenizer tok = new QuotedStringTokenizer("abc 123 'this is a string'\tdef\t\"and another one\" 456 'and a \"bad\" one' xyz");
            QuotedStringTokenizerTest.assertEquals(8, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("abc", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(7, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("123", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(6, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("'this is a string'", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(5, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("def", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(4, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("\"and another one\"", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(3, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("456", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(2, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("'and a \"bad\" one'", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(1, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("xyz", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(0, tok.countTokens());
            try {
                tok.nextToken();
                QuotedStringTokenizerTest.fail("Should have thrown a NoSuchElementException");
            }
            catch (NoSuchElementException nsee) {
            }
            catch (Throwable t) {
                QuotedStringTokenizerTest.fail("Should have thrown a NoSuchElementException, threw " + t.getClass().getName());
            }
        }

        public void testChangeDelim() {
            QuotedStringTokenizer tok = new QuotedStringTokenizer("abc\t123 'this is a string' def \"and another one\" 456 'and a \"bad\" one' xxx\tyyy\tzzz");
            QuotedStringTokenizerTest.assertEquals(10, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("abc\t123", tok.nextToken(" "));
            QuotedStringTokenizerTest.assertEquals(6, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("'this is a string'", tok.nextToken(QuotedStringTokenizer.DEFAULT_DELIM));
            QuotedStringTokenizerTest.assertEquals(7, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("def", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(6, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("\"and another one\"", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(5, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("456", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(4, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("'and a \"bad\" one'", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(3, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("xxx\tyyy\tzzz", tok.nextToken(" "));
            QuotedStringTokenizerTest.assertEquals(0, tok.countTokens());
            try {
                tok.nextToken();
                QuotedStringTokenizerTest.fail("Should have thrown a NoSuchElementException");
            }
            catch (NoSuchElementException nsee) {
            }
            catch (Throwable t) {
                QuotedStringTokenizerTest.fail("Should have thrown a NoSuchElementException, threw " + t.getClass().getName());
            }
        }

        public void testReturnDelims() {
            QuotedStringTokenizer tok = new QuotedStringTokenizer("abc 123\t'this is a string' def \"and another one\" 456 'and a \"bad\" one'\nxyz", QuotedStringTokenizer.DEFAULT_DELIM, true);
            QuotedStringTokenizerTest.assertEquals(15, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("abc", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(14, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals(" ", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(13, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("123", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(12, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("\t", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(11, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("'this is a string'", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(10, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals(" ", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(9, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("def", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(8, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals(" ", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(7, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("\"and another one\"", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(6, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals(" ", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(5, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("456", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(4, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals(" ", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(3, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("'and a \"bad\" one'", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(2, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("\n", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(1, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("xyz", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(0, tok.countTokens());
            try {
                tok.nextToken();
                QuotedStringTokenizerTest.fail("Should have thrown a NoSuchElementException");
            }
            catch (NoSuchElementException nsee) {
            }
            catch (Throwable t) {
                QuotedStringTokenizerTest.fail("Should have thrown a NoSuchElementException, threw " + t.getClass().getName());
            }
        }

        public void testChangeReturnDelims() {
            QuotedStringTokenizer tok = new QuotedStringTokenizer("abc 123\tggg 'this is a string' def \"and another one\" 456 'and a \"bad\" one'\nxxx\nyyy\tzzz", QuotedStringTokenizer.DEFAULT_DELIM, true);
            QuotedStringTokenizerTest.assertEquals(21, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("abc", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(20, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals(" ", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(19, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("123\tggg", tok.nextToken(" "));
            QuotedStringTokenizerTest.assertEquals(11, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals(" ", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(10, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("'this is a string'", tok.nextToken(QuotedStringTokenizer.DEFAULT_DELIM));
            QuotedStringTokenizerTest.assertEquals(14, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals(" ", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(13, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("def", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(12, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals(" ", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(11, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("\"and another one\"", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(10, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals(" ", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(9, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("456", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(8, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals(" ", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(7, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("'and a \"bad\" one'", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(6, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("\n", tok.nextToken());
            QuotedStringTokenizerTest.assertEquals(5, tok.countTokens());
            QuotedStringTokenizerTest.assertEquals("xxx\nyyy\tzzz", tok.nextToken(" "));
            QuotedStringTokenizerTest.assertEquals(0, tok.countTokens());
            try {
                tok.nextToken();
                QuotedStringTokenizerTest.fail("Should have thrown a NoSuchElementException");
            }
            catch (NoSuchElementException nsee) {
            }
            catch (Throwable t) {
                QuotedStringTokenizerTest.fail("Should have thrown a NoSuchElementException, threw " + t.getClass().getName());
            }
        }

        public void testForEach() {
            QuotedStringTokenizer tok = new QuotedStringTokenizer("abc 123 'this is a string'\tdef\t\"and another one\" 456 'and a \"bad\" one' xyz");
            String[] tokens = new String[]{"abc", "123", "'this is a string'", "def", "\"and another one\"", "456", "'and a \"bad\" one'", "xyz"};
            int i = 0;
            QuotedStringTokenizerTest.assertEquals(8, tok.countTokens());
            for (String t : tok) {
                QuotedStringTokenizerTest.assertEquals(tokens[i++], t);
                QuotedStringTokenizerTest.assertEquals(tokens.length - i, tok.countTokens());
            }
            QuotedStringTokenizerTest.assertEquals(0, tok.countTokens());
            for (String t : tok) {
                QuotedStringTokenizerTest.fail("Should not execute, end has been reached");
            }
            tok.reset();
            i = 0;
            QuotedStringTokenizerTest.assertEquals(8, tok.countTokens());
            for (String t : tok) {
                QuotedStringTokenizerTest.assertEquals(tokens[i++], t);
                QuotedStringTokenizerTest.assertEquals(tokens.length - i, tok.countTokens());
            }
        }
    }

    public static class TokenizerException
    extends RuntimeException {
        public TokenizerException() {
        }

        public TokenizerException(String message) {
            super(message);
        }

        public TokenizerException(String message, Throwable cause) {
            super(message, cause);
        }

        public TokenizerException(Throwable cause) {
            super(cause);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class QSTIterator
    implements Iterator<String> {
        private QSTIterator() {
        }

        @Override
        public boolean hasNext() {
            return QuotedStringTokenizer.this.hasMoreTokens();
        }

        @Override
        public String next() {
            return QuotedStringTokenizer.this.nextToken();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Iterator.remove() not supported for QuotedStringTokenizer's iterator");
        }
    }
}

