/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.cunit.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import junit.framework.TestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringOps {
    public static String toStringMillis(long millis) {
        double seconds = (double)millis / 1000.0;
        long days = (long)(seconds / 86400.0);
        long hours = (long)((seconds -= (double)(days * 3600L * 24L)) / 3600.0);
        long minutes = (long)((seconds -= (double)(hours * 3600L)) / 60.0);
        seconds -= (double)(minutes * 60L);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        if (1L == days) {
            pw.print("1 day ");
        } else if (1L < days) {
            pw.print(days + " days ");
        }
        if (1L == hours) {
            pw.print("1 hour ");
        } else if (1L < hours) {
            pw.print(hours + " hours ");
        }
        if (1L == minutes) {
            pw.print("1 minute ");
        } else if (1L < minutes) {
            pw.print(minutes + " minutes ");
        }
        if (1.0 == seconds) {
            pw.print("1 second");
        } else if (0.0 != seconds) {
            if (new Double((long)seconds) == seconds) {
                pw.format("%d seconds", (long)seconds);
            } else {
                pw.format("%5.3f seconds", seconds);
            }
        }
        String s = sw.toString();
        if (s.endsWith(" ")) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public static String replaceVariables(String str, Hashtable<Object, Object> table) {
        int pos = str.indexOf(37);
        while (pos >= 0) {
            if (pos < str.length() - 1 && str.charAt(pos + 1) == '%') {
                str = str.substring(0, pos + 1) + str.substring(pos + 2);
            } else {
                for (Object o : table.keySet()) {
                    String key = o.toString();
                    int endPos = pos + key.length() + 2;
                    if (!str.substring(pos, Math.min(str.length(), endPos)).equals("%" + key + "%")) continue;
                    String value = table.get(key).toString();
                    str = str.substring(0, pos) + value + str.substring(endPos);
                    pos = pos + value.length() - 1;
                    break;
                }
            }
            pos = str.toLowerCase().indexOf(37, pos + 1);
        }
        return str;
    }

    public static boolean stringMatches(String str, char separatorChar, String ... stringPatterns) {
        String sep;
        assert (separatorChar == '.' || separatorChar == '/' || separatorChar == '\\');
        boolean wildcardFound = false;
        boolean exactMatchFound = false;
        for (String p : stringPatterns) {
            if (str.equals(p)) {
                exactMatchFound = true;
            }
            if (p.indexOf(33) < 0 && p.indexOf(63) < 0 && p.indexOf(42) < 0 && p.indexOf(91) < 0 && p.indexOf(124) < 0 && p.indexOf(41) < 0) continue;
            wildcardFound = true;
            break;
        }
        if (!wildcardFound) {
            return exactMatchFound;
        }
        boolean matchFound = false;
        boolean notMatchFound = false;
        switch (separatorChar) {
            case '\\': {
                sep = ",";
                str = str.replace('\\', ',');
                for (int i = 0; i < stringPatterns.length; ++i) {
                    stringPatterns[i] = stringPatterns[i].replace('\\', ',');
                }
                break;
            }
            case '*': 
            case '.': {
                sep = "\\" + separatorChar;
                break;
            }
            default: {
                sep = String.valueOf(separatorChar);
            }
        }
        for (String pattern : stringPatterns) {
            boolean negate = false;
            String regex = pattern;
            if (regex.indexOf(33) == 0) {
                negate = true;
                regex = regex.substring(1);
            }
            regex = regex.replaceAll("\\.", "\\\\.");
            regex = regex.replaceAll("\\$", "\\\\\\$");
            regex = regex.replaceAll("\\?", ".");
            regex = regex.replaceAll("\\(", "(?:");
            regex = regex.replaceAll("\\*\\*\\*", ".`");
            regex = regex.replaceAll("\\*", "[^" + sep + "]*");
            regex = regex.replaceAll("\\.`", ".*");
            regex = "^" + regex + "$";
            boolean matches = str.matches(regex);
            if (!matches) continue;
            if (negate) {
                notMatchFound = true;
                continue;
            }
            matchFound = true;
        }
        return matchFound && !notMatchFound;
    }

    public static class StringOpsTest
    extends TestCase {
        public void testStringMatchesDot() {
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java.lang.Number", '.', "java.*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java.lang.Number", '.', "java.***"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java.lang.Number", '.', "*java*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java.lang.Number", '.', "***java***"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java.lang.Number", '.', "java.lang.Number"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java.lang.Number", '.', "!java.lang.Number"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java.lang.Number", '.', "lang.***"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java.lang.Number", '.', "java.***", "sun.management.***", "!java.lang.Number"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("sun.Foobar", '.', "java.***", "sun.management.***", "!java.lang.Number"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("sun.management.Foobar", '.', "java.***", "sun.management.***", "!java.lang.Number"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java.Foobar", '.', "java.***", "sun.management.***", "!java.lang.Number"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java.util.Foobar", '.', "java.lang.***", "java.util.*", "java.util.concurrent.***", "java.util.logging.***", "sun.reflect.***", "!java.lang.Number"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java.util.concurrent.Foobar", '.', "java.lang.***", "java.util.*", "java.util.concurrent.***", "java.util.logging.***", "sun.reflect.***", "!java.lang.Number"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java.util.logging.Foobar", '.', "java.lang.***", "java.util.*", "java.util.concurrent.***", "java.util.logging.***", "sun.reflect.***", "!java.lang.Number"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java.util.foobar.Foobar", '.', "java.lang.***", "java.util.*", "java.util.concurrent.***", "java.util.logging.***", "sun.reflect.***", "!java.lang.Number"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java/util/Foobar", '.', "java/util/*"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java.util.foo.Foobar", '.', "java.util.*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java.util.foo.Foobar", '.', "java.util.foo.[a-mA-M]*"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java.util.foo.Foobar", '.', "java.util.foo.[n-zN-Z]*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java.util.AbstractCollection", '.', "java.util.*Collection*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java.lang.ref.Reference$1", '.', "java.lang.ref.Reference$*"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java.lang.ref.ReferenceQueue", '.', "java.lang.ref.Reference$*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("edu.rice.cs.cunit.instrumentors.replay.CompactSynchronizedBlockReplayStrategy", '.', "***Synchronized*"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("anything", '.', ""));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("anything", '.', new String[0]));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java/util/FooClass", '.', "java/util/(Foo|Bar)Class"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java/util/BarClass", '.', "java/util/(Foo|Bar)Class"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java/util/FumClass", '.', "java/util/(Foo|Bar)Class"));
        }

        public void testStringMatchesSlash() {
            char ch = '/';
            this.doStringMatchesTest(ch);
        }

        public void testStringMatchesBackslash() {
            char ch = '\\';
            this.doStringMatchesTest(ch);
        }

        private void doStringMatchesTest(char ch) {
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java" + ch + "lang" + ch + "Number.java", ch, "java" + ch + "*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "lang" + ch + "Number.java", ch, "java" + ch + "***"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java" + ch + "lang" + ch + "Number.java", ch, "*java*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "lang" + ch + "Number.java", ch, "***java***"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "lang" + ch + "Number.java", ch, "java" + ch + "lang" + ch + "Number.java"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java" + ch + "lang" + ch + "Number.java", ch, "!java" + ch + "lang" + ch + "Number.java"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java" + ch + "lang" + ch + "Number.java", ch, "lang" + ch + "***"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java" + ch + "lang" + ch + "Number.java", ch, "java" + ch + "***", "sun" + ch + "management" + ch + "***", "!java" + ch + "lang" + ch + "Number.java"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("sun" + ch + "Foobar.java", ch, "java" + ch + "***", "sun" + ch + "management" + ch + "***", "!java" + ch + "lang" + ch + "Number.java"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("sun" + ch + "management" + ch + "Foobar.java", ch, "java" + ch + "***", "sun" + ch + "management" + ch + "***", "!java" + ch + "lang" + ch + "Number.java"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "Foobar.java", ch, "java" + ch + "***", "sun" + ch + "management" + ch + "***", "!java" + ch + "lang" + ch + "Number.java"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "util" + ch + "Foobar.java", ch, "java" + ch + "lang" + ch + "***", "java" + ch + "util" + ch + "*", "java" + ch + "util" + ch + "concurrent" + ch + "***", "java" + ch + "util" + ch + "logging" + ch + "***", "sun" + ch + "reflect" + ch + "***", "!java" + ch + "lang" + ch + "Number.java"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "util" + ch + "concurrent" + ch + "Foobar.java", ch, "java" + ch + "lang" + ch + "***", "java" + ch + "util" + ch + "*", "java" + ch + "util" + ch + "concurrent" + ch + "***", "java" + ch + "util" + ch + "logging" + ch + "***", "sun" + ch + "reflect" + ch + "***", "!java" + ch + "lang" + ch + "Number.java"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "util" + ch + "logging" + ch + "Foobar.java", ch, "java" + ch + "lang" + ch + "***", "java" + ch + "util" + ch + "*", "java" + ch + "util" + ch + "concurrent" + ch + "***", "java" + ch + "util" + ch + "logging" + ch + "***", "sun" + ch + "reflect" + ch + "***", "!java" + ch + "lang" + ch + "Number.java"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java" + ch + "util" + ch + "foobar" + ch + "Foobar.java", ch, "java" + ch + "lang" + ch + "***", "java" + ch + "util" + ch + "*", "java" + ch + "util" + ch + "concurrent" + ch + "***", "java" + ch + "util" + ch + "logging" + ch + "***", "sun" + ch + "reflect" + ch + "***", "!java" + ch + "lang" + ch + "Number.java"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "util" + ch + "Foobar", ch, "java" + ch + "util" + ch + "*"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java" + ch + "util" + ch + "foo" + ch + "Foobar.java", ch, "java" + ch + "util" + ch + "*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "util" + ch + "foo" + ch + "Foobar.java", ch, "java" + ch + "util" + ch + "foo" + ch + "[a-mA-M]*"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java" + ch + "util" + ch + "foo" + ch + "Foobar.java", ch, "java" + ch + "util" + ch + "foo" + ch + "[n-zN-Z]*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "util" + ch + "AbstractCollection.java", ch, "java" + ch + "util" + ch + "*Collection*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "lang" + ch + "ref" + ch + "Reference$1.java", ch, "java" + ch + "lang" + ch + "ref" + ch + "Reference$*"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java" + ch + "lang" + ch + "ref" + ch + "ReferenceQueue.java", ch, "java" + ch + "lang" + ch + "ref" + ch + "Reference$*"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("edu" + ch + "rice" + ch + "cs" + ch + "cunit" + ch + "instrumentors" + ch + "CompactSynchronizedBlockReplayStrategy.java", ch, "***Synchronized*"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("anything", ch, ""));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("anything", ch, new String[0]));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "util" + ch + "FooClass.java", ch, "java" + ch + "util" + ch + "(Foo|Bar)Class.java"));
            StringOpsTest.assertEquals(true, StringOps.stringMatches("java" + ch + "util" + ch + "BarClass.java", ch, "java" + ch + "util" + ch + "(Foo|Bar)Class.java"));
            StringOpsTest.assertEquals(false, StringOps.stringMatches("java" + ch + "util" + ch + "FumClass.java", ch, "java" + ch + "util" + ch + "(Foo|Bar)Class.java"));
        }
    }
}

