/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.config;

import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.config.OptionMap;
import edu.rice.cs.drjava.config.OptionParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ResourceBundleConfiguration
extends FileConfiguration {
    protected final String _resourceBundleName;
    protected final ResourceBundle _bundle;
    protected final FileConfiguration _shadowed;

    public ResourceBundleConfiguration(String resourceBundleName, FileConfiguration shadowed) {
        super(shadowed.getFile());
        this._resourceBundleName = resourceBundleName;
        this._bundle = ResourceBundle.getBundle(resourceBundleName);
        this._shadowed = shadowed;
        this.map = new OptionMap(){

            @Override
            public <T> T getOption(OptionParser<T> o) {
                if (o == null) {
                    return ResourceBundleConfiguration.this._shadowed.getOptionMap().getOption(o);
                }
                try {
                    String str = ResourceBundleConfiguration.this._bundle.getString(o.getName());
                    return o.parse(str);
                }
                catch (MissingResourceException mre) {
                    return ResourceBundleConfiguration.this._shadowed.getOptionMap().getOption(o);
                }
            }

            @Override
            public <T> T setOption(Option<T> o, T val) {
                if (o == null) {
                    return ResourceBundleConfiguration.this._shadowed.getOptionMap().setOption(o, val);
                }
                try {
                    String str = ResourceBundleConfiguration.this._bundle.getString(o.getName());
                    return null;
                }
                catch (MissingResourceException mre) {
                    return ResourceBundleConfiguration.this._shadowed.getOptionMap().setOption(o, val);
                }
            }

            @Override
            public <T> String getString(OptionParser<T> o) {
                if (o == null) {
                    return ResourceBundleConfiguration.this._shadowed.getOptionMap().getString(o);
                }
                try {
                    String str = ResourceBundleConfiguration.this._bundle.getString(o.getName());
                    return str;
                }
                catch (MissingResourceException mre) {
                    return ResourceBundleConfiguration.this._shadowed.getOptionMap().getString(o);
                }
            }

            @Override
            public <T> void setString(OptionParser<T> o, String s) {
                if (o == null) {
                    ResourceBundleConfiguration.this._shadowed.getOptionMap().setString(o, s);
                }
                try {
                    String str = ResourceBundleConfiguration.this._bundle.getString(o.getName());
                    return;
                }
                catch (MissingResourceException mre) {
                    ResourceBundleConfiguration.this._shadowed.getOptionMap().setString(o, s);
                    return;
                }
            }

            @Override
            public <T> T removeOption(OptionParser<T> o) {
                if (o == null) {
                    return ResourceBundleConfiguration.this._shadowed.getOptionMap().removeOption(o);
                }
                try {
                    String str = ResourceBundleConfiguration.this._bundle.getString(o.getName());
                    return null;
                }
                catch (MissingResourceException mre) {
                    return ResourceBundleConfiguration.this._shadowed.getOptionMap().removeOption(o);
                }
            }

            @Override
            public Iterable<OptionParser<?>> keys() {
                Iterable<OptionParser<?>> shadowedKeys = ResourceBundleConfiguration.this._shadowed.getOptionMap().keys();
                return shadowedKeys;
            }
        };
    }

    @Override
    public <T> T setSetting(Option<T> op, T value) {
        if (op == null) {
            return this._shadowed.setSetting(op, value);
        }
        try {
            String str = this._bundle.getString(op.getName());
            return null;
        }
        catch (MissingResourceException mre) {
            return this._shadowed.setSetting(op, value);
        }
    }

    @Override
    public <T> T getSetting(Option<T> op) {
        if (op == null) {
            return this._shadowed.getSetting(op);
        }
        try {
            String str = this._bundle.getString(op.getName());
            return op.parse(str);
        }
        catch (MissingResourceException mre) {
            return this._shadowed.getSetting(op);
        }
    }

    @Override
    public <T> boolean isEditable(Option<T> op) {
        if (op == null) {
            return this._shadowed.isEditable(op);
        }
        try {
            String str = this._bundle.getString(op.getName());
            return false;
        }
        catch (MissingResourceException mre) {
            return this._shadowed.isEditable(op);
        }
    }

    @Override
    public void resetToDefaults() {
        this._shadowed.resetToDefaults();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("In resource bundle ");
        sb.append(this._resourceBundleName);
        sb.append(":\n");
        boolean empty = true;
        Enumeration<String> keyEn = this._bundle.getKeys();
        while (keyEn.hasMoreElements()) {
            String key = keyEn.nextElement();
            sb.append(key);
            sb.append(" = ");
            sb.append(this._bundle.getString(key));
            sb.append("\n");
            empty = false;
        }
        if (empty) {
            sb.append("\tnothing\n");
        }
        sb.append("\nIn shadowed configuration:\n");
        sb.append(this._shadowed);
        return sb.toString();
    }

    @Override
    public void loadConfiguration() throws IOException {
        this._shadowed.loadConfiguration();
    }

    @Override
    public void saveConfiguration() throws IOException {
        this._shadowed.saveConfiguration();
    }

    @Override
    public void saveConfiguration(String header) throws IOException {
        this._shadowed.saveConfiguration(header);
    }

    @Override
    public void loadConfiguration(InputStream is) throws IOException {
        this._shadowed.loadConfiguration(is);
    }

    @Override
    public void saveConfiguration(OutputStream os, String header) throws IOException {
        this._shadowed.saveConfiguration(os, header);
    }

    @Override
    public <T> void addOptionListener(Option<T> op, OptionListener<T> l) {
        op.addListener(this, l);
        op.addListener(this._shadowed, l);
    }

    @Override
    public <T> void removeOptionListener(Option<T> op, OptionListener<T> l) {
        op.removeListener(this, l);
        op.removeListener(this._shadowed, l);
    }
}

