/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.IDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import java.io.File;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;

public class BrowserDocumentRegion
implements IDocumentRegion,
Comparable<BrowserDocumentRegion> {
    private static volatile int _indexCounter = 0;
    private final int _index;
    protected final OpenDefinitionsDocument _doc;
    protected final File _file;
    protected Position _startPosition;
    protected Position _endPosition;
    protected volatile DefaultMutableTreeNode _treeNode;

    public BrowserDocumentRegion(OpenDefinitionsDocument doc, Position sp, Position ep) {
        assert (doc != null);
        this._index = _indexCounter++;
        this._doc = doc;
        this._file = doc.getRawFile();
        this._startPosition = sp;
        this._endPosition = ep;
        this._treeNode = null;
    }

    public int hashCode() {
        return this._index;
    }

    @Override
    public int compareTo(BrowserDocumentRegion r) {
        return this._index - r._index;
    }

    public int getIndex() {
        return this._index;
    }

    @Override
    public OpenDefinitionsDocument getDocument() {
        return this._doc;
    }

    public File getFile() {
        return this._file;
    }

    @Override
    public int getStartOffset() {
        return this._startPosition.getOffset();
    }

    @Override
    public int getEndOffset() {
        return this._endPosition.getOffset();
    }

    public void update(BrowserDocumentRegion other) {
        if (other.getDocument() != this._doc) {
            throw new IllegalArgumentException("Regions must have the same document.");
        }
        this._startPosition = other._startPosition;
        this._endPosition = other._endPosition;
    }

    public String toString() {
        return this._doc.toString() + "[" + this.getStartOffset() + "]";
    }
}

