/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.IDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.OrderedDocumentRegion;

public class DocumentRegion
implements OrderedDocumentRegion {
    protected final OpenDefinitionsDocument _doc;
    protected volatile int _start;
    protected volatile int _end;

    public DocumentRegion(OpenDefinitionsDocument doc, int start, int end) {
        assert (doc != null);
        assert (end >= start);
        this._doc = doc;
        this._start = start;
        this._end = end;
    }

    public final boolean equals(Object o) {
        if (o == null || !(o instanceof IDocumentRegion)) {
            return false;
        }
        IDocumentRegion r = (IDocumentRegion)o;
        return this.getDocument() == r.getDocument() && this.getStartOffset() == r.getStartOffset() && this.getEndOffset() == r.getEndOffset();
    }

    @Override
    public int compareTo(OrderedDocumentRegion r) {
        int end2;
        int docRel = this.getDocument().compareTo(r.getDocument());
        if (docRel != 0) {
            return docRel;
        }
        assert (this.getDocument() == r.getDocument());
        int end1 = this.getEndOffset();
        int endDiff = end1 - (end2 = r.getEndOffset());
        if (endDiff != 0) {
            return endDiff;
        }
        int start1 = this.getStartOffset();
        int start2 = r.getStartOffset();
        return start1 - start2;
    }

    @Override
    public OpenDefinitionsDocument getDocument() {
        return this._doc;
    }

    @Override
    public int getStartOffset() {
        return this._start;
    }

    @Override
    public int getEndOffset() {
        return this._end;
    }

    @Override
    public int getLineStartOffset() {
        throw new UnsupportedOperationException("DocumentRegion does not suppport getLineStart()");
    }

    @Override
    public int getLineEndOffset() {
        throw new UnsupportedOperationException("DocumentRegion does not suppport getLineEnd()");
    }

    @Override
    public String getString() {
        throw new UnsupportedOperationException("DocumentRegion does not suppport getString()");
    }

    @Override
    public void update() {
        throw new UnsupportedOperationException("DocumentRegion does not suppport updateLines()");
    }

    @Override
    public boolean isEmpty() {
        return this.getStartOffset() == this.getEndOffset();
    }

    public String toString() {
        return this._doc.toString() + "[" + this.getStartOffset() + " .. " + this.getEndOffset() + "]";
    }
}

