/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model;

import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.JDKDescriptor;
import edu.rice.cs.drjava.model.JDKToolsLibrary;
import edu.rice.cs.drjava.model.compiler.CompilerInterface;
import edu.rice.cs.drjava.model.compiler.NoCompilerAvailable;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.debug.NoDebuggerAvailable;
import edu.rice.cs.drjava.model.javadoc.DefaultJavadocModel;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.javadoc.NoJavadocAvailable;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.ComposedIterable;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.lambda.Lambda;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.reflect.PathClassLoader;
import edu.rice.cs.plt.reflect.PreemptingClassLoader;
import edu.rice.cs.plt.reflect.ReflectException;
import edu.rice.cs.plt.reflect.ReflectUtil;
import edu.rice.cs.plt.reflect.ShadowingClassLoader;
import edu.rice.cs.util.FileOps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public class JarJDKToolsLibrary
extends JDKToolsLibrary {
    private static final Set<String> TOOLS_PACKAGES = new HashSet<String>();
    private final File _location;
    private final List<File> _bootClassPath;

    private JarJDKToolsLibrary(File location, JavaVersion.FullVersion version, JDKDescriptor jdkDescriptor, CompilerInterface compiler, Debugger debugger, JavadocModel javadoc, List<File> bootClassPath) {
        super(version, jdkDescriptor, compiler, debugger, javadoc);
        this._location = location;
        this._bootClassPath = bootClassPath;
    }

    public File location() {
        return this._location;
    }

    public List<File> bootClassPath() {
        if (this._bootClassPath != null) {
            return new ArrayList<File>(this._bootClassPath);
        }
        return null;
    }

    @Override
    public String toString() {
        return super.toString() + " at " + this._location + ", boot classpath: " + this.bootClassPath();
    }

    public static JarJDKToolsLibrary makeFromFile(File f, GlobalModel model, JDKDescriptor desc) {
        return JarJDKToolsLibrary.makeFromFile(f, model, desc, new ArrayList<File>());
    }

    /*
     * WARNING - void declaration
     */
    public static JarJDKToolsLibrary makeFromFile(File f, GlobalModel model, JDKDescriptor desc, List<File> additionalBootClassPath) {
        assert (desc != null);
        CompilerInterface compiler = NoCompilerAvailable.ONLY;
        Debugger debugger = NoDebuggerAvailable.ONLY;
        JavadocModel javadoc = new NoJavadocAvailable(model);
        JavaVersion.FullVersion version = desc.guessVersion(f);
        JDKToolsLibrary.msg("makeFromFile: " + f + " --> " + version + ", vendor: " + (Object)((Object)version.vendor()));
        JDKToolsLibrary.msg("    desc = " + desc);
        boolean isSupported = JavaVersion.CURRENT.supports(version.majorVersion());
        Iterable<Object> additionalCompilerFiles = IterUtil.empty();
        isSupported |= JavaVersion.CURRENT.supports(desc.getMinimumMajorVersion());
        try {
            additionalCompilerFiles = desc.getAdditionalCompilerFiles(f);
        }
        catch (FileNotFoundException fnfe) {
            isSupported = false;
        }
        ArrayList<File> bootClassPath = null;
        if (isSupported) {
            ShadowingClassLoader loader = new ShadowingClassLoader(JarJDKToolsLibrary.class.getClassLoader(), true, TOOLS_PACKAGES, true);
            SizedIterable<File> path = IterUtil.map(IterUtil.compose(additionalCompilerFiles, f), new Lambda<File, File>(){

                @Override
                public File value(File arg) {
                    return IOUtil.attemptAbsoluteFile(arg);
                }
            });
            String compilerAdapter = desc.getAdapterForCompiler(version);
            if (compilerAdapter != null) {
                File jdkLibDir;
                File libDir = null;
                if (f.getName().equals("classes.jar")) {
                    libDir = f.getParentFile();
                } else if (f.getName().equals("tools.jar") && (jdkLibDir = f.getParentFile()) != null) {
                    File jreLibDir;
                    File file = jdkLibDir.getParentFile();
                    if (file != null && IOUtil.attemptExists(new File(jreLibDir = new File(file, "jre/lib"), "rt.jar"))) {
                        libDir = jreLibDir;
                    }
                    if (libDir == null && IOUtil.attemptExists(new File(jdkLibDir, "rt.jar"))) {
                        libDir = jdkLibDir;
                    }
                }
                bootClassPath = new ArrayList<File>();
                if (libDir != null) {
                    File[] jars = IOUtil.attemptListFiles(libDir, IOUtil.extensionFilePredicate("jar"));
                    if (jars != null) {
                        bootClassPath.addAll(Arrays.asList(jars));
                    }
                } else {
                    bootClassPath.add(f);
                    for (File file : additionalCompilerFiles) {
                        bootClassPath.add(file);
                    }
                }
                if (additionalBootClassPath != null) {
                    bootClassPath.addAll(additionalBootClassPath);
                }
                if (bootClassPath.isEmpty()) {
                    bootClassPath = null;
                }
                try {
                    Class[] sig = new Class[]{JavaVersion.FullVersion.class, String.class, List.class};
                    Object[] objectArray = new Object[]{version, f.toString(), bootClassPath};
                    CompilerInterface attempt = (CompilerInterface)ReflectUtil.loadLibraryAdapter((ClassLoader)loader, path, compilerAdapter, sig, objectArray);
                    if (attempt.isAvailable()) {
                        compiler = attempt;
                    }
                }
                catch (ReflectException e) {
                }
                catch (LinkageError e) {
                    // empty catch block
                }
            }
            String debuggerAdapter = desc.getAdapterForDebugger(version);
            String debuggerPackage = "edu.rice.cs.drjava.model.debug.jpda";
            if (debuggerAdapter != null) {
                try {
                    JDKToolsLibrary.msg("                 loading debugger: " + debuggerAdapter);
                    Class[] classArray = new Class[]{GlobalModel.class};
                    PreemptingClassLoader debugLoader = new PreemptingClassLoader((ClassLoader)new PathClassLoader((ClassLoader)loader, path), debuggerPackage);
                    Debugger attempt = (Debugger)ReflectUtil.loadObject((ClassLoader)debugLoader, debuggerAdapter, classArray, new Object[]{model});
                    JDKToolsLibrary.msg("                 debugger=" + attempt.getClass().getName());
                    if (attempt.isAvailable()) {
                        debugger = attempt;
                    }
                }
                catch (ReflectException reflectException) {
                    JDKToolsLibrary.msg("                 no debugger, ReflectException " + reflectException);
                }
                catch (LinkageError linkageError) {
                    JDKToolsLibrary.msg("                 no debugger, LinkageError " + linkageError);
                }
            }
            try {
                void var16_32;
                void var16_30;
                new PathClassLoader((ClassLoader)loader, path).loadClass("com.sun.tools.javadoc.Main");
                File file = new File(f.getParentFile(), "../bin");
                if (!IOUtil.attemptIsDirectory(file)) {
                    File file2 = new File(f.getParentFile(), "../Home/bin");
                }
                if (!IOUtil.attemptIsDirectory((File)var16_30)) {
                    File file3 = new File(System.getProperty("java.home", f.getParent()));
                }
                javadoc = new DefaultJavadocModel(model, (File)var16_32, path);
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (LinkageError linkageError) {
                // empty catch block
            }
        }
        return new JarJDKToolsLibrary(f, version, desc, compiler, debugger, javadoc, bootClassPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaVersion.FullVersion guessVersion(File f, JDKDescriptor desc) {
        JarFile jf;
        String path;
        assert (desc != null);
        JavaVersion.FullVersion result = null;
        boolean forceUnknown = desc.isCompound();
        File current = IOUtil.attemptCanonicalFile(f);
        String parsedVersion = "";
        String vendor = "";
        do {
            String name = current.getName();
            path = current.getAbsolutePath();
            if (!forceUnknown) {
                if (path.startsWith("/System/Library/Frameworks/JavaVM.framework")) {
                    vendor = "apple";
                } else if (path.startsWith("/Library/Java")) {
                    vendor = "oracle";
                } else if (path.toLowerCase().contains("openjdk")) {
                    vendor = "openjdk";
                } else if (path.toLowerCase().contains("sun")) {
                    vendor = "sun";
                } else if (path.toLowerCase().contains("oracle")) {
                    vendor = "oracle";
                }
            }
            if (name.startsWith("jdk-")) {
                parsedVersion = name.substring(4);
                result = JavaVersion.parseFullVersion(parsedVersion, vendor, vendor, f);
                continue;
            }
            if (name.startsWith("jdk")) {
                parsedVersion = name.substring(3);
                result = JavaVersion.parseFullVersion(parsedVersion, vendor, vendor, f);
                JDKToolsLibrary.msg("For name starting with 'jdk', parsedVersion = '" + parsedVersion + "' result = '" + result + "'");
                continue;
            }
            if (name.startsWith("j2sdk") || name.startsWith("java-")) {
                parsedVersion = name.substring(5);
                result = JavaVersion.parseFullVersion(parsedVersion, vendor, vendor, f);
                continue;
            }
            if (!name.matches("\\d+\\.\\d+\\.\\d+.*")) continue;
            JarJDKToolsLibrary.msg("Invoking parseFullVersion on " + name + ", " + vendor + ", " + vendor + ", " + f);
            parsedVersion = name.substring(0, 5);
            result = JavaVersion.parseFullVersion(parsedVersion, vendor, vendor, f);
            JarJDKToolsLibrary.msg("Result is: " + result.versionString());
        } while ((current = current.getParentFile()) != null && result == null);
        if (result == null || result.majorVersion().equals((Object)JavaVersion.UNRECOGNIZED) || result.majorVersion().equals((Object)JavaVersion.FUTURE)) {
            block51: {
                jf = null;
                try {
                    String v;
                    jf = new JarFile(f);
                    Manifest mf = jf.getManifest();
                    if (mf != null && (v = mf.getMainAttributes().getValue("Created-By")) != null) {
                        int space = v.indexOf(32);
                        if (space >= 0) {
                            v = v.substring(0, space);
                        }
                        parsedVersion = v;
                        result = JavaVersion.parseFullVersion(parsedVersion, vendor, vendor, f);
                    }
                    if (result != null && !result.majorVersion().equals((Object)JavaVersion.UNRECOGNIZED) && !result.majorVersion().equals((Object)JavaVersion.FUTURE)) break block51;
                    Enumeration<JarEntry> jes = jf.entries();
                    while (jes.hasMoreElements()) {
                        JarEntry je = jes.nextElement();
                        if (!je.getName().endsWith(".class")) continue;
                        result = JavaVersion.parseClassVersion(jf.getInputStream(je)).fullVersion();
                        break;
                    }
                }
                catch (IOException ioe) {
                    result = null;
                }
                finally {
                    try {
                        if (jf != null) {
                            jf.close();
                        }
                    }
                    catch (IOException ioe) {}
                }
            }
            if (result == null || result.majorVersion().equals((Object)JavaVersion.UNRECOGNIZED)) {
                result = JavaVersion.CURRENT_FULL;
            }
            parsedVersion = result.versionString();
        }
        if (result == null || result.vendor() == JavaVersion.VendorType.UNKNOWN) {
            if (!forceUnknown) {
                if (result.majorVersion().compareTo(JavaVersion.JAVA_6) < 0) {
                    vendor = "sun";
                } else {
                    jf = null;
                    try {
                        jf = new JarFile(f);
                        if (jf.getJarEntry("com/sun/tools/javac/util/JavacFileManager.class") != null) {
                            vendor = "openjdk";
                        } else if (jf.getJarEntry("com/sun/tools/javac/util/DefaultFileManager.class") != null) {
                            vendor = "sun";
                        }
                    }
                    catch (IOException ioe) {
                    }
                    finally {
                        try {
                            if (jf != null) {
                                jf.close();
                            }
                        }
                        catch (IOException ioe) {}
                    }
                }
            }
            result = JavaVersion.parseFullVersion(parsedVersion, vendor, vendor, f);
        }
        JarJDKToolsLibrary.msg("Guessed version for " + path + " is " + result.versionString());
        return result;
    }

    protected static LinkedHashMap<File, Set<JDKDescriptor>> getDefaultSearchRoots() {
        JDKToolsLibrary.msg("---- Getting Default Search Roots ----");
        LinkedHashMap<File, Set<JDKDescriptor>> roots = new LinkedHashMap<File, Set<JDKDescriptor>>();
        String javaHome = System.getProperty("java.home");
        String envJavaHome = null;
        Object envJava7Home = null;
        String programFiles = null;
        String systemDrive = null;
        if (JavaVersion.CURRENT.supports(JavaVersion.JAVA_5)) {
            envJavaHome = System.getenv("JAVA_HOME");
            programFiles = System.getenv("ProgramFiles");
            systemDrive = System.getenv("SystemDrive");
        }
        if (javaHome != null) {
            JarJDKToolsLibrary.addIfDir(new File(javaHome), roots);
            JarJDKToolsLibrary.addIfDir(new File(javaHome, ".."), roots);
            JarJDKToolsLibrary.addIfDir(new File(javaHome, "../.."), roots);
            JarJDKToolsLibrary.addIfDir(new File(javaHome, "../../.."), roots);
            JarJDKToolsLibrary.addIfDir(new File(javaHome, "../../../.."), roots);
        }
        if (envJavaHome != null) {
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome), roots);
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome, ".."), roots);
            JarJDKToolsLibrary.addIfDir(new File(envJavaHome, "../.."), roots);
        }
        if (programFiles != null) {
            JarJDKToolsLibrary.addIfDir(new File(programFiles, "Java"), roots);
            JarJDKToolsLibrary.addIfDir(new File(programFiles), roots);
        }
        JarJDKToolsLibrary.addIfDir(new File("/C:/Program Files/Java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/C:/Program Files"), roots);
        if (systemDrive != null) {
            JarJDKToolsLibrary.addIfDir(new File(systemDrive, "Java"), roots);
            JarJDKToolsLibrary.addIfDir(new File(systemDrive), roots);
        }
        JarJDKToolsLibrary.addIfDir(new File("/C:/Java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/C:"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/System/Library/Java/JavaVirtualMachines"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/Library/Java/JavaVirtualMachines"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/j2se"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local/java"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local/j2se"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/local"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/lib/jvm"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/lib/jvm/java-7-oracle"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/lib/jvm/java-7-openjdk"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/lib/jvm/java-6-sun"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/lib/jvm/java-6-openjdk"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/usr/lib/jvm/java-1.5.0-sun"), roots);
        JarJDKToolsLibrary.addIfDir(new File("/home/javaplt/java/Linux-i686"), roots);
        return roots;
    }

    protected static void searchRootsForJars(LinkedHashMap<File, Set<JDKDescriptor>> roots, LinkedHashMap<File, Set<JDKDescriptor>> jars) {
        JDKToolsLibrary.msg("***** roots = " + roots);
        Predicate<File> subdirFilter = LambdaUtil.or(IOUtil.regexCanonicalCaseFilePredicate("j2sdk.*"), IOUtil.regexCanonicalCaseFilePredicate("jdk.*"), LambdaUtil.or(IOUtil.regexCanonicalCaseFilePredicate("\\d+\\.\\d+\\.\\d+.*"), IOUtil.regexCanonicalCaseFilePredicate("java-.*")));
        for (Map.Entry<File, Set<JDKDescriptor>> root : roots.entrySet()) {
            JDKToolsLibrary.msg("Searching root (for jar files): " + root.getKey());
            for (File subdir : IOUtil.attemptListFilesAsIterable(root.getKey(), subdirFilter)) {
                JDKToolsLibrary.msg("Looking at subdirectory: " + subdir);
                JarJDKToolsLibrary.addIfFile(new File(subdir, "lib/tools.jar"), root.getValue(), jars);
                JarJDKToolsLibrary.addIfFile(new File(subdir, "Classes/classes.jar"), root.getValue(), jars);
                JarJDKToolsLibrary.addIfFile(new File(subdir, "Contents/Classes/classes.jar"), root.getValue(), jars);
                JarJDKToolsLibrary.addIfFile(new File(subdir, "Contents/Home/lib/tools.jar"), root.getValue(), jars);
            }
        }
    }

    protected static void collectValidResults(GlobalModel model, LinkedHashMap<File, Set<JDKDescriptor>> jars, Map<JavaVersion.FullVersion, Iterable<JarJDKToolsLibrary>> results, Map<JavaVersion.FullVersion, Iterable<JarJDKToolsLibrary>> compoundResults) {
        JDKToolsLibrary.msg("---- Collecting Valid Results ----");
        for (Map.Entry<File, Set<JDKDescriptor>> jar : jars.entrySet()) {
            for (JDKDescriptor desc : jar.getValue()) {
                assert (desc != null);
                boolean containsCompiler = desc.containsCompiler(jar.getKey());
                JDKToolsLibrary.msg("Checking file " + jar.getKey() + " for " + desc);
                JDKToolsLibrary.msg("    " + containsCompiler);
                if (!containsCompiler) continue;
                JarJDKToolsLibrary lib = JarJDKToolsLibrary.makeFromFile(jar.getKey(), model, desc);
                if (lib.isValid()) {
                    JavaVersion.FullVersion v = lib.version();
                    Map<JavaVersion.FullVersion, Iterable<JarJDKToolsLibrary>> mapToAddTo = results;
                    if (desc.isCompound()) {
                        mapToAddTo = compoundResults;
                    }
                    if (mapToAddTo.containsKey(v)) {
                        mapToAddTo.put(v, IterUtil.compose(lib, mapToAddTo.get(v)));
                        continue;
                    }
                    mapToAddTo.put(v, IterUtil.singleton(lib));
                    continue;
                }
                JDKToolsLibrary.msg("    library is not valid: compiler=" + lib.compiler().isAvailable() + " debugger=" + lib.debugger().isAvailable() + " javadoc=" + lib.javadoc().isAvailable());
            }
        }
    }

    protected static Map<JavaVersion.FullVersion, Iterable<JarJDKToolsLibrary>> getCompletedCompoundResults(GlobalModel model, Iterable<JarJDKToolsLibrary> collapsed, Iterable<JarJDKToolsLibrary> compoundCollapsed) {
        JDKToolsLibrary.msg("---- Getting Completed Compound Results ----");
        TreeMap<JavaVersion.FullVersion, Iterable<JarJDKToolsLibrary>> completedResults = new TreeMap<JavaVersion.FullVersion, Iterable<JarJDKToolsLibrary>>();
        for (JarJDKToolsLibrary compoundLib : compoundCollapsed) {
            JarJDKToolsLibrary lib;
            JavaVersion.FullVersion javaVersion;
            JDKToolsLibrary.msg("compoundLib: " + compoundLib);
            JDKToolsLibrary.msg("    " + compoundLib.location());
            JavaVersion.FullVersion compoundVersion = compoundLib.version();
            JarJDKToolsLibrary found = null;
            for (JarJDKToolsLibrary javaLib : collapsed) {
                if (!javaLib.jdkDescriptor().isBaseForCompound()) continue;
                JDKToolsLibrary.msg("    exact? " + javaLib);
                javaVersion = javaLib.version();
                if (!javaVersion.majorVersion().equals((Object)compoundVersion.majorVersion()) || javaVersion.maintenance() != compoundVersion.maintenance() || javaVersion.update() != compoundVersion.update() || javaVersion.release() != compoundVersion.release() || !javaVersion.supports(compoundLib.jdkDescriptor().getMinimumMajorVersion())) continue;
                JDKToolsLibrary.msg("        found");
                found = javaLib;
                break;
            }
            if (found == null) {
                for (JarJDKToolsLibrary javaLib : collapsed) {
                    if (!javaLib.jdkDescriptor().isBaseForCompound()) continue;
                    JDKToolsLibrary.msg("    major? " + javaLib);
                    javaVersion = javaLib.version();
                    if (!javaVersion.majorVersion().equals((Object)compoundVersion.majorVersion()) || !javaVersion.supports(compoundLib.jdkDescriptor().getMinimumMajorVersion())) continue;
                    JDKToolsLibrary.msg("        found");
                    found = javaLib;
                    break;
                }
            }
            if (found == null || !(lib = JarJDKToolsLibrary.makeFromFile(compoundLib.location(), model, compoundLib.jdkDescriptor(), found.bootClassPath())).isValid()) continue;
            JDKToolsLibrary.msg("    based on version " + lib.version());
            JavaVersion.FullVersion v = lib.version();
            if (completedResults.containsKey(v)) {
                completedResults.put(v, IterUtil.compose(lib, (Iterable)completedResults.get(v)));
                continue;
            }
            completedResults.put(v, IterUtil.singleton(lib));
        }
        return completedResults;
    }

    public static Iterable<JarJDKToolsLibrary> search(GlobalModel model) {
        JDKToolsLibrary.msg("---- Searching for Libraries ----");
        LinkedHashMap<File, Set<JDKDescriptor>> roots = JarJDKToolsLibrary.getDefaultSearchRoots();
        LinkedHashMap<File, Set<JDKDescriptor>> jars = new LinkedHashMap<File, Set<JDKDescriptor>>();
        Iterable<JDKDescriptor> descriptors = JarJDKToolsLibrary.searchForJDKDescriptors();
        for (JDKDescriptor desc : descriptors) {
            for (File f : desc.getSearchDirectories()) {
                JarJDKToolsLibrary.addIfDir(f, desc, roots);
            }
            for (File f : desc.getSearchFiles()) {
                JarJDKToolsLibrary.addIfFile(f, desc, jars);
            }
            TOOLS_PACKAGES.addAll(desc.getToolsPackages());
        }
        JarJDKToolsLibrary.searchRootsForJars(roots, jars);
        TreeMap<JavaVersion.FullVersion, Iterable<JarJDKToolsLibrary>> results = new TreeMap<JavaVersion.FullVersion, Iterable<JarJDKToolsLibrary>>();
        TreeMap<JavaVersion.FullVersion, Iterable<JarJDKToolsLibrary>> compoundResults = new TreeMap<JavaVersion.FullVersion, Iterable<JarJDKToolsLibrary>>();
        JarJDKToolsLibrary.collectValidResults(model, jars, results, compoundResults);
        SizedIterable<JarJDKToolsLibrary> collapsed = IterUtil.reverse(IterUtil.collapse(results.values()));
        JDKToolsLibrary.msg("***** Found the following base libraries *****");
        for (JarJDKToolsLibrary lib : collapsed) {
            JDKToolsLibrary.msg("  Base library: " + lib);
        }
        SizedIterable<JarJDKToolsLibrary> compoundCollapsed = IterUtil.reverse(IterUtil.collapse(compoundResults.values()));
        Map<JavaVersion.FullVersion, Iterable<JarJDKToolsLibrary>> completedResults = JarJDKToolsLibrary.getCompletedCompoundResults(model, collapsed, compoundCollapsed);
        JDKToolsLibrary.msg("***** Found the following completed compound libraries *****");
        for (JarJDKToolsLibrary lib : IterUtil.collapse(completedResults.values())) {
            JDKToolsLibrary.msg("  Compound library: " + lib);
        }
        ComposedIterable<JarJDKToolsLibrary> result = IterUtil.compose(collapsed, IterUtil.reverse(IterUtil.collapse(completedResults.values())));
        return result;
    }

    private static void addIfDir(File f, Map<? super File, Set<JDKDescriptor>> map) {
        JarJDKToolsLibrary.addIfDir(f, JDKDescriptor.NONE, map);
    }

    private static void addIfDir(File f, JDKDescriptor c, Map<? super File, Set<JDKDescriptor>> map) {
        if (IOUtil.attemptIsDirectory(f = IOUtil.attemptCanonicalFile(f))) {
            Set<JDKDescriptor> set = map.get(f);
            if (set == null) {
                set = new LinkedHashSet<JDKDescriptor>();
                map.put(f, set);
            }
            if (!set.contains(f)) {
                JDKToolsLibrary.msg("Dir added:     " + f);
            }
            set.add(c);
        } else {
            JDKToolsLibrary.msg("Dir does not exist: " + f);
        }
    }

    private static void addIfFile(File f, Map<? super File, Set<JDKDescriptor>> map) {
        JarJDKToolsLibrary.addIfFile(f, JDKDescriptor.NONE, map);
    }

    private static void addIfFile(File f, JDKDescriptor c, Map<? super File, Set<JDKDescriptor>> map) {
        JarJDKToolsLibrary.addIfFile(f, Collections.singleton(c), map);
    }

    private static void addIfFile(File f, Set<JDKDescriptor> cs, Map<? super File, Set<JDKDescriptor>> map) {
        if (IOUtil.attemptIsFile(f = IOUtil.attemptCanonicalFile(f))) {
            Set<JDKDescriptor> set = map.get(f);
            if (set == null) {
                set = new LinkedHashSet<JDKDescriptor>();
                map.put(f, set);
            }
            set.addAll(cs);
            JDKToolsLibrary.msg("File added:     " + f);
        } else {
            JDKToolsLibrary.msg("File not added: " + f);
        }
    }

    private static Iterable<JDKDescriptor> searchForJDKDescriptors() {
        JDKToolsLibrary.msg("---- Searching for descriptors ----");
        long t0 = System.currentTimeMillis();
        JDKToolsLibrary.msg("ms: " + t0);
        Iterable<JDKDescriptor> descriptors = IterUtil.empty();
        try {
            File f = FileOps.getDrJavaFile();
            JDKToolsLibrary.msg("drjava.jar: " + f);
            if (f.isFile()) {
                JarFile jf = new JarFile(f);
                JDKToolsLibrary.msg("jar file: " + jf);
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements()) {
                    JarEntry je = entries.nextElement();
                    String name = je.getName();
                    if (!name.startsWith("edu/rice/cs/drjava/model/compiler/descriptors/") || !name.endsWith(".class") || name.indexOf(36) >= 0) continue;
                    descriptors = JarJDKToolsLibrary.attemptToLoadDescriptor(descriptors, name);
                }
            } else {
                String DESC_PATH = "edu/rice/cs/drjava/model/compiler/descriptors";
                File dir = new File(f, "edu/rice/cs/drjava/model/compiler/descriptors");
                JDKToolsLibrary.msg("directory, enumerating files in " + dir);
                SizedIterable<File> files = IOUtil.listFilesRecursively(dir, (Predicate<? super File>)new Predicate<File>(){

                    @Override
                    public boolean contains(File arg) {
                        return arg.isFile() && arg.getName().endsWith(".class") && arg.getName().indexOf(36) < 0;
                    }
                });
                for (File je : files) {
                    String name = "edu/rice/cs/drjava/model/compiler/descriptors/" + je.getName();
                    descriptors = JarJDKToolsLibrary.attemptToLoadDescriptor(descriptors, name);
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        long t1 = System.currentTimeMillis();
        JDKToolsLibrary.msg("ms: " + t1);
        JDKToolsLibrary.msg("duration ms: " + (t1 - t0));
        JDKToolsLibrary.msg("---- Done searching for descriptors ----");
        return descriptors;
    }

    protected static Iterable<JDKDescriptor> attemptToLoadDescriptor(Iterable<JDKDescriptor> descriptors, String name) {
        int dotPos = name.indexOf(".class");
        String className = name.substring(0, dotPos).replace('/', '.');
        try {
            JDKToolsLibrary.msg("    class name: " + className);
            Class<?> clazz = Class.forName(className);
            Class<JDKDescriptor> descClass = clazz.asSubclass(JDKDescriptor.class);
            JDKDescriptor desc = descClass.newInstance();
            JDKToolsLibrary.msg("        loaded!");
            descriptors = IterUtil.compose(descriptors, desc);
        }
        catch (LinkageError le) {
            JDKToolsLibrary.msg("LinkageError: " + le);
        }
        catch (ClassNotFoundException cnfe) {
            JDKToolsLibrary.msg("ClassNotFoundException: " + cnfe);
        }
        catch (ClassCastException cce) {
            JDKToolsLibrary.msg("ClassCastException: " + cce);
        }
        catch (IllegalAccessException iae) {
            JDKToolsLibrary.msg("IllegalAccessException: " + iae);
        }
        catch (InstantiationException ie) {
            JDKToolsLibrary.msg("InstantiationException: " + ie);
        }
        return descriptors;
    }

    static {
        Collections.addAll(TOOLS_PACKAGES, "com.sun.javadoc", "com.sun.jdi", "com.sun.tools", "sun.applet", "sun.rmi.rmic", "sun.tools", "com.sun.jarsigner", "com.sun.mirror", "sun.jvmstat", "com.sun.codemodel", "com.sun.istack.internal.tools", "com.sun.istack.internal.ws", "com.sun.source", "com.sun.xml.internal.dtdparser", "com.sun.xml.internal.rngom", "com.sun.xml.internal.xsom", "org.relaxng");
    }
}

