/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.DJError;
import edu.rice.cs.drjava.model.DrJavaFileUtils;
import edu.rice.cs.drjava.model.DummyGlobalModel;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.GlobalModel;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.swing.Utilities;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;

public class CompilerErrorModel {
    private static final String newLine = StringOps.EOL;
    private final DJError[] _errors;
    private final Position[] _positions;
    private final int _numErrors;
    private volatile int _numCompilerErrors;
    private volatile int _numWarnings;
    private volatile int _onlyWarnings = -1;
    private final HashMap<File, StartAndEndIndex> _filesToIndexes = new HashMap();
    private final GlobalModel _model;

    public CompilerErrorModel() {
        this._model = new DummyGlobalModel(){

            @Override
            public OpenDefinitionsDocument getDocumentForFile(File file) {
                throw new IllegalStateException("No documents to get!");
            }

            @Override
            public boolean isAlreadyOpen(File file) {
                return false;
            }

            @Override
            public List<OpenDefinitionsDocument> getOpenDefinitionsDocuments() {
                return new LinkedList<OpenDefinitionsDocument>();
            }

            @Override
            public boolean hasModifiedDocuments() {
                return false;
            }

            @Override
            public boolean hasUntitledDocuments() {
                return false;
            }
        };
        this._errors = new DJError[0];
        this._numErrors = 0;
        this._numWarnings = 0;
        this._numCompilerErrors = 0;
        this._positions = new Position[0];
    }

    public CompilerErrorModel(DJError[] errors, GlobalModel model) {
        this._model = model;
        if (model != null) {
            HashSet<File> odds = new HashSet<File>();
            for (OpenDefinitionsDocument odd : model.getOpenDefinitionsDocuments()) {
                odds.add(odd.getRawFile());
            }
            for (int i = 0; i < errors.length; ++i) {
                File dj2File;
                File javaFile;
                DJError e = errors[i];
                if (!e.fileName().endsWith(".java") || odds.contains(javaFile = e.file()) || !odds.contains(dj2File = DrJavaFileUtils.getDJ2ForJavaFile(javaFile))) continue;
                errors[i] = new DJError(dj2File, e.lineNumber(), e.startColumn(), e.message(), e.isWarning());
            }
        }
        this._errors = errors;
        this._numErrors = errors.length;
        this._positions = new Position[errors.length];
        this._numWarnings = 0;
        this._numCompilerErrors = 0;
        for (int i = 0; i < errors.length; ++i) {
            if (errors[i].isWarning()) {
                ++this._numWarnings;
                continue;
            }
            ++this._numCompilerErrors;
        }
        Arrays.sort(this._errors);
        Utilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompilerErrorModel.this._calculatePositions();
            }
        });
    }

    public DJError getError(int idx) {
        return this._errors[idx];
    }

    public Position getPosition(DJError error) {
        int spot = Arrays.binarySearch(this._errors, error);
        return this._positions[spot];
    }

    public int getNumErrors() {
        return this._numErrors;
    }

    public int getNumCompilerErrors() {
        return this._numCompilerErrors;
    }

    public int getNumWarnings() {
        return this._numWarnings;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().toString() + ":\n  ");
        for (int i = 0; i < this._numErrors; ++i) {
            buf.append(this._errors[i].toString());
            buf.append("\n  ");
        }
        return buf.toString();
    }

    public DJError getErrorAtOffset(OpenDefinitionsDocument odd, int offset) {
        String betweenDotAndErr;
        int errPos;
        int errorAfter;
        int end;
        File file;
        try {
            file = odd.getFile();
            if (file == null) {
                return null;
            }
        }
        catch (FileMovedException e) {
            file = e.getFile();
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        StartAndEndIndex saei = this._filesToIndexes.get(file);
        if (saei == null) {
            return null;
        }
        int start = saei.getStartPos();
        if (start == (end = saei.getEndPos())) {
            return null;
        }
        for (errorAfter = start; errorAfter < end; ++errorAfter) {
            if (this._positions[errorAfter] == null) {
                return null;
            }
            if (this._positions[errorAfter].getOffset() >= offset) break;
        }
        int errorBefore = errorAfter - 1;
        int shouldSelect = -1;
        if (errorBefore >= start) {
            errPos = this._positions[errorBefore].getOffset();
            try {
                betweenDotAndErr = odd.getText(errPos, offset - errPos);
                if (betweenDotAndErr.indexOf(10) == -1) {
                    shouldSelect = errorBefore;
                }
            }
            catch (BadLocationException e) {
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (shouldSelect == -1 && errorAfter < end) {
            errPos = this._positions[errorAfter].getOffset();
            try {
                betweenDotAndErr = odd.getText(offset, errPos - offset);
                if (betweenDotAndErr.indexOf(10) == -1) {
                    shouldSelect = errorAfter;
                }
            }
            catch (BadLocationException e) {
            }
            catch (StringIndexOutOfBoundsException e) {
                // empty catch block
            }
        }
        if (shouldSelect == -1) {
            return null;
        }
        return this._errors[shouldSelect];
    }

    public boolean hasErrorsWithPositions(OpenDefinitionsDocument odd) {
        File file = FileOps.NULL_FILE;
        try {
            file = odd.getFile();
            if (file == null || file == FileOps.NULL_FILE) {
                return false;
            }
        }
        catch (FileMovedException fme) {
            file = fme.getFile();
        }
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        StartAndEndIndex saei = this._filesToIndexes.get(file);
        if (saei == null) {
            return false;
        }
        return saei.getStartPos() != saei.getEndPos();
    }

    public boolean hasOnlyWarnings() {
        if (this._onlyWarnings == 0) {
            return false;
        }
        if (this._onlyWarnings == 1) {
            return true;
        }
        boolean clean = true;
        for (int i = 0; clean && i < this._numErrors; ++i) {
            clean = this._errors[i].isWarning();
        }
        this._onlyWarnings = clean ? 1 : 0;
        return clean;
    }

    private void _calculatePositions() {
        try {
            int curError = 0;
            while (curError < this._numErrors && (curError = this.nextErrorWithLine(curError)) < this._numErrors) {
                OpenDefinitionsDocument document;
                File file = this._errors[curError].file();
                try {
                    document = this._model.getDocumentForFile(file);
                }
                catch (Exception e) {
                    if (e instanceof IOException || e instanceof OperationCanceledException) {
                        document = null;
                    }
                    throw new UnexpectedException(e);
                }
                if (document == null) {
                    while (++curError < this._numErrors && this._errors[curError].file().equals(file)) {
                    }
                    continue;
                }
                if (curError >= this._numErrors) break;
                int fileStartIndex = curError;
                int defsLength = document.getLength();
                String defsText = document.getText(0, defsLength);
                int curLine = 0;
                int offset = 0;
                while (curError < this._numErrors && file.equals(this._errors[curError].file()) && offset <= defsLength) {
                    boolean didNotAdvance = false;
                    if (this._errors[curError].lineNumber() != curLine) {
                        didNotAdvance = true;
                    } else {
                        while (curError < this._numErrors && file.equals(this._errors[curError].file()) && this._errors[curError].lineNumber() == curLine) {
                            this._positions[curError] = document.createPosition(offset + this._errors[curError].startColumn());
                            ++curError;
                        }
                    }
                    if (curError >= this._numErrors) continue;
                    int curErrorLine = this._errors[curError].lineNumber();
                    int nextNewline = 0;
                    while (curLine != curErrorLine && nextNewline != -1 && file.equals(this._errors[curError].file())) {
                        nextNewline = defsText.indexOf(newLine, offset);
                        if (nextNewline == -1) {
                            nextNewline = defsText.indexOf("\n", offset);
                        }
                        if (nextNewline != -1) {
                            ++curLine;
                            offset = nextNewline + 1;
                            continue;
                        }
                        if (!didNotAdvance) continue;
                        this._positions[curError] = null;
                        ++curError;
                    }
                }
                int fileEndIndex = curError;
                if (fileEndIndex == fileStartIndex) continue;
                try {
                    file = file.getCanonicalFile();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                this._filesToIndexes.put(file, new StartAndEndIndex(fileStartIndex, fileEndIndex));
            }
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new UnexpectedException(e);
        }
    }

    private int nextErrorWithLine(int idx) {
        while (idx < this._numErrors && (this._errors[idx].hasNoLocation() || this._errors[idx].file() == null)) {
            ++idx;
        }
        return idx;
    }

    private static class StartAndEndIndex {
        private final int startPos;
        private final int endPos;

        public StartAndEndIndex(int startPos, int endPos) {
            this.startPos = startPos;
            this.endPos = endPos;
        }

        public int getStartPos() {
            return this.startPos;
        }

        public int getEndPos() {
            return this.endPos;
        }
    }
}

