/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler;

import edu.rice.cs.drjava.model.compiler.JavacCompiler;
import edu.rice.cs.plt.io.FilePredicate;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.reflect.JavaVersion;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Javac160FilteringCompiler
extends JavacCompiler {
    protected final boolean _filterExe;
    protected final File _tempJUnit;
    protected static final String PREFIX = "drjava-junit";
    protected static final String SUFFIX = ".jar";

    protected Javac160FilteringCompiler(JavaVersion.FullVersion version, String location, List<? extends File> defaultBootClassPath) {
        super(version, location, defaultBootClassPath);
        this._filterExe = version.compareTo(JavaVersion.parseFullVersion("1.6.0_04")) >= 0;
        File tempJUnit = null;
        if (this._filterExe) {
            block6: {
                try {
                    InputStream is = Javac160FilteringCompiler.class.getResourceAsStream("/junit.jar");
                    if (is != null) {
                        tempJUnit = IOUtil.createAndMarkTempFile(PREFIX, SUFFIX);
                        FileOutputStream fos = new FileOutputStream(tempJUnit);
                        int size = IOUtil.copyInputStream(is, fos);
                    } else if (tempJUnit != null) {
                        tempJUnit.delete();
                        tempJUnit = null;
                    }
                }
                catch (IOException ioe) {
                    if (tempJUnit == null) break block6;
                    tempJUnit.delete();
                    tempJUnit = null;
                }
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        File[] toDelete;
                        File temp = File.createTempFile(Javac160FilteringCompiler.PREFIX, Javac160FilteringCompiler.SUFFIX);
                        IOUtil.attemptDelete(temp);
                        for (File f : toDelete = temp.getParentFile().listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                if (!name.startsWith(Javac160FilteringCompiler.PREFIX) || !name.endsWith(Javac160FilteringCompiler.SUFFIX)) {
                                    return false;
                                }
                                String rest = name.substring(Javac160FilteringCompiler.PREFIX.length(), name.length() - Javac160FilteringCompiler.SUFFIX.length());
                                try {
                                    Integer i = new Integer(rest);
                                    return true;
                                }
                                catch (NumberFormatException e) {
                                    return false;
                                }
                            }
                        })) {
                            f.delete();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }));
        }
        this._tempJUnit = tempJUnit;
    }

    protected List<File> getFilteredClassPath(List<? extends File> classPath) {
        LinkedList<? extends File> filteredClassPath = null;
        if (classPath != null) {
            filteredClassPath = new LinkedList<File>(classPath);
            if (this._filterExe) {
                FilePredicate filter = IOUtil.extensionFilePredicate("exe");
                Iterator i = filteredClassPath.iterator();
                while (i.hasNext()) {
                    if (!filter.accept((File)i.next())) continue;
                    i.remove();
                }
                if (this._tempJUnit != null) {
                    filteredClassPath.add(this._tempJUnit);
                }
            }
        }
        return filteredClassPath;
    }
}

