/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.compiler.descriptors;

import edu.rice.cs.drjava.model.JDKDescriptor;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.iter.SizedIterable;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.util.FileOps;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HjDescriptor
extends JDKDescriptor {
    @Override
    public String getName() {
        return "HJ";
    }

    @Override
    public Set<String> getToolsPackages() {
        HashSet<String> set = new HashSet<String>();
        Collections.addAll(set, "com.sun.codemodel", "com.sun.istack.internal.tools", "com.sun.istack.internal.ws", "com.sun.source", "com.sun.xml.internal.dtdparser", "com.sun.xml.internal.rngom", "com.sun.xml.internal.xsom", "org.relaxng", "com.sun.tools.javac", "com.sun.tools.javac.tree", "com.sun.tools.javac.comp", "com.sun.tools.javac.main");
        return set;
    }

    @Override
    public Iterable<File> getSearchDirectories() {
        return IterUtil.singleton(FileOps.getDrJavaFile().getParentFile());
    }

    @Override
    public Iterable<File> getSearchFiles() {
        SizedIterable<File> files = IterUtil.asIterable(new File("/C:/Program Files/JavaPLT/hj/lib/hjc.jar"), new File("/C:/Program Files/hj/lib/hjc.jar"), new File("/usr/local/hj/lib/hjc.jar"));
        try {
            String hj_home = System.getenv("HJ_HOME");
            if (hj_home != null) {
                files = IterUtil.compose(files, new File(new File(hj_home), "lib/hjc.jar"));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        files = IterUtil.compose(FileOps.getDrJavaFile(), files);
        return files;
    }

    @Override
    public boolean isCompound() {
        return true;
    }

    @Override
    public boolean containsCompiler(File f) {
        return JDKDescriptor.Util.exists(f, "hj/parser/HjLexer.class", "polyglot/ext/hj/Version.class", "polyglot/ext/hj/visit/HjTranslator.class");
    }

    @Override
    public JavaVersion.FullVersion guessVersion(File f) {
        return JavaVersion.parseFullVersion(JavaVersion.JAVA_6.fullVersion().versionString(), "Habanero Research Group", "Habanero Research Group", f);
    }

    @Override
    public String getAdapterForCompiler() {
        return "edu.rice.cs.drjava.model.compiler.HjCompiler";
    }

    @Override
    public String getAdapterForDebugger() {
        return null;
    }

    @Override
    public JavaVersion getMinimumMajorVersion() {
        return JavaVersion.JAVA_6;
    }

    @Override
    public Iterable<File> getAdditionalCompilerFiles(File compiler) throws FileNotFoundException {
        if (compiler.equals(FileOps.getDrJavaFile())) {
            return IterUtil.empty();
        }
        File parentDir = compiler.getParentFile();
        return IterUtil.make(JDKDescriptor.Util.oneOf(parentDir, "hj.jar"), JDKDescriptor.Util.oneOf(parentDir, "sootclasses-2.3.0.jar"), JDKDescriptor.Util.oneOf(parentDir, "polyglot.jar"), JDKDescriptor.Util.oneOf(parentDir, "lpg.jar"), JDKDescriptor.Util.oneOf(parentDir, "jasminclasses-2.3.0.jar"), JDKDescriptor.Util.oneOf(parentDir, "java_cup.jar"));
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + " --> " + this.getAdapterForCompiler();
    }
}

