/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug;

public class DebugWatchData {
    public static final String NO_VALUE = "<not found>";
    public static final String NO_TYPE = "";
    public static final String NOT_LOADED = "<not loaded>";
    private String _name;
    private String _value;
    private String _type;
    private boolean _showValue;
    private boolean _showType;
    private boolean _changed;

    public DebugWatchData(String name) {
        this._name = name;
        this._value = NO_TYPE;
        this._type = NO_TYPE;
        this._showValue = false;
        this._showType = false;
        this._changed = false;
    }

    public String getName() {
        return this._name;
    }

    public String getValue() {
        return this._showValue ? this._value : NO_TYPE;
    }

    public String getType() {
        return this._showType ? this._type : NO_TYPE;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setValue(Object value) {
        this._showValue = true;
        String valString = String.valueOf(value);
        this._changed = !valString.equals(this._value);
        this._value = valString;
    }

    public void hideValueAndType() {
        this._showValue = false;
        this._showType = false;
        this._changed = false;
    }

    public void setNoValue() {
        this._showValue = true;
        this._value = NO_VALUE;
        this._changed = false;
    }

    public void setType(String type) {
        this._showType = true;
        this._type = type;
    }

    public void setNoType() {
        this._showType = true;
        this._type = NO_TYPE;
    }

    public void setTypeNotLoaded() {
        this._showType = true;
        this._type = NOT_LOADED;
    }

    public boolean isChanged() {
        return this._changed;
    }

    public String toString() {
        return this._type + " " + this._name + ": " + this._value;
    }
}

