/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.model.debug.jpda;

import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import edu.rice.cs.drjava.model.debug.DebugThreadData;

public class JPDAThreadData
extends DebugThreadData {
    private final ThreadReference _thread;

    public JPDAThreadData(ThreadReference thread) {
        super(JPDAThreadData.threadName(thread), JPDAThreadData.threadStatus(thread), thread.uniqueID());
        this._thread = thread;
    }

    private static String threadName(ThreadReference thread) {
        try {
            return thread.name();
        }
        catch (VMDisconnectedException e) {
            return "";
        }
    }

    private static String threadStatus(ThreadReference thread) {
        String status = "(unknown)";
        try {
            switch (thread.status()) {
                case 3: {
                    status = "MONITOR";
                    break;
                }
                case 5: {
                    status = "NOT STARTED";
                    break;
                }
                case 1: {
                    status = "RUNNING";
                    break;
                }
                case 2: {
                    status = "SLEEPING";
                    break;
                }
                case -1: {
                    status = "UNKNOWN";
                    break;
                }
                case 4: {
                    status = "WAIT";
                    break;
                }
                case 0: {
                    status = "ZOMBIE";
                }
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        if (JPDAThreadData.safeIsSuspended(thread) && status.equals("RUNNING")) {
            status = "SUSPENDED";
        }
        return status;
    }

    @Override
    public boolean isSuspended() {
        return JPDAThreadData.safeIsSuspended(this._thread);
    }

    private static boolean safeIsSuspended(ThreadReference t) {
        try {
            return t.isSuspended();
        }
        catch (ObjectCollectedException e) {
            return false;
        }
        catch (VMDisconnectedException e) {
            return false;
        }
    }
}

