/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.platform;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.platform.PlatformSupport;
import edu.rice.cs.util.ArgumentTokenizer;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.StringOps;
import java.io.File;
import java.net.URL;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.JTabbedPane;
import javax.swing.UIManager;

class DefaultPlatform
implements PlatformSupport {
    public static DefaultPlatform ONLY = new DefaultPlatform();

    protected DefaultPlatform() {
    }

    @Override
    public boolean isUsingSystemLAF() {
        String sysLAF = UIManager.getSystemLookAndFeelClassName();
        String curLAF = UIManager.getLookAndFeel().getClass().getName();
        return sysLAF.equals(curLAF);
    }

    @Override
    public void beforeUISetup() {
    }

    @Override
    public void afterUISetup(Action about, Action prefs, Action quit) {
    }

    @Override
    public boolean isMacPlatform() {
        return false;
    }

    @Override
    public boolean isWindowsPlatform() {
        return false;
    }

    @Override
    public String getJavaSpecVersion() {
        return System.getProperty("java.specification.version");
    }

    private boolean _javadocMainHasExecuteMethod(Class<?> main) {
        try {
            Class[] arr = new Class[]{String[].class};
            main.getMethod("execute", arr);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public boolean openURL(URL address) {
        String tag;
        FileConfiguration config = DrJava.getConfig();
        File exe = config.getSetting(OptionConstants.BROWSER_FILE);
        String command = config.getSetting(OptionConstants.BROWSER_STRING);
        if (exe == FileOps.NULL_FILE && command.equals("")) {
            return false;
        }
        String addr = address.toString();
        command = command.equals("") ? addr : (command.indexOf(tag = "<URL>") != -1 ? StringOps.replace(command, tag, addr) : command + " " + addr);
        List<String> args = ArgumentTokenizer.tokenize(command);
        if (exe != FileOps.NULL_FILE) {
            args.add(0, exe.getAbsolutePath());
        }
        try {
            Runtime.getRuntime().exec(args.toArray(new String[args.size()]));
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    @Override
    public void setMnemonic(AbstractButton obj, int mnemonic) {
        obj.setMnemonic(mnemonic);
    }

    @Override
    public void setMnemonic(AbstractButton obj, char mnemonic) {
        obj.setMnemonic(mnemonic);
    }

    @Override
    public void setMnemonic(ButtonModel obj, int mnemonic) {
        obj.setMnemonic(mnemonic);
    }

    @Override
    public void setMnemonicAt(JTabbedPane obj, int tabIndex, int mnemonic) {
        obj.setMnemonicAt(tabIndex, mnemonic);
    }

    @Override
    public boolean canRegisterFileExtensions() {
        return false;
    }

    @Override
    public boolean registerDrJavaFileExtensions() {
        return false;
    }

    @Override
    public boolean unregisterDrJavaFileExtensions() {
        return false;
    }

    @Override
    public boolean areDrJavaFileExtensionsRegistered() {
        return false;
    }

    @Override
    public boolean registerJavaFileExtension() {
        return false;
    }

    @Override
    public boolean unregisterJavaFileExtension() {
        return false;
    }

    @Override
    public boolean isJavaFileExtensionRegistered() {
        return false;
    }
}

