/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.project;

import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.config.OptionParser;
import edu.rice.cs.drjava.model.FileRegion;
import edu.rice.cs.drjava.model.debug.DebugBreakpointData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.project.DocFile;
import edu.rice.cs.drjava.project.DocumentInfoGetter;
import edu.rice.cs.drjava.project.ProjectFileIR;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.AbsRelFile;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.XMLConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.w3c.dom.Node;

public class ProjectProfile
implements ProjectFileIR {
    static final String MOD_DATE_FORMAT_STRING = "dd-MMM-yyyy HH:mm:ss";
    static final DateFormat MOD_DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.US);
    private volatile List<DocFile> _sourceFiles = new LinkedList<DocFile>();
    private volatile List<DocFile> _auxiliaryFiles = new LinkedList<DocFile>();
    private volatile List<DocFile> _excludedFiles = new ArrayList<DocFile>();
    private volatile List<String> _collapsedPaths = new ArrayList<String>();
    private volatile File _buildDir = FileOps.NULL_FILE;
    private volatile File _workDir = FileOps.NULL_FILE;
    private volatile List<AbsRelFile> _classPathFiles = new ArrayList<AbsRelFile>();
    private volatile String _mainClass = null;
    private volatile File _projectRoot;
    private volatile File _projectFile;
    private volatile File _createJarFile = FileOps.NULL_FILE;
    private volatile int _createJarFlags = 0;
    private volatile boolean _autoRefreshStatus = false;
    private volatile HashMap<OptionParser<?>, String> _storedPreferences = new HashMap();
    private volatile List<FileRegion> _bookmarks = new ArrayList<FileRegion>();
    private volatile List<DebugBreakpointData> _breakpoints = new ArrayList<DebugBreakpointData>();
    private volatile List<DebugWatchData> _watches = new ArrayList<DebugWatchData>();
    private volatile String _version = "unknown";
    private volatile String _manifest = null;
    private static volatile Log LOG = new Log("ProjectProfile.txt", false);

    public ProjectProfile(String fileName) throws IOException {
        this(new File(fileName));
    }

    public ProjectProfile(File f) throws IOException {
        this._projectFile = f;
        this._projectRoot = this._projectFile.getParentFile();
        if (!this._projectRoot.exists()) {
            throw new IOException("Parent directory of project root " + this._projectRoot + " does not exist");
        }
    }

    @Override
    public DocFile[] getSourceFiles() {
        return this._sourceFiles.toArray(new DocFile[this._sourceFiles.size()]);
    }

    @Override
    public DocFile[] getAuxiliaryFiles() {
        return this._auxiliaryFiles.toArray(new DocFile[this._auxiliaryFiles.size()]);
    }

    @Override
    public DocFile[] getExcludedFiles() {
        return this._excludedFiles.toArray(new DocFile[this._excludedFiles.size()]);
    }

    @Override
    public File getProjectFile() {
        return this._projectFile;
    }

    @Override
    public File getBuildDirectory() {
        return this._buildDir;
    }

    @Override
    public File getWorkingDirectory() {
        return this._workDir;
    }

    @Override
    public String[] getCollapsedPaths() {
        return this._collapsedPaths.toArray(new String[this._collapsedPaths.size()]);
    }

    @Override
    public Iterable<AbsRelFile> getClassPaths() {
        return this._classPathFiles;
    }

    @Override
    public String getMainClass() {
        return this._mainClass;
    }

    @Override
    public File getMainClassContainingFile() {
        DocFile[] possibleContainers = this.getSourceFiles();
        String main = this.getMainClass();
        if (main.toLowerCase().endsWith(".java")) {
            main = main.substring(0, main.length() - ".java".length());
            main = main.replace(File.separatorChar, '.');
        }
        for (int i = 0; i < possibleContainers.length; ++i) {
            String toMatch = possibleContainers[i].getAbsolutePath();
            toMatch = toMatch.substring(0, toMatch.lastIndexOf(".java"));
            if (!(toMatch = toMatch.replace(File.separatorChar, '.')).endsWith(main)) continue;
            return possibleContainers[i];
        }
        File toRet = new File(main.replace('.', File.separatorChar) + ".java");
        return toRet;
    }

    @Override
    public File getProjectRoot() {
        return this._projectRoot;
    }

    @Override
    public File getCreateJarFile() {
        return this._createJarFile;
    }

    @Override
    public int getCreateJarFlags() {
        return this._createJarFlags;
    }

    @Override
    public FileRegion[] getBookmarks() {
        return this._bookmarks.toArray(new FileRegion[this._bookmarks.size()]);
    }

    @Override
    public DebugBreakpointData[] getBreakpoints() {
        return this._breakpoints.toArray(new DebugBreakpointData[this._breakpoints.size()]);
    }

    @Override
    public DebugWatchData[] getWatches() {
        return this._watches.toArray(new DebugWatchData[this._watches.size()]);
    }

    @Override
    public boolean getAutoRefreshStatus() {
        return this._autoRefreshStatus;
    }

    @Override
    public Map<OptionParser<?>, String> getPreferencesStoredInProject() {
        return new HashMap(this._storedPreferences);
    }

    public void addSourceFile(DocFile df) {
        this._sourceFiles.add(df);
    }

    public void addSourceFile(DocumentInfoGetter getter) {
        if (!getter.isUntitled()) {
            try {
                this.addSourceFile(this.docFileFromGetter(getter));
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    public void addAuxiliaryFile(DocFile df) {
        this._auxiliaryFiles.add(df);
    }

    public void addAuxiliaryFile(DocumentInfoGetter getter) {
        if (!getter.isUntitled()) {
            try {
                this.addAuxiliaryFile(this.docFileFromGetter(getter));
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    public void addExcludedFile(DocFile df) {
        this._excludedFiles.add(df);
    }

    public void addExcludedFile(File f) {
        this._excludedFiles.add(new DocFile(f));
    }

    public void addExcludedFile(DocumentInfoGetter getter) {
        if (!getter.isUntitled()) {
            try {
                this.addExcludedFile(this.docFileFromGetter(getter));
            }
            catch (IOException e) {
                throw new UnexpectedException(e);
            }
        }
    }

    public void addClassPathFile(AbsRelFile cp) {
        if (cp != null) {
            this._classPathFiles.add(cp);
        }
    }

    public void addCollapsedPath(String cp) {
        if (cp != null) {
            this._collapsedPaths.add(cp);
        }
    }

    @Override
    public void setBuildDirectory(File dir) {
        this._buildDir = dir;
    }

    @Override
    public void setWorkingDirectory(File dir) {
        this._workDir = FileOps.validate(dir);
    }

    @Override
    public void setMainClass(String main) {
        this._mainClass = main;
    }

    @Override
    public void setSourceFiles(List<DocFile> sf) {
        this._sourceFiles = new LinkedList<DocFile>(sf);
    }

    @Override
    public void setClassPaths(Iterable<? extends AbsRelFile> cpf) {
        this._classPathFiles = new ArrayList<AbsRelFile>();
        for (AbsRelFile absRelFile : cpf) {
            this._classPathFiles.add(absRelFile);
        }
    }

    @Override
    public void setCollapsedPaths(List<String> cp) {
        this._collapsedPaths = new ArrayList<String>(cp);
    }

    @Override
    public void setAuxiliaryFiles(List<DocFile> af) {
        this._auxiliaryFiles = new LinkedList<DocFile>(af);
    }

    @Override
    public void setExcludedFiles(List<DocFile> ef) {
        this._excludedFiles = new ArrayList<DocFile>(ef);
    }

    @Override
    public void setProjectRoot(File root) {
        this._projectRoot = root;
        assert (root.getParentFile() != null);
    }

    @Override
    public void setCreateJarFile(File createJarFile) {
        this._createJarFile = createJarFile;
    }

    @Override
    public void setCreateJarFlags(int createJarFlags) {
        this._createJarFlags = createJarFlags;
    }

    @Override
    public void setBookmarks(List<? extends FileRegion> bms) {
        this._bookmarks = new ArrayList<FileRegion>(bms);
    }

    @Override
    public void setBreakpoints(List<? extends DebugBreakpointData> bps) {
        this._breakpoints = new ArrayList<DebugBreakpointData>(bps);
    }

    @Override
    public void setWatches(List<? extends DebugWatchData> ws) {
        this._watches = new ArrayList<DebugWatchData>(ws);
    }

    @Override
    public void setAutoRefreshStatus(boolean status) {
        this._autoRefreshStatus = status;
    }

    @Override
    public void setPreferencesStoredInProject(Map<OptionParser<?>, String> sp) {
        this._storedPreferences.clear();
        this._storedPreferences.putAll(sp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write() throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this._projectFile);
            this.write(fos);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public void write(OutputStream os) throws IOException {
        Node n;
        Node f;
        String pkg;
        Node f2;
        String s;
        Pair<Integer, Integer> pScr;
        Pair<Integer, Integer> pSel;
        XMLConfig xc = new XMLConfig();
        xc.set("drjava.version", Version.getVersionString());
        String path = FileOps.stringMakeRelativeTo(this._projectRoot, this._projectFile);
        path = StringOps.replace(path, File.separator, "/");
        xc.set("drjava/project.root", path);
        path = FileOps.stringMakeRelativeTo(this._workDir, this._projectFile);
        path = StringOps.replace(path, File.separator, "/");
        xc.set("drjava/project.work", path);
        if (this._manifest != null) {
            String cleanManifest = TextUtil.xmlEscape(this._manifest);
            xc.set("drjava/project.manifest", cleanManifest);
            LOG.log("dirty manifest: " + this._manifest);
            LOG.log("clean manifest: " + cleanManifest);
        }
        if (this._buildDir != null && this._buildDir.getPath() != "") {
            path = FileOps.stringMakeRelativeTo(this._buildDir, this._projectFile);
            path = StringOps.replace(path, File.separator, "/");
            xc.set("drjava/project.build", path);
        }
        if (this._mainClass != null && this._mainClass != "") {
            xc.set("drjava/project.main", this._mainClass);
        }
        xc.set("drjava/project.autorefresh", String.valueOf(this._autoRefreshStatus));
        if (this._createJarFile != null) {
            path = FileOps.stringMakeRelativeTo(this._createJarFile, this._createJarFile);
            path = StringOps.replace(path, File.separator, "/");
            xc.set("drjava/project/createjar.file", path);
        }
        if (this._createJarFlags != 0) {
            xc.set("drjava/project/createjar.flags", String.valueOf(this._createJarFlags));
        }
        xc.createNode("drjava/project/source");
        DocFile active = null;
        if (!this._sourceFiles.isEmpty()) {
            for (DocFile docFile : this._sourceFiles) {
                if (!docFile.isActive()) continue;
                active = docFile;
                break;
            }
            if (active != null) {
                this._sourceFiles.remove(active);
                this._sourceFiles.add(0, active);
            }
            for (DocFile docFile : this._sourceFiles) {
                path = FileOps.stringMakeRelativeTo(docFile, this._projectRoot);
                path = StringOps.replace(path, File.separator, "/");
                pSel = docFile.getSelection();
                pScr = docFile.getScroll();
                s = MOD_DATE_FORMAT.format(new Date(docFile.lastModified()));
                f2 = xc.createNode("drjava/project/source/file", null, false);
                xc.set(".name", path, f2, true);
                xc.set(".timestamp", s, f2, true);
                pkg = docFile.getPackage();
                xc.set(".package", pkg != null ? pkg : "", f2, true);
                xc.set("select.from", String.valueOf(pSel != null ? pSel.first() : 0), f2, true);
                xc.set("select.to", String.valueOf(pSel != null ? pSel.second() : 0), f2, true);
                xc.set("scroll.column", String.valueOf(pScr != null ? pScr.first() : 0), f2, true);
                xc.set("scroll.row", String.valueOf(pScr != null ? pScr.second() : 0), f2, true);
                if (docFile != active) continue;
                xc.set(".active", "true", f2, true);
            }
        }
        xc.createNode("drjava/project/included");
        if (!this._auxiliaryFiles.isEmpty()) {
            if (active == null) {
                for (DocFile docFile : this._auxiliaryFiles) {
                    if (!docFile.isActive()) continue;
                    active = docFile;
                    break;
                }
                if (active != null) {
                    this._auxiliaryFiles.remove(active);
                    this._auxiliaryFiles.add(0, active);
                }
            }
            for (DocFile docFile : this._auxiliaryFiles) {
                path = docFile.getAbsolutePath();
                path = StringOps.replace(path, File.separator, "/");
                pSel = docFile.getSelection();
                pScr = docFile.getScroll();
                s = MOD_DATE_FORMAT.format(new Date(docFile.lastModified()));
                Node f22 = xc.createNode("drjava/project/included/file", null, false);
                xc.set(".name", path, f22, true);
                xc.set(".timestamp", s, f22, true);
                pkg = docFile.getPackage();
                xc.set(".package", pkg != null ? pkg : "", f22, true);
                xc.set("select.from", String.valueOf(pSel != null ? pSel.first() : 0), f22, true);
                xc.set("select.to", String.valueOf(pSel != null ? pSel.second() : 0), f22, true);
                xc.set("scroll.column", String.valueOf(pScr != null ? pScr.first() : 0), f22, true);
                xc.set("scroll.row", String.valueOf(pScr != null ? pScr.second() : 0), f22, true);
                if (docFile != active) continue;
                xc.set(".active", "true", f22, true);
            }
        }
        xc.createNode("drjava/project/excluded");
        if (!this._excludedFiles.isEmpty()) {
            if (active == null) {
                for (DocFile docFile : this._excludedFiles) {
                    if (!docFile.isActive()) continue;
                    active = docFile;
                    break;
                }
                if (active != null) {
                    this._excludedFiles.remove(active);
                    this._excludedFiles.add(0, active);
                }
            }
            for (DocFile docFile : this._excludedFiles) {
                path = docFile.getAbsolutePath();
                path = StringOps.replace(path, File.separator, "/");
                pSel = docFile.getSelection();
                pScr = docFile.getScroll();
                s = MOD_DATE_FORMAT.format(new Date(docFile.lastModified()));
                f2 = xc.createNode("drjava/project/excluded/file", null, false);
                xc.set(".name", path, f2, true);
                xc.set(".timestamp", s, f2, true);
                pkg = docFile.getPackage();
                xc.set(".package", pkg != null ? pkg : "", f2, true);
                xc.set("select.from", String.valueOf(pSel != null ? pSel.first() : 0), f2, true);
                xc.set("select.to", String.valueOf(pSel != null ? pSel.second() : 0), f2, true);
                xc.set("scroll.column", String.valueOf(pScr != null ? pScr.first() : 0), f2, true);
                xc.set("scroll.row", String.valueOf(pScr != null ? pScr.second() : 0), f2, true);
                if (docFile != active) continue;
                xc.set(".active", "true", f2, true);
            }
        }
        xc.createNode("drjava/project/collapsed");
        if (!this._collapsedPaths.isEmpty()) {
            for (String string : this._collapsedPaths) {
                f = xc.createNode("drjava/project/collapsed/path", null, false);
                xc.set(".name", string, f, true);
            }
        }
        xc.createNode("drjava/project/classpath");
        if (!this._classPathFiles.isEmpty()) {
            for (AbsRelFile absRelFile : this._classPathFiles) {
                path = absRelFile.keepAbsolute() ? absRelFile.getAbsolutePath() : FileOps.stringMakeRelativeTo(absRelFile, this._projectRoot);
                path = StringOps.replace(path, File.separator, "/");
                f = xc.createNode("drjava/project/classpath/file", null, false);
                xc.set(".name", path, f, true);
                xc.set(".absolute", String.valueOf(absRelFile.keepAbsolute()), f, true);
            }
        }
        xc.createNode("drjava/project/breakpoints");
        if (!this._breakpoints.isEmpty()) {
            for (DebugBreakpointData debugBreakpointData : this._breakpoints) {
                f = xc.createNode("drjava/project/breakpoints/breakpoint", null, false);
                path = FileOps.stringMakeRelativeTo(debugBreakpointData.getFile(), this._projectRoot);
                path = StringOps.replace(path, File.separator, "/");
                xc.set(".file", path, f, true);
                xc.set(".line", String.valueOf(debugBreakpointData.getLineNumber()), f, true);
                xc.set(".enabled", String.valueOf(debugBreakpointData.isEnabled()), f, true);
            }
        }
        xc.createNode("drjava/project/watches");
        if (!this._watches.isEmpty()) {
            for (DebugWatchData debugWatchData : this._watches) {
                f = xc.createNode("drjava/project/watches/watch", null, false);
                xc.set(".name", debugWatchData.getName(), f, true);
            }
        }
        xc.createNode("drjava/project/bookmarks");
        if (!this._bookmarks.isEmpty()) {
            for (FileRegion fileRegion : this._bookmarks) {
                n = xc.createNode("drjava/project/bookmarks/bookmark", null, false);
                File file = fileRegion.getFile();
                path = FileOps.stringMakeRelativeTo(file, this._projectRoot);
                path = StringOps.replace(path, File.separator, "/");
                xc.set(".file", path, n, true);
                xc.set(".from", String.valueOf(fileRegion.getStartOffset()), n, true);
                xc.set(".to", String.valueOf(fileRegion.getEndOffset()), n, true);
            }
        }
        xc.createNode("drjava/project/preferences");
        if (!this._storedPreferences.isEmpty()) {
            for (Map.Entry entry : this._storedPreferences.entrySet()) {
                n = xc.createNode("drjava/project/preferences/preference", null, false);
                xc.set(".name", TextUtil.xmlEscape(((OptionParser)entry.getKey()).getName()), n, true);
                xc.set(".value", TextUtil.xmlEscape((String)entry.getValue()), n, true);
            }
        }
        xc.save(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeOld() throws IOException {
        FileWriter fw = null;
        try {
            fw = new FileWriter(this._projectFile);
            this.writeOld(fw);
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }

    public String toString() {
        try {
            StringWriter w = new StringWriter();
            this.writeOld(w);
            return w.toString();
        }
        catch (IOException e) {
            return e.toString();
        }
    }

    public void writeOld(Writer fw) throws IOException {
        assert (this._projectRoot != null);
        fw.write(";; DrJava project file, written by build " + Version.getVersionString());
        fw.write("\n;; files in the source tree are relative to: " + this._projectRoot.getCanonicalPath());
        fw.write("\n;; other files with relative paths are rooted at (the parent of) this project file");
        fw.write("\n(proj-root-and-base");
        fw.write("\n" + this.encodeFileRelative(this._projectRoot, "  ", this._projectFile));
        fw.write(")");
        if (this._manifest != null) {
            fw.write("\n(proj-manifest");
            fw.write("\n" + this._manifest);
            fw.write(")");
        }
        if (!this._sourceFiles.isEmpty()) {
            fw.write("\n(source-files");
            DocFile active = null;
            for (DocFile df : this._sourceFiles) {
                if (!df.isActive()) continue;
                active = df;
                fw.write("\n" + this.encodeDocFileRelative(df, "  "));
                break;
            }
            for (DocFile df : this._sourceFiles) {
                if (df == active) continue;
                fw.write("\n" + this.encodeDocFileRelative(df, "  "));
            }
            fw.write(")");
        } else {
            fw.write("\n;; no source files");
        }
        if (!this._auxiliaryFiles.isEmpty()) {
            fw.write("\n(auxiliary");
            for (DocFile df : this._auxiliaryFiles) {
                fw.write("\n" + this.encodeDocFileAbsolute(df, "  "));
            }
            fw.write(")");
        } else {
            fw.write("\n;; no aux files");
        }
        if (!this._collapsedPaths.isEmpty()) {
            fw.write("\n(collapsed");
            for (String s : this._collapsedPaths) {
                fw.write("\n  (path " + StringOps.convertToLiteral(s) + ")");
            }
            fw.write(")");
        } else {
            fw.write("\n;; no collapsed branches");
        }
        if (!this._classPathFiles.isEmpty()) {
            fw.write("\n(classpaths");
            for (AbsRelFile f : this._classPathFiles) {
                fw.write("\n" + this.encodeFileAbsolute(f, "  "));
            }
            fw.write(")");
        } else {
            fw.write("\n;; no classpaths files");
        }
        if (this._buildDir != null && this._buildDir.getPath() != "") {
            fw.write("\n(build-dir");
            fw.write("\n" + this.encodeFileRelative(this._buildDir, "  ", this._projectFile));
            fw.write(")");
        } else {
            fw.write("\n;; no build directory");
        }
        if (this._workDir.getPath() != "") {
            fw.write("\n(work-dir");
            fw.write("\n" + this.encodeFileRelative(this._workDir, "  ", this._projectFile));
            fw.write(")");
        } else {
            fw.write("\n;; no working directory");
        }
        if (this._mainClass != null) {
            fw.write("\n;; rooted at the (parent of the) project file");
            fw.write("\n(main-class");
            fw.write("\n " + this.getMainClass());
            fw.write(")");
        } else {
            fw.write("\n;; no main class");
        }
        if (this._createJarFile != null) {
            fw.write("\n(create-jar-file");
            fw.write("\n" + this.encodeFileRelative(this._createJarFile, "  ", this._projectFile));
            fw.write(")");
        } else {
            fw.write("\n;; no create jar file");
        }
        if (this._createJarFlags != 0) {
            fw.write("\n(create-jar-flags " + this._createJarFlags + ")");
        } else {
            fw.write("\n;; no create jar flags");
        }
        if (!this._breakpoints.isEmpty()) {
            fw.write("\n(breakpoints");
            for (DebugBreakpointData bp : this._breakpoints) {
                fw.write("\n" + this.encodeBreakpointRelative(bp, "  "));
            }
            fw.write(")");
        } else {
            fw.write("\n;; no breakpoints");
        }
        if (!this._watches.isEmpty()) {
            fw.write("\n(watches");
            for (DebugWatchData w : this._watches) {
                fw.write("\n" + this.encodeWatch(w, "  "));
            }
            fw.write(")");
        } else {
            fw.write("\n;; no watches");
        }
        if (!this._bookmarks.isEmpty()) {
            fw.write("\n(bookmarks");
            for (FileRegion bm : this._bookmarks) {
                fw.write("\n" + this.encodeBookmarkRelative(bm, "  "));
            }
            fw.write(")");
        } else {
            fw.write("\n;; no bookmarks");
        }
        fw.close();
    }

    private DocFile docFileFromGetter(DocumentInfoGetter g) throws IOException {
        return new DocFile(g.getFile().getCanonicalPath(), g.getSelection(), g.getScroll(), g.isActive(), g.getPackage());
    }

    private String encodeFileRelative(File f, String prefix, File base) throws IOException {
        String path = FileOps.stringMakeRelativeTo(f, base);
        path = StringOps.replace(path, File.separator, "/");
        return prefix + "(file (name " + StringOps.convertToLiteral(path) + "))";
    }

    private String encodeFileAbsolute(File f, String prefix) throws IOException {
        String path = f.getCanonicalPath();
        path = StringOps.replace(path, File.separator, "/");
        return prefix + "(file (name " + StringOps.convertToLiteral(path) + "))";
    }

    private String encodeDocFile(DocFile df, String prefix, boolean relative) throws IOException {
        String pack;
        String ret = "";
        String path = relative ? FileOps.stringMakeRelativeTo(df, this._projectRoot) : IOUtil.attemptCanonicalFile(df).getPath();
        path = StringOps.replace(path, File.separator, "/");
        ret = ret + prefix + "(file (name " + StringOps.convertToLiteral(path) + ")";
        Pair<Integer, Integer> p1 = df.getSelection();
        Pair<Integer, Integer> p2 = df.getScroll();
        long modDate = df.lastModified();
        if (p1 != null || p2 != null) {
            ret = ret + "\n" + prefix + "      ";
        }
        if (p1 != null) {
            ret = ret + "(select " + p1.first() + " " + p1.second() + ")";
        }
        if (p2 != null) {
            ret = ret + "(scroll " + p2.first() + " " + p2.second() + ")";
        }
        if (modDate > 0L) {
            String s = MOD_DATE_FORMAT.format(new Date(modDate));
            ret = ret + "(mod-date " + StringOps.convertToLiteral(s) + ")";
        }
        if ((pack = df.getPackage()) != null) {
            ret = ret + "\n" + prefix + "      ";
            ret = ret + "(package " + StringOps.convertToLiteral(pack) + ")";
        }
        ret = ret + ")";
        return ret;
    }

    private String encodeDocFileRelative(DocFile df, String prefix) throws IOException {
        return this.encodeDocFile(df, prefix, true);
    }

    private String encodeDocFileAbsolute(DocFile df, String prefix) throws IOException {
        return this.encodeDocFile(df, prefix, false);
    }

    private String encodeBreakpointRelative(DebugBreakpointData bp, String prefix) throws IOException {
        String ret = "";
        String path = FileOps.stringMakeRelativeTo(bp.getFile(), this._projectRoot);
        path = StringOps.replace(path, File.separator, "/");
        ret = ret + prefix + "(breakpoint (name " + StringOps.convertToLiteral(path) + ")";
        int lineNumber = bp.getLineNumber();
        ret = ret + "\n" + prefix + "      ";
        ret = ret + "(line " + lineNumber + ")";
        if (bp.isEnabled()) {
            ret = ret + "(enabled)";
        }
        ret = ret + ")";
        return ret;
    }

    private String encodeWatch(DebugWatchData w, String prefix) throws IOException {
        String ret = "";
        ret = ret + prefix + "(watch " + StringOps.convertToLiteral(w.getName()) + ")";
        return ret;
    }

    private String encodeBookmarkRelative(FileRegion bm, String prefix) throws IOException {
        String ret = "";
        String path = FileOps.stringMakeRelativeTo(bm.getFile(), this._projectRoot);
        path = StringOps.replace(path, File.separator, "/");
        ret = ret + prefix + "(bookmark (name " + StringOps.convertToLiteral(path) + ")";
        int startOffset = bm.getStartOffset();
        int endOffset = bm.getEndOffset();
        ret = ret + "\n" + prefix + "      ";
        ret = ret + "(start " + startOffset + ")";
        ret = ret + "(end " + endOffset + ")";
        ret = ret + ")";
        return ret;
    }

    @Override
    public String getDrJavaVersion() {
        return this._version;
    }

    @Override
    public void setDrJavaVersion(String version) {
        this._version = version;
    }

    @Override
    public String getCustomManifest() {
        return this._manifest;
    }

    @Override
    public void setCustomManifest(String manifest) {
        this._manifest = manifest;
    }
}

