/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.drjava.ui.RegionsTreePanel;
import edu.rice.cs.plt.lambda.Lambda;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.text.BadLocationException;
import javax.swing.tree.DefaultMutableTreeNode;

public class BreakpointsPanel
extends RegionsTreePanel<Breakpoint> {
    protected JButton _goToButton;
    protected JButton _enableDisableButton;
    protected JButton _removeButton;
    protected JButton _removeAllButton;
    protected final Debugger _debugger;

    public BreakpointsPanel(MainFrame frame, RegionManager<Breakpoint> breakpointManager) {
        super(frame, "Breakpoints", breakpointManager);
        this.getRegionManager().addListener(new RegionManagerListener<Breakpoint>(){

            @Override
            public void regionAdded(Breakpoint bp) {
                assert (EventQueue.isDispatchThread());
                BreakpointsPanel.this.addRegion(bp);
            }

            @Override
            public void regionChanged(Breakpoint bp) {
                assert (EventQueue.isDispatchThread());
                DefaultMutableTreeNode regNode = (DefaultMutableTreeNode)BreakpointsPanel.this._regionToTreeNode.get(bp);
                BreakpointsPanel.this.getRegTreeModel().nodeChanged(regNode);
            }

            @Override
            public void regionRemoved(Breakpoint bp) {
                BreakpointsPanel.this.removeRegion(bp);
            }
        });
        this._debugger = this.getGlobalModel().getDebugger();
    }

    @Override
    protected void performDefaultAction() {
        this.goToRegion();
    }

    @Override
    protected JComponent[] makeButtons() {
        AbstractAction goToAction = new AbstractAction("Go to"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BreakpointsPanel.this.goToRegion();
            }
        };
        this._goToButton = new JButton(goToAction);
        AbstractAction enableDisableAction = new AbstractAction("Disable"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BreakpointsPanel.this.enableDisableBreakpoint();
            }
        };
        this._enableDisableButton = new JButton(enableDisableAction);
        AbstractAction removeAction = new AbstractAction("Remove"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                for (Breakpoint bp : BreakpointsPanel.this.getSelectedRegions()) {
                    BreakpointsPanel.this.getRegionManager().removeRegion(bp);
                }
            }
        };
        this._removeButton = new JButton(removeAction);
        AbstractAction removeAllAction = new AbstractAction("Remove All"){

            @Override
            public void actionPerformed(ActionEvent ae) {
                BreakpointsPanel.this.getRegionManager().clearRegions();
            }
        };
        this._removeAllButton = new JButton(removeAllAction);
        JComponent[] buts = new JComponent[]{this._enableDisableButton, this._goToButton, this._removeButton, this._removeAllButton};
        return buts;
    }

    @Override
    protected void _updateButtons() {
        ArrayList regs = this.getSelectedRegions();
        this._goToButton.setEnabled(regs.size() == 1);
        this._removeButton.setEnabled(regs.size() > 0);
        this._removeAllButton.setEnabled(this.getRootNode() != null && this.getRootNode().getDepth() > 0);
        this._enableDisableButton.setEnabled(regs.size() > 0);
        if (regs.size() > 0) {
            if (((Breakpoint)regs.get(0)).isEnabled()) {
                this._enableDisableButton.setText("Disable");
            } else {
                this._enableDisableButton.setText("Enable");
            }
        }
        this._removeAllButton.setEnabled(this.getRootNode() != null && this.getRootNode().getDepth() > 0);
    }

    @Override
    protected void closeIfEmpty() {
    }

    @Override
    protected AbstractAction[] makePopupMenuActions() {
        AbstractAction[] acts = new AbstractAction[]{new AbstractAction("Go to"){

            @Override
            public void actionPerformed(ActionEvent e) {
                BreakpointsPanel.this.goToRegion();
            }
        }, new AbstractAction("Remove"){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (Breakpoint bp : BreakpointsPanel.this.getSelectedRegions()) {
                    BreakpointsPanel.this.getRegionManager().removeRegion(bp);
                }
            }
        }};
        return acts;
    }

    @Override
    protected void goToRegion() {
        ArrayList bps = this.getSelectedRegions();
        if (bps.size() == 1) {
            this._debugger.scrollToSource((Breakpoint)bps.get(0));
        }
    }

    protected void enableDisableBreakpoint() {
        ArrayList bps = this.getSelectedRegions();
        if (bps.size() > 0) {
            final boolean newState = !((Breakpoint)bps.get(0)).isEnabled();
            for (Breakpoint bp : bps) {
                this.getRegionManager().changeRegion(bp, new Lambda<Breakpoint, Object>(){

                    @Override
                    public Object value(Breakpoint bp) {
                        bp.setEnabled(newState);
                        return null;
                    }
                });
            }
        }
    }

    @Override
    protected RegionsTreePanel.RegionTreeUserObj<Breakpoint> makeRegionTreeUserObj(Breakpoint bp) {
        return new BreakpointRegionTreeUserObj(bp);
    }

    protected static class BreakpointRegionTreeUserObj
    extends RegionsTreePanel.RegionTreeUserObj<Breakpoint> {
        public BreakpointRegionTreeUserObj(Breakpoint bp) {
            super(bp);
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.lineNumber());
            try {
                if (!((Breakpoint)this._region).isEnabled()) {
                    sb.append(" (disabled)");
                }
                sb.append(": ");
                int length = Math.min(120, ((Breakpoint)this._region).getEndOffset() - ((Breakpoint)this._region).getStartOffset());
                sb.append(((Breakpoint)this._region).getDocument().getText(((Breakpoint)this._region).getStartOffset(), length).trim());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return sb.toString();
        }
    }
}

