/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.ui.HTMLFrame;
import edu.rice.cs.util.UnexpectedException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

public class JavadocFrame
extends HTMLFrame {
    private static final int MAX_READ_PACKAGES_LINES = 100;
    private static final int MAX_READ_FOR_LINK_LINES = 100;
    private static final String[] INTRO_PAGE = new String[]{"overview-summary.html", "packages.html"};
    private static final String INDEX_PAGE = "allclasses-frame.html";

    private static String introPagePath(File destDir, String curClass) {
        File test = new File(destDir, curClass + ".html");
        for (int i = 0; !test.exists() && i < INTRO_PAGE.length; ++i) {
            test = new File(destDir, INTRO_PAGE[i]);
        }
        if (test.exists()) {
            if (test.getName().equals("packages.html")) {
                test = JavadocFrame._parsePackagesFile(test, destDir);
            }
        } else {
            throw new IllegalStateException("No Javadoc HTML output files found!");
        }
        return test.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File _parsePackagesFile(File packages, File destDir) {
        try {
            FileReader fr = new FileReader(packages);
            BufferedReader br = new BufferedReader(fr);
            try {
                String line = br.readLine();
                int numLinesRead = 1;
                boolean found = false;
                while (!found && numLinesRead < 100 && line != null) {
                    found = line.indexOf("The front page has been relocated") != -1;
                    if (found) continue;
                    line = br.readLine();
                    ++numLinesRead;
                }
                if (!found) return packages;
                boolean foundLink = false;
                while (!foundLink && numLinesRead < 100 && line != null) {
                    foundLink = line.indexOf("Non-frame version") != -1;
                    if (foundLink) continue;
                    line = br.readLine();
                    ++numLinesRead;
                }
                if (!foundLink) return packages;
                String start = "HREF=\"";
                int startIndex = line.indexOf(start) + start.length();
                int endIndex = line.indexOf("\">");
                if (startIndex == -1) return packages;
                if (endIndex == -1) return packages;
                String fileName = line.substring(startIndex, endIndex);
                File file = new File(destDir, fileName);
                return file;
            }
            finally {
                br.close();
            }
        }
        catch (IOException ioe) {
            throw new UnexpectedException(ioe);
        }
    }

    public JavadocFrame(File destDir, String curClass, boolean allDocs) throws MalformedURLException {
        super("Javadoc Viewer", new URL("file", "", JavadocFrame.introPagePath(destDir, curClass)), new URL("file", "", new File(destDir, INDEX_PAGE).getAbsolutePath()), "DrJavadoc.png", destDir);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent event) {
                if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    URL url = event.getURL();
                    JavadocFrame.this.jumpTo(url);
                }
            }
        });
        if (!allDocs) {
            this._hideNavigationPane();
        }
    }
}

