/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import com.jgoodies.looks.HeaderStyle;
import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.DrJavaRoot;
import edu.rice.cs.drjava.RemoteControlClient;
import edu.rice.cs.drjava.RemoteControlServer;
import edu.rice.cs.drjava.config.BooleanOption;
import edu.rice.cs.drjava.config.ConfigOptionListeners;
import edu.rice.cs.drjava.config.DrJavaActionProperty;
import edu.rice.cs.drjava.config.DrJavaProperty;
import edu.rice.cs.drjava.config.DrJavaPropertySetup;
import edu.rice.cs.drjava.config.FileConfiguration;
import edu.rice.cs.drjava.config.FileListProperty;
import edu.rice.cs.drjava.config.FileProperty;
import edu.rice.cs.drjava.config.MutableFileProperty;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionEvent;
import edu.rice.cs.drjava.config.OptionListener;
import edu.rice.cs.drjava.config.PropertyMaps;
import edu.rice.cs.drjava.config.RecursiveFileListProperty;
import edu.rice.cs.drjava.config.VectorOption;
import edu.rice.cs.drjava.model.AbstractGlobalModel;
import edu.rice.cs.drjava.model.AlreadyOpenException;
import edu.rice.cs.drjava.model.BrowserDocumentRegion;
import edu.rice.cs.drjava.model.BrowserHistoryManager;
import edu.rice.cs.drjava.model.ClipboardHistoryModel;
import edu.rice.cs.drjava.model.DefaultGlobalModel;
import edu.rice.cs.drjava.model.DocumentRegion;
import edu.rice.cs.drjava.model.DrJavaFileUtils;
import edu.rice.cs.drjava.model.DummyOpenDefDoc;
import edu.rice.cs.drjava.model.FileMovedException;
import edu.rice.cs.drjava.model.FileSaveSelector;
import edu.rice.cs.drjava.model.GlobalModelListener;
import edu.rice.cs.drjava.model.IDocumentRegion;
import edu.rice.cs.drjava.model.MovingDocumentRegion;
import edu.rice.cs.drjava.model.OpenDefinitionsDocument;
import edu.rice.cs.drjava.model.OrderedDocumentRegion;
import edu.rice.cs.drjava.model.RegionManager;
import edu.rice.cs.drjava.model.RegionManagerListener;
import edu.rice.cs.drjava.model.SingleDisplayModel;
import edu.rice.cs.drjava.model.compiler.CompilerListener;
import edu.rice.cs.drjava.model.compiler.CompilerModel;
import edu.rice.cs.drjava.model.debug.Breakpoint;
import edu.rice.cs.drjava.model.debug.DebugException;
import edu.rice.cs.drjava.model.debug.DebugListener;
import edu.rice.cs.drjava.model.debug.DebugThreadData;
import edu.rice.cs.drjava.model.debug.DebugWatchData;
import edu.rice.cs.drjava.model.debug.Debugger;
import edu.rice.cs.drjava.model.definitions.ClassNameNotFoundException;
import edu.rice.cs.drjava.model.definitions.DefinitionsDocument;
import edu.rice.cs.drjava.model.definitions.DocumentUIListener;
import edu.rice.cs.drjava.model.definitions.InvalidPackageException;
import edu.rice.cs.drjava.model.definitions.NoSuchDocumentException;
import edu.rice.cs.drjava.model.javadoc.JavadocModel;
import edu.rice.cs.drjava.model.repl.DefaultInteractionsModel;
import edu.rice.cs.drjava.model.repl.InteractionsScriptModel;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.project.DocumentInfoGetter;
import edu.rice.cs.drjava.project.MalformedProjectFileException;
import edu.rice.cs.drjava.ui.AboutDialog;
import edu.rice.cs.drjava.ui.AutoCompletePopup;
import edu.rice.cs.drjava.ui.BackgroundColorListener;
import edu.rice.cs.drjava.ui.BookmarksPanel;
import edu.rice.cs.drjava.ui.BreakpointsPanel;
import edu.rice.cs.drjava.ui.ClipboardHistoryFrame;
import edu.rice.cs.drjava.ui.CompilerErrorPanel;
import edu.rice.cs.drjava.ui.ConsoleController;
import edu.rice.cs.drjava.ui.DebugPanel;
import edu.rice.cs.drjava.ui.DefinitionsPane;
import edu.rice.cs.drjava.ui.DetachedFrame;
import edu.rice.cs.drjava.ui.DrJavaErrorHandler;
import edu.rice.cs.drjava.ui.DrJavaErrorWindow;
import edu.rice.cs.drjava.ui.DrJavaScrollableDialog;
import edu.rice.cs.drjava.ui.EditExternalDialog;
import edu.rice.cs.drjava.ui.ErrorCaretListener;
import edu.rice.cs.drjava.ui.ExecuteExternalDialog;
import edu.rice.cs.drjava.ui.FindReplacePanel;
import edu.rice.cs.drjava.ui.FindResultsPanel;
import edu.rice.cs.drjava.ui.ForegroundColorListener;
import edu.rice.cs.drjava.ui.GenerateCustomDrJavaJarFrame;
import edu.rice.cs.drjava.ui.HelpFrame;
import edu.rice.cs.drjava.ui.HistorySaveDialog;
import edu.rice.cs.drjava.ui.InteractionsController;
import edu.rice.cs.drjava.ui.InteractionsHistoryFilter;
import edu.rice.cs.drjava.ui.InteractionsPane;
import edu.rice.cs.drjava.ui.InteractionsScriptController;
import edu.rice.cs.drjava.ui.InteractionsScriptPane;
import edu.rice.cs.drjava.ui.JUnitPanel;
import edu.rice.cs.drjava.ui.JarOptionsDialog;
import edu.rice.cs.drjava.ui.JavadocDialog;
import edu.rice.cs.drjava.ui.JavadocErrorPanel;
import edu.rice.cs.drjava.ui.JavadocFrame;
import edu.rice.cs.drjava.ui.KeyBindingManager;
import edu.rice.cs.drjava.ui.LessPanel;
import edu.rice.cs.drjava.ui.LineEnumRule;
import edu.rice.cs.drjava.ui.MainFrameStatics;
import edu.rice.cs.drjava.ui.NewJavaClassDialog;
import edu.rice.cs.drjava.ui.NewVersionPopup;
import edu.rice.cs.drjava.ui.PreviewConsoleFrame;
import edu.rice.cs.drjava.ui.PreviewDefDocFrame;
import edu.rice.cs.drjava.ui.ProjectPropertiesFrame;
import edu.rice.cs.drjava.ui.QuickStartFrame;
import edu.rice.cs.drjava.ui.RecentDocFrame;
import edu.rice.cs.drjava.ui.RecentFileManager;
import edu.rice.cs.drjava.ui.RegionsTreePanel;
import edu.rice.cs.drjava.ui.SmartSourceFilter;
import edu.rice.cs.drjava.ui.TabbedPanel;
import edu.rice.cs.drjava.ui.avail.AndGUIAvailabilityActionAdapter;
import edu.rice.cs.drjava.ui.avail.AndGUIAvailabilityComponentAdapter;
import edu.rice.cs.drjava.ui.avail.AndGUIAvailabilityListener;
import edu.rice.cs.drjava.ui.avail.DefaultGUIAvailabilityNotifier;
import edu.rice.cs.drjava.ui.avail.GUIAvailabilityListener;
import edu.rice.cs.drjava.ui.config.ConfigFrame;
import edu.rice.cs.drjava.ui.predictive.PredictiveInputFrame;
import edu.rice.cs.drjava.ui.predictive.PredictiveInputModel;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.iter.IterUtil;
import edu.rice.cs.plt.lambda.DelayedThunk;
import edu.rice.cs.plt.lambda.Predicate;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.Runnable3;
import edu.rice.cs.plt.lambda.Thunk;
import edu.rice.cs.plt.reflect.JavaVersion;
import edu.rice.cs.plt.tuple.Pair;
import edu.rice.cs.util.FileOpenSelector;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.OperationCanceledException;
import edu.rice.cs.util.StringOps;
import edu.rice.cs.util.UnexpectedException;
import edu.rice.cs.util.XMLConfig;
import edu.rice.cs.util.classloader.ClassFileError;
import edu.rice.cs.util.docnavigation.GroupNotSelectedException;
import edu.rice.cs.util.docnavigation.INavigatorItem;
import edu.rice.cs.util.docnavigation.JTreeSortNavigator;
import edu.rice.cs.util.swing.AsyncTask;
import edu.rice.cs.util.swing.AsyncTaskLauncher;
import edu.rice.cs.util.swing.BorderlessScrollPane;
import edu.rice.cs.util.swing.BorderlessSplitPane;
import edu.rice.cs.util.swing.CenteredIcon;
import edu.rice.cs.util.swing.ConfirmCheckBoxDialog;
import edu.rice.cs.util.swing.DefaultFileDisplayManager;
import edu.rice.cs.util.swing.DelegatingAction;
import edu.rice.cs.util.swing.DirectoryChooser;
import edu.rice.cs.util.swing.DisplayManager;
import edu.rice.cs.util.swing.FileDisplayManager;
import edu.rice.cs.util.swing.HighlightManager;
import edu.rice.cs.util.swing.IAsyncProgress;
import edu.rice.cs.util.swing.LayeredIcon;
import edu.rice.cs.util.swing.ProcessingDialog;
import edu.rice.cs.util.swing.RightClickMouseAdapter;
import edu.rice.cs.util.swing.ScrollableListDialog;
import edu.rice.cs.util.swing.SwingFrame;
import edu.rice.cs.util.swing.UnfocusableButton;
import edu.rice.cs.util.swing.Utilities;
import edu.rice.cs.util.text.ConsoleDocument;
import edu.rice.cs.util.text.SwingDocument;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ProgressMonitor;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Element;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.tree.DefaultTreeModel;

public class MainFrame
extends SwingFrame
implements ClipboardOwner,
DropTargetListener {
    private static final Log _log = new Log("MainFrame.txt", false);
    private static final int INTERACTIONS_TAB = 0;
    private static final int CONSOLE_TAB = 1;
    private static final String ICON_PATH = "/edu/rice/cs/drjava/ui/icons/";
    private static final String DEBUGGER_OUT_OF_SYNC = " Current document is out of sync with the debugger and should be recompiled!";
    private static final int DEBUG_STEP_TIMER_VALUE = 3000;
    private volatile AbstractGlobalModel _model;
    private volatile ModelListener _mainListener;
    private HashMap<OpenDefinitionsDocument, JScrollPane> _defScrollPanes;
    private volatile DefinitionsPane _currentDefPane;
    private volatile DefinitionsDocument _currentDefDoc;
    private volatile String _fileTitle = "";
    public final LinkedList<TabbedPanel> _tabs = new LinkedList();
    public final JTabbedPane _tabbedPane = new JTabbedPane();
    private final LinkedList<Pair<FindResultsPanel, Map<MovingDocumentRegion, HighlightManager.HighlightInfo>>> _findResults = new LinkedList();
    private volatile DetachedFrame _tabbedPanesFrame;
    public volatile Component _lastFocusOwner;
    private volatile CompilerErrorPanel _compilerErrorPanel;
    private volatile JUnitPanel _junitPanel;
    private volatile JavadocErrorPanel _javadocErrorPanel;
    private volatile FindReplacePanel _findReplace;
    private volatile BreakpointsPanel _breakpointsPanel;
    private volatile BookmarksPanel _bookmarksPanel;
    private volatile DebugPanel _debugPanel;
    private volatile InteractionsPane _consolePane;
    private volatile JScrollPane _consoleScroll;
    private volatile ConsoleController _consoleController;
    private volatile InteractionsPane _interactionsPane;
    private volatile JPanel _interactionsContainer;
    private volatile InteractionsController _interactionsController;
    private volatile InteractionsScriptController _interactionsScriptController;
    private volatile InteractionsScriptPane _interactionsScriptPane;
    private volatile boolean _showDebugger;
    private volatile DetachedFrame _debugFrame;
    private final JPanel _statusBar = new JPanel(new BorderLayout());
    private final JLabel _statusField = new JLabel();
    private final JLabel _statusReport = new JLabel();
    private final JLabel _currLocationField = new JLabel();
    private final PositionListener _posListener = new PositionListener();
    private volatile JSplitPane _docSplitPane;
    private volatile JSplitPane _debugSplitPane;
    JSplitPane _mainSplit;
    private volatile JButton _compileButton;
    private volatile JButton _closeButton;
    private volatile JButton _undoButton;
    private volatile JButton _redoButton;
    private volatile JButton _runButton;
    private volatile JButton _junitButton;
    private volatile JButton _errorsButton;
    private final JToolBar _toolBar = new JToolBar();
    private final JFileChooser _interactionsHistoryChooser = new JFileChooser();
    private final JMenuBar _menuBar = new MenuBar(this);
    private volatile JMenu _fileMenu;
    private volatile JMenu _editMenu;
    private volatile JMenu _toolsMenu;
    private volatile JMenu _projectMenu;
    private volatile JMenu _languageLevelMenu;
    private volatile JMenu _helpMenu;
    private volatile JMenu _debugMenu;
    private volatile JMenuItem _debuggerEnabledMenuItem;
    private JPopupMenu _interactionsPanePopupMenu;
    private JPopupMenu _consolePanePopupMenu;
    private volatile ConfigFrame _configFrame;
    private final HelpFrame _helpFrame = new HelpFrame();
    private final QuickStartFrame _quickStartFrame = new QuickStartFrame();
    private volatile AboutDialog _aboutDialog;
    private volatile RecentDocFrame _recentDocFrame;
    private volatile RecentFileManager _recentFileManager;
    private volatile RecentFileManager _recentProjectManager;
    private volatile File _currentProjFile;
    private volatile Timer _debugStepTimer;
    private volatile Timer _automaticTraceTimer;
    private volatile HighlightManager.HighlightInfo _currentLocationHighlight = null;
    private final IdentityHashMap<Breakpoint, HighlightManager.HighlightInfo> _documentBreakpointHighlights = new IdentityHashMap();
    private final IdentityHashMap<OrderedDocumentRegion, HighlightManager.HighlightInfo> _documentBookmarkHighlights = new IdentityHashMap();
    private volatile long _lastChangeTime = 0L;
    private volatile boolean _promptBeforeQuit;
    private volatile ConfigOptionListeners.SlaveJVMXMXListener _slaveJvmXmxListener;
    private volatile ConfigOptionListeners.MasterJVMXMXListener _masterJvmXmxListener;
    final DefaultGUIAvailabilityNotifier _guiAvailabilityNotifier = new DefaultGUIAvailabilityNotifier();
    protected volatile HashMap<Window, WindowAdapter> _modalWindowAdapters = new HashMap();
    protected volatile Window _modalWindowAdapterOwner = null;
    private volatile JFileChooser _openChooser;
    private volatile JFileChooser _openProjectChooser;
    private volatile JFileChooser _saveChooser;
    private final FileFilter _projectFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getPath().endsWith(".drjava") || f.getPath().endsWith(".xml") || f.getPath().endsWith(".pjt");
        }

        @Override
        public String getDescription() {
            return "DrJava Project Files (*.drjava, *.xml, *.pjt)";
        }
    };
    private final FileFilter _txtFileFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return f.isDirectory() || f.getPath().endsWith(".txt");
        }

        @Override
        public String getDescription() {
            return "Text Files (*.txt)";
        }
    };
    private final FileFilter _anyFileFilter = new FileFilter(){

        @Override
        public boolean accept(File f) {
            return true;
        }

        @Override
        public String getDescription() {
            return "All files (*.*)";
        }
    };
    private volatile ExecutorService _threadPool = Executors.newCachedThreadPool();
    private final FileOpenSelector _openSelector = new FileOpenSelector(){

        @Override
        public File[] getFiles() throws OperationCanceledException {
            MainFrame.this._openChooser.resetChoosableFileFilters();
            MainFrame.this._openChooser.setFileFilter(MainFrame.this.getSourceFileFilter());
            return MainFrame.this.getOpenFiles(MainFrame.this._openChooser);
        }
    };
    private final FileOpenSelector _openFileOrProjectSelector = new FileOpenSelector(){

        @Override
        public File[] getFiles() throws OperationCanceledException {
            MainFrame.this._openChooser.resetChoosableFileFilters();
            MainFrame.this._openChooser.addChoosableFileFilter(MainFrame.this._projectFilter);
            MainFrame.this._openChooser.setFileFilter(MainFrame.this.getSourceFileFilter());
            return MainFrame.this.getOpenFiles(MainFrame.this._openChooser);
        }
    };
    private final FileOpenSelector _openProjectSelector = new FileOpenSelector(){

        @Override
        public File[] getFiles() throws OperationCanceledException {
            return MainFrame.this.getOpenFiles(MainFrame.this._openProjectChooser);
        }
    };
    private final FileOpenSelector _openAnyFileSelector = new FileOpenSelector(){

        @Override
        public File[] getFiles() throws OperationCanceledException {
            MainFrame.this._openChooser.resetChoosableFileFilters();
            MainFrame.this._openChooser.setFileFilter(MainFrame.this._anyFileFilter);
            return MainFrame.this.getOpenFiles(MainFrame.this._openChooser);
        }
    };
    private final FileSaveSelector _saveSelector = new FileSaveSelector(){

        @Override
        public File getFile() throws OperationCanceledException {
            return MainFrame.this.proposeBetterFileName(MainFrame.this.getSaveFile(MainFrame.this._saveChooser));
        }

        @Override
        public boolean warnFileOpen(File f) {
            return MainFrame.this._warnFileOpen(f);
        }

        @Override
        public boolean verifyOverwrite(File f) {
            return MainFrameStatics.verifyOverwrite(MainFrame.this, f);
        }

        @Override
        public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
            MainFrame.this._model.setActiveDocument(doc);
            String text = "File " + oldFile.getAbsolutePath() + "\ncould not be found on disk!  It was probably moved\nor deleted.  Would you like to save it in a new file?";
            int rc = JOptionPane.showConfirmDialog(MainFrame.this, text, "File Moved or Deleted", 0);
            return rc == 0;
        }

        @Override
        public boolean shouldUpdateDocumentState() {
            return true;
        }
    };
    private final FileSaveSelector _saveAsSelector = new FileSaveSelector(){

        @Override
        public File getFile() throws OperationCanceledException {
            return MainFrame.this.proposeBetterFileName(MainFrame.this.getSaveFile(MainFrame.this._saveChooser));
        }

        @Override
        public boolean warnFileOpen(File f) {
            return MainFrame.this._warnFileOpen(f);
        }

        @Override
        public boolean verifyOverwrite(File f) {
            return MainFrameStatics.verifyOverwrite(MainFrame.this, f);
        }

        @Override
        public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
            return true;
        }

        @Override
        public boolean shouldUpdateDocumentState() {
            return true;
        }
    };
    private final FileSaveSelector _saveCopySelector = new FileSaveSelector(){

        @Override
        public File getFile() throws OperationCanceledException {
            return MainFrame.this.proposeBetterFileName(MainFrame.this.getSaveFile(MainFrame.this._saveChooser));
        }

        @Override
        public boolean warnFileOpen(File f) {
            return MainFrame.this._warnFileOpen(f);
        }

        @Override
        public boolean verifyOverwrite(File f) {
            return MainFrameStatics.verifyOverwrite(MainFrame.this, f);
        }

        @Override
        public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
            return true;
        }

        @Override
        public boolean shouldUpdateDocumentState() {
            return false;
        }
    };
    private final JavadocDialog _javadocSelector = new JavadocDialog(this);
    private volatile DirectoryChooser _folderChooser;
    private final JCheckBox _openRecursiveCheckBox = new JCheckBox("Open folders recursively");
    private final Action _moveToAuxiliaryAction = new AbstractAction("Include With Project"){
        {
            String msg = "<html>Open this document each time this project is opened.<br>This file would then be compiled and tested with the<br>rest of the project.</html>";
            this.putValue("LongDescription", msg);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._moveToAuxiliary();
        }
    };
    private final Action _removeAuxiliaryAction = new AbstractAction("Do Not Include With Project"){
        {
            this.putValue("LongDescription", "Do not open this document next time this project is opened.");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._removeAuxiliary();
        }
    };
    private final Action _moveAllToAuxiliaryAction = new AbstractAction("Include All With Project"){
        {
            String msg = "<html>Open these documents each time this project is opened.<br>These files would then be compiled and tested with the<br>rest of the project.</html>";
            this.putValue("LongDescription", msg);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._moveAllToAuxiliary();
        }
    };
    private final Action _removeAllAuxiliaryAction = new AbstractAction("Do Not Include Any With Project"){
        {
            this.putValue("LongDescription", "Do not open these documents next time this project is opened.");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._removeAllAuxiliary();
        }
    };
    private final Action _newAction = new AbstractAction("New"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._new();
        }
    };
    private final Action _newClassAction = new AbstractAction("New Java Class..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._newJavaClass();
        }
    };
    private final Action _newProjectAction = new AbstractAction("New"){
        {
            this.putValue("ShortDescription", "New DrJava project");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._newProject();
        }
    };
    private volatile AbstractAction _runProjectAction = new AbstractAction("Run Main Class of Project"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.PROJECT, GUIAvailabilityListener.ComponentType.PROJECT_MAIN_CLASS, GUIAvailabilityListener.ComponentType.COMPILER, GUIAvailabilityListener.ComponentType.INTERACTIONS);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._runProject();
        }
    };
    private volatile JarOptionsDialog _jarOptionsDialog;
    private final Action _jarProjectAction = new AbstractAction("Create Jar File from Project..."){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.PROJECT, GUIAvailabilityListener.ComponentType.COMPILER);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._jarOptionsDialog.setVisible(true);
        }
    };
    private final Action _detachTabbedPanesAction = new AbstractAction("Detach Tabbed Panes"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            JMenuItem m = (JMenuItem)ae.getSource();
            boolean b = m.isSelected();
            MainFrame.this._detachTabbedPanesMenuItem.setSelected(b);
            DrJava.getConfig().setSetting(RecentFileManager.DETACH_TABBEDPANES, b);
            MainFrame.this._tabbedPanesFrame.setDisplayInFrame(b);
        }
    };
    private volatile JMenuItem _detachTabbedPanesMenuItem = null;
    private final Action _detachDebugFrameAction = new AbstractAction("Detach Debugger"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.DEBUGGER);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._debugFrame == null) {
                return;
            }
            JMenuItem m = (JMenuItem)ae.getSource();
            boolean b = m.isSelected();
            MainFrame.this._detachDebugFrameMenuItem.setSelected(b);
            DrJava.getConfig().setSetting(RecentFileManager.DETACH_DEBUGGER, b);
            MainFrame.this._debugFrame.setDisplayInFrame(b);
        }
    };
    private volatile JMenuItem _detachDebugFrameMenuItem;
    private final Action _newJUnitTestAction = new AbstractAction("New JUnit Test Case..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            String testName = JOptionPane.showInputDialog(MainFrame.this, "Please enter a name for the test class:", "New JUnit Test Case", 3);
            if (testName != null) {
                for (int i = 0; i < OptionConstants.LANGUAGE_LEVEL_EXTENSIONS.length; ++i) {
                    String ext = OptionConstants.LANGUAGE_LEVEL_EXTENSIONS[i];
                    if (!testName.endsWith(ext)) continue;
                    testName = testName.substring(0, testName.length() - ext.length());
                }
                MainFrame.this._model.newTestCase(testName, false, false);
            }
        }
    };
    private final Action _openAction = new AbstractAction("Open..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._open();
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    private final Action _openFolderAction = new AbstractAction("Open Folder..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._openFolder();
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    private final Action _openFileOrProjectAction = new AbstractAction("Open..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._openFileOrProject();
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    private final Action _openProjectAction = new AbstractAction("Open..."){
        {
            this.putValue("ShortDescription", "Open DrJava project");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._openProject();
        }
    };
    private final Action _closeProjectAction = new AbstractAction("Close"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.PROJECT);
            this.putValue("ShortDescription", "Close DrJava project");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.closeProject();
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    private final Action _closeAction = new AbstractAction("Close"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._close();
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    private final Action _closeAllAction = new AbstractAction("Close All"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._closeAll();
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    private final Action _closeFolderAction = new AbstractAction("Close Folder"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._closeFolder();
            MainFrame.this._findReplace.updateFirstDocInSearch();
            MainFrame.this._model.getDocumentNavigator().selectDocument(MainFrame.this._currentDefPane.getOpenDefDocument());
        }
    };
    private final Action _openAllFolderAction = new AbstractAction("Open All Files"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            List<File> l = MainFrame.this._model.getDocumentNavigator().getSelectedFolders();
            for (File f : l) {
                File fAbs = new File(MainFrame.this._model.getProjectRoot(), f.toString());
                MainFrame.this._openFolder(fAbs, false, MainFrame.this._model.getOpenAllFilesInFolderExtension());
            }
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    private final Action _openOneFolderAction = new AbstractAction("Open File in Folder"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._open();
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    public final Action _newFileFolderAction = new AbstractAction("Create New File in Folder"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._new();
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    private volatile AbstractAction _junitFolderAction = new AbstractAction("Test Folder"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.JUNIT, GUIAvailabilityListener.ComponentType.COMPILER, GUIAvailabilityListener.ComponentType.INTERACTIONS);
        }

        @Override
        public final void actionPerformed(ActionEvent ae) {
            MainFrame.this._junitFolder();
        }
    };
    private final Action _saveAction = new AbstractAction("Save"){

        @Override
        public final void actionPerformed(ActionEvent ae) {
            MainFrame.this._save();
        }
    };
    private final Action _saveAsAction = new AbstractAction("Save As..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._saveAs();
        }
    };
    private final Action _saveCopyAction = new AbstractAction("Save Copy..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._saveCopy();
        }
    };
    private final Action _renameAction = new AbstractAction("Rename"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._rename();
        }
    };
    private final Action _saveProjectAction = new AbstractAction("Save"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.PROJECT);
            this.putValue("ShortDescription", "Save DrJava project");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._saveAll();
        }
    };
    private final Action _saveProjectAsAction = new AbstractAction("Save As..."){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.PROJECT);
            this.putValue("ShortDescription", "Save DrJava project As");
            this.putValue("LongDescription", "Save DrJava project under different name");
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._saveProjectAs()) {
                MainFrame.this._saveAll();
            }
        }
    };
    private final Action _exportProjectInOldFormatAction = new AbstractAction("Export Project In Old \".pjt\" Format"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.PROJECT);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            File cpf = MainFrame.this._currentProjFile;
            MainFrame.this._currentProjFile = FileOps.NULL_FILE;
            if (MainFrame.this._saveProjectAs()) {
                MainFrame.this._saveAllOld();
            }
            MainFrame.this._currentProjFile = cpf;
            MainFrame.this._model.setProjectFile(cpf);
            MainFrame.this._recentProjectManager.updateOpenFiles(cpf);
        }
    };
    private final Action _revertAction = new AbstractAction("Revert to Saved"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object[] options;
            String title = "Revert to Saved?";
            int count = MainFrame.this._model.getDocumentNavigator().getDocumentSelectedCount();
            String message = count == 1 ? "Are you sure you want to revert the current file to the version on disk?" : "Are you sure you want to revert the " + count + " selected files to the versions on disk?";
            int rc = JOptionPane.showOptionDialog(MainFrame.this, message, title, 0, 3, null, options = new Object[]{"Yes", "No"}, options[1]);
            if (rc == 0) {
                MainFrame.this._revert();
            }
        }
    };
    final Action _saveAllAction = new AbstractAction("Save All"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._saveAll();
        }
    };
    private final Action _printDefDocAction = new AbstractAction("Print..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._printDefDoc();
        }
    };
    private final Action _printConsoleAction = new AbstractAction("Print Console..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._printConsole();
        }
    };
    private final Action _printInteractionsAction = new AbstractAction("Print Interactions..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._printInteractions();
        }
    };
    private final Action _printDefDocPreviewAction = new AbstractAction("Print Preview..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._printDefDocPreview();
        }
    };
    private final Action _printConsolePreviewAction = new AbstractAction("Print Preview..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._printConsolePreview();
        }
    };
    private final Action _printInteractionsPreviewAction = new AbstractAction("Print Preview..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._printInteractionsPreview();
        }
    };
    private final Action _pageSetupAction = new AbstractAction("Page Setup..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._pageSetup();
        }
    };
    private final Action _compileAction = new AbstractAction("Compile Current Document"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            MainFrame.this.updateStatusField("Compiling " + MainFrame.this._fileTitle);
            MainFrame.this._compile();
            MainFrame.this.updateStatusField("Compilation of current document completed");
        }
    };
    private volatile AbstractAction _compileProjectAction = new AbstractAction("Compile Project"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.PROJECT, GUIAvailabilityListener.ComponentType.COMPILER);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            MainFrame.this.updateStatusField("Compiling all source files in open project");
            MainFrame.this._compileProject();
            MainFrame.this._findReplace.updateFirstDocInSearch();
            MainFrame.this.updateStatusField("Compilation of open project completed");
        }
    };
    private volatile AbstractAction _compileFolderAction = new AbstractAction("Compile Folder"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.COMPILER);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            MainFrame.this.updateStatusField("Compiling all sources in current folder");
            MainFrame.this._compileFolder();
            MainFrame.this._findReplace.updateFirstDocInSearch();
            MainFrame.this.updateStatusField("Compilation of folder completed");
        }
    };
    private volatile AbstractAction _compileAllAction = new AbstractAction("Compile All Documents"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.COMPILER);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            MainFrame.this._compileAll();
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    private volatile AbstractAction _cleanAction = new AbstractAction("Clean Build Directory"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.COMPILER, GUIAvailabilityListener.ComponentType.PROJECT, GUIAvailabilityListener.ComponentType.PROJECT_BUILD_DIR);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._clean();
        }
    };
    private volatile AbstractAction _autoRefreshAction = new AbstractAction("Auto-Refresh Project"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.PROJECT, GUIAvailabilityListener.ComponentType.COMPILER);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._model.autoRefreshProject();
        }
    };
    private volatile AbstractAction _runAction = new AbstractAction("Run Document's Main Method"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.COMPILER, GUIAvailabilityListener.ComponentType.INTERACTIONS);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._runMain();
        }
    };
    private volatile AbstractAction _runAppletAction = new AbstractAction("Run Document as Applet"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.COMPILER, GUIAvailabilityListener.ComponentType.INTERACTIONS);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._runApplet();
        }
    };
    private volatile AbstractAction _junitAction = new AbstractAction("Test Current Document"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.JUNIT, GUIAvailabilityListener.ComponentType.COMPILER, GUIAvailabilityListener.ComponentType.INTERACTIONS);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            MainFrame.this._junit();
        }
    };
    private volatile AbstractAction _junitAllAction = new AbstractAction("Test All Documents"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.JUNIT, GUIAvailabilityListener.ComponentType.COMPILER, GUIAvailabilityListener.ComponentType.INTERACTIONS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            MainFrame.this._junitAll();
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    private volatile AbstractAction _junitProjectAction = new AbstractAction("Test Project"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.PROJECT, GUIAvailabilityListener.ComponentType.JUNIT, GUIAvailabilityListener.ComponentType.COMPILER, GUIAvailabilityListener.ComponentType.INTERACTIONS);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            MainFrame.this._junitProject();
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }
    };
    private volatile AbstractAction _javadocAllAction = new AbstractAction("Javadoc All Documents"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.JAVADOC, GUIAvailabilityListener.ComponentType.COMPILER);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            try {
                JavadocModel jm = MainFrame.this._model.getJavadocModel();
                File suggestedDir = jm.suggestJavadocDestination(MainFrame.this._model.getActiveDocument());
                MainFrame.this._javadocSelector.setSuggestedDir(suggestedDir);
                jm.javadocAll(MainFrame.this._javadocSelector, MainFrame.this._saveSelector);
            }
            catch (IOException ioe) {
                MainFrameStatics.showIOError(MainFrame.this, ioe);
            }
        }
    };
    private volatile AbstractAction _javadocCurrentAction = new AbstractAction("Preview Javadoc for Current Document"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.JAVADOC, GUIAvailabilityListener.ComponentType.COMPILER);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            try {
                MainFrame.this._model.getActiveDocument().generateJavadoc(MainFrame.this._saveSelector);
            }
            catch (IOException ioe) {
                MainFrameStatics.showIOError(MainFrame.this, ioe);
            }
        }
    };
    final Action cutAction = new DefaultEditorKit.CutAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String s;
            Component c = MainFrame.this.getFocusOwner();
            super.actionPerformed(e);
            if (MainFrame.this._currentDefPane.hasFocus() && (s = Utilities.getClipboardSelection(c)) != null && s.length() != 0) {
                ClipboardHistoryModel.singleton().put(s);
            }
            if (c != null) {
                c.requestFocusInWindow();
            }
        }
    };
    final Action copyAction = new DefaultEditorKit.CopyAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            String s;
            Component c = MainFrame.this.getFocusOwner();
            super.actionPerformed(e);
            if (MainFrame.this._currentDefPane.hasFocus() && MainFrame.this._currentDefPane.getSelectedText() != null && (s = Utilities.getClipboardSelection(c)) != null && s.length() != 0) {
                ClipboardHistoryModel.singleton().put(s);
            }
            if (c != null) {
                c.requestFocusInWindow();
            }
        }
    };
    final Action pasteAction = new DefaultEditorKit.PasteAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable contents = clipboard.getContents(null);
            if (contents != null && contents.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String result = (String)contents.getTransferData(DataFlavor.stringFlavor);
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < result.length(); ++i) {
                        char ch = result.charAt(i);
                        if (ch < ' ' && ch != '\n') {
                            sb.append(' ');
                            continue;
                        }
                        sb.append(ch);
                    }
                    StringSelection stringSelection = new StringSelection(sb.toString());
                    clipboard.setContents(stringSelection, stringSelection);
                }
                catch (UnsupportedFlavorException ex) {
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
            Component c = MainFrame.this.getFocusOwner();
            if (MainFrame.this._currentDefPane.hasFocus()) {
                MainFrame.this._currentDefPane.endCompoundEdit();
                super.actionPerformed(e);
                MainFrame.this._currentDefPane.endCompoundEdit();
            } else if (MainFrame.this._interactionsPane.hasFocus()) {
                MainFrame.this._interactionsPane.endCompoundEdit();
                super.actionPerformed(e);
                MainFrame.this._interactionsPane.endCompoundEdit();
            } else {
                super.actionPerformed(e);
            }
            if (c != null) {
                c.requestFocusInWindow();
            }
        }
    };
    private volatile ClipboardHistoryFrame _clipboardHistoryDialog = null;
    private final Action _pasteHistoryAction = new AbstractAction("Paste from History..."){

        @Override
        public void actionPerformed(final ActionEvent ae) {
            final ClipboardHistoryFrame.CloseAction cancelAction = new ClipboardHistoryFrame.CloseAction(){

                @Override
                public Object value(String s) {
                    if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_CLIPBOARD_HISTORY_STORE_POSITION).booleanValue() && MainFrame.this._clipboardHistoryDialog != null && MainFrame.this._clipboardHistoryDialog.getFrameState() != null) {
                        DrJava.getConfig().setSetting(RecentFileManager.DIALOG_CLIPBOARD_HISTORY_STATE, MainFrame.this._clipboardHistoryDialog.getFrameState().toString());
                    } else {
                        DrJava.getConfig().setSetting(RecentFileManager.DIALOG_CLIPBOARD_HISTORY_STATE, RecentFileManager.DIALOG_CLIPBOARD_HISTORY_STATE.getDefault());
                    }
                    return null;
                }
            };
            ClipboardHistoryFrame.CloseAction okAction = new ClipboardHistoryFrame.CloseAction(){

                @Override
                public Object value(String s) {
                    cancelAction.value(null);
                    StringSelection ssel = new StringSelection(s);
                    Clipboard cb = MainFrame.this.getToolkit().getSystemClipboard();
                    if (cb != null) {
                        cb.setContents(ssel, MainFrame.this);
                        MainFrame.this.pasteAction.actionPerformed(ae);
                    }
                    return null;
                }
            };
            MainFrame.this._clipboardHistoryDialog = new ClipboardHistoryFrame(MainFrame.this, "Clipboard History", ClipboardHistoryModel.singleton(), okAction, cancelAction);
            if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_CLIPBOARD_HISTORY_STORE_POSITION).booleanValue()) {
                MainFrame.this._clipboardHistoryDialog.setFrameState(DrJava.getConfig().getSetting(RecentFileManager.DIALOG_CLIPBOARD_HISTORY_STATE));
            }
            MainFrame.this._clipboardHistoryDialog.setVisible(true);
        }
    };
    private final Action _copyInteractionToDefinitionsAction = new AbstractAction("Lift Current Interaction to Definitions"){

        @Override
        public void actionPerformed(ActionEvent a) {
            String text = MainFrame.this._interactionsController.getDocument().getCurrentInput();
            if (!text.equals("")) {
                MainFrame.this._putTextIntoDefinitions(text + "\n");
                return;
            }
            try {
                text = MainFrame.this._interactionsController.getDocument().lastEntry();
            }
            catch (Exception e) {
                return;
            }
            MainFrame.this._putTextIntoDefinitions(text + "\n");
        }
    };
    private final DelegatingAction _undoAction = new DelegatingAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean intPaneFocused;
            boolean bl = intPaneFocused = this.getDelegatee() == MainFrame.this._interactionsController.getUndoAction();
            if (intPaneFocused) {
                MainFrame.this._interactionsPane.endCompoundEdit();
            } else {
                MainFrame.this._currentDefPane.endCompoundEdit();
            }
            super.actionPerformed(e);
            if (intPaneFocused) {
                MainFrame.this._interactionsPane.requestFocusInWindow();
            } else {
                MainFrame.this._currentDefPane.requestFocusInWindow();
                OpenDefinitionsDocument doc = MainFrame.this._model.getActiveDocument();
                MainFrame.this._saveAction.setEnabled(doc.isModifiedSinceSave() || doc.isUntitled());
            }
        }
    };
    private final DelegatingAction _redoAction = new DelegatingAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean intPaneFocused = this.getDelegatee() == MainFrame.this._interactionsController.getRedoAction();
            super.actionPerformed(e);
            if (intPaneFocused) {
                MainFrame.this._interactionsPane.requestFocusInWindow();
            } else {
                MainFrame.this._currentDefPane.requestFocusInWindow();
                OpenDefinitionsDocument doc = MainFrame.this._model.getActiveDocument();
                MainFrame.this._saveAction.setEnabled(doc.isModifiedSinceSave() || doc.isUntitled());
            }
        }
    };
    private final Action _quitAction = new AbstractAction("Quit"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.quit();
        }
    };
    private final Action _forceQuitAction = new AbstractAction("Force Quit"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._forceQuit();
        }
    };
    private final Action _selectAllAction = new AbstractAction("Select All"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._selectAll();
        }
    };
    private final Action _findReplaceAction = new AbstractAction("Find/Replace"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._showFindReplaceTab(true);
            MainFrame.this._findReplace.requestFocusInWindow();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this._findReplace.requestFocusInWindow();
                }
            });
        }
    };
    private final Action _findNextAction = new AbstractAction("Find Next"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._showFindReplaceTab(false);
            if (!DrJava.getConfig().getSetting(RecentFileManager.FIND_REPLACE_FOCUS_IN_DEFPANE).booleanValue()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this._findReplace.requestFocusInWindow();
                    }
                });
            }
            MainFrame.this._findReplace.findNext();
        }
    };
    private final Action _findPrevAction = new AbstractAction("Find Previous"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._showFindReplaceTab(false);
            if (!DrJava.getConfig().getSetting(RecentFileManager.FIND_REPLACE_FOCUS_IN_DEFPANE).booleanValue()) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this._findReplace.requestFocusInWindow();
                    }
                });
            }
            MainFrame.this._findReplace.findPrevious();
            MainFrame.this._currentDefPane.requestFocusInWindow();
        }
    };
    private final Action _gotoLineAction = new AbstractAction("Go to Line..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            int pos = MainFrame.this._gotoLine();
            MainFrame.this._currentDefPane.requestFocusInWindow();
            if (pos != -1) {
                MainFrame.this._currentDefPane.setCaretPosition(pos);
            }
        }
    };
    volatile PredictiveInputFrame<MainFrameStatics.GoToFileListEntry> _gotoFileDialog = null;
    private final Action _gotoFileAction = new AbstractAction("Go to File..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.initGotoFileDialog();
            List<OpenDefinitionsDocument> docs = MainFrame.this._model.getOpenDefinitionsDocuments();
            if (docs == null || docs.size() == 0) {
                return;
            }
            MainFrameStatics.GoToFileListEntry currentEntry = null;
            ArrayList<MainFrameStatics.GoToFileListEntry> list = DrJava.getConfig().getSetting(RecentFileManager.DIALOG_GOTOFILE_FULLY_QUALIFIED) != false ? new ArrayList(2 * docs.size()) : new ArrayList<MainFrameStatics.GoToFileListEntry>(docs.size());
            for (OpenDefinitionsDocument d : docs) {
                MainFrameStatics.GoToFileListEntry entry = new MainFrameStatics.GoToFileListEntry(d, d.toString());
                if (d.equals(MainFrame.this._model.getActiveDocument())) {
                    currentEntry = entry;
                }
                list.add(entry);
                if (!DrJava.getConfig().getSetting(RecentFileManager.DIALOG_GOTOFILE_FULLY_QUALIFIED).booleanValue()) continue;
                try {
                    try {
                        String relative = FileOps.stringMakeRelativeTo(d.getFile(), d.getSourceRoot());
                        if (relative.equals(d.toString())) continue;
                        list.add(new MainFrameStatics.GoToFileListEntry(d, d.getPackageName() + "." + d.toString()));
                    }
                    catch (IOException e) {
                    }
                    catch (InvalidPackageException e) {
                    }
                }
                catch (IllegalStateException e) {}
            }
            MainFrame.this._gotoFileDialog.setItems(true, (Collection<MainFrameStatics.GoToFileListEntry>)list);
            if (currentEntry != null) {
                MainFrame.this._gotoFileDialog.setCurrentItem(currentEntry);
            }
            MainFrame.this.hourglassOn();
            MainFrame.this._gotoFileDialog.setVisible(true);
        }
    };
    final Action _gotoFileUnderCursorAction = new AbstractAction("Go to File Under Cursor"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._gotoFileUnderCursor();
        }
    };
    volatile PredictiveInputFrame<MainFrameStatics.JavaAPIListEntry> _openJavadocDialog = null;
    volatile Set<MainFrameStatics.JavaAPIListEntry> _javaAPISet = new HashSet<MainFrameStatics.JavaAPIListEntry>();
    private volatile Action _openJavadocAction = new AbstractAction("Open Java API Javadoc..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.hourglassOn();
            new Thread(){

                @Override
                public void run() {
                    MainFrame.this.initOpenJavadocDialog();
                    Utilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.this._openJavadocDialog.setItems(true, (Collection<MainFrameStatics.JavaAPIListEntry>)MainFrame.this.getJavaAPISet());
                            MainFrame.this._openJavadocDialog.setVisible(true);
                        }
                    });
                }
            }.start();
        }
    };
    final Action _openJavadocUnderCursorAction = new AbstractAction("Open Java API Javadoc for Word Under Cursor..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._openJavadocUnderCursor();
        }
    };
    final Action _closeSystemInAction = new AbstractAction("Close System.in"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._interactionsController.setEndOfStream(true);
            MainFrame.this._interactionsController.interruptConsoleInput();
        }
    };
    private volatile AutoCompletePopup _completeWordDialog = null;
    final Action completeWordUnderCursorAction = new AbstractAction("Auto-Complete Word Under Cursor"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._completeWordUnderCursor();
        }
    };
    private final Action _indentLinesAction = new AbstractAction("Indent Line(s)"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.hourglassOn();
            try {
                MainFrame.this._currentDefPane.endCompoundEdit();
                MainFrame.this._currentDefPane.indent();
            }
            finally {
                MainFrame.this.hourglassOff();
            }
        }
    };
    private final Action _commentLinesAction = new AbstractAction("Comment Line(s)"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.hourglassOn();
            try {
                MainFrame.this.commentLines();
            }
            finally {
                MainFrame.this.hourglassOff();
            }
        }
    };
    private final Action _uncommentLinesAction = new AbstractAction("Uncomment Line(s)"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.hourglassOn();
            try {
                MainFrame.this.uncommentLines();
            }
            finally {
                MainFrame.this.hourglassOff();
            }
        }
    };
    private final Action _saveConsoleCopyAction = new AbstractAction("Save Copy of Console..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.updateStatusField("Saving Copy of Console");
            MainFrame.this._saveConsoleCopy(MainFrame.this._model.getConsoleDocument());
            MainFrame.this._consolePane.requestFocusInWindow();
        }
    };
    private final Action _clearConsoleAction = new AbstractAction("Clear Console"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._model.resetConsole();
        }
    };
    private final Action _showDebugConsoleAction = new AbstractAction("Show DrJava Debug Console"){

        @Override
        public void actionPerformed(ActionEvent e) {
            DrJavaRoot.showDrJavaDebugConsole(MainFrame.this);
        }
    };
    private final Action _resetInteractionsAction = new AbstractAction("Reset Interactions"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (!DrJava.getConfig().getSetting(RecentFileManager.INTERACTIONS_RESET_PROMPT).booleanValue()) {
                MainFrame.this._doResetInteractions();
                return;
            }
            String title = "Confirm Reset Interactions";
            String message = "Are you sure you want to reset the Interactions Pane?";
            ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(MainFrame.this, title, message);
            int rc = dialog.show();
            if (rc == 0) {
                MainFrame.this._doResetInteractions();
                if (dialog.getCheckBoxValue()) {
                    DrJava.getConfig().setSetting(RecentFileManager.INTERACTIONS_RESET_PROMPT, Boolean.FALSE);
                }
            }
        }
    };
    private final Action _viewInteractionsClassPathAction = new AbstractAction("View Interactions Classpath..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            MainFrame.this.viewInteractionsClassPath();
        }
    };
    private final Action _helpAction = new AbstractAction("Help"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._helpFrame.setVisible(true);
        }
    };
    private final Action _quickStartAction = new AbstractAction("QuickStart"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._quickStartFrame.setVisible(true);
        }
    };
    private final Action _aboutAction = new AbstractAction("About"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._aboutDialog.setVisible(true);
        }
    };
    private final Action _checkNewVersionAction = new AbstractAction("Check for New Version"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            NewVersionPopup popup = new NewVersionPopup(MainFrame.this);
            popup.setVisible(true);
        }
    };
    private final Action _errorsAction = new AbstractAction("DrJava Errors"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.setPopupLoc(DrJavaErrorWindow.singleton());
            DrJavaErrorWindow.singleton().setVisible(true);
        }
    };
    private final Action _generateCustomDrJavaJarAction = new AbstractAction("Generate Custom drjava.jar..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            GenerateCustomDrJavaJarFrame popup = new GenerateCustomDrJavaJarFrame(MainFrame.this);
            popup.setVisible(true);
        }
    };
    private final Action _newDrJavaInstanceAction = new AbstractAction("New DrJava Instance..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                Process p = JVMBuilder.DEFAULT.classPath(FileOps.getDrJavaFile()).start(DrJava.class.getName(), "-new");
            }
            catch (IOException ioe) {
                MainFrameStatics.showIOError(MainFrame.this, ioe);
            }
        }
    };
    private final Action _switchToNextAction = new AbstractAction("Next Document"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.setEnabled(false);
            if (MainFrame.this._docSplitPane.getDividerLocation() < MainFrame.this._docSplitPane.getMinimumDividerLocation()) {
                MainFrame.this._docSplitPane.setDividerLocation(DrJava.getConfig().getSetting(RecentFileManager.DOC_LIST_WIDTH));
            }
            MainFrame.this._model.setActiveNextDocument();
            MainFrame.this._findReplace.updateFirstDocInSearch();
            this.setEnabled(true);
            MainFrame.this.addToBrowserHistory();
        }
    };
    private final Action _switchToPrevAction = new AbstractAction("Previous Document"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            this.setEnabled(false);
            if (MainFrame.this._docSplitPane.getDividerLocation() < MainFrame.this._docSplitPane.getMinimumDividerLocation()) {
                MainFrame.this._docSplitPane.setDividerLocation(DrJava.getConfig().getSetting(RecentFileManager.DOC_LIST_WIDTH));
            }
            MainFrame.this._model.setActivePreviousDocument();
            MainFrame.this._findReplace.updateFirstDocInSearch();
            this.setEnabled(true);
            MainFrame.this.addToBrowserHistory();
        }
    };
    private final Action _switchToNextPaneAction = new AbstractAction("Next Pane"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            this.setEnabled(false);
            MainFrame.this._switchPaneFocus(true);
            this.setEnabled(true);
        }
    };
    private final Action _browseBackAction = new AbstractAction("Browse Back"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.updateStatusField("Browsing Back");
            this.setEnabled(false);
            if (MainFrame.this._docSplitPane.getDividerLocation() < MainFrame.this._docSplitPane.getMinimumDividerLocation()) {
                MainFrame.this._docSplitPane.setDividerLocation(DrJava.getConfig().getSetting(RecentFileManager.DOC_LIST_WIDTH));
            }
            BrowserHistoryManager rm = MainFrame.this._model.getBrowserHistoryManager();
            MainFrame.this.addToBrowserHistory();
            BrowserDocumentRegion r = rm.prevCurrentRegion(MainFrame.this._model.getNotifier());
            if (r != null) {
                MainFrame.this.scrollToDocumentAndOffset(r.getDocument(), r.getStartOffset(), false, false);
            }
            MainFrame.this._configureBrowsing();
        }
    };
    private final Action _browseForwardAction = new AbstractAction("Browse Forward"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.updateStatusField("Browsing Forward");
            this.setEnabled(false);
            if (MainFrame.this._docSplitPane.getDividerLocation() < MainFrame.this._docSplitPane.getMinimumDividerLocation()) {
                MainFrame.this._docSplitPane.setDividerLocation(DrJava.getConfig().getSetting(RecentFileManager.DOC_LIST_WIDTH));
            }
            BrowserHistoryManager rm = MainFrame.this._model.getBrowserHistoryManager();
            MainFrame.this.addToBrowserHistoryBefore();
            BrowserDocumentRegion r = rm.nextCurrentRegion(MainFrame.this._model.getNotifier());
            if (r != null) {
                MainFrame.this.scrollToDocumentAndOffset(r.getDocument(), r.getStartOffset(), false, false);
            }
            MainFrame.this._configureBrowsing();
        }
    };
    private final Action _nextRegionAction = new AbstractAction("Next Region"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Component c = MainFrame.this._tabbedPane.getComponentAt(MainFrame.this._tabbedPane.getSelectedIndex());
            if (c instanceof RegionsTreePanel) {
                RegionsTreePanel rtp = (RegionsTreePanel)c;
                rtp.goToNextRegion();
            }
        }
    };
    private final Action _prevRegionAction = new AbstractAction("Previous Region"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Component c = MainFrame.this._tabbedPane.getComponentAt(MainFrame.this._tabbedPane.getSelectedIndex());
            if (c instanceof RegionsTreePanel) {
                RegionsTreePanel rtp = (RegionsTreePanel)c;
                rtp.goToPreviousRegion();
            }
        }
    };
    private final Action _switchToPreviousPaneAction = new AbstractAction("Previous Pane"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            this.setEnabled(false);
            MainFrame.this._switchPaneFocus(false);
            this.setEnabled(true);
        }
    };
    private final Action _gotoClosingBraceAction = new AbstractAction("Go to Closing Brace"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            OpenDefinitionsDocument odd = MainFrame.this.getCurrentDefPane().getOpenDefDocument();
            try {
                int pos = odd.findNextEnclosingBrace(MainFrame.this.getCurrentDefPane().getCaretPosition(), '{', '}');
                if (pos != -1) {
                    MainFrame.this.getCurrentDefPane().setCaretPosition(pos);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    };
    private final Action _gotoOpeningBraceAction = new AbstractAction("Go to Opening Brace"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            OpenDefinitionsDocument odd = MainFrame.this.getCurrentDefPane().getOpenDefDocument();
            try {
                int pos = odd.findPrevEnclosingBrace(MainFrame.this.getCurrentDefPane().getCaretPosition(), '{', '}');
                if (pos != -1) {
                    MainFrame.this.getCurrentDefPane().setCaretPosition(pos);
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    };
    private final Action _editPreferencesAction = new AbstractAction("Preferences ..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.editPreferences();
        }
    };
    private volatile AbstractAction _projectPropertiesAction = new AbstractAction("Project Properties"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.PROJECT, GUIAvailabilityListener.ComponentType.COMPILER, GUIAvailabilityListener.ComponentType.JUNIT);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._editProject();
        }
    };
    private final Action _toggleDebuggerAction = new AbstractAction("Debug Mode"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.INTERACTIONS);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._guiAvailabilityNotifier.unavailable(GUIAvailabilityListener.ComponentType.INTERACTIONS);
            MainFrame.this.debuggerToggle();
            MainFrame.this._guiAvailabilityNotifier.available(GUIAvailabilityListener.ComponentType.INTERACTIONS);
        }
    };
    private final Action _resumeDebugAction = new AbstractAction("Resume Debugger"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.DEBUGGER, GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            try {
                MainFrame.this.debuggerResume();
            }
            catch (DebugException de) {
                MainFrameStatics.showDebugError(MainFrame.this, de);
            }
        }
    };
    private volatile JMenuItem _automaticTraceMenuItem;
    private final Action _automaticTraceDebugAction = new AbstractAction("Automatic Trace"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.DEBUGGER, GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.debuggerAutomaticTrace();
        }
    };
    private final Action _stepIntoDebugAction = new AbstractAction("Step Into"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.DEBUGGER, GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.debuggerStep(Debugger.StepType.STEP_INTO);
        }
    };
    private final Action _stepOverDebugAction = new AbstractAction("Step Over"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.DEBUGGER, GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.debuggerStep(Debugger.StepType.STEP_OVER);
        }
    };
    private final Action _stepOutDebugAction = new AbstractAction("Step Out"){
        {
            MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.DEBUGGER, GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.debuggerStep(Debugger.StepType.STEP_OUT);
        }
    };
    final Action _toggleBreakpointAction = new AbstractAction("Toggle Breakpoint on Current Line"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.debuggerToggleBreakpoint();
        }
    };
    private final Action _clearAllBreakpointsAction = new AbstractAction("Clear All Breakpoints"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.debuggerClearAllBreakpoints();
        }
    };
    private final Action _breakpointsPanelAction = new AbstractAction("Breakpoints"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            MainFrame.this.showTab(MainFrame.this._breakpointsPanel, true);
            MainFrame.this._breakpointsPanel.setVisible(true);
            MainFrame.this._tabbedPane.setSelectedComponent(MainFrame.this._breakpointsPanel);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this._breakpointsPanel.requestFocusInWindow();
                }
            });
        }
    };
    private final Action _bookmarksPanelAction = new AbstractAction("Bookmarks"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            if (MainFrame.this._mainSplit.getDividerLocation() > MainFrame.this._mainSplit.getMaximumDividerLocation()) {
                MainFrame.this._mainSplit.resetToPreferredSizes();
            }
            MainFrame.this.showTab(MainFrame.this._bookmarksPanel, true);
            MainFrame.this._tabbedPane.setSelectedComponent(MainFrame.this._bookmarksPanel);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this._bookmarksPanel.requestFocusInWindow();
                }
            });
        }
    };
    private final Action _toggleBookmarkAction = new AbstractAction("Toggle Bookmark"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.toggleBookmark();
        }
    };
    protected final Action _cutLineAction = new AbstractAction("Cut Line"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            ActionMap actionMap = MainFrame.this._currentDefPane.getActionMap();
            int oldCol = MainFrame.this._model.getActiveDocument().getCurrentCol();
            actionMap.get("selection-end-line").actionPerformed(ae);
            if (oldCol == MainFrame.this._model.getActiveDocument().getCurrentCol()) {
                actionMap.get("selection-forward").actionPerformed(ae);
                MainFrame.this.cutAction.actionPerformed(ae);
            } else {
                MainFrame.this.cutAction.actionPerformed(ae);
            }
        }
    };
    protected final Action _clearLineAction = new AbstractAction("Clear Line"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            ActionMap actionMap = MainFrame.this._currentDefPane.getActionMap();
            actionMap.get("selection-end-line").actionPerformed(ae);
            actionMap.get("delete-next").actionPerformed(ae);
        }
    };
    private final Action _beginLineAction = new AbstractAction("Begin Line"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            int beginLinePos = MainFrame.this._getBeginLinePos();
            MainFrame.this._currentDefPane.setCaretPosition(beginLinePos);
        }
    };
    private final Action _selectionBeginLineAction = new AbstractAction("Select to Beginning of Line"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            int beginLinePos = MainFrame.this._getBeginLinePos();
            MainFrame.this._currentDefPane.moveCaretPosition(beginLinePos);
        }
    };
    private final FileOpenSelector _interactionsHistoryFileSelector = new FileOpenSelector(){

        @Override
        public File[] getFiles() throws OperationCanceledException {
            return MainFrame.this.getOpenFiles(MainFrame.this._interactionsHistoryChooser);
        }
    };
    private final Action _executeHistoryAction = new AbstractAction("Execute Interactions History..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._tabbedPane.setSelectedIndex(0);
            MainFrame.this._interactionsHistoryChooser.setDialogTitle("Execute Interactions History");
            try {
                MainFrame.this._model.loadHistory(MainFrame.this._interactionsHistoryFileSelector);
            }
            catch (FileNotFoundException fnf) {
                MainFrameStatics.showFileNotFoundError(MainFrame.this, fnf);
            }
            catch (IOException ioe) {
                MainFrameStatics.showIOError(MainFrame.this, ioe);
            }
            MainFrame.this._interactionsPane.requestFocusInWindow();
        }
    };
    private final Action _loadHistoryScriptAction = new AbstractAction("Load Interactions History as Script..."){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                MainFrame.this._interactionsHistoryChooser.setDialogTitle("Load Interactions History");
                InteractionsScriptModel ism = MainFrame.this._model.loadHistoryAsScript(MainFrame.this._interactionsHistoryFileSelector);
                MainFrame.this._interactionsScriptController = new InteractionsScriptController(ism, new AbstractAction("Close"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MainFrame.this._closeInteractionsScript();
                        MainFrame.this._interactionsPane.requestFocusInWindow();
                    }
                }, MainFrame.this._interactionsPane);
                MainFrame.this._interactionsScriptPane = MainFrame.this._interactionsScriptController.getPane();
                MainFrame.this._interactionsContainer.add((Component)MainFrame.this._interactionsScriptPane, "East");
                MainFrame.this._tabbedPane.invalidate();
                MainFrame.this._tabbedPane.repaint();
            }
            catch (FileNotFoundException fnf) {
                MainFrameStatics.showFileNotFoundError(MainFrame.this, fnf);
            }
            catch (IOException ioe) {
                MainFrameStatics.showIOError(MainFrame.this, ioe);
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
        }
    };
    private final Action _saveInteractionsCopyAction = new AbstractAction("Save Copy of Interactions..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this.updateStatusField("Saving Copy of Interactions");
            MainFrame.this._saveConsoleCopy(MainFrame.this._model.getInteractionsDocument());
            MainFrame.this._interactionsPane.requestFocusInWindow();
        }
    };
    private final Action _saveHistoryAction = new AbstractAction("Save Interactions History..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            Object[] options = new String[]{"Yes", "No", "Cancel"};
            int resp = JOptionPane.showOptionDialog(MainFrame.this, "Edit interactions history before saving?", "Edit History?", 1, 3, null, options, options[1]);
            if (resp == 2 || resp == -1) {
                return;
            }
            String history = MainFrame.this._model.getHistoryAsStringWithSemicolons();
            if (resp == 0) {
                history = new HistorySaveDialog(MainFrame.this).editHistory(history);
            }
            if (history == null) {
                return;
            }
            MainFrame.this._interactionsHistoryChooser.setDialogTitle("Save Interactions History");
            FileSaveSelector selector = new FileSaveSelector(){

                @Override
                public File getFile() throws OperationCanceledException {
                    File selection = MainFrame.this._interactionsHistoryChooser.getSelectedFile();
                    if (selection != null) {
                        MainFrame.this._interactionsHistoryChooser.setSelectedFile(selection.getParentFile());
                        MainFrame.this._interactionsHistoryChooser.setSelectedFile(selection);
                        MainFrame.this._interactionsHistoryChooser.setSelectedFile(null);
                    }
                    MainFrame.this._interactionsHistoryChooser.setMultiSelectionEnabled(false);
                    int rc = MainFrame.this._interactionsHistoryChooser.showSaveDialog(MainFrame.this);
                    File c = MainFrame.this.getChosenFile(MainFrame.this._interactionsHistoryChooser, rc, null, false);
                    if (c != null && c.getName().indexOf(46) == -1) {
                        c = new File(c.getAbsolutePath() + "." + "hist");
                    }
                    MainFrame.this._interactionsHistoryChooser.setSelectedFile(c);
                    return c;
                }

                @Override
                public boolean warnFileOpen(File f) {
                    return true;
                }

                @Override
                public boolean verifyOverwrite(File f) {
                    return MainFrameStatics.verifyOverwrite(MainFrame.this, f);
                }

                @Override
                public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
                    return true;
                }

                @Override
                public boolean shouldUpdateDocumentState() {
                    return true;
                }
            };
            try {
                MainFrame.this._model.saveHistory(selector, history);
            }
            catch (IOException ioe) {
                MainFrameStatics.showIOError(MainFrame.this, new IOException("An error occured writing the history to a file"));
            }
            MainFrame.this._interactionsPane.requestFocusInWindow();
        }
    };
    private final Action _clearHistoryAction = new AbstractAction("Clear Interactions History"){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._model.clearHistory();
            MainFrame.this._interactionsPane.requestFocusInWindow();
        }
    };
    private final WindowListener _windowCloseListener = new WindowAdapter(){

        @Override
        public void windowActivated(WindowEvent ev) {
        }

        @Override
        public void windowClosed(WindowEvent ev) {
        }

        @Override
        public void windowClosing(WindowEvent ev) {
            MainFrame.this.quit();
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
        }

        @Override
        public void windowDeiconified(WindowEvent ev) {
            try {
                MainFrame.this._model.getActiveDocument().revertIfModifiedOnDisk();
            }
            catch (FileMovedException fme) {
                MainFrame.this._showFileMovedError(fme);
            }
            catch (IOException e) {
                MainFrameStatics.showIOError(MainFrame.this, e);
            }
        }

        @Override
        public void windowIconified(WindowEvent ev) {
        }

        @Override
        public void windowOpened(WindowEvent ev) {
            MainFrame.this._currentDefPane.requestFocusInWindow();
        }
    };
    private final MouseListener _resetFindReplaceListener = new MouseListener(){

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            MainFrame.this._findReplace.updateFirstDocInSearch();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    };
    private static final DJFileDisplayManager _djFileDisplayManager20;
    private static final DJFileDisplayManager _djFileDisplayManager30;
    private static final OddDisplayManager _oddDisplayManager20;
    private static final OddDisplayManager _oddDisplayManager30;
    private static final Icon _djProjectIcon;
    private final DisplayManager<INavigatorItem> _navPaneDisplayManager = new DisplayManager<INavigatorItem>(){

        @Override
        public Icon getIcon(INavigatorItem item) {
            OpenDefinitionsDocument odd = (OpenDefinitionsDocument)item;
            return _oddDisplayManager20.getIcon(odd);
        }

        @Override
        public String getName(INavigatorItem name) {
            return name.getName();
        }
    };
    public KeyListener _historyListener = new KeyListener(){

        @Override
        public void keyPressed(KeyEvent e) {
            int backQuote = 192;
            if (e.getKeyCode() == backQuote && e.isControlDown()) {
                if (e.isShiftDown()) {
                    MainFrame.this.prevRecentDoc();
                } else {
                    MainFrame.this.nextRecentDoc();
                }
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
            if (e.getKeyCode() == 17) {
                MainFrame.this.hideRecentDocFrame();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }
    };
    public FocusListener _focusListenerForRecentDocs = new FocusListener(){

        @Override
        public void focusLost(FocusEvent e) {
            MainFrame.this.hideRecentDocFrame();
        }

        @Override
        public void focusGained(FocusEvent e) {
        }
    };
    public final FocusListener _undoRedoDefinitionsFocusListener = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent e) {
            MainFrame.this._undoAction.setDelegatee(MainFrame.this._currentDefPane.getUndoAction());
            MainFrame.this._redoAction.setDelegatee(MainFrame.this._currentDefPane.getRedoAction());
        }
    };
    private volatile int _hourglassNestLevel = 0;
    private volatile boolean _allowKeyEvents = true;
    HashSet<MainFrameStatics.GoToFileListEntry> _completeClassSet = new HashSet();
    HashSet<MainFrameStatics.JavaAPIListEntry> _autoImportClassSet = new HashSet();
    private volatile Object _updateLock = new Object();
    private volatile boolean _tabUpdatePending = false;
    private volatile boolean _waitAgain = false;
    private volatile Runnable _pendingUpdate = null;
    private volatile OpenDefinitionsDocument _pendingDocument = null;
    private volatile OrderedDocumentRegion _firstRegion = null;
    private volatile OrderedDocumentRegion _lastRegion = null;
    public static long UPDATE_DELAY;
    public static int UPDATER_PRIORITY;
    public static final Icon FIND_ICON;
    DropTarget dropTarget = new DropTarget(this, this);
    private static DataFlavor uriListFlavor;
    PredictiveInputFrame<MainFrameStatics.JavaAPIListEntry> _autoImportDialog = null;
    JCheckBox _autoImportPackageCheckbox;
    private final Action _followFileAction = new AbstractAction("Follow File..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._followFile();
        }
    };
    private final Action _executeExternalProcessAction = new AbstractAction("New External Process..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._executeExternalProcess();
        }
    };
    private volatile ExecuteExternalDialog _executeExternalDialog;
    private volatile EditExternalDialog _editExternalDialog;
    private final Action _editExternalProcessesAction = new AbstractAction("Edit..."){

        @Override
        public void actionPerformed(ActionEvent ae) {
            MainFrame.this._editExternalDialog.setVisible(true);
        }
    };

    private FileFilter getSourceFileFilter() {
        CompilerModel cm = this._model.getCompilerModel();
        if (cm == null) {
            return new SmartSourceFilter();
        }
        return cm.getActiveCompiler().getFileFilter();
    }

    private String getSuggestedFileExtension() {
        CompilerModel cm = this._model.getCompilerModel();
        if (cm == null) {
            return DrJavaFileUtils.getSuggestedFileExtension();
        }
        return cm.getActiveCompiler().getSuggestedFileExtension();
    }

    private File proposeBetterFileName(File f) {
        if (DrJavaFileUtils.isOldLLFile(f) && DrJava.getConfig().getSetting(RecentFileManager.PROMPT_RENAME_LL_FILES).booleanValue()) {
            File newFile = DrJavaFileUtils.getNewLLForOldLLFile(f);
            String newExt = DrJavaFileUtils.getExtension(newFile.getName());
            return MainFrameStatics.proposeToChangeExtension(this, f, "Change Extension?", f.getPath() + "\nThis file still has an old Language Level extension." + "\nDo you want to change the file's extension to \"" + newExt + "\"?", "Change to \"" + newExt + "\"", "Keep \"" + DrJavaFileUtils.getExtension(f.getName()) + "\"", newExt);
        }
        return f;
    }

    public void _newJavaClass() {
        NewJavaClassDialog njc = new NewJavaClassDialog(this);
        njc.setVisible(true);
    }

    private void initJarOptionsDialog() {
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_JAROPTIONS_STORE_POSITION).booleanValue()) {
            this._jarOptionsDialog.setFrameState(DrJava.getConfig().getSetting(RecentFileManager.DIALOG_JAROPTIONS_STATE));
        }
    }

    public void resetJarOptionsDialogPosition() {
        this._jarOptionsDialog.setFrameState("default");
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_JAROPTIONS_STORE_POSITION).booleanValue()) {
            DrJava.getConfig().setSetting(RecentFileManager.DIALOG_JAROPTIONS_STATE, "default");
        }
    }

    private void initTabbedPanesFrame() {
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_TABBEDPANES_STORE_POSITION).booleanValue()) {
            this._tabbedPanesFrame.setFrameState(DrJava.getConfig().getSetting(RecentFileManager.DIALOG_TABBEDPANES_STATE));
        }
    }

    public void resetTabbedPanesFrame() {
        this._tabbedPanesFrame.setFrameState("default");
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_TABBEDPANES_STORE_POSITION).booleanValue()) {
            DrJava.getConfig().setSetting(RecentFileManager.DIALOG_TABBEDPANES_STATE, "default");
        }
    }

    private void initDebugFrame() {
        if (this._debugFrame == null) {
            return;
        }
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_DEBUGFRAME_STORE_POSITION).booleanValue()) {
            this._debugFrame.setFrameState(DrJava.getConfig().getSetting(RecentFileManager.DIALOG_DEBUGFRAME_STATE));
        }
    }

    public void resetDebugFrame() {
        if (this._debugFrame == null) {
            return;
        }
        this._debugFrame.setFrameState("default");
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_DEBUGFRAME_STORE_POSITION).booleanValue()) {
            DrJava.getConfig().setSetting(RecentFileManager.DIALOG_DEBUGFRAME_STATE, "default");
        }
    }

    public long getLastChangeTime() {
        return this._lastChangeTime;
    }

    @Override
    public void pack() {
        Utilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.packHelp();
            }
        });
    }

    private void packHelp() {
        super.pack();
    }

    public boolean isSaveEnabled() {
        return this._saveAction.isEnabled();
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public void resetClipboardHistoryDialogPosition() {
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_CLIPBOARD_HISTORY_STORE_POSITION).booleanValue()) {
            DrJava.getConfig().setSetting(RecentFileManager.DIALOG_CLIPBOARD_HISTORY_STATE, "default");
        }
    }

    private void _showFindReplaceTab(boolean showDetachedWindow) {
        if (this._mainSplit.getDividerLocation() > this._mainSplit.getMaximumDividerLocation()) {
            this._mainSplit.resetToPreferredSizes();
        }
        boolean wasDisplayed = MainFrame.isDisplayed(this._findReplace);
        this.showTab(this._findReplace, showDetachedWindow);
        if (!wasDisplayed) {
            this._findReplace.beginListeningTo(this._currentDefPane);
        }
        this._findReplace.setVisible(true);
        this._tabbedPane.setSelectedComponent(this._findReplace);
    }

    public void resetGotoFileDialogPosition() {
        this.initGotoFileDialog();
        this._gotoFileDialog.setFrameState("default");
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_GOTOFILE_STORE_POSITION).booleanValue()) {
            DrJava.getConfig().setSetting(RecentFileManager.DIALOG_GOTOFILE_STATE, "default");
        }
    }

    void initGotoFileDialog() {
        if (this._gotoFileDialog == null) {
            PredictiveInputFrame.InfoSupplier<MainFrameStatics.GoToFileListEntry> info = new PredictiveInputFrame.InfoSupplier<MainFrameStatics.GoToFileListEntry>(){

                @Override
                public String value(MainFrameStatics.GoToFileListEntry entry) {
                    StringBuilder sb = new StringBuilder();
                    OpenDefinitionsDocument doc = entry.getOpenDefinitionsDocument();
                    if (doc != null) {
                        try {
                            try {
                                sb.append(FileOps.stringMakeRelativeTo(doc.getRawFile(), doc.getSourceRoot()));
                            }
                            catch (IOException e) {
                                sb.append(doc.getFile());
                            }
                        }
                        catch (FileMovedException e) {
                            sb.append(entry + " was moved");
                        }
                        catch (InvalidPackageException e) {
                            sb.append(entry);
                        }
                    } else {
                        sb.append(entry);
                    }
                    return sb.toString();
                }
            };
            PredictiveInputFrame.CloseAction<MainFrameStatics.GoToFileListEntry> okAction = new PredictiveInputFrame.CloseAction<MainFrameStatics.GoToFileListEntry>(){

                @Override
                public String getName() {
                    return "OK";
                }

                @Override
                public KeyStroke getKeyStroke() {
                    return KeyStroke.getKeyStroke(10, 0);
                }

                @Override
                public String getToolTipText() {
                    return null;
                }

                @Override
                public Object value(PredictiveInputFrame<MainFrameStatics.GoToFileListEntry> p) {
                    block8: {
                        OpenDefinitionsDocument newDoc;
                        if (p.getItem() != null && (newDoc = p.getItem().getOpenDefinitionsDocument()) != null) {
                            boolean docSwitch;
                            boolean docChanged = !newDoc.equals(MainFrame.this._model.getActiveDocument());
                            boolean bl = docSwitch = MainFrame.this._model.getActiveDocument() != newDoc;
                            if (docSwitch) {
                                MainFrame.this._model.setActiveDocument(newDoc);
                            }
                            final int curLine = newDoc.getCurrentLine();
                            String t = p.getText();
                            int last = t.lastIndexOf(58);
                            if (last >= 0) {
                                try {
                                    String end = t.substring(last + 1);
                                    int val = Integer.parseInt(end);
                                    final int lineNum = Math.max(1, val);
                                    Runnable command = new Runnable(){

                                        @Override
                                        public void run() {
                                            try {
                                                MainFrame.this._jumpToLine(lineNum);
                                            }
                                            catch (RuntimeException e) {
                                                MainFrame.this._jumpToLine(curLine);
                                            }
                                        }
                                    };
                                    if (docSwitch) {
                                        EventQueue.invokeLater(command);
                                        break block8;
                                    }
                                    command.run();
                                }
                                catch (RuntimeException e) {}
                            } else if (docChanged) {
                                MainFrame.this.addToBrowserHistory();
                            }
                        }
                    }
                    MainFrame.this.hourglassOff();
                    return null;
                }
            };
            PredictiveInputFrame.CloseAction<MainFrameStatics.GoToFileListEntry> cancelAction = new PredictiveInputFrame.CloseAction<MainFrameStatics.GoToFileListEntry>(){

                @Override
                public String getName() {
                    return "Cancel";
                }

                @Override
                public KeyStroke getKeyStroke() {
                    return KeyStroke.getKeyStroke(27, 0);
                }

                @Override
                public String getToolTipText() {
                    return null;
                }

                @Override
                public Object value(PredictiveInputFrame<MainFrameStatics.GoToFileListEntry> p) {
                    MainFrame.this.hourglassOff();
                    return null;
                }
            };
            ArrayList strategies = new ArrayList();
            strategies.add(new PredictiveInputModel.FragmentLineNumStrategy());
            strategies.add(new PredictiveInputModel.PrefixLineNumStrategy());
            strategies.add(new PredictiveInputModel.RegExLineNumStrategy());
            ArrayList<PredictiveInputFrame.CloseAction<MainFrameStatics.GoToFileListEntry>> actions = new ArrayList<PredictiveInputFrame.CloseAction<MainFrameStatics.GoToFileListEntry>>();
            actions.add(okAction);
            actions.add(cancelAction);
            this._gotoFileDialog = new PredictiveInputFrame<MainFrameStatics.GoToFileListEntry>((SwingFrame)this, "Go to File", true, true, (PredictiveInputFrame.InfoSupplier)info, strategies, actions, 1, new MainFrameStatics.GoToFileListEntry[]{new MainFrameStatics.GoToFileListEntry(null, "dummyGoto")}){

                @Override
                public void setOwnerEnabled(boolean b) {
                    if (b) {
                        MainFrame.this.hourglassOff();
                    } else {
                        MainFrame.this.hourglassOn();
                    }
                }
            };
            if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_GOTOFILE_STORE_POSITION).booleanValue()) {
                this._gotoFileDialog.setFrameState(DrJava.getConfig().getSetting(RecentFileManager.DIALOG_GOTOFILE_STATE));
            }
        }
    }

    void _gotoFileUnderCursor() {
        int end;
        int start;
        OpenDefinitionsDocument odd = this.getCurrentDefPane().getOpenDefDocument();
        String mask = "";
        int loc = this.getCurrentDefPane().getCaretPosition();
        String s = odd.getText();
        for (start = loc; start > 0 && Character.isJavaIdentifierPart(s.charAt(start - 1)); --start) {
        }
        while (start < s.length() && !Character.isJavaIdentifierStart(s.charAt(start)) && start < loc) {
            ++start;
        }
        for (end = loc - 1; end < s.length() - 1 && Character.isJavaIdentifierPart(s.charAt(end + 1)); ++end) {
        }
        if (start >= 0 && end < s.length()) {
            mask = s.substring(start, end + 1);
        }
        this.gotoFileMatchingMask(mask);
    }

    public void gotoFileMatchingMask(String mask) {
        List<OpenDefinitionsDocument> docs = this._model.getOpenDefinitionsDocuments();
        if (docs == null || docs.size() == 0) {
            return;
        }
        MainFrameStatics.GoToFileListEntry currentEntry = null;
        ArrayList<MainFrameStatics.GoToFileListEntry> list = new ArrayList<MainFrameStatics.GoToFileListEntry>(docs.size());
        for (OpenDefinitionsDocument d : docs) {
            MainFrameStatics.GoToFileListEntry entry = new MainFrameStatics.GoToFileListEntry(d, d.toString());
            if (d.equals(this._model.getActiveDocument())) {
                currentEntry = entry;
            }
            list.add(entry);
        }
        PredictiveInputModel pim = new PredictiveInputModel(true, new PredictiveInputModel.PrefixStrategy(), list);
        pim.setMask(mask);
        if (pim.getMatchingItems().size() == 1) {
            OpenDefinitionsDocument newDoc;
            if (pim.getCurrentItem() != null && (newDoc = ((MainFrameStatics.GoToFileListEntry)pim.getCurrentItem()).getOpenDefinitionsDocument()) != null) {
                boolean docChanged = !newDoc.equals(this._model.getActiveDocument());
                this._model.setActiveDocument(newDoc);
                if (docChanged) {
                    this.addToBrowserHistory();
                }
            }
        } else {
            boolean exact = false;
            for (String attemptedExt : OptionConstants.LANGUAGE_LEVEL_EXTENSIONS) {
                OpenDefinitionsDocument newDoc;
                pim.setMask(mask);
                pim.extendMask(attemptedExt);
                if (pim.getMatchingItems().size() != 1) continue;
                exact = true;
                if (pim.getCurrentItem() == null || (newDoc = ((MainFrameStatics.GoToFileListEntry)pim.getCurrentItem()).getOpenDefinitionsDocument()) == null) break;
                boolean docChanged = !newDoc.equals(this._model.getActiveDocument());
                this._model.setActiveDocument(newDoc);
                if (!docChanged) break;
                this.addToBrowserHistory();
                break;
            }
            if (!exact) {
                pim.setMask(mask);
                if (pim.getMatchingItems().size() == 0) {
                    mask = pim.getMask();
                    while (mask.length() > 0) {
                        mask = mask.substring(0, mask.length() - 1);
                        pim.setMask(mask);
                        if (pim.getMatchingItems().size() <= 0) continue;
                    }
                }
                this.initGotoFileDialog();
                this._gotoFileDialog.setModel(true, pim);
                if (currentEntry != null) {
                    this._gotoFileDialog.setCurrentItem(currentEntry);
                }
                this.hourglassOn();
                if (this.isVisible()) {
                    this._gotoFileDialog.setVisible(true);
                }
            }
        }
    }

    public void resetOpenJavadocDialogPosition() {
        this.initOpenJavadocDialog();
        this._openJavadocDialog.setFrameState("default");
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_OPENJAVADOC_STORE_POSITION).booleanValue()) {
            DrJava.getConfig().setSetting(RecentFileManager.DIALOG_OPENJAVADOC_STATE, "default");
        }
    }

    void initOpenJavadocDialog() {
        if (this._openJavadocDialog == null) {
            PredictiveInputFrame.InfoSupplier<MainFrameStatics.JavaAPIListEntry> info = new PredictiveInputFrame.InfoSupplier<MainFrameStatics.JavaAPIListEntry>(){

                @Override
                public String value(MainFrameStatics.JavaAPIListEntry entry) {
                    return entry.getFullString();
                }
            };
            PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry> okAction = new PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry>(){

                @Override
                public String getName() {
                    return "OK";
                }

                @Override
                public KeyStroke getKeyStroke() {
                    return KeyStroke.getKeyStroke(10, 0);
                }

                @Override
                public String getToolTipText() {
                    return null;
                }

                @Override
                public Object value(PredictiveInputFrame<MainFrameStatics.JavaAPIListEntry> p) {
                    if (p.getItem() != null) {
                        PlatformFactory.ONLY.openURL(p.getItem().getURL());
                    }
                    MainFrame.this.hourglassOff();
                    return null;
                }
            };
            PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry> cancelAction = new PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry>(){

                @Override
                public String getName() {
                    return "Cancel";
                }

                @Override
                public KeyStroke getKeyStroke() {
                    return KeyStroke.getKeyStroke(27, 0);
                }

                @Override
                public String getToolTipText() {
                    return null;
                }

                @Override
                public Object value(PredictiveInputFrame<MainFrameStatics.JavaAPIListEntry> p) {
                    MainFrame.this.hourglassOff();
                    return null;
                }
            };
            ArrayList strategies = new ArrayList();
            strategies.add(new PredictiveInputModel.FragmentStrategy());
            strategies.add(new PredictiveInputModel.PrefixStrategy());
            strategies.add(new PredictiveInputModel.RegExStrategy());
            ArrayList<PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry>> actions = new ArrayList<PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry>>();
            actions.add(okAction);
            actions.add(cancelAction);
            this._openJavadocDialog = new PredictiveInputFrame<MainFrameStatics.JavaAPIListEntry>((SwingFrame)this, "Open Java API Javadoc Webpage", true, true, (PredictiveInputFrame.InfoSupplier)info, strategies, actions, 1, new MainFrameStatics.JavaAPIListEntry[]{new MainFrameStatics.JavaAPIListEntry("dummyJavadoc", "dummyJavadoc", null)}){

                @Override
                public void setOwnerEnabled(boolean b) {
                    if (b) {
                        MainFrame.this.hourglassOff();
                    } else {
                        MainFrame.this.hourglassOn();
                    }
                }
            };
            if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_OPENJAVADOC_STORE_POSITION).booleanValue()) {
                this._openJavadocDialog.setFrameState(DrJava.getConfig().getSetting(RecentFileManager.DIALOG_OPENJAVADOC_STATE));
            }
            this.generateJavaAPISet();
        }
    }

    public static Set<MainFrameStatics.JavaAPIListEntry> _generateJavaAPISet(String base, String stripPrefix, String suffix) {
        URL url = MainFrame.class.getResource("/edu/rice/cs/drjava/docs/javaapi" + suffix);
        return MainFrame._generateJavaAPISet(base, stripPrefix, url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<MainFrameStatics.JavaAPIListEntry> _generateJavaAPISet(String base, String stripPrefix, URL url) {
        HashSet<MainFrameStatics.JavaAPIListEntry> s = new HashSet<MainFrameStatics.JavaAPIListEntry>();
        if (url == null) {
            return s;
        }
        try {
            InputStream urls = url.openStream();
            InputStreamReader is = null;
            BufferedReader br = null;
            try {
                is = new InputStreamReader(urls);
                br = new BufferedReader(is);
                String line = br.readLine();
                while (line != null) {
                    String aText = "<a href=\"";
                    int aPos = line.toLowerCase().indexOf("<a href=\"");
                    int aEndPos = line.toLowerCase().indexOf(".html\" ", aPos);
                    if (aPos >= 0 && aEndPos >= 0) {
                        String fullClassName;
                        String link = line.substring(aPos + "<a href=\"".length(), aEndPos);
                        String simpleClassName = fullClassName = link.substring(stripPrefix.length()).replace('/', '.');
                        int lastDot = fullClassName.lastIndexOf(46);
                        if (lastDot >= 0) {
                            simpleClassName = fullClassName.substring(lastDot + 1);
                        }
                        try {
                            URL pageURL = new URL(base + link + ".html");
                            s.add(new MainFrameStatics.JavaAPIListEntry(simpleClassName, fullClassName, pageURL));
                        }
                        catch (MalformedURLException mue) {
                            // empty catch block
                        }
                    }
                    line = br.readLine();
                }
            }
            finally {
                if (br != null) {
                    br.close();
                }
                if (is != null) {
                    is.close();
                }
                if (urls != null) {
                    urls.close();
                }
            }
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return s;
    }

    public Set<MainFrameStatics.GoToFileListEntry> getCompleteClassSet() {
        return this._completeClassSet;
    }

    public void clearCompleteClassSet() {
        this._completeClassSet.clear();
    }

    public void clearJavaAPISet() {
        this._javaAPISet.clear();
    }

    public Set<MainFrameStatics.JavaAPIListEntry> getJavaAPISet() {
        if (this._javaAPISet.size() == 0) {
            this.generateJavaAPISet();
        }
        return this._javaAPISet;
    }

    public void generateJavaAPISet() {
        if (this._javaAPISet.size() == 0) {
            ProcessingDialog pd = new ProcessingDialog((Frame)this, "Java API Classes", "Loading, please wait.", false);
            if (!EventQueue.isDispatchThread()) {
                pd.setVisible(true);
            }
            String linkVersion = DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_API_REF_VERSION);
            String base = "";
            String stripPrefix = "";
            String suffix = "";
            if (linkVersion.equals("use compiler version")) {
                JavaVersion ver = this._model.getCompilerModel().getActiveCompiler().version();
                linkVersion = ver == JavaVersion.JAVA_1_4 ? "1.4" : (ver == JavaVersion.JAVA_5 ? "1.5" : (ver == JavaVersion.JAVA_6 ? "1.6" : (ver == JavaVersion.JAVA_7 ? "1.7" : "1.3")));
            }
            if (linkVersion.equals("1.3")) {
                base = DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_1_3_LINK) + "/";
                stripPrefix = "";
                suffix = "/allclasses-1.3.html";
            } else if (linkVersion.equals("1.4")) {
                base = DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_1_4_LINK) + "/";
                stripPrefix = "";
                suffix = "/allclasses-1.4.html";
            } else if (linkVersion.equals("1.5")) {
                base = DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_1_5_LINK) + "/";
                stripPrefix = "";
                suffix = "/allclasses-1.5.html";
            } else if (linkVersion.equals("1.6")) {
                base = DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_1_6_LINK) + "/";
                stripPrefix = "";
                suffix = "/allclasses-1.6.html";
            } else if (linkVersion.equals("1.7")) {
                base = DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_1_7_LINK) + "/";
                stripPrefix = "";
                suffix = "/allclasses-1.7.html";
            }
            if (!suffix.equals("")) {
                this._javaAPISet.addAll(MainFrame._generateJavaAPISet(base, stripPrefix, suffix));
            }
            Set<MainFrameStatics.JavaAPIListEntry> junitAPIList = MainFrame._generateJavaAPISet(DrJava.getConfig().getSetting(RecentFileManager.JUNIT_LINK) + "/", "", "/allclasses-concjunit4.7.html");
            this._javaAPISet.addAll(junitAPIList);
            for (String url : (Vector)DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_ADDITIONAL_LINKS)) {
                try {
                    Set<MainFrameStatics.JavaAPIListEntry> additionalList = MainFrame._generateJavaAPISet(url + "/", "", new URL(url + "/allclasses-frame.html"));
                    this._javaAPISet.addAll(additionalList);
                }
                catch (MalformedURLException mue) {}
            }
            if (this._javaAPISet.size() == 0) {
                this.clearJavaAPISet();
            }
            if (!EventQueue.isDispatchThread()) {
                pd.setVisible(false);
                pd.dispose();
            }
        }
    }

    private void _openJavadocUnderCursor() {
        this.hourglassOn();
        new Thread(){

            @Override
            public void run() {
                final Set<MainFrameStatics.JavaAPIListEntry> apiSet = MainFrame.this.getJavaAPISet();
                if (apiSet == null) {
                    MainFrame.this.hourglassOff();
                    return;
                }
                Utilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int end;
                        int start;
                        PredictiveInputModel pim = new PredictiveInputModel(true, new PredictiveInputModel.PrefixStrategy(), apiSet);
                        OpenDefinitionsDocument odd = MainFrame.this.getCurrentDefPane().getOpenDefDocument();
                        String mask = "";
                        int loc = MainFrame.this.getCurrentDefPane().getCaretPosition();
                        String s = odd.getText();
                        for (start = loc; start > 0 && Character.isJavaIdentifierPart(s.charAt(start - 1)); --start) {
                        }
                        while (start < s.length() && !Character.isJavaIdentifierStart(s.charAt(start)) && start < loc) {
                            ++start;
                        }
                        for (end = loc - 1; end < s.length() - 1 && Character.isJavaIdentifierPart(s.charAt(end + 1)); ++end) {
                        }
                        if (start >= 0 && end < s.length()) {
                            mask = s.substring(start, end + 1);
                            pim.setMask(mask);
                        }
                        if (pim.getMatchingItems().size() == 1) {
                            if (pim.getCurrentItem() != null) {
                                PlatformFactory.ONLY.openURL(((MainFrameStatics.JavaAPIListEntry)pim.getCurrentItem()).getURL());
                                MainFrame.this.hourglassOff();
                            }
                        } else {
                            boolean exact = false;
                            for (String attemptedExt : OptionConstants.LANGUAGE_LEVEL_EXTENSIONS) {
                                pim.setMask(mask);
                                pim.extendMask(attemptedExt);
                                if (pim.getMatchingItems().size() != 1) continue;
                                exact = true;
                                if (pim.getCurrentItem() == null) break;
                                PlatformFactory.ONLY.openURL(((MainFrameStatics.JavaAPIListEntry)pim.getCurrentItem()).getURL());
                                MainFrame.this.hourglassOff();
                                break;
                            }
                            if (!exact) {
                                pim.setMask(mask);
                                int found = 0;
                                if (pim.getMatchingItems().size() == 0) {
                                    mask = pim.getMask();
                                    while (mask.length() > 0) {
                                        mask = mask.substring(0, mask.length() - 1);
                                        pim.setMask(mask);
                                        if (pim.getMatchingItems().size() <= 0) continue;
                                        break;
                                    }
                                } else {
                                    for (MainFrameStatics.JavaAPIListEntry e : pim.getMatchingItems()) {
                                        if (!e.toString().equalsIgnoreCase(mask)) continue;
                                        ++found;
                                    }
                                }
                                if (found == 1) {
                                    PlatformFactory.ONLY.openURL(((MainFrameStatics.JavaAPIListEntry)pim.getCurrentItem()).getURL());
                                    MainFrame.this.hourglassOff();
                                } else {
                                    MainFrame.this.initOpenJavadocDialog();
                                    MainFrame.this._openJavadocDialog.setModel(true, pim);
                                    MainFrame.this._openJavadocDialog.setVisible(true);
                                }
                            }
                        }
                    }
                });
            }
        }.start();
    }

    private void initCompleteWordDialog() {
        if (this._completeWordDialog == null) {
            this._completeWordDialog = new AutoCompletePopup(this);
        }
    }

    private void _completeWordUnderCursor() {
        this.initCompleteWordDialog();
        this.hourglassOn();
        final OpenDefinitionsDocument odd = this.getCurrentDefPane().getOpenDefDocument();
        int loc = this.getCurrentDefPane().getCaretPosition();
        try {
            String initial = odd.getText(0, loc);
            this._completeWordDialog.show(this, "Complete Word", initial, loc, IterUtil.make("OK", "Fully Qualified"), IterUtil.make(KeyStroke.getKeyStroke(10, 0), KeyStroke.getKeyStroke(10, OptionConstants.MASK)), 0, new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.hourglassOff();
                    MainFrame.this.toFront();
                }
            }, IterUtil.make(new Runnable3<MainFrameStatics.AutoCompletePopupEntry, Integer, Integer>(){

                @Override
                public void run(MainFrameStatics.AutoCompletePopupEntry entry, Integer from, Integer to2) {
                    try {
                        odd.remove(from, to2 - from);
                        odd.insertString(from, entry.getClassName(), null);
                    }
                    catch (BadLocationException ble) {
                        // empty catch block
                    }
                    MainFrame.this.hourglassOff();
                    MainFrame.this.toFront();
                }
            }, new Runnable3<MainFrameStatics.AutoCompletePopupEntry, Integer, Integer>(){

                @Override
                public void run(MainFrameStatics.AutoCompletePopupEntry entry, Integer from, Integer to2) {
                    try {
                        odd.remove(from, to2 - from);
                        odd.insertString(from, entry.getFullPackage() + entry.getClassName(), null);
                    }
                    catch (BadLocationException ble) {
                        // empty catch block
                    }
                    MainFrame.this.hourglassOff();
                    MainFrame.this.toFront();
                }
            }));
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    public void resetCompleteWordDialogPosition() {
        this.initCompleteWordDialog();
        this._completeWordDialog.setFrameState("default");
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_COMPLETE_WORD_STORE_POSITION).booleanValue()) {
            DrJava.getConfig().setSetting(RecentFileManager.DIALOG_COMPLETE_WORD_STATE, "default");
        }
    }

    public void _saveConsoleCopy(ConsoleDocument doc) {
        this._saveChooser.resetChoosableFileFilters();
        this._saveChooser.setFileFilter(this._txtFileFilter);
        this._saveChooser.setMultiSelectionEnabled(false);
        this._saveChooser.setSelectedFile(new File(""));
        try {
            this._model.saveConsoleCopy(doc, new FileSaveSelector(){

                @Override
                public File getFile() throws OperationCanceledException {
                    int rc = MainFrame.this._saveChooser.showSaveDialog(MainFrame.this);
                    switch (rc) {
                        case -1: 
                        case 1: {
                            throw new OperationCanceledException();
                        }
                        case 0: {
                            File chosen = MainFrame.this._saveChooser.getSelectedFile();
                            if (chosen != null) {
                                if (chosen.getName().indexOf(".") == -1) {
                                    return new File(chosen.getAbsolutePath() + ".txt");
                                }
                                return chosen;
                            }
                            throw new RuntimeException("Filechooser returned null file");
                        }
                    }
                    throw new RuntimeException("Filechooser returned bad rc " + rc);
                }

                @Override
                public boolean warnFileOpen(File f) {
                    return MainFrame.this._warnFileOpen(f);
                }

                @Override
                public boolean verifyOverwrite(File f) {
                    return MainFrameStatics.verifyOverwrite(MainFrame.this, f);
                }

                @Override
                public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
                    return true;
                }

                @Override
                public boolean shouldUpdateDocumentState() {
                    return false;
                }
            });
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, new IOException("An error occured writing the contents to a file"));
        }
    }

    public void _saveDocumentCopy(final SwingDocument doc) {
        assert (EventQueue.isDispatchThread());
        this._saveChooser.resetChoosableFileFilters();
        this._saveChooser.setFileFilter(this._txtFileFilter);
        this._saveChooser.setMultiSelectionEnabled(false);
        this._saveChooser.setSelectedFile(new File(""));
        try {
            FileSaveSelector selector = new FileSaveSelector(){

                @Override
                public File getFile() throws OperationCanceledException {
                    int rc = MainFrame.this._saveChooser.showSaveDialog(MainFrame.this);
                    switch (rc) {
                        case -1: 
                        case 1: {
                            throw new OperationCanceledException();
                        }
                        case 0: {
                            File chosen = MainFrame.this._saveChooser.getSelectedFile();
                            if (chosen != null) {
                                if (chosen.getName().indexOf(".") == -1) {
                                    return new File(chosen.getAbsolutePath() + ".txt");
                                }
                                return chosen;
                            }
                            throw new RuntimeException("Filechooser returned null file");
                        }
                    }
                    throw new RuntimeException("Filechooser returned bad rc " + rc);
                }

                @Override
                public boolean warnFileOpen(File f) {
                    return MainFrame.this._warnFileOpen(f);
                }

                @Override
                public boolean verifyOverwrite(File f) {
                    return MainFrameStatics.verifyOverwrite(MainFrame.this, f);
                }

                @Override
                public boolean shouldSaveAfterFileMoved(OpenDefinitionsDocument doc, File oldFile) {
                    return true;
                }

                @Override
                public boolean shouldUpdateDocumentState() {
                    return false;
                }
            };
            try {
                File file = selector.getFile();
                if (!file.getCanonicalFile().exists() || selector.verifyOverwrite(file)) {
                    FileOps.saveFile(new FileOps.DefaultFileSaver(file){

                        @Override
                        public void saveTo(OutputStream os) throws IOException {
                            String text = doc.getText();
                            OutputStreamWriter osw = new OutputStreamWriter(os);
                            osw.write(text, 0, text.length());
                            osw.flush();
                        }
                    });
                }
            }
            catch (OperationCanceledException oce) {
                return;
            }
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, new IOException("An error occured writing the contents to a file"));
        }
    }

    private void _doResetInteractions() {
        this._tabbedPane.setSelectedIndex(0);
        this.updateStatusField("Resetting Interactions");
        this._interactionsPane.discardUndoEdits();
        new Thread(new Runnable(){

            @Override
            public void run() {
                MainFrame.this._model.resetInteractions(MainFrame.this._model.getWorkingDirectory(), true);
                MainFrame.this._closeSystemInAction.setEnabled(true);
            }
        }).start();
    }

    public void viewInteractionsClassPath() {
        String cp = IterUtil.multilineToString(IterUtil.filter(this._model.getInteractionsClassPath(), new Predicate<File>(){
            HashSet<File> alreadySeen = new HashSet();

            @Override
            public boolean contains(File arg) {
                return !"".equals(arg.toString().trim()) && this.alreadySeen.add(arg);
            }
        }));
        new DrJavaScrollableDialog(this, "Interactions Classpath", "Current Interpreter Classpath", cp).show();
    }

    private void _switchToPane(Component c) {
        Component newC = c;
        this.showTab(newC, true);
    }

    private void _switchPaneFocus(boolean next) {
        int numTabs = this._tabbedPane.getTabCount();
        if (next) {
            this._switchToPane(this._tabbedPane.getComponentAt((numTabs + this._tabbedPane.getSelectedIndex() + 1) % numTabs));
        } else {
            this._switchToPane(this._tabbedPane.getComponentAt((numTabs + this._tabbedPane.getSelectedIndex() - 1) % numTabs));
        }
    }

    public void editPreferences() {
        this._configFrame.setUp();
        this.setPopupLoc(this._configFrame);
        this._configFrame.resetToCurrent();
        this._configFrame.setVisible(true);
        this._configFrame.toFront();
    }

    public void setAutomaticTraceMenuItemStatus() {
        if (this._automaticTraceMenuItem != null) {
            this._automaticTraceMenuItem.setSelected(this._model.getDebugger().isAutomaticTraceEnabled());
        }
    }

    public void toggleBookmark() {
        assert (EventQueue.isDispatchThread());
        this.addToBrowserHistory();
        this._model._toggleBookmark(this._currentDefPane.getSelectionStart(), this._currentDefPane.getSelectionEnd());
        this.showTab(this._bookmarksPanel, true);
    }

    public void addToBrowserHistory() {
        this._model.addToBrowserHistory();
    }

    public void addToBrowserHistoryBefore() {
        this._model.addToBrowserHistory(true);
    }

    public FindResultsPanel createFindResultsPanel(final RegionManager<MovingDocumentRegion> rm, MovingDocumentRegion region, String title, String searchString, boolean searchAll, boolean searchSelectionOnly, boolean matchCase, boolean wholeWord, boolean noComments, boolean noTestCases, WeakReference<OpenDefinitionsDocument> doc, FindReplacePanel findReplace) {
        final FindResultsPanel panel = new FindResultsPanel(this, rm, region, title, searchString, searchAll, searchSelectionOnly, matchCase, wholeWord, noComments, noTestCases, doc, findReplace);
        final IdentityHashMap highlights = new IdentityHashMap();
        final Pair pair = new Pair(panel, highlights);
        this._findResults.add(pair);
        rm.addListener(new RegionManagerListener<MovingDocumentRegion>(){

            @Override
            public void regionAdded(MovingDocumentRegion r) {
                DefinitionsPane pane = MainFrame.this.getDefPaneGivenODD(r.getDocument());
                highlights.put(r, pane.getHighlightManager().addHighlight(r.getStartOffset(), r.getEndOffset(), panel.getSelectedPainter()));
            }

            @Override
            public void regionChanged(MovingDocumentRegion r) {
                this.regionRemoved(r);
                this.regionAdded(r);
            }

            @Override
            public void regionRemoved(MovingDocumentRegion r) {
                HighlightManager.HighlightInfo highlight = (HighlightManager.HighlightInfo)highlights.get(r);
                if (highlight != null) {
                    highlight.remove();
                }
                highlights.remove(r);
                if (rm.getDocuments().isEmpty()) {
                    panel._close();
                }
            }
        });
        panel.addCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                MainFrame.this._findResults.remove(pair);
            }
        });
        this._tabs.addLast(panel);
        panel.getMainPanel().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MainFrame.this._lastFocusOwner = panel;
            }
        });
        return panel;
    }

    void disableFindAgainOnClose(List<OpenDefinitionsDocument> projDocs) {
        for (TabbedPanel t : this._tabs) {
            FindResultsPanel p;
            if (!(t instanceof FindResultsPanel) || !projDocs.contains((p = (FindResultsPanel)t).getDocument())) continue;
            p.disableFindAgain();
        }
    }

    public void showFindResultsPanel(final FindResultsPanel panel) {
        assert (EventQueue.isDispatchThread());
        if (this._mainSplit.getDividerLocation() > this._mainSplit.getMaximumDividerLocation()) {
            this._mainSplit.resetToPreferredSizes();
        }
        this.showTab(panel, true);
        panel.updatePanel();
        this._tabbedPane.setSelectedComponent(panel);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                panel.requestFocusInWindow();
            }
        });
    }

    private int _getBeginLinePos() {
        try {
            int currPos = this._currentDefPane.getCaretPosition();
            OpenDefinitionsDocument openDoc = this._model.getActiveDocument();
            openDoc.setCurrentLocation(currPos);
            return openDoc.getIntelligentBeginLinePos(currPos);
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    private void _closeInteractionsScript() {
        if (this._interactionsScriptController != null) {
            this._interactionsContainer.remove(this._interactionsScriptPane);
            this._interactionsScriptController = null;
            this._interactionsScriptPane = null;
            this._tabbedPane.invalidate();
            this._tabbedPane.repaint();
        }
    }

    public static DJFileDisplayManager getFileDisplayManager20() {
        return _djFileDisplayManager20;
    }

    public static DJFileDisplayManager getFileDisplayManager30() {
        return _djFileDisplayManager30;
    }

    public static OddDisplayManager getOddDisplayManager20() {
        return _oddDisplayManager20;
    }

    public static OddDisplayManager getOddDisplayManager30() {
        return _oddDisplayManager30;
    }

    public DisplayManager<INavigatorItem> getNavPaneDisplayManager() {
        return this._navPaneDisplayManager;
    }

    public MainFrame() {
        Utilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                block32: {
                    FileConfiguration config = DrJava.getConfig();
                    assert (MainFrame.this._historyListener != null);
                    MainFrame.this._model = new DefaultGlobalModel();
                    MainFrame.this._showDebugger = MainFrame.this._model.getDebugger().isAvailable();
                    MainFrame.this._findReplace = new FindReplacePanel(MainFrame.this, MainFrame.this._model);
                    Utilities.enableDisableWith(((MainFrame)MainFrame.this)._findReplace._findNextAction, MainFrame.this._findNextAction);
                    Utilities.enableDisableWith(((MainFrame)MainFrame.this)._findReplace._findPreviousAction, MainFrame.this._findPrevAction);
                    if (MainFrame.this._showDebugger) {
                        MainFrame.this._debugPanel = new DebugPanel(MainFrame.this);
                        MainFrame.this._breakpointsPanel = new BreakpointsPanel(MainFrame.this, MainFrame.this._model.getBreakpointManager());
                    } else {
                        MainFrame.this._debugPanel = null;
                        MainFrame.this._breakpointsPanel = null;
                    }
                    MainFrame.this._compilerErrorPanel = new CompilerErrorPanel(MainFrame.this._model, MainFrame.this);
                    MainFrame.this._consoleController = new ConsoleController(MainFrame.this._model.getConsoleDocument(), MainFrame.this._model.getSwingConsoleDocument());
                    MainFrame.this._consolePane = MainFrame.this._consoleController.getPane();
                    MainFrame.this._consoleScroll = new BorderlessScrollPane(MainFrame.this._consolePane){

                        @Override
                        public boolean requestFocusInWindow() {
                            super.requestFocusInWindow();
                            return MainFrame.this._consolePane.requestFocusInWindow();
                        }
                    };
                    MainFrame.this._interactionsController = new InteractionsController(MainFrame.this._model.getInteractionsModel(), MainFrame.this._model.getSwingInteractionsDocument(), new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.this._closeSystemInAction.setEnabled(false);
                        }
                    });
                    MainFrame.this._interactionsPane = MainFrame.this._interactionsController.getPane();
                    MainFrame.this._interactionsContainer = new JPanel(new BorderLayout());
                    MainFrame.this._lastFocusOwner = MainFrame.this._interactionsContainer;
                    MainFrame.this._junitPanel = new JUnitPanel(MainFrame.this._model, MainFrame.this);
                    MainFrame.this._javadocErrorPanel = new JavadocErrorPanel(MainFrame.this._model, MainFrame.this);
                    MainFrame.this._bookmarksPanel = new BookmarksPanel(MainFrame.this, MainFrame.this._model.getBookmarkManager());
                    MainFrame.this._setUpStatusBar();
                    DefinitionsPane.setEditorKit(MainFrame.this._model.getEditorKit());
                    MainFrame.this._defScrollPanes = new HashMap();
                    MainFrame.this._tabbedPane.setFocusable(false);
                    MainFrame.this._tabbedPane.addFocusListener(MainFrame.this._focusListenerForRecentDocs);
                    MainFrame.this._tabbedPane.addKeyListener(MainFrame.this._historyListener);
                    if (Utilities.isPlasticLaf()) {
                        MainFrame.this._tabbedPane.putClientProperty("jgoodies.embeddedTabs", Boolean.TRUE);
                    }
                    JScrollPane defScroll = MainFrame.this._createDefScrollPane(MainFrame.this._model.getActiveDocument());
                    MainFrame.this._docSplitPane = new BorderlessSplitPane(1, true, new JScrollPane(MainFrame.this._model.getDocumentNavigator().asContainer()), defScroll);
                    MainFrame.this._debugSplitPane = new BorderlessSplitPane(0, true);
                    MainFrame.this._mainSplit = new JSplitPane(0, true, MainFrame.this._docSplitPane, MainFrame.this._tabbedPane);
                    MainFrame.this._model.getDocumentNavigator().asContainer().addKeyListener(MainFrame.this._historyListener);
                    MainFrame.this._model.getDocumentNavigator().asContainer().addFocusListener(MainFrame.this._focusListenerForRecentDocs);
                    MainFrame.this._model.getDocumentNavigator().asContainer().addMouseListener(MainFrame.this._resetFindReplaceListener);
                    if (MainFrame.this._showDebugger) {
                        MainFrame.this._model.getDebugger().addListener(new UIDebugListener());
                    }
                    MainFrame.this._debugStepTimer = new Timer(3000, new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (!MainFrame.this._model.getDebugger().isAutomaticTraceEnabled()) {
                                MainFrame.this._model.printDebugMessage("Stepping ...");
                            }
                        }
                    });
                    MainFrame.this._debugStepTimer.setRepeats(false);
                    File workDir = MainFrame.this._model.getMasterWorkingDirectory();
                    MainFrame.this._openChooser = new JFileChooser(){

                        @Override
                        public void setCurrentDirectory(File dir) {
                            super.setCurrentDirectory(dir);
                            this.setDialogTitle("Open:  " + this.getCurrentDirectory());
                        }
                    };
                    MainFrame.this._openChooser.setPreferredSize(new Dimension(650, 410));
                    MainFrame.this._openChooser.setCurrentDirectory(workDir);
                    MainFrame.this._openChooser.resetChoosableFileFilters();
                    MainFrame.this._openChooser.setFileFilter(MainFrame.this.getSourceFileFilter());
                    MainFrame.this._openChooser.setMultiSelectionEnabled(true);
                    MainFrame.this._openRecursiveCheckBox.setSelected(config.getSetting(OptionConstants.OPEN_FOLDER_RECURSIVE));
                    MainFrame.this._folderChooser = MainFrame.this.makeFolderChooser(workDir);
                    Vector recentProjects = (Vector)config.getSetting(RecentFileManager.RECENT_PROJECTS);
                    MainFrame.this._openProjectChooser = new JFileChooser();
                    MainFrame.this._openProjectChooser.setPreferredSize(new Dimension(650, 410));
                    if (recentProjects.size() > 0 && ((File)recentProjects.elementAt(0)).getParentFile() != null) {
                        MainFrame.this._openProjectChooser.setCurrentDirectory(((File)recentProjects.elementAt(0)).getParentFile());
                    } else {
                        MainFrame.this._openProjectChooser.setCurrentDirectory(workDir);
                    }
                    MainFrame.this._openProjectChooser.resetChoosableFileFilters();
                    MainFrame.this._openProjectChooser.setFileFilter(MainFrame.this._projectFilter);
                    MainFrame.this._openProjectChooser.setMultiSelectionEnabled(false);
                    MainFrame.this._saveChooser = new JFileChooser(){

                        @Override
                        public void setCurrentDirectory(File dir) {
                            super.setCurrentDirectory(dir);
                            this.setDialogTitle("Save:  " + this.getCurrentDirectory());
                        }
                    };
                    MainFrame.this._saveChooser.setPreferredSize(new Dimension(650, 410));
                    MainFrame.this._saveChooser.setCurrentDirectory(workDir);
                    MainFrame.this._saveChooser.resetChoosableFileFilters();
                    MainFrame.this._saveChooser.setFileFilter(MainFrame.this.getSourceFileFilter());
                    MainFrame.this._interactionsHistoryChooser.setPreferredSize(new Dimension(650, 410));
                    MainFrame.this._interactionsHistoryChooser.setCurrentDirectory(workDir);
                    MainFrame.this._interactionsHistoryChooser.resetChoosableFileFilters();
                    MainFrame.this._interactionsHistoryChooser.setFileFilter(new InteractionsHistoryFilter());
                    MainFrame.this._interactionsHistoryChooser.setMultiSelectionEnabled(true);
                    MainFrame.this.setGlassPane(new GlassPane());
                    MainFrame.this.setDefaultCloseOperation(0);
                    MainFrame.this.addWindowListener(MainFrame.this._windowCloseListener);
                    MainFrame.this._mainListener = new ModelListener();
                    MainFrame.this._model.addListener(MainFrame.this._mainListener);
                    MainFrame.this._setUpTabs();
                    MainFrame.this._recentDocFrame = new RecentDocFrame(MainFrame.this);
                    OpenDefinitionsDocument activeDoc = MainFrame.this._model.getActiveDocument();
                    MainFrame.this._recentDocFrame.pokeDocument(activeDoc);
                    MainFrame.this._currentDefDoc = activeDoc.getDocument();
                    MainFrame.this._currentDefPane = (DefinitionsPane)defScroll.getViewport().getView();
                    MainFrame.this._currentDefPane.notifyActive();
                    MainFrame.this._currentDefPane.addFocusListener(MainFrame.this._undoRedoDefinitionsFocusListener);
                    int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                    KeyBindingManager.ONLY.setMainFrame(MainFrame.this);
                    MainFrame.this._setUpKeyBindingMaps();
                    MainFrame.this._posListener.updateLocation();
                    MainFrame.this._undoAction.setDelegatee(MainFrame.this._currentDefPane.getUndoAction());
                    MainFrame.this._redoAction.setDelegatee(MainFrame.this._currentDefPane.getRedoAction());
                    MainFrame.this._compilerErrorPanel.reset();
                    MainFrame.this._junitPanel.reset();
                    MainFrame.this._javadocErrorPanel.reset();
                    MainFrame.this._fileMenu = MainFrame.this._setUpFileMenu(mask, true);
                    MainFrame.this._editMenu = MainFrame.this._setUpEditMenu(mask, true);
                    MainFrame.this._toolsMenu = MainFrame.this._setUpToolsMenu(mask, true);
                    MainFrame.this._projectMenu = MainFrame.this._setUpProjectMenu(mask, true);
                    MainFrame.this._debugMenu = null;
                    if (MainFrame.this._showDebugger) {
                        MainFrame.this._debugMenu = MainFrame.this._setUpDebugMenu(mask, true);
                    }
                    MainFrame.this._languageLevelMenu = MainFrame.this._setUpLanguageLevelMenu(mask, true);
                    MainFrame.this._helpMenu = MainFrame.this._setUpHelpMenu(mask, true);
                    MainFrame.this._setUpActions();
                    MainFrame.this._setUpMenuBar(MainFrame.this._menuBar, MainFrame.this._fileMenu, MainFrame.this._editMenu, MainFrame.this._toolsMenu, MainFrame.this._projectMenu, MainFrame.this._debugMenu, MainFrame.this._languageLevelMenu, MainFrame.this._helpMenu);
                    MainFrame.this.setJMenuBar(MainFrame.this._menuBar);
                    MainFrame.this._setUpContextMenus();
                    MainFrame.this._undoButton = MainFrame.this._createManualToolbarButton(MainFrame.this._undoAction);
                    MainFrame.this._redoButton = MainFrame.this._createManualToolbarButton(MainFrame.this._redoAction);
                    MainFrame.this._setUpToolBar();
                    MainFrame.this._setUpGUIComponentAvailability();
                    RecentFileManager.RecentFileAction fileAct = new RecentFileManager.RecentFileAction(){

                        @Override
                        public void actionPerformed(FileOpenSelector selector) {
                            MainFrame.this.open(selector);
                        }
                    };
                    MainFrame.this._recentFileManager = new RecentFileManager(MainFrame.this._fileMenu.getItemCount() - 2, MainFrame.this._fileMenu, fileAct, OptionConstants.RECENT_FILES);
                    RecentFileManager.RecentFileAction projAct = new RecentFileManager.RecentFileAction(){

                        @Override
                        public void actionPerformed(FileOpenSelector selector) {
                            MainFrame.this.openProject(selector);
                        }
                    };
                    MainFrame.this._recentProjectManager = new RecentFileManager(MainFrame.this._projectMenu.getItemCount() - 2, MainFrame.this._projectMenu, projAct, OptionConstants.RECENT_PROJECTS);
                    MainFrame.this._tabbedPanesFrame = new DetachedFrame("Tabbed Panes", MainFrame.this, new Runnable1<DetachedFrame>(){

                        @Override
                        public void run(DetachedFrame frame) {
                            frame.getContentPane().add(MainFrame.this._tabbedPane);
                        }
                    }, new Runnable1<DetachedFrame>(){

                        @Override
                        public void run(DetachedFrame frame) {
                            MainFrame.this._mainSplit.setBottomComponent(MainFrame.this._tabbedPane);
                        }
                    });
                    MainFrame.this._tabbedPanesFrame.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent we) {
                            MainFrame.this._detachTabbedPanesMenuItem.setSelected(false);
                            DrJava.getConfig().setSetting(RecentFileManager.DETACH_TABBEDPANES, false);
                        }
                    });
                    MainFrame.this._tabbedPanesFrame.setUpMenuBar();
                    if (MainFrame.this._debugPanel != null) {
                        MainFrame.this._debugFrame = new DetachedFrame("Debugger", MainFrame.this, new Runnable1<DetachedFrame>(){

                            @Override
                            public void run(DetachedFrame frame) {
                                frame.getContentPane().add(MainFrame.this._debugPanel);
                            }
                        }, new Runnable1<DetachedFrame>(){

                            @Override
                            public void run(DetachedFrame frame) {
                                MainFrame.this._debugSplitPane.setTopComponent(MainFrame.this._docSplitPane);
                                MainFrame.this._debugSplitPane.setBottomComponent(MainFrame.this._debugPanel);
                                MainFrame.this._mainSplit.setTopComponent(MainFrame.this._debugSplitPane);
                            }
                        });
                        MainFrame.this._debugFrame.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowClosing(WindowEvent we) {
                                if (MainFrame.this._debugFrame == null) {
                                    return;
                                }
                                MainFrame.this._detachDebugFrameMenuItem.setSelected(false);
                                DrJava.getConfig().setSetting(RecentFileManager.DETACH_DEBUGGER, false);
                            }
                        });
                        MainFrame.this._debugFrame.setUpMenuBar();
                    } else {
                        MainFrame.this._debugFrame = null;
                    }
                    MainFrame.this.setIconImage(MainFrame.getIcon("drjava64.png").getImage());
                    int x = config.getSetting(RecentFileManager.WINDOW_X);
                    int y = config.getSetting(RecentFileManager.WINDOW_Y);
                    int width = config.getSetting(RecentFileManager.WINDOW_WIDTH);
                    int height = config.getSetting(RecentFileManager.WINDOW_HEIGHT);
                    int state = config.getSetting(RecentFileManager.WINDOW_STATE);
                    Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                    int menubarHeight = 24;
                    if (height > screenSize.height - 24) {
                        height = screenSize.height - 24;
                    }
                    if (width > screenSize.width) {
                        width = screenSize.width;
                    }
                    Rectangle bounds = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration().getBounds();
                    if (x == Integer.MAX_VALUE) {
                        x = (bounds.width - width + bounds.x) / 2;
                    }
                    if (y == Integer.MAX_VALUE) {
                        y = (bounds.height - height + bounds.y) / 2;
                    }
                    if (x < bounds.x) {
                        x = bounds.x;
                    }
                    if (y < bounds.y) {
                        y = bounds.y;
                    }
                    if (x + width > bounds.x + bounds.width) {
                        x = bounds.width - width + bounds.x;
                    }
                    if (y + height > bounds.y + bounds.height) {
                        y = bounds.height - height + bounds.y;
                    }
                    if (!Toolkit.getDefaultToolkit().isFrameStateSupported(state &= 0xFFFFFFFE)) {
                        state = (Integer)RecentFileManager.WINDOW_STATE.getDefault();
                    }
                    MainFrame.this.setBounds(x, y, width, height);
                    final int stateCopy = state;
                    MainFrame.this.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowOpened(WindowEvent e) {
                            MainFrame.this.setExtendedState(stateCopy);
                            MainFrame.this.removeWindowListener(this);
                        }
                    });
                    MainFrame.this._setUpPanes();
                    MainFrame.this.updateStatusField();
                    MainFrame.this._promptBeforeQuit = config.getSetting(RecentFileManager.QUIT_PROMPT);
                    MainFrame.this._setMainFont();
                    Font doclistFont = config.getSetting(RecentFileManager.FONT_DOCLIST);
                    MainFrame.this._model.getDocCollectionWidget().setFont(doclistFont);
                    MainFrame.this._updateNormalColor();
                    MainFrame.this._updateBackgroundColor();
                    config.addOptionListener(RecentFileManager.DEFINITIONS_NORMAL_COLOR, new NormalColorOptionListener());
                    config.addOptionListener(RecentFileManager.DEFINITIONS_BACKGROUND_COLOR, new BackgroundColorOptionListener());
                    config.addOptionListener(RecentFileManager.FONT_MAIN, new MainFontOptionListener());
                    config.addOptionListener(RecentFileManager.FONT_LINE_NUMBERS, new LineNumbersFontOptionListener());
                    config.addOptionListener(RecentFileManager.FONT_DOCLIST, new DoclistFontOptionListener());
                    config.addOptionListener(RecentFileManager.FONT_TOOLBAR, new ToolbarFontOptionListener());
                    config.addOptionListener(RecentFileManager.TOOLBAR_ICONS_ENABLED, new ToolbarOptionListener());
                    config.addOptionListener(RecentFileManager.TOOLBAR_TEXT_ENABLED, new ToolbarOptionListener());
                    config.addOptionListener(RecentFileManager.TOOLBAR_ENABLED, new ToolbarOptionListener());
                    config.addOptionListener(RecentFileManager.LINEENUM_ENABLED, new LineEnumOptionListener());
                    config.addOptionListener(RecentFileManager.DEFINITIONS_LINE_NUMBER_COLOR, new LineEnumColorOptionListener());
                    config.addOptionListener(RecentFileManager.DEFINITIONS_LINE_NUMBER_BACKGROUND_COLOR, new LineEnumColorOptionListener());
                    config.addOptionListener(RecentFileManager.QUIT_PROMPT, new QuitPromptOptionListener());
                    config.addOptionListener(RecentFileManager.RECENT_FILES_MAX_SIZE, new RecentFilesOptionListener());
                    OptionListener<Font> fontListener = new OptionListener<Font>(){

                        @Override
                        public void optionChanged(OptionEvent<Font> oce) {
                            FontMetrics metrics = MainFrame.this.getFontMetrics((Font)oce.value);
                            DefinitionsPane.updateMaxCharWidth(metrics);
                        }
                    };
                    DrJava.getConfig().addOptionListener(OptionConstants.FONT_MAIN, fontListener);
                    DefinitionsPane.updateMaxCharWidth(MainFrame.this.getFontMetrics(DrJava.getConfig().getSetting(RecentFileManager.FONT_MAIN)));
                    config.addOptionListener(RecentFileManager.FORCE_TEST_SUFFIX, new OptionListener<Boolean>(){

                        @Override
                        public void optionChanged(OptionEvent<Boolean> oce) {
                            MainFrame.this._model.getJUnitModel().setForceTestSuffix((Boolean)oce.value);
                        }
                    });
                    OptionListener<String> choiceOptionListener = new OptionListener<String>(){

                        @Override
                        public void optionChanged(OptionEvent<String> oce) {
                            MainFrame.this.clearJavaAPISet();
                        }
                    };
                    DrJava.getConfig().addOptionListener(RecentFileManager.JAVADOC_API_REF_VERSION, choiceOptionListener);
                    OptionListener<String> link13OptionListener = new OptionListener<String>(){

                        @Override
                        public void optionChanged(OptionEvent<String> oce) {
                            String linkVersion = DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_API_REF_VERSION);
                            if (linkVersion.equals("1.3") || linkVersion.equals("use compiler version")) {
                                MainFrame.this.clearJavaAPISet();
                            }
                        }
                    };
                    DrJava.getConfig().addOptionListener(RecentFileManager.JAVADOC_1_3_LINK, link13OptionListener);
                    OptionListener<String> link14OptionListener = new OptionListener<String>(){

                        @Override
                        public void optionChanged(OptionEvent<String> oce) {
                            String linkVersion = DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_API_REF_VERSION);
                            if (linkVersion.equals("1.4") || linkVersion.equals("use compiler version")) {
                                MainFrame.this.clearJavaAPISet();
                            }
                        }
                    };
                    DrJava.getConfig().addOptionListener(RecentFileManager.JAVADOC_1_4_LINK, link14OptionListener);
                    OptionListener<String> link15OptionListener = new OptionListener<String>(){

                        @Override
                        public void optionChanged(OptionEvent<String> oce) {
                            String linkVersion = DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_API_REF_VERSION);
                            if (linkVersion.equals("1.5") || linkVersion.equals("use compiler version")) {
                                MainFrame.this.clearJavaAPISet();
                            }
                        }
                    };
                    DrJava.getConfig().addOptionListener(RecentFileManager.JAVADOC_1_5_LINK, link15OptionListener);
                    OptionListener<String> link16OptionListener = new OptionListener<String>(){

                        @Override
                        public void optionChanged(OptionEvent<String> oce) {
                            String linkVersion = DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_API_REF_VERSION);
                            if (linkVersion.equals("1.6") || linkVersion.equals("use compiler version")) {
                                MainFrame.this.clearJavaAPISet();
                            }
                        }
                    };
                    DrJava.getConfig().addOptionListener(RecentFileManager.JAVADOC_1_6_LINK, link16OptionListener);
                    OptionListener<String> linkJUnitOptionListener = new OptionListener<String>(){

                        @Override
                        public void optionChanged(OptionEvent<String> oce) {
                            MainFrame.this.clearJavaAPISet();
                        }
                    };
                    DrJava.getConfig().addOptionListener(RecentFileManager.JUNIT_LINK, linkJUnitOptionListener);
                    OptionListener<Vector<String>> additionalLinkOptionListener = new OptionListener<Vector<String>>(){

                        @Override
                        public void optionChanged(OptionEvent<Vector<String>> oce) {
                            MainFrame.this.clearJavaAPISet();
                        }
                    };
                    DrJava.getConfig().addOptionListener(RecentFileManager.JAVADOC_ADDITIONAL_LINKS, additionalLinkOptionListener);
                    OptionListener<Boolean> scanClassesOptionListener = new OptionListener<Boolean>(){

                        @Override
                        public void optionChanged(OptionEvent<Boolean> oce) {
                            MainFrame.this.clearCompleteClassSet();
                        }
                    };
                    DrJava.getConfig().addOptionListener(RecentFileManager.DIALOG_COMPLETE_SCAN_CLASS_FILES, scanClassesOptionListener);
                    MainFrame.this._configFrame = new ConfigFrame(MainFrame.this);
                    MainFrame.this._aboutDialog = new AboutDialog(MainFrame.this);
                    MainFrame.this._interactionsScriptController = null;
                    MainFrame.this._executeExternalDialog = new ExecuteExternalDialog(MainFrame.this);
                    MainFrame.this._editExternalDialog = new EditExternalDialog(MainFrame.this);
                    MainFrame.this._jarOptionsDialog = new JarOptionsDialog(MainFrame.this);
                    MainFrame.this.initTabbedPanesFrame();
                    MainFrame.this.initDebugFrame();
                    MainFrame.this.initJarOptionsDialog();
                    MainFrame.this.initExecuteExternalProcessDialog();
                    config.addOptionListener(RecentFileManager.DISPLAY_ALL_COMPILER_VERSIONS, new ConfigOptionListeners.DisplayAllCompilerVersionsListener(MainFrame.this._configFrame));
                    config.addOptionListener(RecentFileManager.LOOK_AND_FEEL, new ConfigOptionListeners.LookAndFeelListener(MainFrame.this._configFrame));
                    config.addOptionListener(RecentFileManager.PLASTIC_THEMES, new ConfigOptionListeners.PlasticThemeListener(MainFrame.this._configFrame));
                    ConfigOptionListeners.SlaveJVMArgsListener slaveJVMArgsListener = new ConfigOptionListeners.SlaveJVMArgsListener(MainFrame.this._configFrame);
                    config.addOptionListener(RecentFileManager.SLAVE_JVM_ARGS, slaveJVMArgsListener);
                    MainFrame.this._slaveJvmXmxListener = new ConfigOptionListeners.SlaveJVMXMXListener(MainFrame.this._configFrame);
                    config.addOptionListener(RecentFileManager.SLAVE_JVM_XMX, MainFrame.this._slaveJvmXmxListener);
                    ConfigOptionListeners.MasterJVMArgsListener masterJVMArgsListener = new ConfigOptionListeners.MasterJVMArgsListener(MainFrame.this._configFrame);
                    config.addOptionListener(RecentFileManager.MASTER_JVM_ARGS, masterJVMArgsListener);
                    MainFrame.this._masterJvmXmxListener = new ConfigOptionListeners.MasterJVMXMXListener(MainFrame.this._configFrame);
                    config.addOptionListener(RecentFileManager.MASTER_JVM_XMX, MainFrame.this._masterJvmXmxListener);
                    config.addOptionListener(RecentFileManager.JAVADOC_CUSTOM_PARAMS, new ConfigOptionListeners.JavadocCustomParamsListener(MainFrame.this._configFrame));
                    ConfigOptionListeners.sanitizeSlaveJVMArgs(MainFrame.this, config.getSetting(RecentFileManager.SLAVE_JVM_ARGS), slaveJVMArgsListener);
                    ConfigOptionListeners.sanitizeSlaveJVMXMX(MainFrame.this, config.getSetting(RecentFileManager.SLAVE_JVM_XMX));
                    ConfigOptionListeners.sanitizeMasterJVMArgs(MainFrame.this, config.getSetting(RecentFileManager.MASTER_JVM_ARGS), masterJVMArgsListener);
                    ConfigOptionListeners.sanitizeMasterJVMXMX(MainFrame.this, config.getSetting(RecentFileManager.MASTER_JVM_XMX));
                    ConfigOptionListeners.sanitizeJavadocCustomParams(MainFrame.this, config.getSetting(RecentFileManager.JAVADOC_CUSTOM_PARAMS));
                    config.addOptionListener(RecentFileManager.REMOTE_CONTROL_ENABLED, new ConfigOptionListeners.RequiresDrJavaRestartListener(MainFrame.this._configFrame, "Remote Control"));
                    config.addOptionListener(RecentFileManager.REMOTE_CONTROL_PORT, new ConfigOptionListeners.RequiresDrJavaRestartListener(MainFrame.this._configFrame, "Remote Control Port"));
                    config.addOptionListener(RecentFileManager.DEFAULT_COMPILER_PREFERENCE, new ConfigOptionListeners.DefaultCompilerListener(MainFrame.this._configFrame));
                    MainFrame.this._showConfigException();
                    KeyBindingManager.ONLY.setShouldCheckConflict(false);
                    PlatformFactory.ONLY.afterUISetup(MainFrame.this._aboutAction, MainFrame.this._editPreferencesAction, MainFrame.this._quitAction);
                    MainFrame.this.setUpKeys();
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){

                        @Override
                        public boolean dispatchKeyEvent(KeyEvent e) {
                            boolean discardEvent = false;
                            if (e.getID() == 400 && e.getKeyChar() == '`' && ((e.getModifiersEx() & 0x80) == 128 || (e.getModifiersEx() & 0xC0) == 192) && e.getComponent().getClass().equals(DefinitionsPane.class)) {
                                discardEvent = true;
                            }
                            return discardEvent;
                        }
                    });
                    if (DrJava.getConfig().getSetting(OptionConstants.REMOTE_CONTROL_ENABLED).booleanValue()) {
                        try {
                            if (!RemoteControlClient.isServerRunning()) {
                                new RemoteControlServer(MainFrame.this);
                            }
                        }
                        catch (IOException ioe) {
                            int n;
                            try {
                                RemoteControlClient.openFile(null);
                            }
                            catch (IOException ignored) {
                                // empty catch block
                            }
                            if (Utilities.TEST_MODE || System.getProperty("user.name").equals(RemoteControlClient.getServerUser())) break block32;
                            Object[] options = new Object[]{"Disable", "Ignore"};
                            String msg = "<html>Could not start DrJava's remote control server";
                            if (RemoteControlClient.getServerUser() != null) {
                                msg = msg + "<br>because user " + RemoteControlClient.getServerUser() + " is already using the same port";
                            }
                            if ((n = JOptionPane.showOptionDialog(MainFrame.this, msg = msg + ".<br>Please select an unused port in the Preferences dialog.<br>In the meantime, do you want to disable the remote control feature?", "Could Not Start Remote Control Server", 0, 3, null, options, options[1])) != 0) break block32;
                            DrJava.getConfig().setSetting(OptionConstants.REMOTE_CONTROL_ENABLED, false);
                        }
                    }
                }
                MainFrame.this.setUpDrJavaProperties();
                DrJavaErrorHandler.setButton(MainFrame.this._errorsButton);
                boolean alreadyShowedDialog = false;
                if (PlatformFactory.ONLY.canRegisterFileExtensions()) {
                    if (DrJava.getConfig().getSetting(OptionConstants.FILE_EXT_REGISTRATION).equals(OptionConstants.FILE_EXT_REGISTRATION_CHOICES.get(2))) {
                        PlatformFactory.ONLY.registerDrJavaFileExtensions();
                        PlatformFactory.ONLY.registerJavaFileExtension();
                    } else if (!(!DrJava.getConfig().getSetting(OptionConstants.FILE_EXT_REGISTRATION).equals("ask me at startup") || Utilities.TEST_MODE || PlatformFactory.ONLY.areDrJavaFileExtensionsRegistered() && PlatformFactory.ONLY.isJavaFileExtensionRegistered())) {
                        alreadyShowedDialog = true;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                String text = "Do you want to associate .java, .drjava and .djapp files with DrJava?\nDouble-clicking on those files will open them in DrJava.\n\nSelect 'Always' to let DrJava do this automatically.\nSelect 'Never' if you don't want to be asked again.\n\nYou can change this setting in the Preferences dialog under\nMiscellaneous/File Types.";
                                Object[] options = new Object[]{"Yes", "No", "Always", "Never"};
                                int rc = JOptionPane.showOptionDialog(MainFrame.this, text, "Set File Associations?", 0, 3, null, options, options[0]);
                                if (rc == 0 || rc == 2) {
                                    PlatformFactory.ONLY.registerDrJavaFileExtensions();
                                    PlatformFactory.ONLY.registerJavaFileExtension();
                                }
                                if (rc == 2) {
                                    DrJava.getConfig().setSetting(OptionConstants.FILE_EXT_REGISTRATION, OptionConstants.FILE_EXT_REGISTRATION_CHOICES.get(2));
                                }
                                if (rc == 3) {
                                    DrJava.getConfig().setSetting(OptionConstants.FILE_EXT_REGISTRATION, OptionConstants.FILE_EXT_REGISTRATION_CHOICES.get(0));
                                }
                            }
                        });
                    }
                }
                if (!alreadyShowedDialog && DrJava.getConfig().getSetting(OptionConstants.NEW_VERSION_ALLOWED).booleanValue() && !DrJava.getConfig().getSetting(OptionConstants.NEW_VERSION_NOTIFICATION).equals("none (disabled)") && !Utilities.TEST_MODE) {
                    int days = DrJava.getConfig().getSetting(RecentFileManager.NEW_VERSION_NOTIFICATION_DAYS);
                    Date nextCheck = new Date(DrJava.getConfig().getSetting(OptionConstants.LAST_NEW_VERSION_NOTIFICATION) + (long)days * 24L * 60L * 60L * 1000L);
                    if (new Date().after(nextCheck)) {
                        alreadyShowedDialog = true;
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                NewVersionPopup popup = new NewVersionPopup(MainFrame.this);
                                if (popup.checkNewVersion()) {
                                    popup.setVisible(true);
                                }
                            }
                        });
                    }
                }
                MainFrame.this.initDone();
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this._tabbedPanesFrame.setDisplayInFrame(DrJava.getConfig().getSetting(RecentFileManager.DETACH_TABBEDPANES));
                    }
                });
            }
        });
    }

    @Override
    public void setVisible(boolean b) {
        this._updateToolBarVisible();
        super.setVisible(b);
    }

    public void setUpDrJavaProperties() {
        String DEF_DIR = "${drjava.working.dir}";
        DrJavaPropertySetup.setup();
        PropertyMaps.TEMPLATE.setProperty("DrJava", new FileProperty("drjava.current.file", new Thunk<File>(){

            @Override
            public File value() {
                return MainFrame.this._model.getActiveDocument().getRawFile();
            }
        }, "Returns the current document in DrJava.\nOptional attributes:\n\trel=\"<dir to which the output should be relative\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }
        });
        PropertyMaps.TEMPLATE.setProperty("DrJava", new DrJavaProperty("drjava.current.line", "Returns the current line in the Definitions Pane."){

            @Override
            public void update(PropertyMaps pm) {
                this._value = String.valueOf(MainFrame.this._posListener.lastLine());
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("DrJava", new DrJavaProperty("drjava.current.col", "Returns the current column in the Definitions Pane."){

            @Override
            public void update(PropertyMaps pm) {
                this._value = String.valueOf(MainFrame.this._posListener.lastCol());
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("DrJava", new FileProperty("drjava.working.dir", new Thunk<File>(){

            @Override
            public File value() {
                return MainFrame.this._model.getInteractionsModel().getWorkingDirectory();
            }
        }, "Returns the current working directory of DrJava.\nOptional attributes:\n\trel=\"<dir to which output should be relative\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }
        });
        PropertyMaps.TEMPLATE.setProperty("DrJava", new FileProperty("drjava.master.working.dir", new Thunk<File>(){

            @Override
            public File value() {
                return MainFrame.this._model.getMasterWorkingDirectory();
            }
        }, "Returns the working directory of the DrJava master JVM.\nOptional attributes:\n\trel=\"<dir to which output should be relative\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }
        });
        PropertyMaps.TEMPLATE.setProperty("DrJava", new FileListProperty("drjava.all.files", File.pathSeparator, "${drjava.working.dir}", "Returns a list of all files open in DrJava.\nOptional attributes:\n\trel=\"<dir to which output should be relative\"\n\tsep=\"<separator between files>\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            protected List<File> getList(PropertyMaps pm) {
                ArrayList<File> l = new ArrayList<File>();
                for (OpenDefinitionsDocument odd : MainFrame.this._model.getOpenDefinitionsDocuments()) {
                    l.add(odd.getRawFile());
                }
                return l;
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("DrJava", new FileListProperty("drjava.project.files", File.pathSeparator, "${drjava.working.dir}", "Returns a list of all files open in DrJava that belong to a project and are underneath the project root.\nOptional attributes:\n\trel=\"<dir to which output should be relative\"\n\tsep=\"<separator between files>\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            protected List<File> getList(PropertyMaps pm) {
                ArrayList<File> l = new ArrayList<File>();
                for (OpenDefinitionsDocument odd : MainFrame.this._model.getProjectDocuments()) {
                    l.add(odd.getRawFile());
                }
                return l;
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        }).listenToInvalidatesOf(PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.all.files"));
        PropertyMaps.TEMPLATE.setProperty("DrJava", new FileListProperty("drjava.included.files", File.pathSeparator, "${drjava.working.dir}", "Returns a list of all files open in DrJava that are not underneath the project root but are included in the project.\nOptional attributes:\n\trel=\"<dir to which output should be relative\"\n\tsep=\"<separator between files>\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            protected List<File> getList(PropertyMaps pm) {
                ArrayList<File> l = new ArrayList<File>();
                for (OpenDefinitionsDocument odd : MainFrame.this._model.getAuxiliaryDocuments()) {
                    l.add(odd.getRawFile());
                }
                return l;
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        }).listenToInvalidatesOf(PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.all.files"));
        PropertyMaps.TEMPLATE.setProperty("DrJava", new FileListProperty("drjava.external.files", File.pathSeparator, "${drjava.working.dir}", "Returns a list of all files open in DrJava that are not underneath the project root and are not included in the project.\nOptional attributes:\n\trel=\"<dir to which output should be relative\"\n\tsep=\"<separator between files>\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            protected List<File> getList(PropertyMaps pm) {
                ArrayList<File> l = new ArrayList<File>();
                for (OpenDefinitionsDocument odd : MainFrame.this._model.getNonProjectDocuments()) {
                    l.add(odd.getRawFile());
                }
                return l;
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        }).listenToInvalidatesOf(PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.all.files"));
        PropertyMaps.TEMPLATE.setProperty("Misc", new DrJavaProperty("input", "(User Input...)", "Get an input string from the user.\nOptional attributes:\n\tprompt=\"<prompt to display>\"\n\tdefault=\"<suggestion to the user>\""){

            @Override
            public String toString() {
                return "(User Input...)";
            }

            @Override
            public void update(PropertyMaps pm) {
                String input;
                String msg = (String)this._attributes.get("prompt");
                if (msg == null) {
                    msg = "Please enter text for the external process.";
                }
                if ((input = (String)this._attributes.get("default")) == null) {
                    input = "";
                }
                if ((input = JOptionPane.showInputDialog(MainFrame.this, msg, input)) == null) {
                    input = (String)this._attributes.get("default");
                }
                if (input == null) {
                    input = "";
                }
                this._value = input;
            }

            @Override
            public String getCurrent(PropertyMaps pm) {
                this.invalidate();
                return super.getCurrent(pm);
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("prompt", null);
                this._attributes.put("default", null);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Project", new DrJavaProperty("project.mode", "Evaluates to true if a project is loaded."){

            @Override
            public void update(PropertyMaps pm) {
                Boolean b = MainFrame.this._model.isProjectActive();
                String f = ((String)this._attributes.get("fmt")).toLowerCase();
                this._value = f.equals("int") ? (b != false ? "1" : "0") : (f.equals("yes") ? (b != false ? "yes" : "no") : b.toString());
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("fmt", "boolean");
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Project", new DrJavaProperty("project.changed", "Evaluates to true if the project has been changed since the last save."){

            @Override
            public void update(PropertyMaps pm) {
                String f = ((String)this._attributes.get("fmt")).toLowerCase();
                Boolean b = MainFrame.this._model.isProjectChanged();
                this._value = f.equals("int") ? (b != false ? "1" : "0") : (f.equals("yes") ? (b != false ? "yes" : "no") : b.toString());
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("fmt", "boolean");
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Project", new FileProperty("project.file", new Thunk<File>(){

            @Override
            public File value() {
                return MainFrame.this._model.getProjectFile();
            }
        }, "Returns the current project file in DrJava.\nOptional attributes:\n\trel=\"<dir to which the output should be relative\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Project", new FileProperty("project.main.class", new Thunk<File>(){

            @Override
            public File value() {
                return new File(MainFrame.this._model.getMainClass());
            }
        }, "Returns the current project file in DrJava.\nOptional attributes:\n\trel=\"<dir to which the output should be relative\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Project", new FileProperty("project.root", new Thunk<File>(){

            @Override
            public File value() {
                return MainFrame.this._model.getProjectRoot();
            }
        }, "Returns the current project root in DrJava.\nOptional attributes:\n\trel=\"<dir to which the output should be relative\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Project", new FileProperty("project.build.dir", new Thunk<File>(){

            @Override
            public File value() {
                return MainFrame.this._model.getBuildDirectory();
            }
        }, "Returns the current build directory in DrJava.\nOptional attributes:\n\trel=\"<dir to which the output should be relative\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }
        });
        RecursiveFileListProperty classFilesProperty = new RecursiveFileListProperty("project.class.files", File.pathSeparator, "${drjava.working.dir}", this._model.getBuildDirectory().getAbsolutePath(), "Returns the class files currently in the build directory.\n\trel=\"<dir to which the output should be relative\"\n\tsep=\"<string to separate files in the list>\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("sep", this._sep);
                this._attributes.put("rel", this._dir);
                this._attributes.put("dir", MainFrame.this._model.getBuildDirectory().getAbsolutePath());
                this._attributes.put("filter", "*.class");
                this._attributes.put("dirfilter", "*");
            }
        };
        PropertyMaps.TEMPLATE.setProperty("Project", classFilesProperty);
        PropertyMaps.TEMPLATE.setProperty("Project", new DrJavaProperty("project.auto.refresh", "Evaluates to true if project auto-refresh is enabled."){

            @Override
            public void update(PropertyMaps pm) {
                Boolean b = MainFrame.this._model.getAutoRefreshStatus();
                String f = ((String)this._attributes.get("fmt")).toLowerCase();
                this._value = f.equals("int") ? (b != false ? "1" : "0") : (f.equals("yes") ? (b != false ? "yes" : "no") : b.toString());
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("fmt", "boolean");
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Project", new FileListProperty("project.excluded.files", File.pathSeparator, "${drjava.working.dir}", "Returns a list of files that are excluded from DrJava's project auto-refresh.\nOptional attributes:\n\trel=\"<dir to which output should be relative\"\n\tsep=\"<separator between files>\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            protected List<File> getList(PropertyMaps pm) {
                ArrayList<File> l = new ArrayList<File>();
                for (File f : MainFrame.this._model.getExclFiles()) {
                    l.add(f);
                }
                return l;
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Project", new FileListProperty("project.extra.class.path", File.pathSeparator, "${drjava.working.dir}", "Returns a list of files in the project's extra class path.\nOptional attributes:\n\trel=\"<dir to which output should be relative\"\n\tsep=\"<separator between files>\"\n\tsquote=\"<true to enclose file in single quotes>\"\n\tdquote=\"<true to enclose file in double quotes>\""){

            @Override
            protected List<File> getList(PropertyMaps pm) {
                ArrayList<File> l = new ArrayList<File>();
                for (File file : MainFrame.this._model.getExtraClassPath()) {
                    l.add(file);
                }
                return l;
            }

            @Override
            public String getLazy(PropertyMaps pm) {
                return this.getCurrent(pm);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Action", new DrJavaActionProperty("action.save.all", "(Save All...)", "Execute a \"Save All\" action."){

            @Override
            public void update(PropertyMaps pm) {
                MainFrame.this._saveAll();
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Action", new DrJavaActionProperty("action.compile.all", "(Compile All...)", "Execute a \"Compile All\" action."){

            @Override
            public void update(PropertyMaps pm) {
                MainFrame.this._compileAll();
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Action", new DrJavaActionProperty("action.clean", "(Clean Build Directory...)", "Execute a \"Clean Build Directory\" action."){

            @Override
            public void update(PropertyMaps pm) {
                IOUtil.deleteRecursively(MainFrame.this._model.getBuildDirectory());
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Action", new DrJavaActionProperty("action.open.file", "(Open File...)", "Execute an \"Open File\" action.\nRequired attributes:\n\tfile=\"<file to open>\"\nOptional attributes:\n\tline=\"<line number to display>"){

            @Override
            public void update(PropertyMaps pm) {
                if (this._attributes.get("file") != null) {
                    final String dir = StringOps.unescapeFileName(StringOps.replaceVariables("${drjava.working.dir}", pm, PropertyMaps.GET_CURRENT));
                    final String fil = StringOps.unescapeFileName(StringOps.replaceVariables((String)this._attributes.get("file"), pm, PropertyMaps.GET_CURRENT));
                    FileOpenSelector fs = new FileOpenSelector(){

                        @Override
                        public File[] getFiles() {
                            if (fil.startsWith("/")) {
                                return new File[]{new File(fil)};
                            }
                            return new File[]{new File(dir, fil)};
                        }
                    };
                    MainFrame.this.open(fs);
                    int lineNo = -1;
                    if (this._attributes.get("line") != null) {
                        try {
                            lineNo = Integer.valueOf((String)this._attributes.get("line"));
                        }
                        catch (NumberFormatException nfe) {
                            lineNo = -1;
                        }
                    }
                    if (lineNo >= 0) {
                        final int l = lineNo;
                        Utilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MainFrame.this._jumpToLine(l);
                            }
                        });
                    }
                }
            }

            @Override
            public void resetAttributes() {
                this._attributes.clear();
                this._attributes.put("file", null);
                this._attributes.put("line", null);
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
        PropertyMaps.TEMPLATE.setProperty("Action", new DrJavaActionProperty("action.auto.refresh", "(Auto-Refresh...)", "Execute an \"Auto-Refresh Project\" action."){

            @Override
            public void update(PropertyMaps pm) {
                MainFrame.this._model.autoRefreshProject();
            }

            @Override
            public boolean isCurrent() {
                return false;
            }
        });
    }

    void refreshBreakpointHighlightPainter() {
        for (Map.Entry<Breakpoint, HighlightManager.HighlightInfo> pair : this._documentBreakpointHighlights.entrySet()) {
            if (pair.getKey().isEnabled()) {
                pair.getValue().refresh(DefinitionsPane.BREAKPOINT_PAINTER);
                continue;
            }
            pair.getValue().refresh(DefinitionsPane.DISABLED_BREAKPOINT_PAINTER);
        }
    }

    void refreshBookmarkHighlightPainter() {
        for (HighlightManager.HighlightInfo hi : this._documentBookmarkHighlights.values()) {
            hi.refresh(DefinitionsPane.BOOKMARK_PAINTER);
        }
    }

    void refreshFindResultsHighlightPainter(FindResultsPanel panel, LayeredHighlighter.LayerPainter painter) {
        for (Pair pair : this._findResults) {
            if (pair.first() != panel) continue;
            Map highlights = (Map)pair.second();
            for (HighlightManager.HighlightInfo hi : highlights.values()) {
                hi.refresh(painter);
            }
        }
    }

    private DirectoryChooser makeFolderChooser(File workDir) {
        assert (this.duringInit() || EventQueue.isDispatchThread());
        DirectoryChooser dc = new DirectoryChooser(this);
        dc.setSelectedFile(workDir);
        dc.setApproveButtonText("Select");
        dc.setDialogTitle("Open Folder");
        dc.setAccessory(this._openRecursiveCheckBox);
        return dc;
    }

    private void setUpKeys() {
        this.setFocusTraversalKeysEnabled(false);
    }

    @Override
    public void dispose() {
        this._model.dispose();
        super.dispose();
    }

    public SingleDisplayModel getModel() {
        return this._model;
    }

    InteractionsPane getInteractionsPane() {
        return this._interactionsPane;
    }

    InteractionsController getInteractionsController() {
        return this._interactionsController;
    }

    JButton getCloseButton() {
        return this._closeButton;
    }

    JButton getCompileAllButton() {
        return this._compileButton;
    }

    public void hourglassOn() {
        assert (EventQueue.isDispatchThread());
        ++this._hourglassNestLevel;
        if (this._hourglassNestLevel == 1) {
            this.getGlassPane().setVisible(true);
            this._currentDefPane.setEditable(false);
            this.setAllowKeyEvents(false);
            this._interactionsPane.setEnabled(false);
        }
    }

    public void hourglassOff() {
        assert (EventQueue.isDispatchThread());
        --this._hourglassNestLevel;
        if (this._hourglassNestLevel == 0) {
            this.getGlassPane().setVisible(false);
            this._currentDefPane.setEditable(true);
            this.setAllowKeyEvents(true);
            this._interactionsPane.setEnabled(true);
        }
    }

    public void setAllowKeyEvents(boolean a) {
        this._allowKeyEvents = a;
    }

    public boolean getAllowKeyEvents() {
        return this._allowKeyEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debuggerToggle() {
        block9: {
            assert (EventQueue.isDispatchThread());
            Debugger debugger = this._model.getDebugger();
            if (!debugger.isAvailable()) {
                return;
            }
            this.updateStatusField("Toggling Debugger Mode");
            try {
                if (this.isDebuggerReady()) {
                    this._guiAvailabilityNotifier.ensureUnavailable(GUIAvailabilityListener.ComponentType.DEBUGGER);
                    debugger.shutdown();
                    break block9;
                }
                this.hourglassOn();
                try {
                    debugger.startUp();
                    this._model.refreshActiveDocument();
                    this._updateDebugStatus();
                }
                finally {
                    this.hourglassOff();
                }
            }
            catch (DebugException de) {
                MainFrameStatics.showError(this, de, "Debugger Error", "Could not start the debugger.");
            }
            catch (NoClassDefFoundError err) {
                MainFrameStatics.showError(this, err, "Debugger Error", "Unable to find the JPDA package for the debugger.\nPlease make sure either tools.jar or jpda.jar is\nin your classpath when you start DrJava.");
                this._setDebugMenuItemsEnabled(false);
            }
        }
    }

    public void showDebugger() {
        assert (EventQueue.isDispatchThread());
        this._setDebugMenuItemsEnabled(true);
        this._showDebuggerPanel();
    }

    public void hideDebugger() {
        this._setDebugMenuItemsEnabled(false);
        this._hideDebuggerPanel();
    }

    private void _showDebuggerPanel() {
        if (this._debugFrame == null) {
            return;
        }
        if (this._detachDebugFrameMenuItem.isSelected()) {
            this._debugFrame.setDisplayInFrame(true);
        } else {
            this._debugSplitPane.setTopComponent(this._docSplitPane);
            this._mainSplit.setTopComponent(this._debugSplitPane);
        }
        this._debugPanel.updateData();
        this._lastFocusOwner.requestFocusInWindow();
    }

    private void _hideDebuggerPanel() {
        if (this._debugFrame == null) {
            return;
        }
        if (this._detachDebugFrameMenuItem.isSelected()) {
            this._debugFrame.setVisible(false);
        } else {
            this._mainSplit.setTopComponent(this._docSplitPane);
        }
        this._lastFocusOwner.requestFocusInWindow();
    }

    public void updateStatusField(String text) {
        assert (EventQueue.isDispatchThread());
        this._statusField.setText(text);
        this._statusBar.repaint();
    }

    public void updateStatusField() {
        OpenDefinitionsDocument doc = this._model.getActiveDocument();
        String fileName = doc.getCompletePath();
        if (!fileName.equals(this._fileTitle)) {
            this._fileTitle = fileName;
            this.setTitle(fileName);
            this._tabbedPanesFrame.setTitle("Tabbed Panes - " + fileName);
            if (this._debugFrame != null) {
                this._debugFrame.setTitle("Debugger - " + fileName);
            }
            this._model.getDocCollectionWidget().repaint();
        }
        String path = doc.getCompletePath();
        String text = "Editing " + path;
        if (!this._statusField.getText().equals(text)) {
            this._statusField.setText(text);
            this._statusBar.repaint();
        }
    }

    public File[] getOpenFiles(JFileChooser jfc) throws OperationCanceledException {
        int rc = jfc.showOpenDialog(this);
        return this.getChosenFiles(jfc, rc);
    }

    public File getSaveFile(JFileChooser jfc) throws OperationCanceledException {
        OpenDefinitionsDocument active = this._model.getActiveDocument();
        File previous = null;
        if (active.isUntitled()) {
            try {
                String className = active.getFirstTopLevelClassName();
                if (!className.equals("")) {
                    jfc.setSelectedFile(new File(jfc.getCurrentDirectory(), className));
                }
            }
            catch (ClassNameNotFoundException e) {}
        } else {
            previous = active.getRawFile();
            jfc.setSelectedFile(previous);
        }
        jfc.resetChoosableFileFilters();
        jfc.setFileFilter(this.getSourceFileFilter());
        jfc.setMultiSelectionEnabled(false);
        int rc = jfc.showSaveDialog(this);
        return this.getChosenFile(jfc, rc, previous, true);
    }

    public DefinitionsPane getCurrentDefPane() {
        return this._currentDefPane;
    }

    public CompilerErrorPanel getCompilerErrorPanel() {
        return this._compilerErrorPanel;
    }

    public JUnitPanel getJUnitPanel() {
        return this._junitPanel;
    }

    public JavadocErrorPanel getJavadocErrorPanel() {
        return this._javadocErrorPanel;
    }

    public CompilerErrorPanel getSelectedErrorPanel() {
        Component c = this._tabbedPane.getSelectedComponent();
        if (c instanceof CompilerErrorPanel) {
            return (CompilerErrorPanel)c;
        }
        return null;
    }

    public boolean isCompilerTabSelected() {
        return this._tabbedPane.getSelectedComponent() == this._compilerErrorPanel;
    }

    public boolean isTestTabSelected() {
        return this._tabbedPane.getSelectedComponent() == this._junitPanel;
    }

    public boolean isJavadocTabSelected() {
        return this._tabbedPane.getSelectedComponent() == this._javadocErrorPanel;
    }

    private void _installNewDocumentListener(OpenDefinitionsDocument d) {
        d.addDocumentListener(new DocumentUIListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                assert (EventQueue.isDispatchThread());
                MainFrame.this._saveAction.setEnabled(true);
                if (MainFrame.this.isDebuggerEnabled() && MainFrame.this._debugPanel.getStatusText().equals("")) {
                    MainFrame.this._debugPanel.setStatusText(MainFrame.DEBUGGER_OUT_OF_SYNC);
                }
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                assert (EventQueue.isDispatchThread());
                MainFrame.this._saveAction.setEnabled(true);
                if (MainFrame.this.isDebuggerEnabled() && MainFrame.this._debugPanel.getStatusText().equals("")) {
                    MainFrame.this._debugPanel.setStatusText(MainFrame.DEBUGGER_OUT_OF_SYNC);
                }
            }
        });
    }

    public void setStatusMessage(String msg) {
        this._statusReport.setText(msg);
    }

    public void clearStatusMessage() {
        this._statusReport.setText("");
    }

    public void setStatusMessageFont(Font f) {
        this._statusReport.setFont(f);
    }

    public void setStatusMessageColor(Color c) {
        this._statusReport.setForeground(c);
    }

    private void _processDocs(Collection<OpenDefinitionsDocument> docs, Runnable1<OpenDefinitionsDocument> op) {
        for (OpenDefinitionsDocument doc : docs) {
            if (doc == null || doc.isUntitled()) continue;
            op.run(doc);
            try {
                String path = this._model.fixPathForNavigator(doc.getFile().getCanonicalPath());
                this._model.getDocumentNavigator().refreshDocument(doc, path);
            }
            catch (IOException e) {}
        }
        PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.project.files").invalidate();
        PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.included.files").invalidate();
        PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.external.files").invalidate();
    }

    void _moveToAuxiliary() {
        Runnable1<OpenDefinitionsDocument> op = new Runnable1<OpenDefinitionsDocument>(){

            @Override
            public void run(OpenDefinitionsDocument d) {
                MainFrame.this._model.addAuxiliaryFile(d);
            }
        };
        this._processDocs(this._model.getDocumentNavigator().getSelectedDocuments(), op);
    }

    private void _removeAuxiliary() {
        Runnable1<OpenDefinitionsDocument> op = new Runnable1<OpenDefinitionsDocument>(){

            @Override
            public void run(OpenDefinitionsDocument d) {
                MainFrame.this._model.removeAuxiliaryFile(d);
            }
        };
        this._processDocs(this._model.getDocumentNavigator().getSelectedDocuments(), op);
    }

    void _moveAllToAuxiliary() {
        assert (EventQueue.isDispatchThread());
        Runnable1<OpenDefinitionsDocument> op = new Runnable1<OpenDefinitionsDocument>(){

            @Override
            public void run(OpenDefinitionsDocument d) {
                MainFrame.this._model.addAuxiliaryFile(d);
            }
        };
        this._processDocs(this._model.getDocumentNavigator().getDocumentsInBin(this._model.getExternalBinTitle()), op);
    }

    private void _removeAllAuxiliary() {
        assert (EventQueue.isDispatchThread());
        Runnable1<OpenDefinitionsDocument> op = new Runnable1<OpenDefinitionsDocument>(){

            @Override
            public void run(OpenDefinitionsDocument d) {
                MainFrame.this._model.removeAuxiliaryFile(d);
            }
        };
        this._processDocs(this._model.getDocumentNavigator().getDocumentsInBin(this._model.getAuxiliaryBinTitle()), op);
    }

    private void _new() {
        this.updateStatusField("Creating a new Untitled Document");
        this._model.newFile();
    }

    private void _open() {
        this.updateStatusField("Opening File");
        this.open(this._openSelector);
    }

    private void _openFolder() {
        this.openFolder(this._folderChooser);
    }

    private void _openFileOrProject() {
        try {
            final File[] fileList = this._openFileOrProjectSelector.getFiles();
            FileOpenSelector fos = new FileOpenSelector(){

                @Override
                public File[] getFiles() {
                    return fileList;
                }
            };
            if (this._openChooser.getFileFilter().equals(this._projectFilter)) {
                this.openProject(fos);
            } else {
                this.open(fos);
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
    }

    private void _putTextIntoDefinitions(String text) {
        int caretPos = this._currentDefPane.getCaretPosition();
        try {
            this._model.getActiveDocument().insertString(caretPos, text, null);
        }
        catch (BadLocationException ble) {
            throw new UnexpectedException(ble);
        }
    }

    private void _resetNavigatorPane() {
        if (this._model.getDocumentNavigator() instanceof JTreeSortNavigator) {
            JTreeSortNavigator nav = (JTreeSortNavigator)this._model.getDocumentNavigator();
            nav.setDisplayManager(this.getNavPaneDisplayManager());
            nav.setRootIcon(_djProjectIcon);
        }
        this._docSplitPane.remove(this._docSplitPane.getLeftComponent());
        this._docSplitPane.setLeftComponent(new JScrollPane(this._model.getDocumentNavigator().asContainer()));
        Font doclistFont = DrJava.getConfig().getSetting(RecentFileManager.FONT_DOCLIST);
        this._model.getDocCollectionWidget().setFont(doclistFont);
        this._updateNormalColor();
        this._updateBackgroundColor();
    }

    private void _openProject() {
        this.openProject(this._openProjectSelector);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openProject(FileOpenSelector projectSelector) {
        try {
            File[] files = projectSelector.getFiles();
            if (files.length < 1) {
                throw new IllegalStateException("Open project file selection not canceled but no project file was selected.");
            }
            File file = files[0];
            this.updateStatusField("Opening project " + file);
            try {
                this.hourglassOn();
                if (!this._model.isProjectActive() || this._model.isProjectActive() && this._closeProject()) {
                    this._openProjectHelper(file);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            finally {
                this.hourglassOff();
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
    }

    private void _openProjectHelper(File projectFile) {
        this._currentProjFile = projectFile;
        try {
            this._mainListener.resetFNFCount();
            this._model.openProject(projectFile);
            this._setUpProjectButtons(projectFile);
            this._openProjectUpdate();
            if (this._mainListener.someFilesNotFound()) {
                this._model.setProjectChanged(true);
            }
            this.clearCompleteClassSet();
            this.addToBrowserHistory();
        }
        catch (MalformedProjectFileException e) {
            MainFrameStatics.showProjectFileParseError(this, e);
            return;
        }
        catch (FileNotFoundException e) {
            MainFrameStatics.showFileNotFoundError(this, e);
            return;
        }
        catch (IOException e) {
            MainFrameStatics.showIOError(this, e);
            return;
        }
    }

    private void _setUpProjectButtons(File projectFile) {
        this._compileButton = this._updateToolbarButton(this._compileButton, this._compileProjectAction);
        this._junitButton = this._updateToolbarButton(this._junitButton, this._junitProjectAction);
        this._recentProjectManager.updateOpenFiles(projectFile);
    }

    private void _openProjectUpdate() {
        if (this._model.isProjectActive()) {
            this._guiAvailabilityNotifier.available(GUIAvailabilityListener.ComponentType.PROJECT);
            this._model.getDocumentNavigator().asContainer().addKeyListener(this._historyListener);
            this._model.getDocumentNavigator().asContainer().addFocusListener(this._focusListenerForRecentDocs);
            this._model.getDocumentNavigator().asContainer().addMouseListener(this._resetFindReplaceListener);
            this._resetNavigatorPane();
            this._model.refreshActiveDocument();
        }
    }

    boolean closeProject() {
        this.updateStatusField("Closing current project");
        return this._closeProject();
    }

    boolean _closeProject() {
        return this._closeProject(false);
    }

    boolean _closeProject(boolean quitting) {
        this.clearCompleteClassSet();
        this._autoImportClassSet = new HashSet();
        if (this._checkProjectClose()) {
            List<OpenDefinitionsDocument> projDocs = this._model.getProjectDocuments();
            this._cleanUpDebugger();
            boolean couldClose = this._model.closeFiles(projDocs);
            if (!couldClose) {
                return false;
            }
            this.disableFindAgainOnClose(projDocs);
            if (quitting) {
                return true;
            }
            this._model.closeProject(quitting);
            Component renderer = this._model.getDocumentNavigator().getRenderer();
            new ForegroundColorListener(renderer);
            new BackgroundColorListener(renderer);
            this._resetNavigatorPane();
            if (this._model.getDocumentCount() == 1) {
                this._model.setActiveFirstDocument();
            }
            this._guiAvailabilityNotifier.unavailable(GUIAvailabilityListener.ComponentType.PROJECT);
            this._setUpContextMenus();
            this._currentProjFile = FileOps.NULL_FILE;
            return true;
        }
        return false;
    }

    private void _configureBrowsing() {
        BrowserHistoryManager bm = this._model.getBrowserHistoryManager();
        this._browseBackAction.setEnabled(!bm.isCurrentRegionFirst());
        this._browseForwardAction.setEnabled(!bm.isCurrentRegionLast());
    }

    private boolean _checkProjectClose() {
        _log.log("is changed? " + this._model.isProjectChanged() + " based on " + this._model);
        if (this._model.isProjectChanged()) {
            String fname = this._model.getProjectFile().getName();
            String text = fname + " has been modified. Would you like to save it?";
            int rc = JOptionPane.showConfirmDialog(this, text, "Save " + fname + "?", 1);
            switch (rc) {
                case 0: {
                    this._saveProject();
                    return true;
                }
                case 1: {
                    return true;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
            throw new RuntimeException("Invalid rc: " + rc);
        }
        return true;
    }

    public File getCurrentProject() {
        return this._currentProjFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(FileOpenSelector openSelector) {
        try {
            this.hourglassOn();
            this._model.openFiles(openSelector);
        }
        catch (AlreadyOpenException aoe) {
            OpenDefinitionsDocument[] openDocs;
            for (OpenDefinitionsDocument openDoc : openDocs = aoe.getOpenDocuments()) {
                try {
                    File f = openDoc.getFile();
                    if (this._model.inProject(f)) continue;
                    this._recentFileManager.updateOpenFiles(f);
                }
                catch (IllegalStateException ise) {
                    throw new UnexpectedException(ise);
                }
                catch (FileMovedException fme) {
                    File f = fme.getFile();
                    if (this._model.inProject(f)) continue;
                    this._recentFileManager.updateOpenFiles(f);
                }
            }
        }
        catch (OperationCanceledException oce) {
        }
        catch (FileNotFoundException fnf) {
            MainFrameStatics.showFileNotFoundError(this, fnf);
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
        }
        finally {
            this.hourglassOff();
        }
    }

    public void openFolder(DirectoryChooser chooser) {
        String ext = this._model.getOpenAllFilesInFolderExtension();
        final String type = "'" + ext + "' ";
        chooser.setDialogTitle("Open All " + type + "Files in ...");
        FileFilter ff = new FileFilter(){

            @Override
            public boolean accept(File f) {
                return true;
            }

            @Override
            public String getDescription() {
                return "All " + type + " Files in Folder Selected";
            }
        };
        chooser.resetChoosableFileFilters();
        chooser.setAcceptAllFileFilterUsed(false);
        chooser.setFileFilter(ff);
        File openDir = FileOps.NULL_FILE;
        try {
            File activeFile = this._model.getActiveDocument().getFile();
            openDir = activeFile != null ? activeFile.getParentFile() : this._model.getProjectRoot();
        }
        catch (FileMovedException e) {
            // empty catch block
        }
        int result = chooser.showDialog(openDir);
        File dir = chooser.getSelectedDirectory();
        chooser.removeChoosableFileFilter(ff);
        if (result != 0) {
            return;
        }
        boolean rec = this._openRecursiveCheckBox.isSelected();
        DrJava.getConfig().setSetting(OptionConstants.OPEN_FOLDER_RECURSIVE, rec);
        this.updateStatusField("Opening folder " + dir);
        this._openFolder(dir, rec, ext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _openFolder(File dir, boolean rec, String ext) {
        this.hourglassOn();
        try {
            this._model.openFolder(dir, rec, ext);
        }
        catch (AlreadyOpenException e) {
        }
        catch (IOException e) {
            MainFrameStatics.showIOError(this, e);
        }
        catch (OperationCanceledException oce) {
        }
        finally {
            this.hourglassOff();
        }
    }

    private void _close() {
        List<OpenDefinitionsDocument> l = this._model.getDocumentNavigator().getSelectedDocuments();
        boolean queryNecessary = false;
        for (OpenDefinitionsDocument doc : l) {
            if ((!this._model.isProjectActive() || !doc.inProjectPath()) && !doc.isAuxiliaryFile()) continue;
            queryNecessary = true;
            break;
        }
        if (queryNecessary) {
            int rc;
            String fileName = null;
            Object[] options = new Object[]{"Yes", "No"};
            if (l.size() == 1) {
                OpenDefinitionsDocument doc = l.get(0);
                try {
                    fileName = doc.isUntitled() ? "File" : this._model.getActiveDocument().getFile().getName();
                }
                catch (FileMovedException e) {
                    fileName = e.getFile().getName();
                }
                String text = "Closing this file will permanently remove it from the current project.\nAre you sure that you want to close this file?";
                rc = JOptionPane.showOptionDialog(this, text, "Close " + fileName + "?", 0, 3, null, options, options[1]);
            } else {
                fileName = l.size() + " files";
                String text = "Closing these " + fileName + " will permanently remove them from the current project." + "\nAre you sure that you want to close these files?";
                rc = JOptionPane.showOptionDialog(this, text, "Close " + l.size() + " files?", 0, 3, null, options, options[1]);
            }
            if (rc != 0) {
                return;
            }
            this.updateStatusField("Closing " + fileName);
            this._model.setProjectChanged(true);
        }
        this.disableFindAgainOnClose(l);
        for (OpenDefinitionsDocument doc : l) {
            this._model.closeFile(doc);
        }
    }

    private void _closeFolder() {
        ArrayList<OpenDefinitionsDocument> docs = this._model.getDocumentNavigator().getDocuments();
        LinkedList<OpenDefinitionsDocument> l = new LinkedList<OpenDefinitionsDocument>();
        if (this._model.getDocumentNavigator().isGroupSelected()) {
            for (OpenDefinitionsDocument doc : docs) {
                if (!this._model.getDocumentNavigator().isSelectedInGroup(doc)) continue;
                l.add(doc);
            }
            this.disableFindAgainOnClose(l);
            this._model.closeFiles(l);
            if (!l.isEmpty()) {
                this._model.setProjectChanged(true);
            }
        }
    }

    private void _printDefDoc() {
        try {
            this._model.getActiveDocument().print();
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (PrinterException e) {
            MainFrameStatics.showError(this, e, "Print Error", "An error occured while printing.");
        }
        catch (BadLocationException e) {
            MainFrameStatics.showError(this, e, "Print Error", "An error occured while printing.");
        }
    }

    private void _printConsole() {
        try {
            this._model.getConsoleDocument().print();
        }
        catch (PrinterException e) {
            MainFrameStatics.showError(this, e, "Print Error", "An error occured while printing.");
        }
    }

    private void _printInteractions() {
        try {
            this._model.getInteractionsDocument().print();
        }
        catch (PrinterException e) {
            MainFrameStatics.showError(this, e, "Print Error", "An error occured while printing.");
        }
    }

    private void _printDefDocPreview() {
        try {
            this._model.getActiveDocument().preparePrintJob();
            new PreviewDefDocFrame(this._model, this);
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (BadLocationException e) {
            MainFrameStatics.showError(this, e, "Print Error", "An error occured while preparing the print preview.");
        }
        catch (IllegalStateException e) {
            MainFrameStatics.showError(this, e, "Print Error", "An error occured while preparing the print preview.");
        }
    }

    private void _printConsolePreview() {
        try {
            this._model.getConsoleDocument().preparePrintJob();
            new PreviewConsoleFrame(this._model, this, false);
        }
        catch (IllegalStateException e) {
            MainFrameStatics.showError(this, e, "Print Error", "An error occured while preparing the print preview.");
        }
    }

    private void _printInteractionsPreview() {
        try {
            this._model.getInteractionsDocument().preparePrintJob();
            new PreviewConsoleFrame(this._model, this, true);
        }
        catch (IllegalStateException e) {
            MainFrameStatics.showError(this, e, "Print Error", "An error occured while preparing the print preview.");
        }
    }

    private void _pageSetup() {
        PrinterJob job = PrinterJob.getPrinterJob();
        this._model.setPageFormat(job.pageDialog(this._model.getPageFormat()));
    }

    void closeAll() {
        this._closeAll();
    }

    private void _closeAll() {
        this.updateStatusField("Closing All Files");
        if (!this._model.isProjectActive() || this._model.isProjectActive() && this._closeProject()) {
            this._model.closeAllFiles();
        }
    }

    private boolean _save() {
        this.updateStatusField("Saving File");
        try {
            List<OpenDefinitionsDocument> l = this._model.getDocumentNavigator().getSelectedDocuments();
            boolean success = false;
            for (OpenDefinitionsDocument doc : l) {
                if (!doc.saveFile(this._saveSelector)) continue;
                this.getDefPaneGivenODD(doc).hasWarnedAboutModified(false);
                success = true;
            }
            this._model.refreshActiveDocument();
            return success;
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
            return false;
        }
    }

    private boolean _saveAs() {
        this.updateStatusField("Saving File Under New Name");
        try {
            boolean toReturn = this._model.getActiveDocument().saveFileAs(this._saveAsSelector);
            this._model.refreshActiveDocument();
            return toReturn;
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
            return false;
        }
    }

    private boolean _saveCopy() {
        this.updateStatusField("Saving Copy of File");
        try {
            boolean toReturn = this._model.getActiveDocument().saveFileAs(this._saveCopySelector);
            this._model.refreshActiveDocument();
            return toReturn;
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
            return false;
        }
    }

    private boolean _rename() {
        try {
            File fileToDelete;
            if (!this._model.getActiveDocument().fileExists()) {
                return this._saveAs();
            }
            try {
                fileToDelete = this._model.getActiveDocument().getFile();
            }
            catch (FileMovedException fme) {
                return this._saveAs();
            }
            boolean toReturn = this._model.getActiveDocument().saveFileAs(this._saveAsSelector);
            if (toReturn && !this._model.getActiveDocument().getFile().equals(fileToDelete)) {
                fileToDelete.delete();
            }
            this._model.refreshActiveDocument();
            return toReturn;
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _saveAll() {
        this.hourglassOn();
        try {
            if (this._model.isProjectActive()) {
                this._saveProject();
            }
            this._model.saveAllFiles(this._saveSelector);
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
        }
        finally {
            this.hourglassOff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _saveAllOld() {
        this.hourglassOn();
        File file = this._currentProjFile;
        try {
            if (this._model.isProjectActive()) {
                if (file.getName().indexOf(".") == -1) {
                    file = new File(file.getAbsolutePath() + ".pjt");
                }
                this._model.exportOldProject(file, this.gatherProjectDocInfo());
            }
            this._model.saveAllFiles(this._saveSelector);
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
        }
        finally {
            this.hourglassOff();
        }
    }

    void saveProject() {
        this._saveProject();
    }

    private void _saveProject() {
        this._saveProjectHelper(this._currentProjFile);
    }

    private void _editProject() {
        ProjectPropertiesFrame ppf = new ProjectPropertiesFrame(this);
        ppf.setVisible(true);
        ppf.reset();
        ppf.toFront();
    }

    private void _newProject() {
        this._closeProject(true);
        this._saveChooser.resetChoosableFileFilters();
        this._saveChooser.setFileFilter(this._projectFilter);
        this._saveChooser.setMultiSelectionEnabled(false);
        int rc = this._saveChooser.showSaveDialog(this);
        if (rc == 0) {
            File projectFile = this._saveChooser.getSelectedFile();
            if (projectFile == null || projectFile.getParentFile() == null) {
                return;
            }
            String fileName = projectFile.getName();
            if (!fileName.endsWith(".drjava")) {
                int lastIndex = fileName.lastIndexOf(".");
                projectFile = lastIndex == -1 ? new File(projectFile.getAbsolutePath() + ".drjava") : new File(projectFile.getParentFile(), fileName.substring(0, lastIndex) + ".drjava");
            }
            try {
                if (projectFile == null || projectFile.getParentFile() == null || projectFile.getCanonicalFile().exists() && !MainFrameStatics.verifyOverwrite(this, projectFile)) {
                    return;
                }
                this._model.createNewProject(projectFile);
                this._model.configNewProject();
                this._editProject();
                this._setUpProjectButtons(projectFile);
                this._currentProjFile = projectFile;
            }
            catch (IOException e) {
                MainFrameStatics.showIOError(this, e);
            }
        }
    }

    private boolean _saveProjectAs() {
        this._saveChooser.resetChoosableFileFilters();
        this._saveChooser.setFileFilter(this._projectFilter);
        if (this._currentProjFile != FileOps.NULL_FILE) {
            this._saveChooser.setSelectedFile(this._currentProjFile);
        }
        this._saveChooser.setMultiSelectionEnabled(false);
        int rc = this._saveChooser.showSaveDialog(this);
        if (rc == 0) {
            File file = this._saveChooser.getSelectedFile();
            try {
                if (file != null && (!file.getCanonicalFile().exists() || MainFrameStatics.verifyOverwrite(this, file))) {
                    this._model.setProjectFile(file);
                    this._currentProjFile = file;
                }
            }
            catch (IOException e) {
                MainFrameStatics.showIOError(this, e);
                return false;
            }
        }
        return rc == 0;
    }

    void _saveProjectHelper(File file) {
        try {
            String fileName = file.getAbsolutePath();
            if (!(fileName.endsWith(".drjava") || fileName.endsWith(".xml") || fileName.endsWith(".pjt"))) {
                String text = "The file name does not end with a DrJava project file extension (.drjava or .xml or .pjt):\n" + file.getName() + "\n" + "Do you want to append " + ".drjava" + " at the end?";
                Object[] options = new Object[]{"Append .drjava", "Don't Change File Name"};
                int rc = 0;
                if (!Utilities.TEST_MODE) {
                    rc = JOptionPane.showOptionDialog(this, text, "Append Extension?", 0, 3, null, options, options[0]);
                }
                if (rc == 0) {
                    int lastDot = fileName.lastIndexOf(46);
                    file = lastDot == -1 ? new File(fileName + ".drjava") : new File(fileName.substring(0, lastDot) + ".drjava");
                }
            }
            if ((fileName = file.getCanonicalPath()).endsWith(".pjt")) {
                file = MainFrameStatics.proposeToChangeExtension(this, file, "Change Extension?", "The project will be saved in XML format.\nDo you want to change the project file's extension to \".drjava\"?", "Change to \".drjava\"", "Keep \"" + DrJavaFileUtils.getExtension(fileName) + "\"", ".drjava");
                this._model.setProjectFile(file);
                this._currentProjFile = file;
            }
            this._model.saveProject(file, this.gatherProjectDocInfo());
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
        }
        this._recentProjectManager.updateOpenFiles(file);
        this._model.setProjectChanged(false);
    }

    public HashMap<OpenDefinitionsDocument, DocumentInfoGetter> gatherProjectDocInfo() {
        HashMap<OpenDefinitionsDocument, DocumentInfoGetter> map = new HashMap<OpenDefinitionsDocument, DocumentInfoGetter>();
        List<OpenDefinitionsDocument> docs = this._model.getProjectDocuments();
        for (OpenDefinitionsDocument doc : docs) {
            map.put(doc, this._makeInfoGetter(doc));
        }
        return map;
    }

    private DocumentInfoGetter _makeInfoGetter(final OpenDefinitionsDocument doc) {
        JScrollPane s = this._defScrollPanes.get(doc);
        if (s == null) {
            s = this._createDefScrollPane(doc);
        }
        final DefinitionsPane pane = this._currentDefPane;
        return new DocumentInfoGetter(){

            @Override
            public Pair<Integer, Integer> getSelection() {
                Integer selStart = pane.getSelectionStart();
                Integer selEnd = pane.getSelectionEnd();
                if (selStart == 0 && selEnd == 0) {
                    return new Pair<Integer, Integer>(pane.getCaretPosition(), pane.getCaretPosition());
                }
                if (pane.getCaretPosition() == selStart.intValue()) {
                    return new Pair<Integer, Integer>(selEnd, selStart);
                }
                return new Pair<Integer, Integer>(selStart, selEnd);
            }

            @Override
            public Pair<Integer, Integer> getScroll() {
                Integer scrollv = pane.getVerticalScroll();
                Integer scrollh = pane.getHorizontalScroll();
                return new Pair<Integer, Integer>(scrollv, scrollh);
            }

            @Override
            public File getFile() {
                return doc.getRawFile();
            }

            @Override
            public String getPackage() {
                return doc.getPackageName();
            }

            @Override
            public boolean isActive() {
                return MainFrame.this._model.getActiveDocument() == doc;
            }

            @Override
            public boolean isUntitled() {
                return doc.isUntitled();
            }
        };
    }

    private void _revert() {
        List<OpenDefinitionsDocument> l = this._model.getDocumentNavigator().getSelectedDocuments();
        for (OpenDefinitionsDocument d : l) {
            this._revert(d);
        }
    }

    private void _revert(OpenDefinitionsDocument doc) {
        try {
            doc.revertFile();
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
        }
    }

    void quit() {
        if (this._promptBeforeQuit) {
            String title = "Quit DrJava?";
            String message = "Are you sure you want to quit DrJava?";
            ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(this, title, message);
            int rc = dialog.show();
            if (rc != 0) {
                return;
            }
            if (dialog.getCheckBoxValue()) {
                DrJava.getConfig().setSetting(RecentFileManager.QUIT_PROMPT, Boolean.FALSE);
            }
        }
        this._executeExternalDialog.setVisible(false);
        if (!this._closeProject(true)) {
            return;
        }
        this._updateSavedConfiguration();
        this.dispose();
        this._model.quit();
    }

    void _updateSavedConfiguration() {
        this._recentFileManager.saveRecentFiles();
        this._recentProjectManager.saveRecentFiles();
        if (!this._model.closeAllFilesOnQuit()) {
            return;
        }
        this._storePositionInfo();
        if (!DrJava.getConfig().hadStartupException()) {
            try {
                DrJava.getConfig().saveConfiguration();
            }
            catch (IOException ioe) {
                MainFrameStatics.showIOError(this, ioe);
            }
        }
    }

    private void _forceQuit() {
        this._model.forceQuit();
    }

    private void _storePositionInfo() {
        assert (EventQueue.isDispatchThread());
        FileConfiguration config = DrJava.getConfig();
        if (config.getSetting(RecentFileManager.WINDOW_STORE_POSITION).booleanValue()) {
            Rectangle bounds = this.getBounds();
            config.setSetting(RecentFileManager.WINDOW_HEIGHT, bounds.height);
            config.setSetting(RecentFileManager.WINDOW_WIDTH, bounds.width);
            config.setSetting(RecentFileManager.WINDOW_X, bounds.x);
            config.setSetting(RecentFileManager.WINDOW_Y, bounds.y);
            config.setSetting(RecentFileManager.WINDOW_STATE, this.getExtendedState());
        } else {
            config.setSetting(RecentFileManager.WINDOW_HEIGHT, RecentFileManager.WINDOW_HEIGHT.getDefault());
            config.setSetting(RecentFileManager.WINDOW_WIDTH, RecentFileManager.WINDOW_WIDTH.getDefault());
            config.setSetting(RecentFileManager.WINDOW_X, RecentFileManager.WINDOW_X.getDefault());
            config.setSetting(RecentFileManager.WINDOW_Y, RecentFileManager.WINDOW_Y.getDefault());
            config.setSetting(RecentFileManager.WINDOW_STATE, RecentFileManager.WINDOW_STATE.getDefault());
        }
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_GOTOFILE_STORE_POSITION).booleanValue() && this._gotoFileDialog != null && this._gotoFileDialog.getFrameState() != null) {
            config.setSetting(RecentFileManager.DIALOG_GOTOFILE_STATE, this._gotoFileDialog.getFrameState().toString());
        } else {
            config.setSetting(RecentFileManager.DIALOG_GOTOFILE_STATE, RecentFileManager.DIALOG_GOTOFILE_STATE.getDefault());
        }
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_OPENJAVADOC_STORE_POSITION).booleanValue() && this._openJavadocDialog != null && this._openJavadocDialog.getFrameState() != null) {
            config.setSetting(RecentFileManager.DIALOG_OPENJAVADOC_STATE, this._openJavadocDialog.getFrameState().toString());
        } else {
            config.setSetting(RecentFileManager.DIALOG_OPENJAVADOC_STATE, RecentFileManager.DIALOG_OPENJAVADOC_STATE.getDefault());
        }
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_COMPLETE_WORD_STORE_POSITION).booleanValue() && this._completeWordDialog != null && this._completeWordDialog.getFrameState() != null) {
            config.setSetting(RecentFileManager.DIALOG_COMPLETE_WORD_STATE, this._completeWordDialog.getFrameState().toString());
        } else {
            config.setSetting(RecentFileManager.DIALOG_COMPLETE_WORD_STATE, RecentFileManager.DIALOG_COMPLETE_WORD_STATE.getDefault());
        }
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_JAROPTIONS_STORE_POSITION).booleanValue() && this._jarOptionsDialog != null && this._jarOptionsDialog.getFrameState() != null) {
            config.setSetting(RecentFileManager.DIALOG_JAROPTIONS_STATE, this._jarOptionsDialog.getFrameState().toString());
        } else {
            config.setSetting(RecentFileManager.DIALOG_JAROPTIONS_STATE, RecentFileManager.DIALOG_JAROPTIONS_STATE.getDefault());
        }
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_TABBEDPANES_STORE_POSITION).booleanValue() && this._tabbedPanesFrame != null && this._tabbedPanesFrame.getFrameState() != null) {
            config.setSetting(RecentFileManager.DIALOG_TABBEDPANES_STATE, this._tabbedPanesFrame.getFrameState().toString());
        } else {
            config.setSetting(RecentFileManager.DIALOG_TABBEDPANES_STATE, RecentFileManager.DIALOG_TABBEDPANES_STATE.getDefault());
        }
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_DEBUGFRAME_STORE_POSITION).booleanValue() && this._debugFrame != null && this._debugFrame.getFrameState() != null) {
            config.setSetting(RecentFileManager.DIALOG_DEBUGFRAME_STATE, this._debugFrame.getFrameState().toString());
        } else {
            config.setSetting(RecentFileManager.DIALOG_DEBUGFRAME_STATE, RecentFileManager.DIALOG_DEBUGFRAME_STATE.getDefault());
        }
        if (this._showDebugger) {
            config.setSetting(RecentFileManager.DEBUG_PANEL_HEIGHT, this._debugPanel.getHeight());
        }
        config.setSetting(RecentFileManager.DOC_LIST_WIDTH, this._docSplitPane.getDividerLocation());
    }

    private void _cleanUpDebugger() {
        if (this.isDebuggerReady()) {
            this._model.getDebugger().shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compile() {
        this._cleanUpDebugger();
        this.hourglassOn();
        try {
            try {
                this._model.getCompilerModel().compile(this._model.getDocumentNavigator().getSelectedDocuments());
            }
            catch (FileMovedException fme) {
                this._showFileMovedError(fme);
            }
            catch (IOException ioe) {
                MainFrameStatics.showIOError(this, ioe);
            }
        }
        finally {
            this.hourglassOff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compileFolder() {
        this._cleanUpDebugger();
        this.hourglassOn();
        try {
            ArrayList<OpenDefinitionsDocument> docs = this._model.getDocumentNavigator().getDocuments();
            LinkedList<OpenDefinitionsDocument> l = new LinkedList<OpenDefinitionsDocument>();
            if (this._model.getDocumentNavigator().isGroupSelected()) {
                for (OpenDefinitionsDocument doc : docs) {
                    if (!this._model.getDocumentNavigator().isSelectedInGroup(doc)) continue;
                    l.add(doc);
                }
                try {
                    this._model.getCompilerModel().compile(l);
                }
                catch (FileMovedException fme) {
                    this._showFileMovedError(fme);
                }
                catch (IOException ioe) {
                    MainFrameStatics.showIOError(this, ioe);
                }
            }
        }
        finally {
            this.hourglassOff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compileProject() {
        this._cleanUpDebugger();
        this.hourglassOn();
        try {
            this._model.getCompilerModel().compileProject();
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
        }
        finally {
            this.hourglassOff();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _compileAll() {
        this._cleanUpDebugger();
        this.hourglassOn();
        try {
            this._model.getCompilerModel().compileAll();
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
        }
        finally {
            this.hourglassOff();
        }
    }

    private boolean showCleanWarning() {
        if (DrJava.getConfig().getSetting(RecentFileManager.PROMPT_BEFORE_CLEAN).booleanValue()) {
            String buildDirTxt = "";
            try {
                buildDirTxt = this._model.getBuildDirectory().getCanonicalPath();
            }
            catch (Exception e) {
                buildDirTxt = this._model.getBuildDirectory().getPath();
            }
            ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(this, "Clean Build Directory?", "Cleaning your build directory will delete all\nclass files and empty folders within that directory.\nAre you sure you want to clean\n" + buildDirTxt + "?", "Do not show this message again");
            int rc = dialog.show();
            switch (rc) {
                case 0: {
                    this._saveAll();
                    if (dialog.getCheckBoxValue()) {
                        DrJava.getConfig().setSetting(RecentFileManager.PROMPT_BEFORE_CLEAN, Boolean.FALSE);
                    }
                    return true;
                }
                case 1: {
                    return false;
                }
                case 2: {
                    return false;
                }
                case -1: {
                    return false;
                }
            }
            throw new RuntimeException("Invalid rc from showConfirmDialog: " + rc);
        }
        return true;
    }

    private void _clean() {
        this._model.cleanBuildDirectory();
    }

    private void _scanClassFiles() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                File buildDir = MainFrame.this._model.getBuildDirectory();
                HashSet<MainFrameStatics.GoToFileListEntry> hs = new HashSet<MainFrameStatics.GoToFileListEntry>();
                HashSet<MainFrameStatics.JavaAPIListEntry> hs2 = new HashSet<MainFrameStatics.JavaAPIListEntry>();
                if (buildDir != null) {
                    List<File> classFiles = MainFrame.this._model.getClassFiles();
                    DummyOpenDefDoc dummyDoc = new DummyOpenDefDoc();
                    for (File f : classFiles) {
                        String s = f.toString();
                        if (s.lastIndexOf(File.separatorChar) >= 0) {
                            s = s.substring(s.lastIndexOf(File.separatorChar) + 1);
                        }
                        s = s.substring(0, s.lastIndexOf(".class"));
                        s = s.replace('$', '.');
                        int pos = 0;
                        boolean ok = true;
                        while ((pos = s.indexOf(46, pos)) >= 0) {
                            if (s.length() <= pos + 1 || Character.isDigit(s.charAt(pos + 1))) {
                                ok = false;
                                break;
                            }
                            ++pos;
                        }
                        if (!ok) continue;
                        if (s.lastIndexOf(46) >= 0) {
                            s = s.substring(s.lastIndexOf(46) + 1);
                        }
                        MainFrameStatics.GoToFileListEntry entry = new MainFrameStatics.GoToFileListEntry(dummyDoc, s);
                        hs.add(entry);
                        try {
                            String rel = FileOps.stringMakeRelativeTo(f, buildDir);
                            String full = rel.replace(File.separatorChar, '.');
                            if ((full = full.substring(0, full.lastIndexOf(".class"))).indexOf(36) >= 0) continue;
                            hs2.add(new MainFrameStatics.JavaAPIListEntry(s, full, null));
                        }
                        catch (IOException ioe) {
                        }
                        catch (SecurityException se) {}
                    }
                }
                MainFrame.this.clearCompleteClassSet();
                MainFrame.this._completeClassSet.addAll(hs);
                MainFrame.this._autoImportClassSet = new HashSet(hs2);
            }
        });
        t.setPriority(1);
        t.start();
    }

    private void _runProject() {
        block7: {
            if (this._model.isProjectActive()) {
                try {
                    File f = this._model.getMainClassContainingFile();
                    if (f == null) break block7;
                    this.updateStatusField("Running Open Project");
                    OpenDefinitionsDocument doc = this._model.getDocumentForFile(f);
                    boolean smart = DrJava.getConfig().getSetting(OptionConstants.SMART_RUN_FOR_APPLETS_AND_PROGRAMS);
                    if (smart) {
                        doc.runSmart(this._model.getMainClass());
                        break block7;
                    }
                    doc.runMain(this._model.getMainClass());
                }
                catch (ClassNameNotFoundException e) {
                    String msg = "DrJava could not find the top level class name in the\ncurrent document, so it could not run the class.  Please\nmake sure that the class is properly defined first.";
                    JOptionPane.showMessageDialog(this, msg, "No Class Found", 0);
                }
                catch (FileMovedException fme) {
                    this._showFileMovedError(fme);
                }
                catch (IOException ioe) {
                    MainFrameStatics.showIOError(this, ioe);
                }
            } else {
                this._runMain();
            }
        }
    }

    private void _runMain() {
        try {
            boolean smart = DrJava.getConfig().getSetting(OptionConstants.SMART_RUN_FOR_APPLETS_AND_PROGRAMS);
            if (smart) {
                this.updateStatusField("Running main Method of Current Document");
                this._model.getActiveDocument().runSmart(null);
            } else {
                this.updateStatusField("Running Current Document");
                this._model.getActiveDocument().runMain(null);
            }
        }
        catch (ClassNameNotFoundException e) {
            String msg = "DrJava could not find the top level class name in the\ncurrent document, so it could not run the class.  Please\nmake sure that the class is properly defined first.";
            JOptionPane.showMessageDialog(this, msg, "No Class Found", 0);
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
        }
    }

    private void _runApplet() {
        this.updateStatusField("Running Current Document as Applet");
        try {
            this._model.getActiveDocument().runApplet(null);
        }
        catch (ClassNameNotFoundException e) {
            String msg = "DrJava could not find the top level class name in the\ncurrent document, so it could not run the class.  Please\nmake sure that the class is properly defined first.";
            JOptionPane.showMessageDialog(this, msg, "No Class Found", 0);
        }
        catch (FileMovedException fme) {
            this._showFileMovedError(fme);
        }
        catch (IOException ioe) {
            MainFrameStatics.showIOError(this, ioe);
        }
    }

    private void _junit() {
        assert (Utilities.TEST_MODE || EventQueue.isDispatchThread());
        this.hourglassOn();
        this._guiAvailabilityNotifier.junitStarted();
        try {
            this._model.getJUnitModel().junitDocs(this._model.getDocumentNavigator().getSelectedDocuments());
        }
        catch (UnexpectedException e) {
            this._junitInterrupted(e);
        }
        catch (Exception e) {
            this._junitInterrupted(new UnexpectedException(e));
        }
    }

    private void _junitFolder() {
        this.updateStatusField("Running Unit Tests in Current Folder");
        this.hourglassOn();
        this._guiAvailabilityNotifier.junitStarted();
        if (this._model.getDocumentNavigator().isGroupSelected()) {
            ArrayList<OpenDefinitionsDocument> docs = this._model.getDocumentNavigator().getDocuments();
            LinkedList<OpenDefinitionsDocument> l = new LinkedList<OpenDefinitionsDocument>();
            for (OpenDefinitionsDocument doc : docs) {
                if (!this._model.getDocumentNavigator().isSelectedInGroup(doc)) continue;
                l.add(doc);
            }
            try {
                this._model.getJUnitModel().junitDocs(l);
            }
            catch (UnexpectedException e) {
                this._junitInterrupted(e);
            }
            catch (Exception e) {
                this._junitInterrupted(new UnexpectedException(e));
            }
        }
    }

    private void _junitProject() {
        this.updateStatusField("Running JUnit Tests in Project");
        this.hourglassOn();
        this._guiAvailabilityNotifier.junitStarted();
        try {
            this._model.getJUnitModel().junitProject();
        }
        catch (UnexpectedException e) {
            this._junitInterrupted(e);
        }
        catch (Exception e) {
            this._junitInterrupted(new UnexpectedException(e));
        }
    }

    private void _junitAll() {
        this.updateStatusField("Running All Open Unit Tests");
        this.hourglassOn();
        this._guiAvailabilityNotifier.junitStarted();
        try {
            this._model.getJUnitModel().junitAll();
        }
        catch (UnexpectedException e) {
            this._junitInterrupted(e);
        }
        catch (Exception e) {
            this._junitInterrupted(new UnexpectedException(e));
        }
    }

    void debuggerResume() throws DebugException {
        if (this.isDebuggerReady()) {
            this._model.getDebugger().resume();
            this.removeCurrentLocationHighlight();
        }
    }

    void debuggerAutomaticTrace() {
        _log.log("debuggerAutomaticTrace(): isDebuggerReady() = " + this.isDebuggerReady());
        if (this.isDebuggerReady()) {
            if (!this._model.getDebugger().isAutomaticTraceEnabled()) {
                this.enableAutomaticTrace();
            } else {
                this.disableAutomaticTrace();
            }
        }
    }

    private void enableAutomaticTrace() {
        if (!this.isDebuggerEnabled()) {
            return;
        }
        try {
            int rate = DrJava.getConfig().getSetting(OptionConstants.AUTO_STEP_RATE);
            this._automaticTraceTimer = new Timer(rate, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this._debugStepTimer.stop();
                    if (MainFrame.this._model.getDebugger().isAutomaticTraceEnabled()) {
                        MainFrame.this.debuggerStep(Debugger.StepType.STEP_INTO);
                    }
                }
            });
            this._automaticTraceTimer.setRepeats(false);
            this._model.getDebugger().setAutomaticTraceEnabled(true);
            this._debugPanel.setAutomaticTraceButtonText();
            this.debuggerStep(Debugger.StepType.STEP_INTO);
            this._debugStepTimer.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void disableAutomaticTrace() {
        if (!this.isDebuggerEnabled()) {
            return;
        }
        _log.log("disableAutomaticTrace(): isDebuggerReady() = " + this.isDebuggerReady());
        this._model.getDebugger().setAutomaticTraceEnabled(false);
        this._debugPanel.setAutomaticTraceButtonText();
        if (this._automaticTraceTimer != null) {
            this._automaticTraceTimer.stop();
        }
    }

    void debuggerStep(Debugger.StepType type) {
        if (this.isDebuggerReady()) {
            try {
                this._model.getDebugger().step(type);
            }
            catch (IllegalStateException ise) {
            }
            catch (DebugException de) {
                MainFrameStatics.showError(this, de, "Debugger Error", "Could not create a step request.");
            }
        }
    }

    void debuggerToggleBreakpoint() {
        this.addToBrowserHistory();
        OpenDefinitionsDocument doc = this._model.getActiveDocument();
        boolean isUntitled = doc.isUntitled();
        if (isUntitled) {
            JOptionPane.showMessageDialog(this, "You must save and compile this document before you can\nset a breakpoint in it.", "Must Save and Compile", 0);
            return;
        }
        boolean isModified = doc.isModifiedSinceSave();
        if (this.isDebuggerReady() && isModified && !this._currentDefPane.hasWarnedAboutModified() && DrJava.getConfig().getSetting(RecentFileManager.WARN_BREAKPOINT_OUT_OF_SYNC).booleanValue()) {
            String message = "This document has been modified and may be out of sync\nwith the debugger.  It is recommended that you first\nsave and recompile before continuing to use the debugger,\nto avoid any unexpected errors.  Would you still like to\ntoggle the breakpoint on the specified line?";
            String title = "Toggle breakpoint on modified file?";
            ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(this, title, message);
            int rc = dialog.show();
            switch (rc) {
                case 0: {
                    this._currentDefPane.hasWarnedAboutModified(true);
                    if (!dialog.getCheckBoxValue()) break;
                    DrJava.getConfig().setSetting(RecentFileManager.WARN_BREAKPOINT_OUT_OF_SYNC, Boolean.FALSE);
                    break;
                }
                case 1: {
                    if (dialog.getCheckBoxValue()) {
                        DrJava.getConfig().setSetting(RecentFileManager.WARN_BREAKPOINT_OUT_OF_SYNC, Boolean.FALSE);
                    }
                    return;
                }
                case -1: 
                case 2: {
                    return;
                }
                default: {
                    throw new RuntimeException("Invalid rc from showConfirmDialog: " + rc);
                }
            }
        }
        try {
            Debugger debugger = this._model.getDebugger();
            boolean breakpointSet = debugger.toggleBreakpoint(doc, this._currentDefPane.getCaretPosition(), true);
            if (breakpointSet) {
                this.showBreakpoints();
            }
        }
        catch (DebugException de) {
            MainFrameStatics.showError(this, de, "Debugger Error", "Could not set a breakpoint at the current line.");
        }
    }

    void debuggerClearAllBreakpoints() {
        this._model.getBreakpointManager().clearRegions();
    }

    void _showFileMovedError(FileMovedException fme) {
        try {
            File f = fme.getFile();
            OpenDefinitionsDocument doc = this._model.getDocumentForFile(f);
            if (doc != null && this._saveSelector.shouldSaveAfterFileMoved(doc, f)) {
                this._saveAs();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void _showProjectFileParseError(MalformedProjectFileException mpfe) {
        MainFrameStatics.showProjectFileParseError(this, mpfe);
    }

    void _showFileNotFoundError(FileNotFoundException fnf) {
        MainFrameStatics.showFileNotFoundError(this, fnf);
    }

    void _showIOError(IOException ioe) {
        MainFrameStatics.showIOError(this, ioe);
    }

    void _showClassNotFoundError(ClassNotFoundException cnfe) {
        MainFrameStatics.showClassNotFoundError(this, cnfe);
    }

    void _showNoClassDefError(NoClassDefFoundError ncde) {
        MainFrameStatics.showNoClassDefError(this, ncde);
    }

    void _showDebugError(DebugException de) {
        MainFrameStatics.showDebugError(this, de);
    }

    void _showJUnitInterrupted(UnexpectedException e) {
        MainFrameStatics.showJUnitInterrupted((Component)this, e);
    }

    void _showJUnitInterrupted(String message) {
        MainFrameStatics.showJUnitInterrupted((Component)this, message);
    }

    void _showError(Throwable e, String title, String message) {
        MainFrameStatics.showError(this, e, title, message);
    }

    void _showWarning(Throwable e, String title, String message) {
        MainFrameStatics.showWarning(this, e, title, message);
    }

    private void _showConfigException() {
        if (DrJava.getConfig().hadStartupException()) {
            try {
                DrJava.getConfig().saveConfiguration();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            Exception e = DrJava.getConfig().getStartupException();
            MainFrameStatics.showError(this, e, "Error in Config File", "Could not read the '.drjava' configuration file\nin your home directory.  Starting with default\nvalues instead.\n\nThe problem was:\n");
        }
    }

    private File getChosenFile(JFileChooser fc, int choice, File previous, boolean addSourceFileExtension) throws OperationCanceledException {
        switch (choice) {
            case -1: 
            case 1: {
                throw new OperationCanceledException();
            }
            case 0: {
                File chosen = fc.getSelectedFile();
                if (chosen != null) {
                    if (addSourceFileExtension && chosen.getName().indexOf(".") == -1) {
                        String previousName;
                        String string = previousName = previous != null ? previous.getName() : "";
                        if (!DrJavaFileUtils.isSourceFile(previousName)) {
                            File newFile = new File(chosen.getAbsolutePath() + this.getSuggestedFileExtension());
                            return newFile;
                        }
                        int previousLastDotPos = previousName.lastIndexOf(".");
                        String previousExt = previousName.substring(previousLastDotPos);
                        File newFile = new File(chosen.getAbsolutePath() + previousExt);
                        return newFile;
                    }
                    return chosen;
                }
                throw new RuntimeException("Filechooser returned null file");
            }
        }
        throw new RuntimeException("Filechooser returned bad rc " + choice);
    }

    private File[] getChosenFiles(JFileChooser fc, int choice) throws OperationCanceledException {
        switch (choice) {
            case -1: 
            case 1: {
                throw new OperationCanceledException();
            }
            case 0: {
                File[] chosen = fc.getSelectedFiles();
                if (chosen == null) {
                    throw new UnexpectedException(new OperationCanceledException(), "filechooser returned null file");
                }
                if (chosen.length == 0) {
                    if (!fc.isMultiSelectionEnabled()) {
                        return new File[]{fc.getSelectedFile()};
                    }
                    throw new OperationCanceledException();
                }
                return chosen;
            }
        }
        throw new UnexpectedException(new OperationCanceledException(), "filechooser returned bad rc " + choice);
    }

    private void _selectAll() {
        this._currentDefPane.selectAll();
    }

    public int _jumpToLine(int lineNum) {
        int pos = this._model.getActiveDocument().gotoLine(lineNum);
        this.addToBrowserHistory();
        this._currentDefPane.setCaretPosition(pos);
        this._currentDefPane.centerViewOnOffset(pos);
        return pos;
    }

    private int _gotoLine() {
        String msg = "What line would you like to go to?";
        String title = "Go to Line";
        String lineStr = JOptionPane.showInputDialog(this, "What line would you like to go to?", "Go to Line", 3);
        try {
            if (lineStr != null) {
                int lineNum = Integer.parseInt(lineStr);
                return this._jumpToLine(lineNum);
            }
        }
        catch (NumberFormatException nfe) {
            Toolkit.getDefaultToolkit().beep();
        }
        return -1;
    }

    private void _removeErrorListener(OpenDefinitionsDocument doc) {
        JScrollPane scroll = this._defScrollPanes.get(doc);
        if (scroll != null) {
            DefinitionsPane pane = (DefinitionsPane)scroll.getViewport().getView();
            pane.removeCaretListener(pane.getErrorCaretListener());
        }
    }

    void _addGUIAvailabilityListener(Action a, GUIAvailabilityListener.ComponentType ... components) {
        this._guiAvailabilityNotifier.addListener(new AndGUIAvailabilityActionAdapter(a, this._guiAvailabilityNotifier, components));
    }

    void _addGUIAvailabilityListener(Component a, GUIAvailabilityListener.ComponentType ... components) {
        this._guiAvailabilityNotifier.addListener(new AndGUIAvailabilityComponentAdapter(a, this._guiAvailabilityNotifier, components));
    }

    void _displayGUIComponentAvailabilityFrame() {
        JFrame frame = new JFrame("GUI Availability");
        frame.setAlwaysOnTop(true);
        frame.setLocationByPlatform(true);
        frame.getContentPane().setLayout(new BoxLayout(frame.getContentPane(), 3));
        for (final GUIAvailabilityListener.ComponentType c : GUIAvailabilityListener.ComponentType.values()) {
            final DelayedThunk<JButton> buttonThunk = DelayedThunk.make();
            final JButton button = new JButton(new AbstractAction(c.toString() + " " + this._guiAvailabilityNotifier.getCount(c)){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this._guiAvailabilityNotifier.availabilityChanged(c, !((JButton)buttonThunk.value()).getText().endsWith(" 0"));
                }
            });
            buttonThunk.set(button);
            this._guiAvailabilityNotifier.addListener(new AndGUIAvailabilityListener(this._guiAvailabilityNotifier, new GUIAvailabilityListener.ComponentType[]{c}){

                @Override
                public void availabilityChanged(boolean available) {
                    button.setText(c.toString() + " " + MainFrame.this._guiAvailabilityNotifier.getCount(c));
                    button.setSelected(available);
                }
            });
            button.setSelected(this._guiAvailabilityNotifier.isAvailable(c));
            frame.add(button);
        }
        frame.pack();
        frame.setVisible(true);
    }

    private void _setUpGUIComponentAvailability() {
        this._guiAvailabilityNotifier.ensureUnavailable(GUIAvailabilityListener.ComponentType.PROJECT);
        this._guiAvailabilityNotifier.ensureUnavailable(GUIAvailabilityListener.ComponentType.PROJECT_BUILD_DIR);
        this._guiAvailabilityNotifier.ensureUnavailable(GUIAvailabilityListener.ComponentType.PROJECT_MAIN_CLASS);
        this._guiAvailabilityNotifier.ensureUnavailable(GUIAvailabilityListener.ComponentType.DEBUGGER);
        this._guiAvailabilityNotifier.ensureUnavailable(GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        this._guiAvailabilityNotifier.ensureAvailable(GUIAvailabilityListener.ComponentType.JUNIT);
        this._guiAvailabilityNotifier.ensureAvailable(GUIAvailabilityListener.ComponentType.COMPILER);
        this._guiAvailabilityNotifier.ensureAvailabilityIs(GUIAvailabilityListener.ComponentType.JAVADOC, this._model.getJavadocModel().isAvailable());
    }

    private void _setUpActions() {
        this._setUpAction(this._newAction, "New", "Create a new document");
        this._setUpAction(this._newClassAction, "New", "Create a new Java Class");
        this._setUpAction(this._newJUnitTestAction, "New", "Create a new JUnit test case class");
        this._setUpAction(this._newProjectAction, "New", "Make a new project");
        this._setUpAction(this._openAction, "Open", "Open an existing file");
        this._setUpAction(this._openFolderAction, "Open Folder", "OpenAll", "Open all files within a directory");
        this._setUpAction(this._openFileOrProjectAction, "Open", "Open an existing file or project");
        this._setUpAction(this._openProjectAction, "Open", "Open an existing project");
        this._setUpAction(this._saveAction, "Save", "Save the current document");
        this._setUpAction(this._saveAsAction, "Save As", "SaveAs", "Save the current document with a new name");
        this._setUpAction(this._saveCopyAction, "Save Copy", "SaveAs", "Save a copy of the current document");
        this._setUpAction(this._renameAction, "Rename", "Rename", "Rename the current document");
        this._setUpAction(this._saveProjectAction, "Save", "Save", "Save the current project");
        this._setUpAction(this._saveProjectAsAction, "Save As", "SaveAs", "Save current project to new project file");
        this._setUpAction(this._exportProjectInOldFormatAction, "Export Project In Old \".pjt\" Format", "SaveAs", "Export Project In Old \".pjt\" Format");
        this._setUpAction(this._revertAction, "Revert", "Revert the current document to the saved version");
        this._setUpAction(this._closeAction, "Close", "Close the current document");
        this._setUpAction(this._closeAllAction, "Close All", "CloseAll", "Close all documents");
        this._setUpAction(this._closeProjectAction, "Close", "CloseAll", "Close the current project");
        this._setUpAction(this._projectPropertiesAction, "Project Properties for " + this._model.getProjectFile().getName(), "Preferences", "Edit Project Properties");
        this._setUpAction(this._junitProjectAction, "Test Project", "Test the documents in the project source tree");
        this._setUpAction(this._compileProjectAction, "Compile Project", "Compile the documents in the project source tree");
        this._setUpAction(this._runProjectAction, "Run Project", "Run the project's main method");
        this._setUpAction(this._jarProjectAction, "Jar", "Create a jar archive from this project");
        this._setUpAction(this._saveAllAction, "Save All", "SaveAll", "Save all open documents");
        this._setUpAction(this._cleanAction, "Clean", "Clean Build directory");
        this._setUpAction(this._autoRefreshAction, "Auto-Refresh", "Auto-refresh project");
        this._setUpAction(this._compileAction, "Compile Current Document", "Compile the current document");
        this._setUpAction(this._compileAllAction, "Compile", "Compile all open documents");
        this._setUpAction(this._printDefDocAction, "Print", "Print the current document");
        this._setUpAction(this._printConsoleAction, "Print", "Print the Console pane");
        this._setUpAction(this._printInteractionsAction, "Print", "Print the Interactions pane");
        this._setUpAction(this._pageSetupAction, "Page Setup", "PageSetup", "Change the printer settings");
        this._setUpAction(this._printDefDocPreviewAction, "Print Preview", "PrintPreview", "Preview how the document will be printed");
        this._setUpAction(this._printConsolePreviewAction, "Print Preview", "PrintPreview", "Preview how the console document will be printed");
        this._setUpAction(this._printInteractionsPreviewAction, "Print Preview", "PrintPreview", "Preview how the interactions document will be printed");
        this._setUpAction(this._quitAction, "Quit", "Quit", "Quit DrJava");
        this._setUpAction(this._undoAction, "Undo", "Undo previous command");
        this._setUpAction(this._redoAction, "Redo", "Redo last undo");
        this._undoAction.putValue("Name", "Undo previous command");
        this._redoAction.putValue("Name", "Redo last undo");
        this._setUpAction(this.cutAction, "Cut", "Cut selected text to the clipboard");
        this._setUpAction(this.copyAction, "Copy", "Copy selected text to the clipboard");
        this._setUpAction(this.pasteAction, "Paste", "Paste text from the clipboard");
        this._setUpAction(this._pasteHistoryAction, "Paste from History", "Paste text from the clipboard history");
        this._setUpAction(this._selectAllAction, "Select All", "Select all text");
        this.cutAction.putValue("Name", "Cut");
        this.copyAction.putValue("Name", "Copy");
        this.pasteAction.putValue("Name", "Paste");
        this._pasteHistoryAction.putValue("Name", "Paste from History");
        this._setUpAction(this._indentLinesAction, "Indent Lines", "Indent all selected lines");
        this._setUpAction(this._commentLinesAction, "Comment Lines", "Comment out all selected lines");
        this._setUpAction(this._uncommentLinesAction, "Uncomment Lines", "Uncomment all selected lines");
        this._setUpAction(this.completeWordUnderCursorAction, "Auto-Complete Word Under Cursor", "Auto-complete the word the cursor is currently located on");
        this._setUpAction(this._bookmarksPanelAction, "Bookmarks", "Display the bookmarks panel");
        this._setUpAction(this._toggleBookmarkAction, "Toggle Bookmark", "Toggle the bookmark at the current cursor location");
        this._setUpAction(this._followFileAction, "Follow File", "Follow a file's updates");
        this._setUpAction(this._executeExternalProcessAction, "Execute External", "Execute external process");
        this._setUpAction(this._editExternalProcessesAction, "Preferences", "Edit saved external processes");
        this._setUpAction(this._findReplaceAction, "Find", "Find or replace text in the document");
        this._setUpAction(this._findNextAction, "Find Next", "Repeats the last find");
        this._setUpAction(this._findPrevAction, "Find Previous", "Repeats the last find in the opposite direction");
        this._setUpAction(this._gotoLineAction, "Go to line", "Go to a line number in the document");
        this._setUpAction(this._gotoFileAction, "Go to File", "Go to a file specified by its name");
        this._setUpAction(this._gotoFileUnderCursorAction, "Go to File Under Cursor", "Go to the file specified by the word the cursor is located on");
        this._setUpAction(this._switchToPrevAction, "Previous Document", "Up", "Switch to the previous document");
        this._setUpAction(this._switchToNextAction, "Next Document", "Down", "Switch to the next document");
        this._setUpAction(this._browseBackAction, "Back", "Back", "Move back in the browser history");
        this._setUpAction(this._browseForwardAction, "Forward", "Forward", "Move forward in the browser history");
        this._setUpAction(this._prevRegionAction, "Previous Region", "Move to previous region in tabbed pane");
        this._setUpAction(this._nextRegionAction, "Next Region", "Move to next region in tabbed pane");
        this._setUpAction(this._switchToPreviousPaneAction, "Previous Pane", "Switch focus to the previous pane");
        this._setUpAction(this._switchToNextPaneAction, "Next Pane", "Switch focus to the next pane");
        this._setUpAction(this._gotoOpeningBraceAction, "Go to Opening Brace", "Go th the opening brace of the block enclosing the cursor");
        this._setUpAction(this._gotoClosingBraceAction, "Go to Closing Brace", "Go th the closing brace of the block enclosing the cursor");
        this._setUpAction(this._editPreferencesAction, "Preferences", "Edit configurable settings in DrJava");
        this._setUpAction(this._junitAction, "Test Current", "Run JUnit over the current document");
        this._setUpAction(this._junitAllAction, "Test", "Run JUnit over all open JUnit tests");
        if (this._model.getJavadocModel().isAvailable()) {
            this._setUpAction(this._javadocAllAction, "Javadoc", "Create and save Javadoc for the packages of all open documents");
            this._setUpAction(this._javadocCurrentAction, "Preview Javadoc Current", "Preview the Javadoc for the current document");
        } else {
            this._setUpAction(this._javadocAllAction, "Javadoc", "Note: DrJava cannot run Javadoc because no JDK was found. Please install a JDK.");
            this._setUpAction(this._javadocCurrentAction, "Preview Javadoc Current", "Note: DrJava cannot run Javadoc because no JDK was found.  Please install a JDK.");
        }
        this._setUpAction(this._runAction, "Run", "Run the main method of the current document");
        this._setUpAction(this._runAppletAction, "Run", "Run the current document as applet");
        this._setUpAction(this._openJavadocAction, "Open Java API Javadoc...", "Open the Java API Javadoc Web page for a class");
        this._setUpAction(this._openJavadocUnderCursorAction, "Open Java API Javadoc for Word Under Cursor...", "Open the Java API Javadoc Web page for the word under the cursor");
        this._setUpAction(this._saveInteractionsCopyAction, "Save Copy of Interactions...", "SaveAs", "Save copy of interactions contents to a file");
        this._setUpAction(this._executeHistoryAction, "Execute History", "Load and execute a history of interactions from a file");
        this._setUpAction(this._loadHistoryScriptAction, "Load History as Script", "Load a history from a file as a series of interactions");
        this._setUpAction(this._saveHistoryAction, "Save History", "Save the history of interactions to a file");
        this._setUpAction(this._clearHistoryAction, "Clear History", "Clear the current history of interactions");
        this._setUpAction(this._resetInteractionsAction, "Reset", "Reset the Interactions Pane");
        this._setUpAction(this._closeSystemInAction, "Close System.in", "Close System.in Stream in Interactions Pane");
        this._setUpAction(this._viewInteractionsClassPathAction, "View Interactions Classpath", "Display the classpath in use by the Interactions Pane");
        this._setUpAction(this._copyInteractionToDefinitionsAction, "Lift Current Interaction", "Copy the current interaction into the Definitions Pane");
        this._setUpAction(this._saveConsoleCopyAction, "Save Copy of Console...", "SaveAs", "Save copy of console contents to a file");
        this._setUpAction(this._clearConsoleAction, "Clear Console", "Clear all text in the Console Pane");
        this._setUpAction(this._showDebugConsoleAction, "Show DrJava Debug Console", "<html>Show a console for debugging DrJava<br>(with \"mainFrame\", \"model\", and \"config\" variables defined)</html>");
        if (this._model.getDebugger().isAvailable()) {
            this._setUpAction(this._toggleDebuggerAction, "Debug Mode", "Enable or disable DrJava's debugger");
            this._setUpAction(this._toggleBreakpointAction, "Toggle Breakpoint", "Set or clear a breakpoint on the current line");
            this._setUpAction(this._clearAllBreakpointsAction, "Clear Breakpoints", "Clear all breakpoints in all classes");
            this._setUpAction(this._resumeDebugAction, "Resume", "Resume the current suspended thread");
            this._setUpAction(this._automaticTraceDebugAction, "Automatic Trace", "Automatically trace through entire program");
            this._setUpAction(this._stepIntoDebugAction, "Step Into", "Step into the current line or method call");
            this._setUpAction(this._stepOverDebugAction, "Step Over", "Step over the current line or method call");
            this._setUpAction(this._stepOutDebugAction, "Step Out", "Step out of the current method");
            this._setUpAction(this._breakpointsPanelAction, "Breakpoints", "Display the breakpoints panel");
        }
        this._setUpAction(this._helpAction, "Help", "Show documentation on how to use DrJava");
        this._setUpAction(this._quickStartAction, "Help", "View Quick Start Guide for DrJava");
        this._setUpAction(this._aboutAction, "About", "About DrJava");
        this._setUpAction(this._checkNewVersionAction, "Check for New Version", "Find", "Check for New Version");
        this._checkNewVersionAction.setEnabled(DrJava.getConfig().getSetting(OptionConstants.NEW_VERSION_ALLOWED));
        this._setUpAction(this._errorsAction, "DrJava Errors", "drjavaerror", "Show a window with internal DrJava errors");
        this._setUpAction(this._forceQuitAction, "Force Quit", "Stop", "Force DrJava to quit without cleaning up");
        this._setUpAction(this._generateCustomDrJavaJarAction, "Generate Custom drjava.jar...", "<html>Generate a custom drjava.jar file that includes additional files,<br>e.g. libraries or resources.</html>");
    }

    private void _setUpAction(Action a, String name, String icon, String longDesc) {
        a.putValue("SmallIcon", this._getIcon(icon + "16.gif"));
        a.putValue("Default", name);
        a.putValue("LongDescription", longDesc);
    }

    private void _setUpAction(Action a, String icon, String shortDesc) {
        this._setUpAction(a, icon, icon, shortDesc);
    }

    private ImageIcon _getIcon(String name) {
        return MainFrame.getIcon(name);
    }

    public static ImageIcon getIcon(String name) {
        URL url = MainFrame.class.getResource(ICON_PATH + name);
        if (url != null) {
            return new ImageIcon(url);
        }
        return null;
    }

    public void addMenuBarInOtherFrame(JMenuBar menuBar) {
        JMenu fileMenu = menuBar.getMenu(Utilities.getComponentIndex(this._fileMenu));
        this._recentFileManager.addMirroredMenu(fileMenu);
        JMenu projectMenu = menuBar.getMenu(Utilities.getComponentIndex(this._projectMenu));
        this._recentProjectManager.addMirroredMenu(projectMenu);
    }

    public void removeMenuBarInOtherFrame(JMenuBar menuBar) {
        JMenu fileMenu = menuBar.getMenu(Utilities.getComponentIndex(this._fileMenu));
        this._recentFileManager.removeMirroredMenu(fileMenu);
        JMenu projectMenu = menuBar.getMenu(Utilities.getComponentIndex(this._projectMenu));
        this._recentProjectManager.removeMirroredMenu(projectMenu);
    }

    void _setUpMenuBar(JMenuBar menuBar) {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this._setUpMenuBar(menuBar, this._setUpFileMenu(mask, false), this._setUpEditMenu(mask, false), this._setUpToolsMenu(mask, false), this._setUpProjectMenu(mask, false), this._showDebugger ? this._setUpDebugMenu(mask, false) : null, this._setUpLanguageLevelMenu(mask, false), this._setUpHelpMenu(mask, false));
    }

    void _setUpMenuBar(JMenuBar menuBar, JMenu fileMenu, JMenu editMenu, JMenu toolsMenu, JMenu projectMenu, JMenu debugMenu, JMenu languageLevelMenu, JMenu helpMenu) {
        menuBar.add(fileMenu);
        menuBar.add(editMenu);
        menuBar.add(toolsMenu);
        menuBar.add(projectMenu);
        if (this._showDebugger && debugMenu != null) {
            menuBar.add(debugMenu);
        }
        menuBar.add(languageLevelMenu);
        menuBar.add(helpMenu);
        if (Utilities.isPlasticLaf()) {
            menuBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        }
    }

    private JMenuItem _addMenuItem(JMenu menu, Action a, VectorOption<KeyStroke> opt, boolean updateKeyboardManager) {
        JMenuItem item = menu.add(a);
        this._setMenuShortcut(item, a, opt, updateKeyboardManager);
        return item;
    }

    private JMenuItem _addMenuItem(JMenu menu, Action a, VectorOption<KeyStroke> opt, int index, boolean updateKeyboardManager) {
        JMenuItem item = menu.insert(a, index);
        this._setMenuShortcut(item, a, opt, updateKeyboardManager);
        return item;
    }

    private void _setMenuShortcut(JMenuItem item, Action a, VectorOption<KeyStroke> opt, boolean updateKeyboardManager) {
        Vector keys = (Vector)((Object)DrJava.getConfig().getSetting(opt));
        if (updateKeyboardManager) {
            KeyBindingManager.ONLY.put(opt, a, item, item.getText());
        }
        if (keys.size() > 0 && KeyBindingManager.ONLY.get((KeyStroke)keys.get(0)) == a) {
            item.setAccelerator((KeyStroke)keys.get(0));
        }
    }

    private JMenu _setUpFileMenu(int mask, boolean updateKeyboardManager) {
        JMenu fileMenu = new JMenu("File");
        PlatformFactory.ONLY.setMnemonic((AbstractButton)fileMenu, 70);
        this._addMenuItem(fileMenu, this._newAction, RecentFileManager.KEY_NEW_FILE, updateKeyboardManager);
        this._addMenuItem(fileMenu, this._newClassAction, OptionConstants.KEY_NEW_CLASS_FILE, updateKeyboardManager);
        this._addMenuItem(fileMenu, this._newJUnitTestAction, RecentFileManager.KEY_NEW_TEST, updateKeyboardManager);
        this._addMenuItem(fileMenu, this._openAction, RecentFileManager.KEY_OPEN_FILE, updateKeyboardManager);
        this._addMenuItem(fileMenu, this._openFolderAction, RecentFileManager.KEY_OPEN_FOLDER, updateKeyboardManager);
        fileMenu.addSeparator();
        this._addMenuItem(fileMenu, this._saveAction, RecentFileManager.KEY_SAVE_FILE, updateKeyboardManager);
        this._saveAction.setEnabled(true);
        this._addMenuItem(fileMenu, this._saveAsAction, RecentFileManager.KEY_SAVE_FILE_AS, updateKeyboardManager);
        this._addMenuItem(fileMenu, this._saveCopyAction, RecentFileManager.KEY_SAVE_FILE_COPY, updateKeyboardManager);
        this._addMenuItem(fileMenu, this._saveAllAction, RecentFileManager.KEY_SAVE_ALL_FILES, updateKeyboardManager);
        this._addMenuItem(fileMenu, this._renameAction, RecentFileManager.KEY_RENAME_FILE, updateKeyboardManager);
        this._renameAction.setEnabled(false);
        this._addMenuItem(fileMenu, this._revertAction, RecentFileManager.KEY_REVERT_FILE, updateKeyboardManager);
        this._revertAction.setEnabled(false);
        fileMenu.addSeparator();
        this._addMenuItem(fileMenu, this._closeAction, RecentFileManager.KEY_CLOSE_FILE, updateKeyboardManager);
        this._addMenuItem(fileMenu, this._closeAllAction, RecentFileManager.KEY_CLOSE_ALL_FILES, updateKeyboardManager);
        fileMenu.addSeparator();
        this._addMenuItem(fileMenu, this._pageSetupAction, RecentFileManager.KEY_PAGE_SETUP, updateKeyboardManager);
        this._addMenuItem(fileMenu, this._printDefDocPreviewAction, RecentFileManager.KEY_PRINT_PREVIEW, updateKeyboardManager);
        this._addMenuItem(fileMenu, this._printDefDocAction, RecentFileManager.KEY_PRINT, updateKeyboardManager);
        fileMenu.addSeparator();
        this._addMenuItem(fileMenu, this._quitAction, RecentFileManager.KEY_QUIT, updateKeyboardManager);
        return fileMenu;
    }

    private JMenu _setUpEditMenu(int mask, boolean updateKeyboardManager) {
        JMenu editMenu = new JMenu("Edit");
        PlatformFactory.ONLY.setMnemonic((AbstractButton)editMenu, 69);
        final JMenuItem undoItem = this._addMenuItem(editMenu, this._undoAction, RecentFileManager.KEY_UNDO, updateKeyboardManager);
        this._undoAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    boolean val = (Boolean)evt.getNewValue();
                    undoItem.setEnabled(val);
                }
            }
        });
        final JMenuItem redoItem = this._addMenuItem(editMenu, this._redoAction, RecentFileManager.KEY_REDO, updateKeyboardManager);
        this._redoAction.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    boolean val = (Boolean)evt.getNewValue();
                    redoItem.setEnabled(val);
                }
            }
        });
        editMenu.addSeparator();
        this._addMenuItem(editMenu, this.cutAction, RecentFileManager.KEY_CUT, updateKeyboardManager);
        this._addMenuItem(editMenu, this.copyAction, RecentFileManager.KEY_COPY, updateKeyboardManager);
        this._addMenuItem(editMenu, this.pasteAction, RecentFileManager.KEY_PASTE, updateKeyboardManager);
        this._addMenuItem(editMenu, this._pasteHistoryAction, RecentFileManager.KEY_PASTE_FROM_HISTORY, updateKeyboardManager);
        this._addMenuItem(editMenu, this._selectAllAction, RecentFileManager.KEY_SELECT_ALL, updateKeyboardManager);
        editMenu.addSeparator();
        JMenuItem editItem = editMenu.add(this._indentLinesAction);
        editItem.setAccelerator(KeyStroke.getKeyStroke(9, 0));
        this._addMenuItem(editMenu, this._commentLinesAction, RecentFileManager.KEY_COMMENT_LINES, updateKeyboardManager);
        this._addMenuItem(editMenu, this._uncommentLinesAction, RecentFileManager.KEY_UNCOMMENT_LINES, updateKeyboardManager);
        this._addMenuItem(editMenu, this.completeWordUnderCursorAction, RecentFileManager.KEY_COMPLETE_FILE, updateKeyboardManager);
        editMenu.addSeparator();
        this._addMenuItem(editMenu, this._findReplaceAction, RecentFileManager.KEY_FIND_REPLACE, updateKeyboardManager);
        this._addMenuItem(editMenu, this._findNextAction, RecentFileManager.KEY_FIND_NEXT, updateKeyboardManager);
        this._addMenuItem(editMenu, this._findPrevAction, RecentFileManager.KEY_FIND_PREV, updateKeyboardManager);
        editMenu.addSeparator();
        this._addMenuItem(editMenu, this._switchToPrevAction, RecentFileManager.KEY_PREVIOUS_DOCUMENT, updateKeyboardManager);
        this._addMenuItem(editMenu, this._switchToNextAction, RecentFileManager.KEY_NEXT_DOCUMENT, updateKeyboardManager);
        this._addMenuItem(editMenu, this._browseBackAction, RecentFileManager.KEY_BROWSE_BACK, updateKeyboardManager);
        this._addMenuItem(editMenu, this._browseForwardAction, RecentFileManager.KEY_BROWSE_FORWARD, updateKeyboardManager);
        editMenu.addSeparator();
        JMenu goToMenu = new JMenu("Go To");
        this._addMenuItem(goToMenu, this._gotoLineAction, RecentFileManager.KEY_GOTO_LINE, updateKeyboardManager);
        this._addMenuItem(goToMenu, this._gotoFileAction, RecentFileManager.KEY_GOTO_FILE, updateKeyboardManager);
        this._addMenuItem(goToMenu, this._gotoFileUnderCursorAction, RecentFileManager.KEY_GOTO_FILE_UNDER_CURSOR, updateKeyboardManager);
        this._addMenuItem(goToMenu, this._gotoOpeningBraceAction, RecentFileManager.KEY_OPENING_BRACE, updateKeyboardManager);
        this._addMenuItem(goToMenu, this._gotoClosingBraceAction, RecentFileManager.KEY_CLOSING_BRACE, updateKeyboardManager);
        editMenu.add(goToMenu);
        JMenu panesMenu = new JMenu("Tabbed Panes");
        this._addMenuItem(panesMenu, this._switchToPreviousPaneAction, RecentFileManager.KEY_PREVIOUS_PANE, updateKeyboardManager);
        this._addMenuItem(panesMenu, this._switchToNextPaneAction, RecentFileManager.KEY_NEXT_PANE, updateKeyboardManager);
        panesMenu.addSeparator();
        this._addMenuItem(panesMenu, this._prevRegionAction, RecentFileManager.KEY_TABBED_PREV_REGION, updateKeyboardManager);
        this._addMenuItem(panesMenu, this._nextRegionAction, RecentFileManager.KEY_TABBED_NEXT_REGION, updateKeyboardManager);
        panesMenu.addSeparator();
        JMenuItem tempDetachTabbedPanesMenuItem = MainFrameStatics.newCheckBoxMenuItem(this._detachTabbedPanesAction);
        tempDetachTabbedPanesMenuItem.setSelected(DrJava.getConfig().getSetting(RecentFileManager.DETACH_TABBEDPANES));
        this._setMenuShortcut(tempDetachTabbedPanesMenuItem, this._detachTabbedPanesAction, RecentFileManager.KEY_DETACH_TABBEDPANES, updateKeyboardManager);
        panesMenu.add(tempDetachTabbedPanesMenuItem);
        if (this._detachTabbedPanesMenuItem == null) {
            this._detachTabbedPanesMenuItem = tempDetachTabbedPanesMenuItem;
        } else {
            final WeakReference<JMenuItem> weakRef = new WeakReference<JMenuItem>(tempDetachTabbedPanesMenuItem);
            this._detachTabbedPanesMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JMenuItem temp = (JMenuItem)weakRef.get();
                    if (temp != null) {
                        temp.setSelected(MainFrame.this._detachTabbedPanesMenuItem.isSelected());
                    } else {
                        MainFrame.this._detachTabbedPanesMenuItem.removeItemListener(this);
                    }
                }
            });
        }
        editMenu.add(panesMenu);
        editMenu.addSeparator();
        this._addMenuItem(editMenu, this._editPreferencesAction, RecentFileManager.KEY_PREFERENCES, updateKeyboardManager);
        return editMenu;
    }

    private JMenu _setUpToolsMenu(int mask, boolean updateKeyboardManager) {
        final JMenu toolsMenu = new JMenu("Tools");
        PlatformFactory.ONLY.setMnemonic((AbstractButton)toolsMenu, 84);
        this._addMenuItem(toolsMenu, this._compileAllAction, RecentFileManager.KEY_COMPILE_ALL, updateKeyboardManager);
        this._addMenuItem(toolsMenu, this._compileAction, RecentFileManager.KEY_COMPILE, updateKeyboardManager);
        this._addMenuItem(toolsMenu, this._junitAllAction, RecentFileManager.KEY_TEST_ALL, updateKeyboardManager);
        this._addMenuItem(toolsMenu, this._junitAction, RecentFileManager.KEY_TEST, updateKeyboardManager);
        toolsMenu.addSeparator();
        final int runActionIndex = toolsMenu.getItemCount();
        this._addMenuItem(toolsMenu, this._runAction, RecentFileManager.KEY_RUN, updateKeyboardManager);
        this._addMenuItem(toolsMenu, this._runAppletAction, RecentFileManager.KEY_RUN_APPLET, updateKeyboardManager);
        this._addMenuItem(toolsMenu, this._resetInteractionsAction, RecentFileManager.KEY_RESET_INTERACTIONS, updateKeyboardManager);
        toolsMenu.addSeparator();
        JMenu javadocMenu = new JMenu("Javadoc");
        this._addMenuItem(javadocMenu, this._javadocAllAction, RecentFileManager.KEY_JAVADOC_ALL, updateKeyboardManager);
        this._addMenuItem(javadocMenu, this._javadocCurrentAction, RecentFileManager.KEY_JAVADOC_CURRENT, updateKeyboardManager);
        javadocMenu.addSeparator();
        this._addMenuItem(javadocMenu, this._openJavadocAction, RecentFileManager.KEY_OPEN_JAVADOC, updateKeyboardManager);
        this._addMenuItem(javadocMenu, this._openJavadocUnderCursorAction, RecentFileManager.KEY_OPEN_JAVADOC_UNDER_CURSOR, updateKeyboardManager);
        toolsMenu.add(javadocMenu);
        JMenu historyMenu = new JMenu("History");
        this._addMenuItem(historyMenu, this._executeHistoryAction, RecentFileManager.KEY_EXECUTE_HISTORY, updateKeyboardManager);
        this._addMenuItem(historyMenu, this._loadHistoryScriptAction, RecentFileManager.KEY_LOAD_HISTORY_SCRIPT, updateKeyboardManager);
        this._addMenuItem(historyMenu, this._saveHistoryAction, RecentFileManager.KEY_SAVE_HISTORY, updateKeyboardManager);
        this._addMenuItem(historyMenu, this._clearHistoryAction, RecentFileManager.KEY_CLEAR_HISTORY, updateKeyboardManager);
        toolsMenu.add(historyMenu);
        JMenu interMenu = new JMenu("Interactions & Console");
        this._addMenuItem(interMenu, this._saveInteractionsCopyAction, RecentFileManager.KEY_SAVE_INTERACTIONS_COPY, updateKeyboardManager);
        this._addMenuItem(interMenu, this._viewInteractionsClassPathAction, RecentFileManager.KEY_VIEW_INTERACTIONS_CLASSPATH, updateKeyboardManager);
        this._addMenuItem(interMenu, this._copyInteractionToDefinitionsAction, RecentFileManager.KEY_LIFT_CURRENT_INTERACTION, updateKeyboardManager);
        this._addMenuItem(interMenu, this._printInteractionsAction, RecentFileManager.KEY_PRINT_INTERACTIONS, updateKeyboardManager);
        interMenu.addSeparator();
        this._addMenuItem(interMenu, this._clearConsoleAction, RecentFileManager.KEY_CLEAR_CONSOLE, updateKeyboardManager);
        this._addMenuItem(interMenu, this._saveConsoleCopyAction, RecentFileManager.KEY_SAVE_CONSOLE_COPY, updateKeyboardManager);
        this._addMenuItem(interMenu, this._printConsoleAction, RecentFileManager.KEY_PRINT_CONSOLE, updateKeyboardManager);
        this._addMenuItem(interMenu, this._closeSystemInAction, RecentFileManager.KEY_CLOSE_SYSTEM_IN, updateKeyboardManager);
        if (DrJava.getConfig().getSetting(RecentFileManager.SHOW_DEBUG_CONSOLE).booleanValue()) {
            toolsMenu.add(this._showDebugConsoleAction);
        }
        toolsMenu.add(interMenu);
        final JMenu extMenu = new JMenu("External Processes");
        this._addMenuItem(extMenu, this._executeExternalProcessAction, RecentFileManager.KEY_EXEC_PROCESS, updateKeyboardManager);
        final JMenuItem execItem = extMenu.getItem(0);
        extMenu.addSeparator();
        extMenu.add(this._editExternalProcessesAction);
        toolsMenu.add(extMenu);
        int savedCount = DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_COUNT);
        int namesCount = ((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_NAMES))).size();
        int cmdlinesCount = ((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES))).size();
        int workdirsCount = ((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS))).size();
        int enclosingFileCount = ((Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES))).size();
        if (savedCount != namesCount || savedCount != cmdlinesCount || savedCount != workdirsCount || savedCount != enclosingFileCount) {
            DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_COUNT, 0);
            DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_NAMES, new Vector());
            DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES, new Vector());
            DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS, new Vector());
            DrJava.getConfig().setSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES, new Vector());
        }
        OptionListener<Integer> externalSavedCountListener = new OptionListener<Integer>(){

            @Override
            public void optionChanged(OptionEvent<Integer> oce) {
                extMenu.removeAll();
                extMenu.add(execItem);
                extMenu.addSeparator();
                int count = 0;
                while (count < (Integer)oce.value) {
                    final int i = count++;
                    final Vector names = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_NAMES));
                    final Vector cmdlines = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_CMDLINES));
                    final Vector workdirs = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_WORKDIRS));
                    final Vector enclosingfiles = (Vector)((Object)DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_ENCLOSING_DJAPP_FILES));
                    extMenu.insert(new AbstractAction((String)names.get(i)){

                        @Override
                        public void actionPerformed(ActionEvent ae) {
                            try {
                                PropertyMaps pm = PropertyMaps.TEMPLATE.clone();
                                String s = ((String)enclosingfiles.get(i)).trim();
                                ((MutableFileProperty)pm.getProperty("enclosing.djapp.file")).setFile(s.length() > 0 ? new File(s) : null);
                                MainFrame.this._executeExternalDialog.runCommand((String)names.get(i), (String)cmdlines.get(i), (String)workdirs.get(i), (String)enclosingfiles.get(i), pm);
                            }
                            catch (CloneNotSupportedException e) {
                                throw new UnexpectedException(e);
                            }
                        }
                    }, i + 2);
                }
                if ((Integer)oce.value > 0) {
                    extMenu.addSeparator();
                }
                extMenu.add(MainFrame.this._editExternalProcessesAction);
                MainFrame.this._editExternalProcessesAction.setEnabled(true);
            }
        };
        DrJava.getConfig().addOptionListener(OptionConstants.EXTERNAL_SAVED_COUNT, externalSavedCountListener);
        externalSavedCountListener.optionChanged(new OptionEvent<Integer>(OptionConstants.EXTERNAL_SAVED_COUNT, DrJava.getConfig().getSetting(OptionConstants.EXTERNAL_SAVED_COUNT)));
        JMenu advancedMenu = new JMenu("Advanced");
        this._addMenuItem(advancedMenu, this._generateCustomDrJavaJarAction, RecentFileManager.KEY_GENERATE_CUSTOM_DRJAVA, updateKeyboardManager);
        this._addMenuItem(advancedMenu, this._newDrJavaInstanceAction, RecentFileManager.KEY_NEW_DRJAVA_INSTANCE, updateKeyboardManager);
        toolsMenu.add(advancedMenu);
        toolsMenu.addSeparator();
        this._addMenuItem(toolsMenu, this._bookmarksPanelAction, RecentFileManager.KEY_BOOKMARKS_PANEL, updateKeyboardManager);
        this._addMenuItem(toolsMenu, this._toggleBookmarkAction, RecentFileManager.KEY_BOOKMARKS_TOGGLE, updateKeyboardManager);
        toolsMenu.addSeparator();
        this._addMenuItem(toolsMenu, this._followFileAction, RecentFileManager.KEY_FOLLOW_FILE, updateKeyboardManager);
        OptionListener<Boolean> runMainListener = new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oce) {
                JMenuItem mi = toolsMenu.getItem(runActionIndex);
                if (((Boolean)oce.value).booleanValue()) {
                    mi.setText("Run Document");
                    mi.setToolTipText("Run the current document, regardless of whether it is an applet, an ACM Java Task Force program, or a regular Java program with a main method.");
                } else {
                    mi.setText("Run Document's Main Method");
                    mi.setToolTipText("Run the main method of the current document");
                }
            }
        };
        DrJava.getConfig().addOptionListener(OptionConstants.SMART_RUN_FOR_APPLETS_AND_PROGRAMS, runMainListener);
        runMainListener.optionChanged(new OptionEvent<Boolean>(OptionConstants.SMART_RUN_FOR_APPLETS_AND_PROGRAMS, DrJava.getConfig().getSetting(OptionConstants.SMART_RUN_FOR_APPLETS_AND_PROGRAMS)));
        return toolsMenu;
    }

    private JMenu _setUpProjectMenu(int mask, boolean updateKeyboardManager) {
        JMenu projectMenu = new JMenu("Project");
        PlatformFactory.ONLY.setMnemonic((AbstractButton)projectMenu, 80);
        this._addMenuItem(projectMenu, this._newProjectAction, RecentFileManager.KEY_NEW_PROJECT, updateKeyboardManager);
        this._addMenuItem(projectMenu, this._openProjectAction, RecentFileManager.KEY_OPEN_PROJECT, updateKeyboardManager);
        this._addMenuItem(projectMenu, this._saveProjectAction, RecentFileManager.KEY_SAVE_PROJECT, updateKeyboardManager);
        this._addMenuItem(projectMenu, this._saveProjectAsAction, RecentFileManager.KEY_SAVE_AS_PROJECT, updateKeyboardManager);
        this._addMenuItem(projectMenu, this._closeProjectAction, RecentFileManager.KEY_CLOSE_PROJECT, updateKeyboardManager);
        projectMenu.addSeparator();
        this._addMenuItem(projectMenu, this._compileProjectAction, RecentFileManager.KEY_COMPILE_PROJECT, updateKeyboardManager);
        this._addMenuItem(projectMenu, this._junitProjectAction, RecentFileManager.KEY_JUNIT_PROJECT, updateKeyboardManager);
        this._addMenuItem(projectMenu, this._runProjectAction, RecentFileManager.KEY_RUN_PROJECT, updateKeyboardManager);
        this._addMenuItem(projectMenu, this._cleanAction, RecentFileManager.KEY_CLEAN_PROJECT, updateKeyboardManager);
        this._addMenuItem(projectMenu, this._autoRefreshAction, RecentFileManager.KEY_AUTO_REFRESH_PROJECT, updateKeyboardManager);
        this._addMenuItem(projectMenu, this._jarProjectAction, RecentFileManager.KEY_JAR_PROJECT, updateKeyboardManager);
        projectMenu.addSeparator();
        this._addMenuItem(projectMenu, this._projectPropertiesAction, RecentFileManager.KEY_PROJECT_PROPERTIES, updateKeyboardManager);
        return projectMenu;
    }

    private JMenu _setUpDebugMenu(int mask, boolean updateKeyboardManager) {
        JMenu debugMenu = new JMenu("Debugger");
        PlatformFactory.ONLY.setMnemonic((AbstractButton)debugMenu, 68);
        JMenuItem tempDebuggerEnabledMenuItem = MainFrameStatics.newCheckBoxMenuItem(this._toggleDebuggerAction);
        tempDebuggerEnabledMenuItem.setSelected(false);
        this._setMenuShortcut(tempDebuggerEnabledMenuItem, this._toggleDebuggerAction, RecentFileManager.KEY_DEBUG_MODE_TOGGLE, updateKeyboardManager);
        debugMenu.add(tempDebuggerEnabledMenuItem);
        if (this._debuggerEnabledMenuItem == null) {
            this._debuggerEnabledMenuItem = tempDebuggerEnabledMenuItem;
        } else {
            final WeakReference<JMenuItem> weakRef = new WeakReference<JMenuItem>(tempDebuggerEnabledMenuItem);
            this._debuggerEnabledMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JMenuItem temp = (JMenuItem)weakRef.get();
                    if (temp != null) {
                        temp.setSelected(MainFrame.this._debuggerEnabledMenuItem.isSelected());
                    } else {
                        MainFrame.this._debuggerEnabledMenuItem.removeItemListener(this);
                    }
                }
            });
        }
        debugMenu.addSeparator();
        this._addMenuItem(debugMenu, this._toggleBreakpointAction, RecentFileManager.KEY_DEBUG_BREAKPOINT_TOGGLE, updateKeyboardManager);
        this._addMenuItem(debugMenu, this._clearAllBreakpointsAction, RecentFileManager.KEY_DEBUG_CLEAR_ALL_BREAKPOINTS, updateKeyboardManager);
        this._addMenuItem(debugMenu, this._breakpointsPanelAction, RecentFileManager.KEY_DEBUG_BREAKPOINT_PANEL, updateKeyboardManager);
        debugMenu.addSeparator();
        this._addMenuItem(debugMenu, this._resumeDebugAction, RecentFileManager.KEY_DEBUG_RESUME, updateKeyboardManager);
        this._addMenuItem(debugMenu, this._stepIntoDebugAction, RecentFileManager.KEY_DEBUG_STEP_INTO, updateKeyboardManager);
        this._addMenuItem(debugMenu, this._stepOverDebugAction, RecentFileManager.KEY_DEBUG_STEP_OVER, updateKeyboardManager);
        this._addMenuItem(debugMenu, this._stepOutDebugAction, RecentFileManager.KEY_DEBUG_STEP_OUT, updateKeyboardManager);
        JMenuItem tempAutomaticTraceMenuItem = MainFrameStatics.newCheckBoxMenuItem(this._automaticTraceDebugAction);
        this._setMenuShortcut(tempAutomaticTraceMenuItem, this._automaticTraceDebugAction, RecentFileManager.KEY_DEBUG_AUTOMATIC_TRACE, updateKeyboardManager);
        debugMenu.add(tempAutomaticTraceMenuItem);
        if (this._automaticTraceMenuItem == null) {
            this._automaticTraceMenuItem = tempAutomaticTraceMenuItem;
        } else {
            final WeakReference<JMenuItem> weakRef = new WeakReference<JMenuItem>(tempAutomaticTraceMenuItem);
            this._automaticTraceMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JMenuItem temp = (JMenuItem)weakRef.get();
                    if (temp != null) {
                        temp.setSelected(MainFrame.this._automaticTraceMenuItem.isSelected());
                    } else {
                        MainFrame.this._automaticTraceMenuItem.removeItemListener(this);
                    }
                }
            });
        }
        debugMenu.addSeparator();
        JMenuItem tempDetachDebugFrameMenuItem = MainFrameStatics.newCheckBoxMenuItem(this._detachDebugFrameAction);
        tempDetachDebugFrameMenuItem.setSelected(DrJava.getConfig().getSetting(RecentFileManager.DETACH_DEBUGGER));
        this._setMenuShortcut(tempDetachDebugFrameMenuItem, this._detachDebugFrameAction, RecentFileManager.KEY_DETACH_DEBUGGER, updateKeyboardManager);
        debugMenu.add(tempDetachDebugFrameMenuItem);
        if (this._detachDebugFrameMenuItem == null) {
            this._detachDebugFrameMenuItem = tempDetachDebugFrameMenuItem;
        } else {
            final WeakReference<JMenuItem> weakRef = new WeakReference<JMenuItem>(tempDetachDebugFrameMenuItem);
            this._detachDebugFrameMenuItem.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    JMenuItem temp = (JMenuItem)weakRef.get();
                    if (temp != null) {
                        temp.setSelected(MainFrame.this._detachDebugFrameMenuItem.isSelected());
                    } else {
                        MainFrame.this._detachDebugFrameMenuItem.removeItemListener(this);
                    }
                }
            });
        }
        this._setDebugMenuItemsEnabled(false);
        return debugMenu;
    }

    private void _setDebugMenuItemsEnabled(boolean isEnabled) {
        this._debuggerEnabledMenuItem.setSelected(isEnabled);
        this._guiAvailabilityNotifier.ensureUnavailable(GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED);
        if (this._showDebugger) {
            this._debugPanel.setAutomaticTraceButtonText();
        }
    }

    private void _setThreadDependentDebugMenuItems(boolean isSuspended) {
        this._guiAvailabilityNotifier.ensureAvailabilityIs(GUIAvailabilityListener.ComponentType.DEBUGGER_SUSPENDED, isSuspended);
        if (this._showDebugger) {
            this._debugPanel.setAutomaticTraceButtonText();
        }
    }

    private JMenu _setUpLanguageLevelMenu(int mask, boolean updateKeyboardManager) {
        JMenu languageLevelMenu = new JMenu("Language Level");
        PlatformFactory.ONLY.setMnemonic((AbstractButton)languageLevelMenu, 76);
        ButtonGroup group = new ButtonGroup();
        final FileConfiguration config = DrJava.getConfig();
        int currentLanguageLevel = config.getSetting(RecentFileManager.LANGUAGE_LEVEL);
        AbstractAction rbFullJavaAction = new AbstractAction("Full Java"){
            {
                super(x0);
                MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.LANGUAGE_LEVELS);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                config.setSetting(RecentFileManager.LANGUAGE_LEVEL, 0);
            }
        };
        final JRadioButtonMenuItem rbFullJavaMenuItem = new JRadioButtonMenuItem(rbFullJavaAction);
        rbFullJavaMenuItem.setToolTipText("Use full Java syntax");
        if (currentLanguageLevel != 4) {
            rbFullJavaMenuItem.setSelected(true);
        }
        group.add(rbFullJavaMenuItem);
        languageLevelMenu.add(rbFullJavaMenuItem);
        languageLevelMenu.addSeparator();
        AbstractAction rbFunctionalAction = new AbstractAction("Functional Java"){
            {
                super(x0);
                MainFrame.this._addGUIAvailabilityListener(this, GUIAvailabilityListener.ComponentType.LANGUAGE_LEVELS);
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                config.setSetting(RecentFileManager.LANGUAGE_LEVEL, 4);
            }
        };
        final JRadioButtonMenuItem rbFunctionalMenuItem = new JRadioButtonMenuItem(rbFunctionalAction);
        rbFunctionalMenuItem.setToolTipText("Use Functional Java language-level features");
        if (currentLanguageLevel == 4) {
            rbFunctionalMenuItem.setSelected(true);
        }
        group.add(rbFunctionalMenuItem);
        languageLevelMenu.add(rbFunctionalMenuItem);
        config.addOptionListener(RecentFileManager.LANGUAGE_LEVEL, new OptionListener<Integer>(){

            @Override
            public void optionChanged(OptionEvent<Integer> oce) {
                switch ((Integer)oce.value) {
                    case 1: 
                    case 2: 
                    case 4: {
                        rbFunctionalMenuItem.setSelected(true);
                        break;
                    }
                    default: {
                        rbFullJavaMenuItem.setSelected(true);
                    }
                }
            }
        });
        this._guiAvailabilityNotifier.ensureAvailabilityIs(GUIAvailabilityListener.ComponentType.LANGUAGE_LEVELS, this._model.getCompilerModel().getActiveCompiler().supportsLanguageLevels());
        return languageLevelMenu;
    }

    private JMenu _setUpHelpMenu(int mask, boolean updateKeyboardManager) {
        JMenu helpMenu = new JMenu("Help");
        PlatformFactory.ONLY.setMnemonic((AbstractButton)helpMenu, 72);
        this._addMenuItem(helpMenu, this._helpAction, RecentFileManager.KEY_HELP, updateKeyboardManager);
        this._addMenuItem(helpMenu, this._quickStartAction, RecentFileManager.KEY_QUICKSTART, updateKeyboardManager);
        helpMenu.addSeparator();
        this._addMenuItem(helpMenu, this._aboutAction, RecentFileManager.KEY_ABOUT, updateKeyboardManager);
        this._addMenuItem(helpMenu, this._checkNewVersionAction, RecentFileManager.KEY_CHECK_NEW_VERSION, updateKeyboardManager);
        this._addMenuItem(helpMenu, this._errorsAction, RecentFileManager.KEY_DRJAVA_ERRORS, updateKeyboardManager);
        helpMenu.addSeparator();
        this._addMenuItem(helpMenu, this._forceQuitAction, RecentFileManager.KEY_FORCE_QUIT, updateKeyboardManager);
        this._addMenuItem(helpMenu, this._exportProjectInOldFormatAction, RecentFileManager.KEY_EXPORT_OLD, updateKeyboardManager);
        return helpMenu;
    }

    JButton _createManualToolbarButton(Action a) {
        UnfocusableButton ret;
        Icon icon;
        Font buttonFont = DrJava.getConfig().getSetting(RecentFileManager.FONT_TOOLBAR);
        boolean useIcon = DrJava.getConfig().getSetting(RecentFileManager.TOOLBAR_ICONS_ENABLED);
        boolean useText = DrJava.getConfig().getSetting(RecentFileManager.TOOLBAR_TEXT_ENABLED);
        Icon icon2 = icon = useIcon ? (Icon)a.getValue("SmallIcon") : null;
        if (icon == null) {
            ret = new UnfocusableButton((String)a.getValue("Default"));
        } else {
            ret = new UnfocusableButton(icon);
            if (useText) {
                ret.setText((String)a.getValue("Default"));
            }
        }
        ret.setEnabled(false);
        ret.addActionListener(a);
        ret.setToolTipText((String)a.getValue("LongDescription"));
        ret.setFont(buttonFont);
        a.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("enabled".equals(evt.getPropertyName())) {
                    Boolean val = (Boolean)evt.getNewValue();
                    ret.setEnabled(val);
                }
            }
        });
        return ret;
    }

    public JButton _createToolbarButton(Action a) {
        boolean useText = DrJava.getConfig().getSetting(RecentFileManager.TOOLBAR_TEXT_ENABLED);
        boolean useIcons = DrJava.getConfig().getSetting(RecentFileManager.TOOLBAR_ICONS_ENABLED);
        Font buttonFont = DrJava.getConfig().getSetting(RecentFileManager.FONT_TOOLBAR);
        UnfocusableButton result = new UnfocusableButton(a);
        result.setText((String)a.getValue("Default"));
        result.setFont(buttonFont);
        if (!useIcons) {
            result.setIcon(null);
        }
        if (!useText && result.getIcon() != null) {
            result.setText("");
        }
        return result;
    }

    public JButton _updateToolbarButton(JButton b, Action a) {
        JButton result = this._createToolbarButton(a);
        int index = this._toolBar.getComponentIndex(b);
        this._toolBar.remove(b);
        this._toolBar.add((Component)result, index);
        this._fixToolbarHeights();
        return result;
    }

    private void _setUpToolBar() {
        this._toolBar.setFloatable(false);
        this._toolBar.add(this._createToolbarButton(this._newAction));
        this._toolBar.add(this._createToolbarButton(this._openFileOrProjectAction));
        this._toolBar.add(this._createToolbarButton(this._saveAction));
        this._closeButton = this._createToolbarButton(this._closeAction);
        this._toolBar.add(this._closeButton);
        this._toolBar.addSeparator();
        this._toolBar.add(this._createToolbarButton(this.cutAction));
        this._toolBar.add(this._createToolbarButton(this.copyAction));
        this._toolBar.add(this._createToolbarButton(this.pasteAction));
        this._toolBar.add(this._undoButton);
        this._toolBar.add(this._redoButton);
        this._toolBar.addSeparator();
        this._toolBar.add(this._createToolbarButton(this._findReplaceAction));
        this._toolBar.addSeparator();
        this._compileButton = this._createToolbarButton(this._compileAllAction);
        this._toolBar.add(this._compileButton);
        this._toolBar.add(this._createToolbarButton(this._resetInteractionsAction));
        this._toolBar.addSeparator();
        this._runButton = this._createToolbarButton(this._runAction);
        this._toolBar.add(this._runButton);
        this._junitButton = this._createToolbarButton(this._junitAllAction);
        this._toolBar.add(this._junitButton);
        this._toolBar.add(this._createToolbarButton(this._javadocAllAction));
        this._toolBar.addSeparator();
        this._errorsButton = this._createToolbarButton(this._errorsAction);
        this._errorsButton.setVisible(false);
        this._errorsButton.setBackground(DrJava.getConfig().getSetting(RecentFileManager.DRJAVA_ERRORS_BUTTON_COLOR));
        this._toolBar.add(this._errorsButton);
        OptionListener<Color> errBtnColorOptionListener = new OptionListener<Color>(){

            @Override
            public void optionChanged(OptionEvent<Color> oce) {
                MainFrame.this._errorsButton.setBackground((Color)oce.value);
            }
        };
        DrJava.getConfig().addOptionListener(RecentFileManager.DRJAVA_ERRORS_BUTTON_COLOR, errBtnColorOptionListener);
        OptionListener<Boolean> runButtonListener = new OptionListener<Boolean>(){

            @Override
            public void optionChanged(OptionEvent<Boolean> oce) {
                if (((Boolean)oce.value).booleanValue()) {
                    MainFrame.this._runAction.putValue("LongDescription", "Run the current document, regardless of whether it is an applet, an ACM Java Task Force program, or a regular Java program with a main method.");
                } else {
                    MainFrame.this._runAction.putValue("LongDescription", "Run the main method of the current document");
                }
                MainFrame.this.projectRunnableChanged();
            }
        };
        DrJava.getConfig().addOptionListener(OptionConstants.SMART_RUN_FOR_APPLETS_AND_PROGRAMS, runButtonListener);
        runButtonListener.optionChanged(new OptionEvent<Boolean>(OptionConstants.SMART_RUN_FOR_APPLETS_AND_PROGRAMS, DrJava.getConfig().getSetting(OptionConstants.SMART_RUN_FOR_APPLETS_AND_PROGRAMS)));
        this._fixToolbarHeights();
        if (Utilities.isPlasticLaf()) {
            this._toolBar.putClientProperty("JToolBar.isRollover", Boolean.FALSE);
            this._toolBar.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        }
        this.getContentPane().add((Component)this._toolBar, "North");
    }

    private void _updateToolBarVisible() {
        this._toolBar.setVisible(DrJava.getConfig().getSetting(RecentFileManager.TOOLBAR_ENABLED));
    }

    private void _updateToolbarButtons() {
        this._updateToolBarVisible();
        Component[] buttons = this._toolBar.getComponents();
        Font toolbarFont = DrJava.getConfig().getSetting(RecentFileManager.FONT_TOOLBAR);
        boolean iconsEnabled = DrJava.getConfig().getSetting(RecentFileManager.TOOLBAR_ICONS_ENABLED);
        boolean textEnabled = DrJava.getConfig().getSetting(RecentFileManager.TOOLBAR_TEXT_ENABLED);
        for (int i = 0; i < buttons.length; ++i) {
            if (!(buttons[i] instanceof JButton)) continue;
            JButton b = (JButton)buttons[i];
            Action a = b.getAction();
            b.setFont(toolbarFont);
            if (a == null) {
                if (b == this._undoButton) {
                    a = this._undoAction;
                } else {
                    if (b != this._redoButton) continue;
                    a = this._redoAction;
                }
            }
            if (b.getIcon() == null) {
                if (iconsEnabled) {
                    b.setIcon((Icon)a.getValue("SmallIcon"));
                }
            } else if (!iconsEnabled && b.getText().equals("")) {
                b.setIcon(null);
            }
            if (b.getText().equals("")) {
                if (!textEnabled) continue;
                b.setText((String)a.getValue("Default"));
                continue;
            }
            if (textEnabled || b.getIcon() == null) continue;
            b.setText("");
        }
        this._fixToolbarHeights();
    }

    private void _fixToolbarHeights() {
        Dimension d;
        JButton b;
        int i;
        Component[] buttons = this._toolBar.getComponents();
        int max = 0;
        for (i = 0; i < buttons.length; ++i) {
            if (!(buttons[i] instanceof JButton)) continue;
            b = (JButton)buttons[i];
            b.setPreferredSize(null);
            d = b.getPreferredSize();
            int cur = (int)d.getHeight();
            if (cur <= max) continue;
            max = cur;
        }
        for (i = 0; i < buttons.length; ++i) {
            if (!(buttons[i] instanceof JButton)) continue;
            b = (JButton)buttons[i];
            d = new Dimension((int)b.getPreferredSize().getWidth(), max);
            b.setPreferredSize(d);
            b.setMaximumSize(d);
        }
    }

    private void _setUpStatusBar() {
        this._statusField.setFont(this._statusField.getFont().deriveFont(0));
        this._statusReport.setHorizontalAlignment(4);
        JPanel fileNameAndMessagePanel = new JPanel(new BorderLayout());
        fileNameAndMessagePanel.add((Component)this._statusField, "Center");
        fileNameAndMessagePanel.add((Component)this._statusReport, "East");
        this._currLocationField.setFont(this._currLocationField.getFont().deriveFont(0));
        this._currLocationField.setHorizontalAlignment(4);
        this._currLocationField.setPreferredSize(new Dimension(165, 12));
        this._statusBar.add((Component)fileNameAndMessagePanel, "Center");
        this._statusBar.add((Component)this._currLocationField, "East");
        this._statusBar.setBorder(new CompoundBorder(new EmptyBorder(2, 2, 2, 2), new CompoundBorder(new BevelBorder(1), new EmptyBorder(2, 2, 2, 2))));
        this.getContentPane().add((Component)this._statusBar, "South");
    }

    private void _setUpTabs() {
        this._interactionsController.setPrevPaneAction(this._switchToPreviousPaneAction);
        this._interactionsController.setNextPaneAction(this._switchToNextPaneAction);
        BorderlessScrollPane interactionsScroll = new BorderlessScrollPane(this._interactionsPane, 22, 30);
        this._interactionsContainer.add((Component)interactionsScroll, "Center");
        if (this._showDebugger) {
            this._model.getBreakpointManager().addListener(new RegionManagerListener<Breakpoint>(){

                @Override
                public void regionAdded(Breakpoint bp) {
                    DefinitionsPane bpPane = MainFrame.this.getDefPaneGivenODD(bp.getDocument());
                    MainFrame.this._documentBreakpointHighlights.put(bp, bpPane.getHighlightManager().addHighlight(bp.getStartOffset(), bp.getEndOffset(), bp.isEnabled() ? DefinitionsPane.BREAKPOINT_PAINTER : DefinitionsPane.DISABLED_BREAKPOINT_PAINTER));
                    MainFrame.this._updateDebugStatus();
                }

                @Override
                public void regionChanged(Breakpoint bp) {
                    this.regionRemoved(bp);
                    this.regionAdded(bp);
                }

                @Override
                public void regionRemoved(Breakpoint bp) {
                    HighlightManager.HighlightInfo highlight = (HighlightManager.HighlightInfo)MainFrame.this._documentBreakpointHighlights.get(bp);
                    if (highlight != null) {
                        highlight.remove();
                    }
                    MainFrame.this._documentBreakpointHighlights.remove(bp);
                }
            });
        }
        this._model.getBookmarkManager().addListener(new RegionManagerListener<MovingDocumentRegion>(){

            @Override
            public void regionAdded(MovingDocumentRegion r) {
                DefinitionsPane bpPane = MainFrame.this.getDefPaneGivenODD(r.getDocument());
                MainFrame.this._documentBookmarkHighlights.put(r, bpPane.getHighlightManager().addHighlight(r.getStartOffset(), r.getEndOffset(), DefinitionsPane.BOOKMARK_PAINTER));
            }

            @Override
            public void regionChanged(MovingDocumentRegion r) {
                this.regionRemoved(r);
                this.regionAdded(r);
            }

            @Override
            public void regionRemoved(MovingDocumentRegion r) {
                HighlightManager.HighlightInfo highlight = (HighlightManager.HighlightInfo)MainFrame.this._documentBookmarkHighlights.get(r);
                if (highlight != null) {
                    highlight.remove();
                }
                MainFrame.this._documentBookmarkHighlights.remove(r);
            }
        });
        this._tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                MainFrame.this.clearStatusMessage();
                if (MainFrame.this._tabbedPane.getSelectedIndex() == 0) {
                    MainFrame.this._interactionsContainer.setVisible(true);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.this._interactionsContainer.requestFocusInWindow();
                        }
                    });
                } else if (MainFrame.this._tabbedPane.getSelectedIndex() == 1) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            MainFrame.this._consoleScroll.requestFocusInWindow();
                        }
                    });
                }
                if (MainFrame.this._currentDefPane != null) {
                    int pos = MainFrame.this._currentDefPane.getCaretPosition();
                    MainFrame.this._currentDefPane.removeErrorHighlight();
                    MainFrame.this._currentDefPane.getErrorCaretListener().updateHighlight(pos);
                }
            }
        });
        this._tabbedPane.add("Interactions", this._interactionsContainer);
        this._tabbedPane.add("Console", this._consoleScroll);
        this._interactionsPane.addKeyListener(this._historyListener);
        this._interactionsPane.addFocusListener(this._focusListenerForRecentDocs);
        this._interactionsController.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MainFrame.this._undoAction.setDelegatee(MainFrame.this._interactionsController.getUndoAction());
                MainFrame.this._redoAction.setDelegatee(MainFrame.this._interactionsController.getRedoAction());
            }
        });
        this._consoleScroll.addKeyListener(this._historyListener);
        this._consoleScroll.addFocusListener(this._focusListenerForRecentDocs);
        this._tabs.addLast(this._compilerErrorPanel);
        this._tabs.addLast(this._junitPanel);
        this._tabs.addLast(this._javadocErrorPanel);
        this._tabs.addLast(this._findReplace);
        if (this._showDebugger) {
            this._tabs.addLast(this._breakpointsPanel);
        }
        this._tabs.addLast(this._bookmarksPanel);
        this._interactionsContainer.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this._interactionsPane.requestFocusInWindow();
                    }
                });
            }
        });
        this._interactionsPane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MainFrame.this._lastFocusOwner = MainFrame.this._interactionsContainer;
            }
        });
        this._consolePane.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MainFrame.this._lastFocusOwner = MainFrame.this._consoleScroll;
            }
        });
        this._compilerErrorPanel.getMainPanel().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MainFrame.this._lastFocusOwner = MainFrame.this._compilerErrorPanel;
            }
        });
        this._junitPanel.getMainPanel().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MainFrame.this._lastFocusOwner = MainFrame.this._junitPanel;
            }
        });
        this._javadocErrorPanel.getMainPanel().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MainFrame.this._lastFocusOwner = MainFrame.this._javadocErrorPanel;
            }
        });
        this._findReplace.getFindField().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MainFrame.this._lastFocusOwner = MainFrame.this._findReplace;
            }
        });
        if (this._showDebugger) {
            this._breakpointsPanel.getMainPanel().addFocusListener(new FocusAdapter(){

                @Override
                public void focusGained(FocusEvent e) {
                    MainFrame.this._lastFocusOwner = MainFrame.this._breakpointsPanel;
                }
            });
        }
        this._bookmarksPanel.getMainPanel().addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MainFrame.this._lastFocusOwner = MainFrame.this._bookmarksPanel;
            }
        });
    }

    public void start() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.setVisible(true);
                MainFrame.this._compilerErrorPanel.setVisible(true);
                MainFrame.this.showTab(MainFrame.this._compilerErrorPanel, true);
                MainFrame.this._tabbedPane.invalidate();
                MainFrame.this._tabbedPane.repaint();
                try {
                    MainFrame.this._model.getInteractionsModel().performDefaultImports();
                }
                catch (Throwable t) {
                    DrJavaErrorHandler.record(t);
                }
            }
        });
    }

    private void _setUpContextMenus() {
        this._model.getDocCollectionWidget().addMouseListener(new RightClickMouseAdapter(){

            @Override
            protected void _popupAction(MouseEvent e) {
                boolean showContextMenu = true;
                if (!MainFrame.this._model.getDocumentNavigator().isSelectedAt(e.getX(), e.getY())) {
                    showContextMenu = MainFrame.this._model.getDocumentNavigator().selectDocumentAt(e.getX(), e.getY());
                }
                if (showContextMenu) {
                    boolean rootSelected = MainFrame.this._model.getDocumentNavigator().isRootSelected();
                    boolean folderSelected = false;
                    boolean docSelected = false;
                    boolean externalSelected = false;
                    boolean auxiliarySelected = false;
                    boolean externalBinSelected = false;
                    boolean auxiliaryBinSelected = false;
                    int docSelectedCount = MainFrame.this._model.getDocumentNavigator().getDocumentSelectedCount();
                    int groupSelectedCount = MainFrame.this._model.getDocumentNavigator().getGroupSelectedCount();
                    try {
                        Set<String> groupNames = MainFrame.this._model.getDocumentNavigator().getNamesOfSelectedTopLevelGroup();
                        if (docSelectedCount > 0) {
                            rootSelected = false;
                            if (groupNames.contains(MainFrame.this._model.getSourceBinTitle())) {
                                docSelected = true;
                            }
                            if (groupNames.contains(MainFrame.this._model.getExternalBinTitle())) {
                                externalSelected = true;
                            }
                            if (groupNames.contains(MainFrame.this._model.getAuxiliaryBinTitle())) {
                                auxiliarySelected = true;
                            }
                        } else if (groupSelectedCount > 0) {
                            if (!MainFrame.this._model.getDocumentNavigator().isTopLevelGroupSelected()) {
                                folderSelected = true;
                            } else {
                                if (groupNames.contains(MainFrame.this._model.getSourceBinTitle())) {
                                    folderSelected = true;
                                }
                                if (groupNames.contains(MainFrame.this._model.getExternalBinTitle())) {
                                    externalBinSelected = true;
                                }
                                if (groupNames.contains(MainFrame.this._model.getAuxiliaryBinTitle())) {
                                    auxiliaryBinSelected = true;
                                }
                            }
                        }
                    }
                    catch (GroupNotSelectedException ex) {
                        if (MainFrame.this._model.isProjectActive()) {
                            rootSelected = true;
                        }
                        docSelected = true;
                        rootSelected = false;
                        folderSelected = false;
                        externalSelected = false;
                        auxiliarySelected = false;
                        externalBinSelected = false;
                        auxiliaryBinSelected = false;
                    }
                    if (!(rootSelected || folderSelected || docSelected || externalSelected || auxiliarySelected || externalBinSelected || auxiliaryBinSelected)) {
                        return;
                    }
                    JPopupMenu m = new JPopupMenu();
                    if (docSelectedCount == 0) {
                        auxiliarySelected = false;
                        externalSelected = false;
                        docSelected = false;
                    }
                    if (groupSelectedCount == 0) {
                        folderSelected = false;
                    }
                    if (rootSelected) {
                        m.add(Utilities.createDelegateAction("Save Project", MainFrame.this._saveProjectAction));
                        m.add(Utilities.createDelegateAction("Close Project", MainFrame.this._closeProjectAction));
                        m.add(MainFrame.this._compileProjectAction);
                        m.add(MainFrame.this._runProjectAction);
                        m.add(MainFrame.this._junitProjectAction);
                        m.add(MainFrame.this._projectPropertiesAction);
                    }
                    if (folderSelected) {
                        if (m.getComponentCount() > 0) {
                            m.addSeparator();
                        }
                        if (groupSelectedCount == 1) {
                            m.add(MainFrame.this._newFileFolderAction);
                            m.add(MainFrame.this._openOneFolderAction);
                            m.add(Utilities.createDelegateAction("Open All Files in Folder", MainFrame.this._openAllFolderAction));
                            m.add(MainFrame.this._closeFolderAction);
                            m.add(MainFrame.this._compileFolderAction);
                            m.add(MainFrame.this._junitFolderAction);
                        } else if (groupSelectedCount > 1) {
                            if (!externalBinSelected && !auxiliaryBinSelected) {
                                m.add(Utilities.createDelegateAction("Open All Files in All Folders (" + groupSelectedCount + ")", MainFrame.this._openAllFolderAction));
                            }
                            m.add(Utilities.createDelegateAction("Close All Folders (" + groupSelectedCount + ")", MainFrame.this._closeFolderAction));
                            m.add(Utilities.createDelegateAction("Compile All Folders (" + groupSelectedCount + ")", MainFrame.this._compileFolderAction));
                            m.add(Utilities.createDelegateAction("Test All Folders (" + groupSelectedCount + ")", MainFrame.this._junitFolderAction));
                        }
                    }
                    if (docSelected || externalSelected || auxiliarySelected) {
                        if (m.getComponentCount() > 0) {
                            m.addSeparator();
                        }
                        if (docSelectedCount == 1) {
                            m.add(Utilities.createDelegateAction("Save File", MainFrame.this._saveAction));
                            m.add(Utilities.createDelegateAction("Save File As...", MainFrame.this._saveAsAction));
                            m.add(Utilities.createDelegateAction("Save File Copy...", MainFrame.this._saveCopyAction));
                            m.add(Utilities.createDelegateAction("Rename File", MainFrame.this._renameAction));
                            m.add(Utilities.createDelegateAction("Revert File to Saved", MainFrame.this._revertAction));
                            m.add(Utilities.createDelegateAction("Close File", MainFrame.this._closeAction));
                            m.add(Utilities.createDelegateAction("Print File...", MainFrame.this._printDefDocAction));
                            m.add(Utilities.createDelegateAction("Print File Preview...", MainFrame.this._printDefDocPreviewAction));
                            m.add(Utilities.createDelegateAction("Compile File", MainFrame.this._compileAction));
                            m.add(Utilities.createDelegateAction("Test File", MainFrame.this._junitAction));
                            m.add(Utilities.createDelegateAction("Preview Javadoc for File", MainFrame.this._javadocCurrentAction));
                            m.add(Utilities.createDelegateAction("Run File", MainFrame.this._runAction));
                            m.add(Utilities.createDelegateAction("Run File as Applet", MainFrame.this._runAppletAction));
                        } else if (docSelectedCount > 1) {
                            m.add(Utilities.createDelegateAction("Save All Files (" + docSelectedCount + ")", MainFrame.this._saveAction));
                            m.add(Utilities.createDelegateAction("Revert All Files to Saved (" + docSelectedCount + ")", MainFrame.this._revertAction));
                            m.add(Utilities.createDelegateAction("Close All Files  (" + docSelectedCount + ")", MainFrame.this._closeAction));
                            m.add(Utilities.createDelegateAction("Compile All Files (" + docSelectedCount + ")", MainFrame.this._compileAction));
                            m.add(Utilities.createDelegateAction("Test All Files (" + docSelectedCount + ")", MainFrame.this._junitAction));
                        }
                    }
                    if (externalSelected && !docSelected && !auxiliarySelected) {
                        if (m.getComponentCount() > 0) {
                            m.addSeparator();
                        }
                        if (docSelectedCount == 1) {
                            m.add(Utilities.createDelegateAction("Include File With Project", MainFrame.this._moveToAuxiliaryAction));
                        } else if (docSelectedCount > 1) {
                            m.add(Utilities.createDelegateAction("Include All Files With Project (" + docSelectedCount + ")", MainFrame.this._moveToAuxiliaryAction));
                        }
                    }
                    if (auxiliarySelected && !docSelected && !externalSelected) {
                        if (m.getComponentCount() > 0) {
                            m.addSeparator();
                        }
                        if (docSelectedCount == 1) {
                            m.add(Utilities.createDelegateAction("Do Not Include File With Project", MainFrame.this._removeAuxiliaryAction));
                        } else if (docSelectedCount > 1) {
                            m.add(Utilities.createDelegateAction("Do Not Include Any Files With Project (" + docSelectedCount + ")", MainFrame.this._removeAuxiliaryAction));
                        }
                    }
                    if (!folderSelected && (externalBinSelected || auxiliaryBinSelected)) {
                        if (m.getComponentCount() > 0) {
                            m.addSeparator();
                        }
                        m.add(Utilities.createDelegateAction("Close All Files", MainFrame.this._closeFolderAction));
                        m.add(Utilities.createDelegateAction("Compile All Files", MainFrame.this._compileFolderAction));
                        m.add(Utilities.createDelegateAction("Test All Files", MainFrame.this._junitFolderAction));
                    }
                    if (externalBinSelected && !auxiliaryBinSelected) {
                        m.add(Utilities.createDelegateAction("Include All Files With Project", MainFrame.this._moveAllToAuxiliaryAction));
                    }
                    if (auxiliaryBinSelected && !externalBinSelected) {
                        m.add(Utilities.createDelegateAction("Do Not Include Any Files With Project", MainFrame.this._removeAllAuxiliaryAction));
                    }
                    m.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        this._interactionsPanePopupMenu = new JPopupMenu();
        this._interactionsPanePopupMenu.add(this.cutAction);
        this._interactionsPanePopupMenu.add(this.copyAction);
        this._interactionsPanePopupMenu.add(this.pasteAction);
        this._interactionsPanePopupMenu.addSeparator();
        this._interactionsPanePopupMenu.add(this._printInteractionsAction);
        this._interactionsPanePopupMenu.add(this._printInteractionsPreviewAction);
        this._interactionsPanePopupMenu.addSeparator();
        this._interactionsPanePopupMenu.add(this._saveInteractionsCopyAction);
        this._interactionsPanePopupMenu.addSeparator();
        this._interactionsPanePopupMenu.add(this._executeHistoryAction);
        this._interactionsPanePopupMenu.add(this._loadHistoryScriptAction);
        this._interactionsPanePopupMenu.add(this._saveHistoryAction);
        this._interactionsPanePopupMenu.add(this._clearHistoryAction);
        this._interactionsPanePopupMenu.addSeparator();
        this._interactionsPanePopupMenu.add(this._resetInteractionsAction);
        this._interactionsPanePopupMenu.add(this._viewInteractionsClassPathAction);
        this._interactionsPanePopupMenu.add(this._copyInteractionToDefinitionsAction);
        this._interactionsPane.addMouseListener(new RightClickMouseAdapter(){

            @Override
            protected void _popupAction(MouseEvent e) {
                MainFrame.this._interactionsPane.requestFocusInWindow();
                MainFrame.this._interactionsPane.endCompoundEdit();
                MainFrame.this._interactionsPanePopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
        this._consolePanePopupMenu = new JPopupMenu();
        this._consolePanePopupMenu.add(this._clearConsoleAction);
        this._consolePanePopupMenu.add(this._saveConsoleCopyAction);
        this._consolePanePopupMenu.addSeparator();
        this._consolePanePopupMenu.add(this._printConsoleAction);
        this._consolePanePopupMenu.add(this._printConsolePreviewAction);
        this._consolePane.addMouseListener(new RightClickMouseAdapter(){

            @Override
            protected void _popupAction(MouseEvent e) {
                MainFrame.this._consolePane.requestFocusInWindow();
                MainFrame.this._consolePanePopupMenu.show(e.getComponent(), e.getX(), e.getY());
            }
        });
    }

    private void nextRecentDoc() {
        if (this._recentDocFrame.isVisible()) {
            this._recentDocFrame.next();
        } else {
            this._recentDocFrame.setVisible(true);
        }
    }

    private void prevRecentDoc() {
        if (this._recentDocFrame.isVisible()) {
            this._recentDocFrame.prev();
        } else {
            this._recentDocFrame.setVisible(true);
        }
    }

    private void hideRecentDocFrame() {
        if (this._recentDocFrame.isVisible()) {
            this._recentDocFrame.setVisible(false);
            OpenDefinitionsDocument doc = this._recentDocFrame.getDocument();
            if (doc != null) {
                this.addToBrowserHistory();
                this._model.setActiveDocument(doc);
            }
        }
    }

    private static boolean isDisplayed(TabbedPanel p) {
        return p != null && p.isDisplayed();
    }

    JScrollPane _createDefScrollPane(OpenDefinitionsDocument doc) {
        DefinitionsPane pane = new DefinitionsPane(this, doc);
        pane.addKeyListener(this._historyListener);
        pane.addFocusListener(this._focusListenerForRecentDocs);
        this._installNewDocumentListener(doc);
        ErrorCaretListener caretListener = new ErrorCaretListener(doc, pane, this);
        pane.addErrorCaretListener(caretListener);
        doc.addDocumentListener(new DocumentUIListener(){

            private void updateUI(OpenDefinitionsDocument doc, int offset) {
                assert (EventQueue.isDispatchThread());
                Component c = MainFrame.this._tabbedPane.getSelectedComponent();
                if (c instanceof RegionsTreePanel) {
                    this.reloadPanel((RegionsTreePanel)c, doc, offset);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private <R extends OrderedDocumentRegion> void reloadPanel(final RegionsTreePanel<R> p, OpenDefinitionsDocument doc, int offset) {
                Pair interval;
                final RegionManager<R> rm = p.getRegionManager();
                SortedSet<R> regions = rm.getRegions(doc);
                if (regions == null || regions.size() == 0) {
                    return;
                }
                int numLinesChangedAfter = doc.getDocument().getAndResetNumLinesChangedAfter();
                Pair<DocumentRegion, DocumentRegion> lineNumInterval = null;
                if (numLinesChangedAfter >= 0) {
                    DocumentRegion start = new DocumentRegion(doc, numLinesChangedAfter, numLinesChangedAfter);
                    int len = doc.getLength();
                    DocumentRegion end = new DocumentRegion(doc, len, len);
                    lineNumInterval = Pair.make(start, end);
                }
                if ((interval = rm.getRegionInterval(doc, offset)) == null && lineNumInterval == null) {
                    return;
                }
                interval = MainFrame.maxInterval(lineNumInterval, interval);
                OrderedDocumentRegion first = (OrderedDocumentRegion)interval.first();
                OrderedDocumentRegion last = (OrderedDocumentRegion)interval.second();
                Object object = MainFrame.this._updateLock;
                synchronized (object) {
                    if (MainFrame.this._tabUpdatePending && MainFrame.this._pendingDocument == doc) {
                        MainFrame.this._firstRegion = MainFrame.this._firstRegion.compareTo(first) <= 0 ? MainFrame.this._firstRegion : first;
                        MainFrame.this._lastRegion = MainFrame.this._lastRegion.compareTo(last) >= 0 ? MainFrame.this._lastRegion : last;
                        MainFrame.this._waitAgain = true;
                        return;
                    }
                    MainFrame.this._firstRegion = first;
                    MainFrame.this._lastRegion = last;
                    MainFrame.this._pendingDocument = doc;
                    MainFrame.this._tabUpdatePending = true;
                    MainFrame.this._pendingUpdate = new Runnable(){

                        @Override
                        public void run() {
                            OrderedDocumentRegion first = MainFrame.this._firstRegion;
                            OrderedDocumentRegion last = MainFrame.this._lastRegion;
                            rm.updateLines(first, last);
                            p.reload(first, last);
                            p.repaint();
                        }
                    };
                }
                MainFrame.this._threadPool.submit(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Thread.currentThread().setPriority(UPDATER_PRIORITY);
                        Object object = MainFrame.this._updateLock;
                        synchronized (object) {
                            try {
                                do {
                                    MainFrame.this._waitAgain = false;
                                    MainFrame.this._updateLock.wait(UPDATE_DELAY);
                                } while (MainFrame.this._waitAgain);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            MainFrame.this._tabUpdatePending = false;
                        }
                        Utilities.invokeLater(MainFrame.this._pendingUpdate);
                    }
                });
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.updateUI(((DefinitionsDocument)e.getDocument()).getOpenDefDoc(), e.getOffset());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.updateUI(((DefinitionsDocument)e.getDocument()).getOpenDefDoc(), e.getOffset());
            }
        });
        pane.addCaretListener(this._posListener);
        pane.addFocusListener(new LastFocusListener());
        BorderlessScrollPane scroll = new BorderlessScrollPane(pane, 20, 30);
        pane.setScrollPane(scroll);
        if (DrJava.getConfig().getSetting(RecentFileManager.LINEENUM_ENABLED).booleanValue()) {
            scroll.setRowHeaderView(new LineEnumRule(pane));
        }
        this._defScrollPanes.put(doc, scroll);
        return scroll;
    }

    private static <R extends OrderedDocumentRegion> Pair<R, R> maxInterval(Pair<R, R> i, Pair<R, R> j) {
        if (i == null) {
            return j;
        }
        if (j == null) {
            return i;
        }
        OrderedDocumentRegion i1 = (OrderedDocumentRegion)i.first();
        OrderedDocumentRegion i2 = (OrderedDocumentRegion)i.second();
        OrderedDocumentRegion j1 = (OrderedDocumentRegion)j.first();
        OrderedDocumentRegion j2 = (OrderedDocumentRegion)j.second();
        return Pair.make(i1.compareTo(j1) <= 0 ? i1 : j1, i2.compareTo(j2) >= 0 ? i2 : j2);
    }

    private void _setUpPanes() {
        if (this._showDebugger) {
            try {
                int debugHeight = DrJava.getConfig().getSetting(RecentFileManager.DEBUG_PANEL_HEIGHT);
                Dimension debugMinSize = this._debugPanel.getMinimumSize();
                if (debugHeight > debugMinSize.height) {
                    debugMinSize.height = debugHeight;
                }
                this._debugPanel.setPreferredSize(debugMinSize);
            }
            catch (NoClassDefFoundError e) {
                this._showDebugger = false;
            }
        }
        this._debugSplitPane.setBottomComponent(this._debugPanel);
        this._mainSplit.setResizeWeight(1.0);
        this._debugSplitPane.setResizeWeight(1.0);
        this.getContentPane().add((Component)this._mainSplit, "Center");
        this._mainSplit.setDividerLocation(this._mainSplit.getHeight() - 132);
        this._mainSplit.setOneTouchExpandable(true);
        this._debugSplitPane.setOneTouchExpandable(true);
        int docListWidth = DrJava.getConfig().getSetting(RecentFileManager.DOC_LIST_WIDTH);
        this._docSplitPane.setDividerLocation(docListWidth);
        this._docSplitPane.setOneTouchExpandable(true);
    }

    void _switchDefScrollPane() {
        assert (EventQueue.isDispatchThread());
        this._currentDefPane.notifyInactive();
        OpenDefinitionsDocument activeDoc = this._model.getActiveDocument();
        this._currentDefDoc = activeDoc.getDocument();
        JScrollPane scroll = this._defScrollPanes.get(activeDoc);
        if (scroll == null) {
            scroll = this._createDefScrollPane(activeDoc);
        }
        this._reenableScrollBar();
        int oldLocation = this._docSplitPane.getDividerLocation();
        this._docSplitPane.setRightComponent(scroll);
        this._docSplitPane.setDividerLocation(oldLocation);
        if (this._currentDefPane.isEditable()) {
            if (this._currentDefPane != null) {
                this._currentDefPane.removeFocusListener(this._undoRedoDefinitionsFocusListener);
            }
            this._currentDefPane = (DefinitionsPane)scroll.getViewport().getView();
            this._currentDefPane.notifyActive();
            this._currentDefPane.addFocusListener(this._undoRedoDefinitionsFocusListener);
        } else {
            try {
                this._currentDefPane.setEditable(true);
            }
            catch (NoSuchDocumentException e) {
                // empty catch block
            }
            if (this._currentDefPane != null) {
                this._currentDefPane.removeFocusListener(this._undoRedoDefinitionsFocusListener);
            }
            this._currentDefPane = (DefinitionsPane)scroll.getViewport().getView();
            this._currentDefPane.notifyActive();
            this._currentDefPane.setEditable(false);
            this._currentDefPane.addFocusListener(this._undoRedoDefinitionsFocusListener);
        }
        this.resetUndo();
        this._updateDebugStatus();
    }

    private void _refreshDefScrollPane() {
        this._currentDefPane.notifyInactive();
        OpenDefinitionsDocument doc = this._model.getActiveDocument();
        this._currentDefDoc = doc.getDocument();
        JScrollPane scroll = this._defScrollPanes.get(doc);
        this._reenableScrollBar();
        int oldLocation = this._docSplitPane.getDividerLocation();
        this._docSplitPane.setRightComponent(scroll);
        this._docSplitPane.setDividerLocation(oldLocation);
        this._currentDefPane.notifyActive();
        this.resetUndo();
        this._updateDebugStatus();
    }

    public void resetUndo() {
        this._undoAction.setDelegatee(this._currentDefPane.getUndoAction());
        this._redoAction.setDelegatee(this._currentDefPane.getRedoAction());
    }

    public DefinitionsPane getDefPaneGivenODD(OpenDefinitionsDocument doc) {
        JScrollPane scroll = this._defScrollPanes.get(doc);
        if (scroll == null) {
            if (this._model.getOpenDefinitionsDocuments().contains(doc)) {
                scroll = this._createDefScrollPane(doc);
            } else {
                throw new UnexpectedException(new Exception("Attempted to get DefinitionsPane for a closed document"));
            }
        }
        DefinitionsPane pane = (DefinitionsPane)scroll.getViewport().getView();
        return pane;
    }

    private void _reenableScrollBar() {
        JScrollPane scroll = this._defScrollPanes.get(this._model.getActiveDocument());
        if (scroll == null) {
            throw new UnexpectedException(new Exception("Current definitions scroll pane not found."));
        }
        JScrollBar oldbar = scroll.getVerticalScrollBar();
        JScrollBar newbar = scroll.createVerticalScrollBar();
        newbar.setMinimum(oldbar.getMinimum());
        newbar.setMaximum(oldbar.getMaximum());
        newbar.setValue(oldbar.getValue());
        newbar.setVisibleAmount(oldbar.getVisibleAmount());
        newbar.setEnabled(true);
        newbar.revalidate();
        scroll.setVerticalScrollBar(newbar);
        oldbar = scroll.getHorizontalScrollBar();
        newbar = scroll.createHorizontalScrollBar();
        newbar.setMinimum(oldbar.getMinimum());
        newbar.setMaximum(oldbar.getMaximum());
        newbar.setValue(oldbar.getValue());
        newbar.setVisibleAmount(oldbar.getVisibleAmount());
        newbar.setEnabled(true);
        newbar.revalidate();
        scroll.setHorizontalScrollBar(newbar);
        scroll.revalidate();
    }

    private File _getFullFile(File f) throws IOException {
        if (PlatformFactory.ONLY.isWindowsPlatform() && (f.getAbsolutePath().indexOf("..") != -1 || f.getAbsolutePath().indexOf("./") != -1 || f.getAbsolutePath().indexOf(".\\") != -1)) {
            return f.getCanonicalFile();
        }
        return f.getAbsoluteFile();
    }

    private void _setCurrentDirectory(File file) {
        try {
            file = this._getFullFile(file);
            this._openChooser.setCurrentDirectory(file);
            this._saveChooser.setCurrentDirectory(file);
            DrJava.getConfig().setSetting(RecentFileManager.LAST_DIRECTORY, file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void _setCurrentDirectory(OpenDefinitionsDocument doc) {
        try {
            File file = doc.getFile();
            if (file != null) {
                this._setCurrentDirectory(file);
            }
        }
        catch (FileMovedException fme) {
            this._setCurrentDirectory(fme.getFile());
        }
    }

    private void _setMainFont() {
        Font f = DrJava.getConfig().getSetting(RecentFileManager.FONT_MAIN);
        for (JScrollPane scroll : this._defScrollPanes.values()) {
            if (scroll == null) continue;
            DefinitionsPane pane = (DefinitionsPane)scroll.getViewport().getView();
            pane.setFont(f);
            if (!DrJava.getConfig().getSetting(RecentFileManager.LINEENUM_ENABLED).booleanValue()) continue;
            scroll.setRowHeaderView(new LineEnumRule(pane));
        }
        this._interactionsPane.setFont(f);
        this._consolePane.setFont(f);
        this._findReplace.setFieldFont(f);
        this._compilerErrorPanel.setListFont(f);
        this._junitPanel.setListFont(f);
        this._javadocErrorPanel.setListFont(f);
    }

    private void _updateNormalColor() {
        Color norm = DrJava.getConfig().getSetting(RecentFileManager.DEFINITIONS_NORMAL_COLOR);
        this._model.getDocCollectionWidget().setForeground(norm);
        this._repaintLineNums();
    }

    private void _updateBackgroundColor() {
        Color back = DrJava.getConfig().getSetting(RecentFileManager.DEFINITIONS_BACKGROUND_COLOR);
        this._model.getDocCollectionWidget().setBackground(back);
        this._repaintLineNums();
    }

    private void _updateLineNums() {
        if (DrJava.getConfig().getSetting(RecentFileManager.LINEENUM_ENABLED).booleanValue()) {
            for (JScrollPane spane : this._defScrollPanes.values()) {
                LineEnumRule ler = (LineEnumRule)spane.getRowHeader().getView();
                ler.updateFont();
                ler.revalidate();
            }
            this._repaintLineNums();
        }
    }

    private void _repaintLineNums() {
        Component view;
        JViewport rhvport;
        JScrollPane front = this._defScrollPanes.get(this._model.getActiveDocument());
        if (front != null && (rhvport = front.getRowHeader()) != null && (view = rhvport.getView()) != null) {
            view.repaint();
        }
    }

    private void _updateDefScrollRowHeader() {
        boolean ruleEnabled = DrJava.getConfig().getSetting(RecentFileManager.LINEENUM_ENABLED);
        for (JScrollPane scroll : this._defScrollPanes.values()) {
            if (scroll == null) continue;
            DefinitionsPane pane = (DefinitionsPane)scroll.getViewport().getView();
            if (scroll.getRowHeader() == null || scroll.getRowHeader().getView() == null) {
                if (!ruleEnabled) continue;
                scroll.setRowHeaderView(new LineEnumRule(pane));
                continue;
            }
            if (ruleEnabled) continue;
            scroll.setRowHeaderView(null);
        }
    }

    public void removeCurrentLocationHighlight() {
        if (this._currentLocationHighlight != null) {
            this._currentLocationHighlight.remove();
            this._currentLocationHighlight = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _disableStepTimer() {
        Timer timer = this._debugStepTimer;
        synchronized (timer) {
            if (this._debugStepTimer.isRunning()) {
                this._debugStepTimer.stop();
            }
        }
    }

    private void _updateDebugStatus() {
        boolean debuggerReady = this.isDebuggerReady();
        this._guiAvailabilityNotifier.ensureAvailabilityIs(GUIAvailabilityListener.ComponentType.DEBUGGER, debuggerReady);
        if (!debuggerReady) {
            return;
        }
        if (this._model.getActiveDocument().isUntitled() || this._model.getActiveDocument().getClassFileInSync()) {
            if (this._debugPanel.getStatusText().equals(DEBUGGER_OUT_OF_SYNC)) {
                this._debugPanel.setStatusText("");
            }
        } else if (this._debugPanel.getStatusText().equals("")) {
            this._debugPanel.setStatusText(DEBUGGER_OUT_OF_SYNC);
        }
        this._debugPanel.repaint();
    }

    protected void _disableInteractionsPane() {
        assert (EventQueue.isDispatchThread());
        this._interactionsPane.setEditable(false);
        this._interactionsPane.setCursor(Cursor.getPredefinedCursor(3));
        if (this._interactionsScriptController != null) {
            this._interactionsScriptController.setActionsDisabled();
        }
    }

    protected void _enableInteractionsPane() {
        assert (EventQueue.isDispatchThread());
        this._interactionsPane.setCursor(Cursor.getPredefinedCursor(2));
        this._interactionsPane.setEditable(true);
        this._interactionsController.moveToEnd();
        if (this._interactionsPane.hasFocus()) {
            this._interactionsPane.getCaret().setVisible(true);
        }
        if (this._interactionsScriptController != null) {
            this._interactionsScriptController.setActionsEnabled();
        }
    }

    public void commentLines() {
        assert (EventQueue.isDispatchThread());
        OpenDefinitionsDocument openDoc = this._model.getActiveDocument();
        int caretPos = this._currentDefPane.getCaretPosition();
        openDoc.setCurrentLocation(caretPos);
        int start = this._currentDefPane.getSelectionStart();
        int end = this._currentDefPane.getSelectionEnd();
        int newEnd = openDoc.commentLines(start, end);
        this._currentDefPane.setCaretPosition(start + 2);
        if (start != end) {
            this._currentDefPane.moveCaretPosition(newEnd);
        }
    }

    public void uncommentLines() {
        Position startPos;
        assert (EventQueue.isDispatchThread());
        OpenDefinitionsDocument openDoc = this._model.getActiveDocument();
        int caretPos = this._currentDefPane.getCaretPosition();
        openDoc.setCurrentLocation(caretPos);
        int start = this._currentDefPane.getSelectionStart();
        int end = this._currentDefPane.getSelectionEnd();
        this._currentDefPane.endCompoundEdit();
        openDoc.setCurrentLocation(start);
        try {
            startPos = openDoc.createUnwrappedPosition(start);
        }
        catch (BadLocationException e) {
            throw new UnexpectedException(e);
        }
        int startOffset = startPos.getOffset();
        int newEnd = openDoc.uncommentLines(start, end);
        if (startOffset != startPos.getOffset()) {
            start -= 2;
        }
        int f_start = start;
        boolean moveSelection = start != end;
        this._currentDefPane.setCaretPosition(f_start);
        if (moveSelection) {
            this._currentDefPane.moveCaretPosition(newEnd);
        }
    }

    public void scrollToDocumentAndOffset(OpenDefinitionsDocument doc, int offset, boolean shouldHighlight) {
        this.scrollToDocumentAndOffset(doc, offset, shouldHighlight, true);
    }

    public void goToRegionAndHighlight(final IDocumentRegion r) {
        assert (EventQueue.isDispatchThread());
        this.addToBrowserHistory();
        final OpenDefinitionsDocument doc = r.getDocument();
        boolean toSameDoc = doc == this._model.getActiveDocument();
        Runnable command = new Runnable(){

            @Override
            public void run() {
                int startOffset = r.getStartOffset();
                int endOffset = r.getEndOffset();
                doc.setCurrentLocation(startOffset);
                MainFrame.this._currentLocationHighlight = MainFrame.this._currentDefPane.getHighlightManager().addHighlight(startOffset, endOffset, DefinitionsPane.THREAD_PAINTER);
                MainFrame.this._currentDefPane.centerViewOnOffset(startOffset);
                MainFrame.this._currentDefPane.select(startOffset, endOffset);
                MainFrame.this._currentDefPane.requestFocusInWindow();
            }
        };
        if (!toSameDoc) {
            this._model.setActiveDocument(doc);
            this._findReplace.updateFirstDocInSearch();
            EventQueue.invokeLater(command);
        } else {
            this._model.refreshActiveDocument();
            command.run();
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                MainFrame.this.addToBrowserHistory();
            }
        });
    }

    public void scrollToDocumentAndOffset(final OpenDefinitionsDocument doc, final int offset, final boolean shouldHighlight, boolean shouldAddToHistory) {
        OpenDefinitionsDocument activeDoc;
        assert (this.duringInit() || EventQueue.isDispatchThread());
        if (shouldAddToHistory) {
            this.addToBrowserHistory();
        }
        boolean toSameDoc = (activeDoc = this._model.getActiveDocument()) == doc;
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (offset >= 0) {
                    if (shouldHighlight) {
                        int endOffset;
                        MainFrame.this.removeCurrentLocationHighlight();
                        int startOffset = doc._getLineStartPos(offset);
                        if (startOffset >= 0 && (endOffset = doc._getLineEndPos(offset)) >= 0) {
                            MainFrame.this._currentLocationHighlight = MainFrame.this._currentDefPane.getHighlightManager().addHighlight(startOffset, endOffset, DefinitionsPane.THREAD_PAINTER);
                        }
                    }
                    if (MainFrame.this._currentDefPane.getSize().getWidth() > 0.0 && MainFrame.this._currentDefPane.getSize().getHeight() > 0.0) {
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                MainFrame.this._currentDefPane.centerViewOnOffset(offset);
                                MainFrame.this._currentDefPane.requestFocusInWindow();
                            }
                        });
                    }
                }
                if (MainFrame.this._showDebugger) {
                    MainFrame.this._interactionsPane.requestFocusInWindow();
                    MainFrame.this._updateDebugStatus();
                }
            }
        };
        if (!toSameDoc) {
            this._model.setActiveDocument(doc);
            this._findReplace.updateFirstDocInSearch();
            EventQueue.invokeLater(command);
        } else {
            this._model.refreshActiveDocument();
            command.run();
        }
    }

    boolean isProjectActiveAndMainClassSet() {
        return this._model.isProjectActive() && this._model.getMainClass() != null && this._model.getMainClassContainingFile() != null && this._model.getMainClassContainingFile().exists();
    }

    boolean isProjectActiveAndBuildDirSet() {
        return this._model.isProjectActive() && this._model.getBuildDirectory() != null && this._model.getBuildDirectory() != FileOps.NULL_FILE;
    }

    void askToIncreaseSlaveMaxHeap() {
        String res;
        String value = "set to " + DrJava.getConfig().getSetting(RecentFileManager.SLAVE_JVM_XMX) + " MB";
        if (!"".equals(DrJava.getConfig().getSetting(RecentFileManager.SLAVE_JVM_XMX)) && OptionConstants.heapSizeChoices.get(0).equals(DrJava.getConfig().getSetting(RecentFileManager.SLAVE_JVM_XMX))) {
            value = "not set, implying the system's default";
        }
        if ((res = (String)JOptionPane.showInputDialog(this, "Your program ran out of memory. You may try to enter a larger\nmaximum heap size for the Interactions JVM. The maximum heap size is\ncurrently " + value + ".\n" + "A restart is required after changing this setting.", "Increase Maximum Heap Size?", 3, null, OptionConstants.heapSizeChoices.toArray(), DrJava.getConfig().getSetting(RecentFileManager.SLAVE_JVM_XMX))) != null) {
            DrJava.getConfig().removeOptionListener(RecentFileManager.SLAVE_JVM_XMX, this._slaveJvmXmxListener);
            final ConfigOptionListeners.SlaveJVMXMXListener l = new ConfigOptionListeners.SlaveJVMXMXListener(this);
            DrJava.getConfig().addOptionListener(RecentFileManager.SLAVE_JVM_XMX, l);
            DrJava.getConfig().setSetting(RecentFileManager.SLAVE_JVM_XMX, res.trim());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DrJava.getConfig().removeOptionListener(RecentFileManager.SLAVE_JVM_XMX, l);
                    DrJava.getConfig().addOptionListener(RecentFileManager.SLAVE_JVM_XMX, MainFrame.this._slaveJvmXmxListener);
                }
            });
        }
        this._model.getInteractionsModel().resetLastErrors();
    }

    void askToIncreaseMasterMaxHeap() {
        String res;
        String value = "set to " + DrJava.getConfig().getSetting(RecentFileManager.MASTER_JVM_XMX) + " MB";
        if (!"".equals(DrJava.getConfig().getSetting(RecentFileManager.MASTER_JVM_XMX)) && OptionConstants.heapSizeChoices.get(0).equals(DrJava.getConfig().getSetting(RecentFileManager.MASTER_JVM_XMX))) {
            value = "not set, implying the system's default";
        }
        if ((res = (String)JOptionPane.showInputDialog(this, "DrJava ran out of memory. You may try to enter a larger\nmaximum heap size for the main JVM. The maximum heap size is\ncurrently " + value + ".\n" + "A restart is required after changing this setting.", "Increase Maximum Heap Size?", 3, null, OptionConstants.heapSizeChoices.toArray(), DrJava.getConfig().getSetting(RecentFileManager.MASTER_JVM_XMX))) != null) {
            DrJava.getConfig().removeOptionListener(RecentFileManager.MASTER_JVM_XMX, this._masterJvmXmxListener);
            final ConfigOptionListeners.MasterJVMXMXListener l = new ConfigOptionListeners.MasterJVMXMXListener(this);
            DrJava.getConfig().addOptionListener(RecentFileManager.MASTER_JVM_XMX, l);
            DrJava.getConfig().setSetting(RecentFileManager.MASTER_JVM_XMX, res.trim());
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DrJava.getConfig().removeOptionListener(RecentFileManager.MASTER_JVM_XMX, l);
                    DrJava.getConfig().addOptionListener(RecentFileManager.MASTER_JVM_XMX, MainFrame.this._masterJvmXmxListener);
                }
            });
        }
        this._model.getInteractionsModel().resetLastErrors();
    }

    public void projectRunnableChanged() {
        boolean mainClassSet = this.isProjectActiveAndMainClassSet();
        this._guiAvailabilityNotifier.ensureAvailabilityIs(GUIAvailabilityListener.ComponentType.PROJECT_MAIN_CLASS, mainClassSet);
        this._runButton = mainClassSet ? this._updateToolbarButton(this._runButton, this._runProjectAction) : this._updateToolbarButton(this._runButton, this._runAction);
    }

    public JViewport getDefViewport() {
        OpenDefinitionsDocument doc = this._model.getActiveDocument();
        JScrollPane defScroll = this._defScrollPanes.get(doc);
        return defScroll.getViewport();
    }

    public void removeTab(Component c) {
        if (this._tabbedPane.getTabCount() > 1) {
            this._tabbedPane.remove(c);
            ((TabbedPanel)c).setDisplayed(false);
        }
        this._currentDefPane.requestFocusInWindow();
    }

    public void showBookmarks() {
        this.showTab(this._bookmarksPanel, true);
    }

    public void showBreakpoints() {
        this.showTab(this._breakpointsPanel, true);
    }

    private void _createTab(TabbedPanel panel) {
        int numVisible = 0;
        for (TabbedPanel t : this._tabs) {
            if (t == panel) {
                Icon icon = panel instanceof FindResultsPanel ? FIND_ICON : null;
                this._tabbedPane.insertTab(panel.getName(), icon, panel, null, numVisible + 2);
                panel.setVisible(true);
                panel.setDisplayed(true);
                panel.repaint();
                break;
            }
            if (!MainFrame.isDisplayed(t)) continue;
            ++numVisible;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showTab(Component c, boolean showDetachedWindow) {
        assert (EventQueue.isDispatchThread());
        try {
            if (c instanceof TabbedPanel) {
                this._createTab((TabbedPanel)c);
            }
            if (c instanceof RegionsTreePanel) {
                RegionsTreePanel p = (RegionsTreePanel)c;
                DefaultTreeModel model = p.getRegTreeModel();
                model.reload();
                p.expandTree();
                p.repaint();
            }
            this._tabbedPane.setSelectedComponent(c);
            c.requestFocusInWindow();
            if (this._mainSplit.getDividerLocation() > this._mainSplit.getMaximumDividerLocation()) {
                this._mainSplit.resetToPreferredSizes();
            }
        }
        finally {
            if (showDetachedWindow && this._tabbedPanesFrame != null && this._tabbedPanesFrame.isVisible()) {
                this._tabbedPanesFrame.toFront();
            }
        }
    }

    private boolean _warnFileOpen(File f) {
        OpenDefinitionsDocument d = null;
        try {
            d = this._model.getDocumentForFile(f);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        Object[] options = new Object[]{"Yes", "No"};
        if (d == null) {
            return false;
        }
        boolean dMod = d.isModifiedSinceSave();
        String msg = "This file is already open in DrJava" + (dMod ? " and has been modified" : "") + ".  Do you wish to overwrite it?";
        int choice = JOptionPane.showOptionDialog(this, msg, "File Open Warning", 0, 3, null, options, options[1]);
        if (choice == 0) {
            return this._model.closeFileWithoutPrompt(d);
        }
        return false;
    }

    private boolean _verifyOverwrite(File f) {
        return MainFrameStatics.verifyOverwrite(this, f);
    }

    private void _resetJUnit() {
        this._junitPanel.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _junitInterrupted(UnexpectedException e) {
        try {
            MainFrameStatics.showJUnitInterrupted((Component)this, e);
            this.removeTab(this._junitPanel);
            this._resetJUnit();
            this._model.refreshActiveDocument();
        }
        finally {
            this.hourglassOff();
            this._guiAvailabilityNotifier.junitFinished();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _junitInterrupted(String message) {
        try {
            MainFrameStatics.showJUnitInterrupted((Component)this, message);
            this.removeTab(this._junitPanel);
            this._resetJUnit();
            this._model.refreshActiveDocument();
        }
        finally {
            this.hourglassOff();
            this._guiAvailabilityNotifier.junitFinished();
        }
    }

    boolean isDebuggerReady() {
        return this._showDebugger && this._model.getDebugger().isReady();
    }

    boolean isDebuggerEnabled() {
        return this._showDebugger;
    }

    FindReplacePanel getFindReplaceDialog() {
        return this._findReplace;
    }

    private void _setUpKeyBindingMaps() {
        ActionMap actionMap = this._currentDefPane.getActionMap();
        KeyBindingManager kbm = KeyBindingManager.ONLY;
        kbm.put(RecentFileManager.KEY_BACKWARD, actionMap.get("caret-backward"), null, "Cursor Backward");
        kbm.put(RecentFileManager.KEY_BACKWARD_SELECT, actionMap.get("selection-backward"), null, "Cursor Backward (Select)");
        kbm.put(RecentFileManager.KEY_BEGIN_DOCUMENT, actionMap.get("caret-begin"), null, "Cursor Begin Document");
        kbm.put(RecentFileManager.KEY_BEGIN_DOCUMENT_SELECT, actionMap.get("selection-begin"), null, "Cursor Begin Document (Select)");
        kbm.put(RecentFileManager.KEY_BEGIN_LINE, this._beginLineAction, null, "Cursor Begin Line");
        kbm.put(RecentFileManager.KEY_BEGIN_LINE_SELECT, this._selectionBeginLineAction, null, "Cursor Begin Line (Select)");
        kbm.put(RecentFileManager.KEY_PREVIOUS_WORD, actionMap.get("caret-previous-word"), null, "Cursor Previous Word");
        kbm.put(RecentFileManager.KEY_PREVIOUS_WORD_SELECT, actionMap.get("selection-previous-word"), null, "Cursor Previous Word (Select)");
        kbm.put(RecentFileManager.KEY_DOWN, actionMap.get("caret-down"), null, "Cursor Down");
        kbm.put(RecentFileManager.KEY_DOWN_SELECT, actionMap.get("selection-down"), null, "Cursor Down (Select)");
        kbm.put(RecentFileManager.KEY_END_DOCUMENT, actionMap.get("caret-end"), null, "Cursor End Document");
        kbm.put(RecentFileManager.KEY_END_DOCUMENT_SELECT, actionMap.get("selection-end"), null, "Cursor End Document (Select)");
        kbm.put(RecentFileManager.KEY_END_LINE, actionMap.get("caret-end-line"), null, "Cursor End Line");
        kbm.put(RecentFileManager.KEY_END_LINE_SELECT, actionMap.get("selection-end-line"), null, "Cursor End Line (Select)");
        kbm.put(RecentFileManager.KEY_NEXT_WORD, actionMap.get("caret-next-word"), null, "Cursor Next Word");
        kbm.put(RecentFileManager.KEY_NEXT_WORD_SELECT, actionMap.get("selection-next-word"), null, "Cursor Next Word (Select)");
        kbm.put(RecentFileManager.KEY_FORWARD, actionMap.get("caret-forward"), null, "Cursor Forward");
        kbm.put(RecentFileManager.KEY_FORWARD_SELECT, actionMap.get("selection-forward"), null, "Cursor Forward (Select)");
        kbm.put(RecentFileManager.KEY_UP, actionMap.get("caret-up"), null, "Cursor Up");
        kbm.put(RecentFileManager.KEY_UP_SELECT, actionMap.get("selection-up"), null, "Cursor Up (Select)");
        kbm.put(RecentFileManager.KEY_PAGE_DOWN, actionMap.get("page-down"), null, "Cursor Page Down");
        kbm.put(RecentFileManager.KEY_PAGE_UP, actionMap.get("page-up"), null, "Cursor Page Up");
        kbm.put(RecentFileManager.KEY_CUT_LINE, this._cutLineAction, null, "Cut Line");
        kbm.put(RecentFileManager.KEY_CLEAR_LINE, this._clearLineAction, null, "Clear Line");
        kbm.put(RecentFileManager.KEY_SHIFT_DELETE_PREVIOUS, actionMap.get("delete-previous"), null, "Delete Previous");
        kbm.put(RecentFileManager.KEY_SHIFT_DELETE_NEXT, actionMap.get("delete-next"), null, "Delete Next");
    }

    public void addComponentListenerToOpenDocumentsList(ComponentListener listener) {
        this._docSplitPane.getLeftComponent().addComponentListener(listener);
    }

    public String getFileNameField() {
        return this._statusField.getText();
    }

    public String getStatusMessage() {
        return this._statusReport.getText();
    }

    public JMenu getEditMenu() {
        return this._editMenu;
    }

    public void setPopupLoc(Window popup) {
        Utilities.setPopupLoc(popup, popup.getOwner() != null ? popup.getOwner() : this);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
        dropTargetDragEvent.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        assert (EventQueue.isDispatchThread());
        try {
            Transferable tr = dropTargetDropEvent.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor) || uriListFlavor != null && tr.isDataFlavorSupported(uriListFlavor)) {
                List<File> fileList;
                List<File> data;
                dropTargetDropEvent.acceptDrop(3);
                if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                    fileList = data = (List)tr.getTransferData(DataFlavor.javaFileListFlavor);
                } else {
                    data = (String)tr.getTransferData(uriListFlavor);
                    fileList = MainFrame.textURIListToFileList((String)((Object)data));
                }
                Iterator<File> iterator = fileList.iterator();
                ArrayList<File> filteredFileList = new ArrayList<File>();
                while (iterator.hasNext()) {
                    File file = iterator.next();
                    if (file.isFile() && (DrJavaFileUtils.isSourceFile(file) || file.getName().endsWith(".txt"))) {
                        filteredFileList.add(file);
                        continue;
                    }
                    if (!file.isFile() || !file.getName().endsWith(".djapp")) continue;
                    MainFrame.openExtProcessFile(file);
                }
                final File[] fileArray = filteredFileList.toArray(new File[filteredFileList.size()]);
                FileOpenSelector fs = new FileOpenSelector(){

                    @Override
                    public File[] getFiles() {
                        return fileArray;
                    }
                };
                this.open(fs);
                dropTargetDropEvent.getDropTargetContext().dropComplete(true);
            } else {
                dropTargetDropEvent.rejectDrop();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
            dropTargetDropEvent.rejectDrop();
        }
    }

    public static void openExtProcessFile(File file) {
        try {
            XMLConfig xc = new XMLConfig(file);
            String name = xc.get("drjava/extprocess/name");
            ExecuteExternalDialog.addToMenu(name, xc.get("drjava/extprocess/cmdline"), xc.get("drjava/extprocess/workdir"), "");
            JOptionPane.showMessageDialog(null, "The installation was successful for:\n" + name, "Installation Successful", 1);
        }
        catch (XMLConfig.XMLConfigException xce) {
            MainFrame.openExtProcessJarFile(file);
        }
    }

    public static void openExtProcessJarFile(File file) {
        try {
            JarFile jf = new JarFile(file);
            JarEntry je = jf.getJarEntry("process.djapp");
            InputStream is = jf.getInputStream(je);
            XMLConfig xc = new XMLConfig(is);
            String name = xc.get("drjava/extprocess/name");
            ExecuteExternalDialog.addToMenu(name, xc.get("drjava/extprocess/cmdline"), xc.get("drjava/extprocess/workdir"), file.getAbsolutePath());
            JOptionPane.showMessageDialog(null, "The installation was successful for:\n" + name, "Installation Successful", 1);
            is.close();
            jf.close();
        }
        catch (IOException ioe) {
        }
        catch (XMLConfig.XMLConfigException xMLConfigException) {
            // empty catch block
        }
    }

    private static List<File> textURIListToFileList(String data) {
        ArrayList<File> list = new ArrayList<File>();
        StringTokenizer st = new StringTokenizer(data, "\r\n");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (s.startsWith("#")) continue;
            try {
                URI uri = new URI(s);
                File file = new File(uri);
                list.add(file);
            }
            catch (URISyntaxException e) {
            }
            catch (IllegalArgumentException e) {}
        }
        return list;
    }

    public void handleRemoteOpenFile(final File f, int lineNo) {
        if (f.getName().endsWith(".djapp")) {
            MainFrame.openExtProcessFile(f);
        } else {
            final FileOpenSelector openSelector = new FileOpenSelector(){

                @Override
                public File[] getFiles() throws OperationCanceledException {
                    return new File[]{f};
                }
            };
            String currFileName = f.getName();
            if (currFileName.endsWith(".drjava") || currFileName.endsWith(".xml") || currFileName.endsWith(".pjt")) {
                Utilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.openProject(openSelector);
                    }
                });
            } else {
                final int l = lineNo;
                Utilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MainFrame.this.open(openSelector);
                        if (l >= 0) {
                            MainFrame.this._jumpToLine(l);
                        }
                    }
                });
            }
        }
    }

    public void resetAutoImportDialogPosition() {
        this._initAutoImportDialog();
        this._autoImportDialog.setFrameState("default");
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_AUTOIMPORT_STORE_POSITION).booleanValue()) {
            DrJava.getConfig().setSetting(RecentFileManager.DIALOG_AUTOIMPORT_STATE, "default");
        }
    }

    private void _initAutoImportDialog() {
        if (this._autoImportDialog == null) {
            this._autoImportPackageCheckbox = new JCheckBox("Import Package");
            this._autoImportPackageCheckbox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MainFrame.this._autoImportDialog.resetFocus();
                }
            });
            PlatformFactory.ONLY.setMnemonic((AbstractButton)this._autoImportPackageCheckbox, 'p');
            PredictiveInputFrame.InfoSupplier<MainFrameStatics.JavaAPIListEntry> info = new PredictiveInputFrame.InfoSupplier<MainFrameStatics.JavaAPIListEntry>(){

                @Override
                public String value(MainFrameStatics.JavaAPIListEntry entry) {
                    return entry.getFullString();
                }
            };
            PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry> okAction = new PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry>(){

                @Override
                public String getName() {
                    return "OK";
                }

                @Override
                public KeyStroke getKeyStroke() {
                    return KeyStroke.getKeyStroke(10, 0);
                }

                @Override
                public String getToolTipText() {
                    return null;
                }

                @Override
                public Object value(PredictiveInputFrame<MainFrameStatics.JavaAPIListEntry> p) {
                    int lastDot;
                    String text = p.getItem() != null ? p.getItem().getFullString() : p.getText();
                    if (MainFrame.this._autoImportPackageCheckbox.isSelected() && (lastDot = text.lastIndexOf(46)) > 0) {
                        text = text.substring(0, lastDot + 1) + "*";
                    }
                    final DefaultInteractionsModel im = MainFrame.this._model.getInteractionsModel();
                    String lastLine = im.removeLastFromHistory();
                    String importLine = "import " + text + "; // auto-import";
                    final String code = importLine + (lastLine != null ? "\n" + lastLine : "");
                    EventQueue.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            try {
                                im.append(code, "default");
                                im.interpretCurrentInteraction();
                            }
                            finally {
                                MainFrame.this.hourglassOff();
                            }
                        }
                    });
                    return null;
                }
            };
            PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry> cancelAction = new PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry>(){

                @Override
                public String getName() {
                    return "Cancel";
                }

                @Override
                public KeyStroke getKeyStroke() {
                    return KeyStroke.getKeyStroke(27, 0);
                }

                @Override
                public String getToolTipText() {
                    return null;
                }

                @Override
                public Object value(PredictiveInputFrame<MainFrameStatics.JavaAPIListEntry> p) {
                    MainFrame.this._model.getInteractionsModel().resetLastErrors();
                    MainFrame.this.hourglassOff();
                    return null;
                }
            };
            ArrayList strategies = new ArrayList();
            strategies.add(new PredictiveInputModel.FragmentStrategy());
            strategies.add(new PredictiveInputModel.PrefixStrategy());
            strategies.add(new PredictiveInputModel.RegExStrategy());
            ArrayList<PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry>> actions = new ArrayList<PredictiveInputFrame.CloseAction<MainFrameStatics.JavaAPIListEntry>>();
            actions.add(okAction);
            actions.add(cancelAction);
            this._autoImportDialog = new PredictiveInputFrame<MainFrameStatics.JavaAPIListEntry>((SwingFrame)this, "Auto Import Class", false, true, (PredictiveInputFrame.InfoSupplier)info, strategies, actions, 1, new MainFrameStatics.JavaAPIListEntry[]{new MainFrameStatics.JavaAPIListEntry("dummyImport", "dummyImport", null)}){

                @Override
                public void setOwnerEnabled(boolean b) {
                    if (b) {
                        MainFrame.this.hourglassOff();
                    } else {
                        MainFrame.this.hourglassOn();
                    }
                }

                @Override
                protected JComponent[] makeOptions() {
                    return new JComponent[]{MainFrame.this._autoImportPackageCheckbox};
                }
            };
            if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_AUTOIMPORT_STORE_POSITION).booleanValue()) {
                this._autoImportDialog.setFrameState(DrJava.getConfig().getSetting(RecentFileManager.DIALOG_AUTOIMPORT_STATE));
            }
            this.generateJavaAPISet();
        }
    }

    private void _showAutoImportDialog(final String s) {
        this.hourglassOn();
        new Thread(){

            @Override
            public void run() {
                final Set<MainFrameStatics.JavaAPIListEntry> apiSet = MainFrame.this.getJavaAPISet();
                if (apiSet == null) {
                    MainFrame.this.hourglassOff();
                    return;
                }
                Utilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ArrayList<MainFrameStatics.JavaAPIListEntry> autoImportList = new ArrayList<MainFrameStatics.JavaAPIListEntry>(apiSet);
                        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_COMPLETE_SCAN_CLASS_FILES).booleanValue() && MainFrame.this._autoImportClassSet.size() > 0) {
                            autoImportList.addAll(MainFrame.this._autoImportClassSet);
                        } else {
                            File projectRoot = MainFrame.this._model.getProjectRoot();
                            List<OpenDefinitionsDocument> docs = MainFrame.this._model.getOpenDefinitionsDocuments();
                            if (docs != null) {
                                for (OpenDefinitionsDocument d : docs) {
                                    if (d.isUntitled()) continue;
                                    try {
                                        MainFrameStatics.JavaAPIListEntry entry;
                                        String simple;
                                        String rel = FileOps.stringMakeRelativeTo(d.getRawFile(), projectRoot);
                                        String full = rel.replace(File.separatorChar, '.');
                                        for (String ext : DrJavaFileUtils.getSourceFileExtensions()) {
                                            if (!full.endsWith(ext)) continue;
                                            full = full.substring(0, full.lastIndexOf(ext));
                                            break;
                                        }
                                        if ((simple = full).lastIndexOf(46) >= 0) {
                                            simple = simple.substring(simple.lastIndexOf(46) + 1);
                                        }
                                        if (autoImportList.contains(entry = new MainFrameStatics.JavaAPIListEntry(simple, full, null))) continue;
                                        autoImportList.add(entry);
                                    }
                                    catch (IOException ioe) {
                                    }
                                    catch (SecurityException se) {}
                                }
                            }
                        }
                        PredictiveInputModel pim = new PredictiveInputModel(true, new PredictiveInputModel.PrefixStrategy(), autoImportList);
                        pim.setMask(s);
                        MainFrame.this._initAutoImportDialog();
                        MainFrame.this._autoImportDialog.setModel(true, pim);
                        MainFrame.this._autoImportPackageCheckbox.setSelected(false);
                        MainFrame.this._autoImportDialog.setVisible(true);
                    }
                });
            }
        }.start();
    }

    private void _followFile() {
        this.updateStatusField("Opening File for Following");
        try {
            File[] files = this._openAnyFileSelector.getFiles();
            if (files == null) {
                return;
            }
            for (File f : files) {
                if (f == null) continue;
                String end = f.getName();
                int lastIndex = end.lastIndexOf(File.separatorChar);
                if (lastIndex >= 0) {
                    end = end.substring(lastIndex + 1);
                }
                final LessPanel panel = new LessPanel(this, "Follow: " + end, f);
                this._tabs.addLast(panel);
                panel.getMainPanel().addFocusListener(new FocusAdapter(){

                    @Override
                    public void focusGained(FocusEvent e) {
                        MainFrame.this._lastFocusOwner = panel;
                    }
                });
                panel.setVisible(true);
                this.showTab(panel, true);
                this._tabbedPane.setSelectedComponent(panel);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        panel.requestFocusInWindow();
                    }
                });
            }
        }
        catch (OperationCanceledException operationCanceledException) {
            // empty catch block
        }
    }

    private void _executeExternalProcess() {
        this._executeExternalDialog.setVisible(true);
    }

    private void initExecuteExternalProcessDialog() {
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_EXTERNALPROCESS_STORE_POSITION).booleanValue()) {
            this._executeExternalDialog.setFrameState(DrJava.getConfig().getSetting(RecentFileManager.DIALOG_EXTERNALPROCESS_STATE));
        }
    }

    public void resetExecuteExternalProcessPosition() {
        this._executeExternalDialog.setFrameState("default");
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_EXTERNALPROCESS_STORE_POSITION).booleanValue()) {
            DrJava.getConfig().setSetting(RecentFileManager.DIALOG_EXTERNALPROCESS_STATE, "default");
        }
    }

    private void initEditExternalProcessDialog() {
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_EDITEXTERNALPROCESS_STORE_POSITION).booleanValue()) {
            this._editExternalDialog.setFrameState(DrJava.getConfig().getSetting(RecentFileManager.DIALOG_EDITEXTERNALPROCESS_STATE));
        }
    }

    public void resetEditExternalProcessPosition() {
        this._editExternalDialog.setFrameState("default");
        if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_EDITEXTERNALPROCESS_STORE_POSITION).booleanValue()) {
            DrJava.getConfig().setSetting(RecentFileManager.DIALOG_EDITEXTERNALPROCESS_STATE, "default");
        }
    }

    public void installModalWindowAdapter(final Window w, final Runnable1<? super WindowEvent> toFrontAction, final Runnable1<? super WindowEvent> closeAction) {
        WindowAdapter wa;
        assert (EventQueue.isDispatchThread());
        if (this._modalWindowAdapters.containsKey(w)) {
            return;
        }
        if (this._modalWindowAdapterOwner == null) {
            this._modalWindowAdapterOwner = w;
            wa = new WindowAdapter(){
                final HashSet<Window> trumpedBy = new HashSet();
                final WindowAdapter regainFront = new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent we) {
                        w.toFront();
                        w.requestFocus();
                        toFrontAction.run(we);
                        Window o = we.getOppositeWindow();
                        if (o != null) {
                            trumpedBy.remove(o);
                            o.removeWindowListener(this);
                        }
                    }
                };
                final WindowAdapter regainFrontAfterNative = new WindowAdapter(){

                    @Override
                    public void windowActivated(WindowEvent we) {
                        MainFrame.this.removeWindowListener(this);
                        MainFrame.this._tabbedPanesFrame.removeWindowListener(this);
                        if (MainFrame.this._debugFrame != null) {
                            MainFrame.this._debugFrame.removeWindowListener(this);
                        }
                        if (MainFrame.this._modalWindowAdapterOwner == w) {
                            w.toFront();
                            w.requestFocus();
                            toFrontAction.run(we);
                        }
                    }
                };

                public void toFront(WindowEvent we) {
                    Dialog d;
                    Window opposite = we.getOppositeWindow();
                    if (opposite == null) {
                        MainFrame.this.addWindowListener(this.regainFrontAfterNative);
                        MainFrame.this._tabbedPanesFrame.addWindowListener(this.regainFrontAfterNative);
                        if (MainFrame.this._debugFrame != null) {
                            MainFrame.this._debugFrame.addWindowListener(this.regainFrontAfterNative);
                        }
                        return;
                    }
                    if (opposite instanceof Dialog && (d = (Dialog)opposite).isModal()) {
                        if (!this.trumpedBy.contains(d)) {
                            d.addWindowListener(this.regainFront);
                            this.trumpedBy.add(d);
                        }
                        return;
                    }
                    we.getWindow().toFront();
                    we.getWindow().requestFocus();
                    toFrontAction.run(we);
                }

                @Override
                public void windowDeactivated(WindowEvent we) {
                    this.toFront(we);
                }

                @Override
                public void windowIconified(WindowEvent we) {
                    this.toFront(we);
                }

                @Override
                public void windowLostFocus(WindowEvent we) {
                    this.toFront(we);
                }

                @Override
                public void windowClosing(WindowEvent we) {
                    closeAction.run(we);
                }
            };
        } else {
            wa = new WindowAdapter(){

                @Override
                public void windowDeactivated(WindowEvent we) {
                }

                @Override
                public void windowIconified(WindowEvent we) {
                }

                @Override
                public void windowLostFocus(WindowEvent we) {
                }

                @Override
                public void windowClosing(WindowEvent we) {
                    closeAction.run(we);
                }
            };
        }
        this._modalWindowAdapters.put(w, wa);
        w.addWindowListener(wa);
        w.addWindowFocusListener(wa);
    }

    public void removeModalWindowAdapter(Window w) {
        assert (EventQueue.isDispatchThread());
        if (!this._modalWindowAdapters.containsKey(w)) {
            return;
        }
        w.removeWindowListener(this._modalWindowAdapters.get(w));
        w.removeWindowFocusListener(this._modalWindowAdapters.get(w));
        this._modalWindowAdapterOwner = null;
        this._modalWindowAdapters.remove(w);
    }

    static {
        ImageIcon java = MainFrame.getIcon("JavaIcon20.gif");
        ImageIcon dj0 = MainFrame.getIcon("ElementaryIcon20.gif");
        ImageIcon dj1 = MainFrame.getIcon("IntermediateIcon20.gif");
        ImageIcon dj2 = MainFrame.getIcon("AdvancedIcon20.gif");
        ImageIcon dj = MainFrame.getIcon("FunctionalIcon20.gif");
        ImageIcon other = MainFrame.getIcon("OtherIcon20.gif");
        _djFileDisplayManager20 = new DJFileDisplayManager(java, dj0, dj1, dj2, dj, other);
        java = MainFrame.getIcon("JavaIcon30.gif");
        dj0 = MainFrame.getIcon("ElementaryIcon30.gif");
        dj1 = MainFrame.getIcon("IntermediateIcon30.gif");
        dj2 = MainFrame.getIcon("AdvancedIcon30.gif");
        dj = MainFrame.getIcon("FunctionalIcon30.gif");
        other = MainFrame.getIcon("OtherIcon30.gif");
        _djFileDisplayManager30 = new DJFileDisplayManager(java, dj0, dj1, dj2, dj, other);
        ImageIcon star = MainFrame.getIcon("ModStar20.gif");
        ImageIcon jup = MainFrame.getIcon("JUnitPass20.gif");
        ImageIcon juf = MainFrame.getIcon("JUnitFail20.gif");
        _oddDisplayManager20 = new OddDisplayManager(_djFileDisplayManager20, star, jup, juf);
        star = MainFrame.getIcon("ModStar30.gif");
        jup = MainFrame.getIcon("JUnitPass30.gif");
        juf = MainFrame.getIcon("JUnitFail30.gif");
        _oddDisplayManager30 = new OddDisplayManager(_djFileDisplayManager30, star, jup, juf);
        _djProjectIcon = MainFrame.getIcon("ProjectIcon.gif");
        UPDATE_DELAY = 500L;
        UPDATER_PRIORITY = 2;
        FIND_ICON = MainFrame.getIcon("Find16.gif");
        try {
            uriListFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
        }
        catch (ClassNotFoundException cnfe) {
            uriListFlavor = null;
        }
    }

    private class LastFocusListener
    extends FocusAdapter {
        private LastFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            MainFrame.this._lastFocusOwner = e.getComponent();
        }
    }

    private class RecentFilesOptionListener
    implements OptionListener<Integer> {
        private RecentFilesOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Integer> oce) {
            MainFrame.this._recentFileManager.updateMax((Integer)oce.value);
            MainFrame.this._recentFileManager.numberItems();
            MainFrame.this._recentProjectManager.updateMax((Integer)oce.value);
            MainFrame.this._recentProjectManager.numberItems();
        }
    }

    private class QuitPromptOptionListener
    implements OptionListener<Boolean> {
        private QuitPromptOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            MainFrame.this._promptBeforeQuit = (Boolean)oce.value;
        }
    }

    private class LineEnumColorOptionListener
    implements OptionListener<Color> {
        private LineEnumColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            MainFrame.this._updateLineNums();
        }
    }

    private class LineEnumOptionListener
    implements OptionListener<Boolean> {
        private LineEnumOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            MainFrame.this._updateDefScrollRowHeader();
        }
    }

    private class ToolbarOptionListener
    implements OptionListener<Boolean> {
        private ToolbarOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Boolean> oce) {
            MainFrame.this._updateToolbarButtons();
        }
    }

    private class BackgroundColorOptionListener
    implements OptionListener<Color> {
        private BackgroundColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            MainFrame.this._updateBackgroundColor();
        }
    }

    private class NormalColorOptionListener
    implements OptionListener<Color> {
        private NormalColorOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Color> oce) {
            MainFrame.this._updateNormalColor();
        }
    }

    private class ToolbarFontOptionListener
    implements OptionListener<Font> {
        private ToolbarFontOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Font> oce) {
            MainFrame.this._updateToolbarButtons();
        }
    }

    private class DoclistFontOptionListener
    implements OptionListener<Font> {
        private DoclistFontOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Font> oce) {
            Font doclistFont = DrJava.getConfig().getSetting(RecentFileManager.FONT_DOCLIST);
            MainFrame.this._model.getDocCollectionWidget().setFont(doclistFont);
        }
    }

    private class LineNumbersFontOptionListener
    implements OptionListener<Font> {
        private LineNumbersFontOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Font> oce) {
            MainFrame.this._updateLineNums();
        }
    }

    private class MainFontOptionListener
    implements OptionListener<Font> {
        private MainFontOptionListener() {
        }

        @Override
        public void optionChanged(OptionEvent<Font> oce) {
            MainFrame.this._setMainFont();
        }
    }

    private class ModelListener
    implements GlobalModelListener {
        private volatile int _fnfCount = 0;

        private ModelListener() {
        }

        @Override
        public <P, R> void executeAsyncTask(AsyncTask<P, R> task, P param, boolean showProgress, boolean lockUI) {
            new DJAsyncTaskLauncher().executeTask(task, param, showProgress, lockUI);
        }

        @Override
        public void handleAlreadyOpenDocument(OpenDefinitionsDocument doc) {
            MainFrame.this._model.setActiveDocument(doc);
            if (doc.isModifiedSinceSave()) {
                String title = "Revert to Saved?";
                String message = doc.getFileName() + " is already open and modified.\n" + "Would you like to revert to the version on disk?\n";
                int choice = JOptionPane.showConfirmDialog(MainFrame.this, message, title, 0);
                if (choice == 0) {
                    MainFrame.this._revert(doc);
                }
            }
        }

        @Override
        public void newFileCreated(OpenDefinitionsDocument doc) {
            MainFrame.this._createDefScrollPane(doc);
            PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.all.files").invalidate();
        }

        private boolean resetFNFCount() {
            return this._fnfCount == 0;
        }

        private boolean someFilesNotFound() {
            PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.all.files").invalidate();
            return this._fnfCount > 0;
        }

        @Override
        public void filesNotFound(File ... files) {
            if (files.length == 0) {
                return;
            }
            this._fnfCount += files.length;
            if (files.length == 1) {
                JOptionPane.showMessageDialog(MainFrame.this, "The following file could not be found.\n" + files[0].getPath(), "File Not Found", 0);
            } else {
                ArrayList<String> filePaths = new ArrayList<String>();
                for (File f : files) {
                    filePaths.add(f.getPath());
                }
                ScrollableListDialog dialog = new ScrollableListDialog.Builder().setOwner(MainFrame.this).setTitle("Files Not Found").setText("The following files could not be found.").setItems(filePaths).setMessageType(0).build();
                MainFrame.this.setPopupLoc(dialog);
                dialog.showDialog();
                PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.all.files").invalidate();
            }
        }

        @Override
        public File[] filesReadOnly(File ... files) {
            if (files.length == 0) {
                return new File[0];
            }
            this._fnfCount += files.length;
            ArrayList<String> choices = new ArrayList<String>();
            choices.add("Yes");
            choices.add("No");
            ArrayList<String> filePaths = new ArrayList<String>();
            for (File f : files) {
                filePaths.add(f.getPath());
            }
            ScrollableListDialog dialog = new ScrollableListDialog.Builder().setOwner(MainFrame.this).setTitle("Files are Read-Only").setText("<html>The following files could not be saved because they are read-only.<br>Do you want to overwrite them anyway?</html>").setItems(filePaths).setSelectedItems(filePaths).setMessageType(3).clearButtons().addButton(new JButton("Yes")).addButton(new JButton("No")).setSelectable(true).build();
            boolean overwrite = false;
            if (files.length == 1) {
                int res = JOptionPane.showConfirmDialog(MainFrame.this, "The following file could not be saved because it is read-only.\nDo you want to overwrite it anyway?\n" + files[0].getPath(), "File is Read-Only", 0, 3);
                overwrite = res == 0;
            } else {
                MainFrame.this.setPopupLoc(dialog);
                dialog.showDialog();
                boolean bl = overwrite = dialog.getButtonPressed() == 0;
            }
            if (overwrite) {
                if (files.length == 1) {
                    return files;
                }
                File[] overwriteFiles = new File[dialog.getSelectedItems().size()];
                int i = 0;
                for (String s : dialog.getSelectedItems()) {
                    overwriteFiles[i++] = new File(s);
                }
                return overwriteFiles;
            }
            return new File[0];
        }

        @Override
        public void fileSaved(OpenDefinitionsDocument doc) {
            block3: {
                doc.documentSaved();
                MainFrame.this._saveAction.setEnabled(false);
                MainFrame.this._renameAction.setEnabled(true);
                MainFrame.this._revertAction.setEnabled(true);
                MainFrame.this.updateStatusField();
                MainFrame.this._currentDefPane.requestFocusInWindow();
                PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.all.files").invalidate();
                try {
                    File f = doc.getFile();
                    if (!MainFrame.this._model.inProject(f)) {
                        MainFrame.this._recentFileManager.updateOpenFiles(f);
                    }
                }
                catch (FileMovedException fme) {
                    File f = fme.getFile();
                    if (MainFrame.this._model.inProject(f)) break block3;
                    MainFrame.this._recentFileManager.updateOpenFiles(f);
                }
            }
            MainFrame.this._updateDebugStatus();
        }

        @Override
        public void fileOpened(OpenDefinitionsDocument doc) {
            this._fileOpened(doc);
            PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.all.files").invalidate();
        }

        private void _fileOpened(OpenDefinitionsDocument doc) {
            block3: {
                try {
                    File f = doc.getFile();
                    if (!MainFrame.this._model.inProject(f)) {
                        MainFrame.this._recentFileManager.updateOpenFiles(f);
                        PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.all.files").invalidate();
                    }
                }
                catch (FileMovedException fme) {
                    File f = fme.getFile();
                    if (MainFrame.this._model.inProject(f)) break block3;
                    MainFrame.this._recentFileManager.updateOpenFiles(f);
                }
            }
        }

        @Override
        public void fileClosed(OpenDefinitionsDocument doc) {
            this._fileClosed(doc);
        }

        private void _fileClosed(OpenDefinitionsDocument doc) {
            MainFrame.this._recentDocFrame.closeDocument(doc);
            MainFrame.this._removeErrorListener(doc);
            JScrollPane jsp = (JScrollPane)MainFrame.this._defScrollPanes.get(doc);
            if (jsp != null) {
                ((DefinitionsPane)jsp.getViewport().getView()).close();
                MainFrame.this._defScrollPanes.remove(doc);
            }
            PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.all.files").invalidate();
        }

        @Override
        public void fileReverted(OpenDefinitionsDocument doc) {
            MainFrame.this.updateStatusField();
            MainFrame.this._saveAction.setEnabled(false);
            MainFrame.this._currentDefPane.resetUndo();
            MainFrame.this._currentDefPane.hasWarnedAboutModified(false);
            MainFrame.this._currentDefPane.setPositionAndScroll(0);
            MainFrame.this._updateDebugStatus();
        }

        @Override
        public void undoableEditHappened() {
            assert (EventQueue.isDispatchThread());
            MainFrame.this._currentDefPane.getUndoAction().updateUndoState();
            MainFrame.this._currentDefPane.getRedoAction().updateRedoState();
        }

        @Override
        public void activeDocumentRefreshed(OpenDefinitionsDocument active) {
            assert (EventQueue.isDispatchThread());
            MainFrame.this._recentDocFrame.pokeDocument(active);
            MainFrame.this._refreshDefScrollPane();
            int pos = MainFrame.this._currentDefPane.getCaretPosition();
            MainFrame.this._currentDefPane.getErrorCaretListener().updateHighlight(pos);
            this.focusOnLastFocusOwner();
        }

        @Override
        public void activeDocumentChanged(OpenDefinitionsDocument active) {
            assert (EventQueue.isDispatchThread());
            MainFrame.this._recentDocFrame.pokeDocument(active);
            MainFrame.this._switchDefScrollPane();
            boolean isModified = active.isModifiedSinceSave();
            boolean canCompile = !isModified && !active.isUntitled();
            boolean hasName = !active.isUntitled();
            MainFrame.this._saveAction.setEnabled(!canCompile);
            MainFrame.this._renameAction.setEnabled(hasName);
            MainFrame.this._revertAction.setEnabled(hasName);
            int pos = MainFrame.this._currentDefPane.getCaretPosition();
            MainFrame.this._currentDefPane.getErrorCaretListener().updateHighlight(pos);
            MainFrame.this._setCurrentDirectory(active);
            MainFrame.this.updateStatusField();
            MainFrame.this._posListener.updateLocation();
            if (isModified) {
                MainFrame.this._model.getDocumentNavigator().repaint();
            }
            try {
                active.revertIfModifiedOnDisk();
            }
            catch (FileMovedException fme) {
                MainFrame.this._showFileMovedError(fme);
            }
            catch (IOException e) {
                MainFrameStatics.showIOError(MainFrame.this, e);
            }
            if (MainFrame.isDisplayed(MainFrame.this._findReplace)) {
                MainFrame.this._findReplace.stopListening();
                MainFrame.this._findReplace.beginListeningTo(MainFrame.this._currentDefPane);
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this._lastFocusOwner = MainFrame.this._currentDefPane;
                    MainFrame.this._currentDefPane.requestFocusInWindow();
                    PropertyMaps.TEMPLATE.getProperty("DrJava", "drjava.current.file").invalidate();
                }
            });
        }

        @Override
        public void focusOnLastFocusOwner() {
            MainFrame.this._lastFocusOwner.requestFocusInWindow();
        }

        @Override
        public void focusOnDefinitionsPane() {
            MainFrame.this._currentDefPane.requestFocusInWindow();
        }

        @Override
        public void interactionStarted() {
            _log.log("interactionStarted()");
            MainFrame.this.disableAutomaticTrace();
            MainFrame.this._interactionsPane.endCompoundEdit();
            MainFrame.this._disableInteractionsPane();
            MainFrame.this._guiAvailabilityNotifier.unavailable(GUIAvailabilityListener.ComponentType.INTERACTIONS);
        }

        @Override
        public void interactionEnded() {
            assert (EventQueue.isDispatchThread());
            DefaultInteractionsModel im = MainFrame.this._model.getInteractionsModel();
            String lastError = im.getLastError();
            FileConfiguration config = DrJava.getConfig();
            if (config != null && config.getSetting(OptionConstants.DIALOG_AUTOIMPORT_ENABLED).booleanValue()) {
                String secondToLastError;
                if (!(lastError == null || (secondToLastError = im.getSecondToLastError()) == null && lastError.equals(secondToLastError))) {
                    if (lastError.startsWith("Static Error: Undefined class '") && lastError.endsWith("'")) {
                        String undefinedClassName = lastError.substring(lastError.indexOf(39) + 1, lastError.lastIndexOf(39));
                        MainFrame.this._showAutoImportDialog(undefinedClassName);
                    } else if (lastError.startsWith("Static Error: Undefined name '") && lastError.endsWith("'")) {
                        String undefinedName = lastError.substring(lastError.indexOf(39) + 1, lastError.lastIndexOf(39));
                        if (undefinedName.length() > 0 && Character.isUpperCase(undefinedName.charAt(0)) && undefinedName.indexOf(46) >= 0) {
                            String undefinedClassName = undefinedName.substring(0, undefinedName.indexOf(46));
                            MainFrame.this._showAutoImportDialog(undefinedClassName);
                        }
                    } else if (lastError.startsWith("java.lang.OutOfMemoryError")) {
                        MainFrame.this.askToIncreaseSlaveMaxHeap();
                    }
                }
            } else {
                im.resetLastErrors();
            }
            MainFrame.this._enableInteractionsPane();
            MainFrame.this._guiAvailabilityNotifier.available(GUIAvailabilityListener.ComponentType.INTERACTIONS);
            MainFrame.this._interactionsPane.discardUndoEdits();
        }

        @Override
        public void interactionErrorOccurred(int offset, int length) {
            MainFrame.this._interactionsPane.highlightError(offset, length);
        }

        @Override
        public void interpreterChanged(boolean inProgress) {
            MainFrame.this._guiAvailabilityNotifier.availabilityChanged(GUIAvailabilityListener.ComponentType.INTERACTIONS, !inProgress);
            if (inProgress) {
                MainFrame.this._disableInteractionsPane();
            } else {
                MainFrame.this._enableInteractionsPane();
            }
        }

        @Override
        public void compileStarted() {
            assert (EventQueue.isDispatchThread());
            MainFrame.this._guiAvailabilityNotifier.unavailable(GUIAvailabilityListener.ComponentType.COMPILER);
            MainFrame.this.showTab(MainFrame.this._compilerErrorPanel, true);
            MainFrame.this._compilerErrorPanel.setCompilationInProgress();
            MainFrame.this._saveAction.setEnabled(false);
        }

        @Override
        public void compileEnded(File workDir, List<? extends File> excludedFiles) {
            assert (EventQueue.isDispatchThread());
            MainFrame.this._guiAvailabilityNotifier.available(GUIAvailabilityListener.ComponentType.COMPILER);
            MainFrame.this._compilerErrorPanel.reset(excludedFiles.toArray(new File[0]));
            if (MainFrame.this.isDebuggerReady()) {
                MainFrame.this._updateDebugStatus();
            }
            if (DrJava.getConfig().getSetting(RecentFileManager.DIALOG_COMPLETE_SCAN_CLASS_FILES).booleanValue() && MainFrame.this._model.getBuildDirectory() != null) {
                MainFrame.this._scanClassFiles();
            }
            if (MainFrame.this._junitPanel.isDisplayed()) {
                MainFrame.this._resetJUnit();
            }
            MainFrame.this._model.refreshActiveDocument();
        }

        @Override
        public void compileAborted(Exception e) {
            MainFrame.this._guiAvailabilityNotifier.available(GUIAvailabilityListener.ComponentType.COMPILER);
        }

        @Override
        public void activeCompilerChanged() {
            String linkVersion = DrJava.getConfig().getSetting(RecentFileManager.JAVADOC_API_REF_VERSION);
            if (linkVersion.equals("use compiler version")) {
                MainFrame.this.clearJavaAPISet();
            }
            MainFrame.this._model.updateSyntaxHighlighting();
            MainFrame.this._guiAvailabilityNotifier.ensureAvailabilityIs(GUIAvailabilityListener.ComponentType.LANGUAGE_LEVELS, MainFrame.this._model.getCompilerModel().getActiveCompiler().supportsLanguageLevels());
        }

        @Override
        public void prepareForRun(OpenDefinitionsDocument doc) {
            assert (EventQueue.isDispatchThread());
            MainFrame.this.showTab(MainFrame.this._interactionsContainer, true);
            MainFrame.this._lastFocusOwner = MainFrame.this._interactionsContainer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void junitStarted() {
            assert (EventQueue.isDispatchThread());
            try {
                MainFrame.this.showTab(MainFrame.this._junitPanel, true);
                MainFrame.this._junitPanel.setJUnitInProgress();
            }
            finally {
                MainFrame.this.hourglassOff();
            }
        }

        @Override
        public void junitClassesStarted() {
            assert (EventQueue.isDispatchThread());
            MainFrame.this.showTab(MainFrame.this._junitPanel, true);
            MainFrame.this._junitPanel.setJUnitInProgress();
        }

        @Override
        public void junitSuiteStarted(int numTests) {
            assert (EventQueue.isDispatchThread());
            MainFrame.this._junitPanel.progressReset(numTests);
        }

        @Override
        public void junitTestStarted(String name) {
            assert (EventQueue.isDispatchThread());
            MainFrame.this._junitPanel.getErrorListPane().testStarted(name);
        }

        @Override
        public void junitTestEnded(String name, boolean succeeded, boolean causedError) {
            assert (EventQueue.isDispatchThread());
            MainFrame.this._junitPanel.getErrorListPane().testEnded(name, succeeded, causedError);
            MainFrame.this._junitPanel.progressStep(succeeded);
            MainFrame.this._model.refreshActiveDocument();
        }

        @Override
        public void junitEnded() {
            assert (EventQueue.isDispatchThread());
            MainFrame.this._guiAvailabilityNotifier.junitFinished();
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this._junitPanel.reset();
                }
            });
            MainFrame.this._model.refreshActiveDocument();
        }

        @Override
        public void javadocStarted() {
            assert (EventQueue.isDispatchThread());
            MainFrame.this.hourglassOn();
            MainFrame.this._guiAvailabilityNotifier.javadocStarted();
            MainFrame.this.showTab(MainFrame.this._javadocErrorPanel, true);
            MainFrame.this._javadocErrorPanel.setJavadocInProgress();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void javadocEnded(boolean success, File destDir, boolean allDocs) {
            assert (EventQueue.isDispatchThread());
            try {
                MainFrame.this._javadocErrorPanel.getErrorListPane().setJavadocEnded(success);
                MainFrame.this.showTab(MainFrame.this._javadocErrorPanel, true);
                MainFrame.this._javadocErrorPanel.reset();
                MainFrame.this._model.refreshActiveDocument();
            }
            finally {
                MainFrame.this._guiAvailabilityNotifier.javadocFinished();
                MainFrame.this.hourglassOff();
            }
            if (success) {
                String className;
                try {
                    className = MainFrame.this._model.getActiveDocument().getQualifiedClassName();
                    className = className.replace('.', File.separatorChar);
                }
                catch (ClassNameNotFoundException cnf) {
                    className = "";
                }
                try {
                    String fileName = allDocs || className.equals("") ? "index.html" : className + ".html";
                    File index = new File(destDir, fileName);
                    URL address = FileOps.toURL(index.getAbsoluteFile());
                    if (!PlatformFactory.ONLY.openURL(address)) {
                        JavadocFrame _javadocFrame = new JavadocFrame(destDir, className, allDocs);
                        _javadocFrame.setVisible(true);
                    }
                }
                catch (MalformedURLException me) {
                    throw new UnexpectedException(me);
                }
                catch (IllegalStateException ise) {
                    String msg = "Javadoc completed successfully, but did not produce any HTML files.\nPlease ensure that your access level in Preferences is appropriate.";
                    JOptionPane.showMessageDialog(MainFrame.this, msg, "No output to display.", 1);
                }
            }
        }

        @Override
        public void interpreterExited(int status) {
            if (DrJava.getConfig().getSetting(RecentFileManager.INTERACTIONS_EXIT_PROMPT).booleanValue() && !Utilities.TEST_MODE && MainFrame.this.isVisible()) {
                String msg = "The interactions window was terminated by a call to System.exit(" + status + ").\n" + "The interactions window will now be restarted.";
                String title = "Interactions terminated by System.exit(" + status + ")";
                ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(MainFrame.this, title, msg, "Do not show this message again", 1, -1);
                if (dialog.show() == 0 && dialog.getCheckBoxValue()) {
                    DrJava.getConfig().setSetting(RecentFileManager.INTERACTIONS_EXIT_PROMPT, Boolean.FALSE);
                }
            }
        }

        @Override
        public void interpreterResetFailed(Throwable t) {
            this.interpreterReady(FileOps.NULL_FILE);
        }

        @Override
        public void interpreterResetting() {
            assert (MainFrame.this.duringInit() || EventQueue.isDispatchThread());
            MainFrame.this._guiAvailabilityNotifier.unavailable(GUIAvailabilityListener.ComponentType.INTERACTIONS);
            MainFrame.this._closeInteractionsScript();
            MainFrame.this._interactionsPane.setEditable(false);
            MainFrame.this._interactionsPane.setCursor(Cursor.getPredefinedCursor(3));
        }

        @Override
        public void interpreterReady(File wd) {
            assert (MainFrame.this.duringInit() || EventQueue.isDispatchThread());
            this.interactionEnded();
            MainFrame.this._guiAvailabilityNotifier.available(GUIAvailabilityListener.ComponentType.INTERACTIONS);
            MainFrame.this._interactionsController.interruptConsoleInput();
        }

        @Override
        public void consoleReset() {
        }

        @Override
        public void saveBeforeCompile() {
            assert (EventQueue.isDispatchThread());
            this._saveAllBeforeProceeding("To compile, you must first save ALL modified files.\nWould you like to save and then compile?", RecentFileManager.ALWAYS_SAVE_BEFORE_COMPILE, "Always save before compiling");
        }

        @Override
        public void compileBeforeJUnit(final CompilerListener testAfterCompile, List<OpenDefinitionsDocument> outOfSync) {
            if (DrJava.getConfig().getSetting(RecentFileManager.ALWAYS_COMPILE_BEFORE_JUNIT).booleanValue() || Utilities.TEST_MODE) {
                MainFrame.this._model.getCompilerModel().addListener(testAfterCompile);
                MainFrame.this._compileAll();
            } else {
                JButton yesButton = new JButton(new AbstractAction("Yes"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MainFrame.this._model.getCompilerModel().addListener(testAfterCompile);
                        MainFrame.this._compileAll();
                    }
                });
                JButton noButton = new JButton(new AbstractAction("No"){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        MainFrame.this._junitInterrupted("Unit testing cancelled by user.");
                    }
                });
                ScrollableListDialog<OpenDefinitionsDocument> dialog = new ScrollableListDialog.Builder().setOwner(MainFrame.this).setTitle("Must Compile All Source Files to Run Unit Tests").setText("<html>Before you can run unit tests, you must first compile all out of sync source files.<br>The files below are out of sync. Would you like to compile all files and<br>run the specified test(s)?").setItems(outOfSync).setMessageType(3).setFitToScreen(true).clearButtons().addButton(yesButton).addButton(noButton).build();
                dialog.showDialog();
            }
        }

        @Override
        public void saveBeforeJavadoc() {
            this._saveAllBeforeProceeding("To run Javadoc, you must first save ALL modified files.\nWould you like to save and then run Javadoc?", RecentFileManager.ALWAYS_SAVE_BEFORE_JAVADOC, "Always save before running Javadoc");
        }

        private void _saveAllBeforeProceeding(String message, BooleanOption option, String checkMsg) {
            block5: {
                block6: {
                    if (!MainFrame.this._model.hasModifiedDocuments()) break block5;
                    if (DrJava.getConfig().getSetting(option).booleanValue() || Utilities.TEST_MODE) break block6;
                    ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(MainFrame.this, "Must Save All Files to Continue", message, checkMsg);
                    int rc = dialog.show();
                    switch (rc) {
                        case 0: {
                            MainFrame.this._saveAll();
                            if (dialog.getCheckBoxValue()) {
                                DrJava.getConfig().setSetting(option, Boolean.TRUE);
                                break;
                            }
                            break block5;
                        }
                        case -1: 
                        case 1: 
                        case 2: {
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid rc from showConfirmDialog: " + rc);
                        }
                    }
                    break block5;
                }
                MainFrame.this._saveAll();
            }
        }

        @Override
        public void compileBeforeJavadoc(CompilerListener afterCompile) {
            this._compileBeforeProceeding("To run Javadoc, you must first compile all files.\nWould you like to compile and then run Javadoc?", RecentFileManager.ALWAYS_COMPILE_BEFORE_JAVADOC, "Always save before running Javadoc", afterCompile);
        }

        private void _compileBeforeProceeding(String message, BooleanOption option, String checkMsg, CompilerListener afterCompile) {
            block5: {
                block6: {
                    if (!MainFrame.this._model.hasOutOfSyncDocuments()) break block5;
                    if (DrJava.getConfig().getSetting(option).booleanValue() || Utilities.TEST_MODE) break block6;
                    ConfirmCheckBoxDialog dialog = new ConfirmCheckBoxDialog(MainFrame.this, "Must Compile Files to Continue", message, checkMsg);
                    int rc = dialog.show();
                    switch (rc) {
                        case 0: {
                            MainFrame.this._model.getCompilerModel().addListener(afterCompile);
                            MainFrame.this._compileAll();
                            if (dialog.getCheckBoxValue()) {
                                DrJava.getConfig().setSetting(option, Boolean.TRUE);
                                break;
                            }
                            break block5;
                        }
                        case -1: 
                        case 1: 
                        case 2: {
                            afterCompile.compileAborted(new RuntimeException("Not compiled."));
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid rc from showConfirmDialog: " + rc);
                        }
                    }
                    break block5;
                }
                MainFrame.this._model.getCompilerModel().addListener(afterCompile);
                MainFrame.this._compileAll();
            }
        }

        @Override
        public void saveUntitled() {
            MainFrame.this._saveAs();
        }

        @Override
        public void filePathContainsPound() {
            String msg;
            String title;
            ConfirmCheckBoxDialog dialog;
            if (DrJava.getConfig().getSetting(RecentFileManager.WARN_PATH_CONTAINS_POUND).booleanValue() && (dialog = new ConfirmCheckBoxDialog(MainFrame.this, title = "Path Contains Pound Sign", msg = "Files whose paths contain the '#' symbol cannot be used in the\nInteractions Pane due to a bug in Java's file to URL conversion.\nIt is suggested that you change the name of the directory\ncontaining the '#' symbol.", "Do not show this message again", 2, -1)).show() == 0 && dialog.getCheckBoxValue()) {
                DrJava.getConfig().setSetting(RecentFileManager.WARN_PATH_CONTAINS_POUND, Boolean.FALSE);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void nonTestCase(boolean isTestAll, boolean didCompileFail) {
            assert (EventQueue.isDispatchThread());
            String title = "Cannot Run JUnit Test Cases";
            String message = didCompileFail ? "Compile failed. Cannot run JUnit TestCases.\nPlease examine the Compiler Output." : (isTestAll ? "There are no compiled JUnit TestCases available for execution.\nPerhaps you have not yet saved and compiled your test files." : "The current document is not a valid JUnit test case.\nPlease make sure that:\n- it has been compiled and\n- it is a subclass of junit.framework.TestCase.\n");
            JOptionPane.showMessageDialog(MainFrame.this, message, title, 0);
            try {
                if (!didCompileFail) {
                    MainFrame.this.showTab(MainFrame.this._junitPanel, true);
                }
                MainFrame.this._resetJUnit();
            }
            finally {
                MainFrame.this.hourglassOff();
                MainFrame.this._guiAvailabilityNotifier.junitFinished();
            }
        }

        @Override
        public void classFileError(ClassFileError e) {
            assert (EventQueue.isDispatchThread());
            String message = "The class file for class " + e.getClassName() + " in source file " + e.getCanonicalPath() + " cannot be loaded.\n " + "When DrJava tries to load it, the following error is generated:\n" + e.getError();
            JOptionPane.showMessageDialog(MainFrame.this, message, "Testing works only on valid class files", 0);
            MainFrame.this.showTab(MainFrame.this._junitPanel, true);
            MainFrame.this._guiAvailabilityNotifier.junitFinished();
            MainFrame.this._junitPanel.reset();
        }

        @Override
        public void currentDirectoryChanged(File dir) {
            MainFrame.this._setCurrentDirectory(dir);
        }

        @Override
        public boolean canAbandonFile(OpenDefinitionsDocument doc) {
            return this._fileSaveHelper(doc, 1);
        }

        private boolean _fileSaveHelper(OpenDefinitionsDocument doc, int paneOption) {
            String text;
            String fname;
            OpenDefinitionsDocument lastActive = MainFrame.this._model.getActiveDocument();
            if (lastActive != doc) {
                MainFrame.this._model.setActiveDocument(doc);
            }
            boolean notFound = false;
            try {
                File file = doc.getFile();
                if (file == null) {
                    fname = "Untitled file";
                    text = "Untitled file has been modified. Would you like to save it?";
                } else {
                    fname = file.getName();
                    text = fname + " has been modified. Would you like to save it?";
                }
            }
            catch (FileMovedException fme) {
                fname = fme.getFile().getName();
                text = fname + " not found on disk. Would you like to save to another file?";
                notFound = true;
            }
            int rc = JOptionPane.showConfirmDialog(MainFrame.this, text, "Save " + fname + "?", paneOption);
            switch (rc) {
                case 0: {
                    boolean saved = false;
                    saved = notFound ? MainFrame.this._saveAs() : MainFrame.this._save();
                    if (doc != lastActive) {
                        MainFrame.this._model.setActiveDocument(lastActive);
                    }
                    return saved;
                }
                case 1: {
                    if (doc != lastActive) {
                        MainFrame.this._model.setActiveDocument(lastActive);
                    }
                    return true;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
            throw new RuntimeException("Invalid option: " + rc);
        }

        @Override
        public boolean quitFile(OpenDefinitionsDocument doc) {
            return this._fileSaveHelper(doc, 1);
        }

        @Override
        public boolean shouldRevertFile(OpenDefinitionsDocument doc) {
            String fname;
            if (!MainFrame.this._model.getActiveDocument().equals(doc)) {
                MainFrame.this._model.setActiveDocument(doc);
            }
            try {
                File file = doc.getFile();
                fname = file == null ? "Untitled file" : file.getName();
            }
            catch (FileMovedException fme) {
                fname = fme.getFile().getName();
            }
            String text = fname + " has changed on disk.\n" + "Would you like to reload it and discard any changes you have made?";
            Object[] options = new String[]{"Reload from disk", "Keep my changes"};
            int rc = JOptionPane.showOptionDialog(MainFrame.this, text, fname + " Modified on Disk", -1, 3, null, options, options[0]);
            switch (rc) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
                case -1: 
                case 2: {
                    return false;
                }
            }
            throw new RuntimeException("Invalid rc: " + rc);
        }

        @Override
        public void interactionIncomplete() {
        }

        @Override
        public void projectBuildDirChanged() {
            MainFrame.this._guiAvailabilityNotifier.ensureAvailabilityIs(GUIAvailabilityListener.ComponentType.PROJECT_BUILD_DIR, MainFrame.this.isProjectActiveAndBuildDirSet());
        }

        @Override
        public void projectWorkDirChanged() {
        }

        @Override
        public void projectModified() {
        }

        @Override
        public void projectClosed() {
            MainFrame.this._model.getDocumentNavigator().asContainer().addKeyListener(MainFrame.this._historyListener);
            MainFrame.this._model.getDocumentNavigator().asContainer().addFocusListener(MainFrame.this._focusListenerForRecentDocs);
            MainFrame.this._model.getDocumentNavigator().asContainer().addMouseListener(MainFrame.this._resetFindReplaceListener);
            MainFrame.this.removeTab(MainFrame.this._junitPanel);
            MainFrame.this._runButton = MainFrame.this._updateToolbarButton(MainFrame.this._runButton, MainFrame.this._runAction);
            MainFrame.this._compileButton = MainFrame.this._updateToolbarButton(MainFrame.this._compileButton, MainFrame.this._compileAllAction);
            MainFrame.this._junitButton = MainFrame.this._updateToolbarButton(MainFrame.this._junitButton, MainFrame.this._junitAllAction);
            this.projectRunnableChanged();
        }

        @Override
        public void allFilesClosed() {
            MainFrame.this._compilerErrorPanel._close();
            MainFrame.this._junitPanel._close();
            MainFrame.this._javadocErrorPanel._close();
            MainFrame.this._model.resetConsole();
        }

        @Override
        public void openProject(File projectFile, FileOpenSelector files) {
            MainFrame.this._setUpContextMenus();
            this.projectRunnableChanged();
            MainFrame.this._setUpProjectButtons(projectFile);
            MainFrame.this.open(files);
            MainFrame.this._openProjectUpdate();
        }

        @Override
        public void projectRunnableChanged() {
            MainFrame.this.projectRunnableChanged();
        }

        @Override
        public void documentNotFound(OpenDefinitionsDocument d, File f) {
            MainFrame.this._model.setProjectChanged(true);
            String text = "File " + f.getAbsolutePath() + "\ncould not be found on disk!  It was probably moved\n" + "or deleted.  Would you like to try to find it?";
            int rc = JOptionPane.showConfirmDialog(MainFrame.this, text, "File Moved or Deleted", 0);
            if (rc == 1) {
                return;
            }
            if (rc == 0) {
                try {
                    File[] opened = MainFrame.this._openSelector.getFiles();
                    d.setFile(opened[0]);
                }
                catch (OperationCanceledException oce) {
                    // empty catch block
                }
            }
        }

        @Override
        public void browserChanged() {
            MainFrame.this._configureBrowsing();
        }

        @Override
        public void updateCurrentLocationInDoc() {
            if (MainFrame.this._currentDefPane != null) {
                MainFrame.this._currentDefPane.updateCurrentLocationInDoc();
            }
        }
    }

    private class DJAsyncTaskLauncher
    extends AsyncTaskLauncher {
        private DJAsyncTaskLauncher() {
        }

        @Override
        protected boolean shouldSetEnabled() {
            return true;
        }

        @Override
        protected void setParentContainerEnabled(boolean enabled) {
            if (enabled) {
                MainFrame.this.hourglassOff();
            } else {
                MainFrame.this.hourglassOn();
            }
        }

        @Override
        protected IAsyncProgress createProgressMonitor(final String description, final int min, final int max) {
            return new IAsyncProgress(){
                private ProgressMonitor _monitor;
                {
                    this._monitor = new ProgressMonitor(MainFrame.this, description, "", min, max);
                }

                @Override
                public void close() {
                    this._monitor.close();
                }

                @Override
                public int getMaximum() {
                    return this._monitor.getMaximum();
                }

                @Override
                public int getMillisToDecideToPopup() {
                    return this._monitor.getMillisToDecideToPopup();
                }

                @Override
                public int getMillisToPopup() {
                    return this._monitor.getMillisToPopup();
                }

                @Override
                public int getMinimum() {
                    return this._monitor.getMinimum();
                }

                @Override
                public String getNote() {
                    return this._monitor.getNote();
                }

                @Override
                public boolean isCanceled() {
                    return this._monitor.isCanceled();
                }

                @Override
                public void setMaximum(int m) {
                    this._monitor.setMaximum(m);
                }

                @Override
                public void setMinimum(int m) {
                    this._monitor.setMinimum(m);
                }

                @Override
                public void setNote(String note) {
                    this._monitor.setNote(note);
                }

                @Override
                public void setProgress(int nv) {
                    this._monitor.setProgress(nv);
                }
            };
        }
    }

    private class UIDebugListener
    implements DebugListener {
        private UIDebugListener() {
        }

        @Override
        public void debuggerStarted() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this.showDebugger();
                }
            });
        }

        @Override
        public void debuggerShutdown() {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MainFrame.this._disableStepTimer();
                    MainFrame.this.hideDebugger();
                    MainFrame.this.removeCurrentLocationHighlight();
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stepRequested() {
            Timer timer = MainFrame.this._debugStepTimer;
            synchronized (timer) {
                if (MainFrame.this._automaticTraceTimer == null || !MainFrame.this._automaticTraceTimer.isRunning()) {
                    if (!MainFrame.this._debugStepTimer.isRunning()) {
                        MainFrame.this._debugStepTimer.start();
                    } else {
                        MainFrame.this._debugStepTimer.restart();
                    }
                }
            }
        }

        @Override
        public void currThreadSuspended() {
            assert (EventQueue.isDispatchThread());
            MainFrame.this._disableStepTimer();
            MainFrame.this._setThreadDependentDebugMenuItems(true);
            MainFrame.this._model.getInteractionsModel().autoImport();
            if (MainFrame.this._model.getDebugger().isAutomaticTraceEnabled() && MainFrame.this._automaticTraceTimer != null && !MainFrame.this._automaticTraceTimer.isRunning()) {
                MainFrame.this._automaticTraceTimer.start();
            }
        }

        @Override
        public void currThreadResumed() {
            MainFrame.this._setThreadDependentDebugMenuItems(false);
            MainFrame.this.removeCurrentLocationHighlight();
        }

        @Override
        public void threadLocationUpdated(OpenDefinitionsDocument doc, int lineNumber, boolean shouldHighlight) {
            MainFrame.this.scrollToDocumentAndOffset(doc, doc._getOffset(lineNumber), shouldHighlight);
        }

        @Override
        public void currThreadDied() {
            assert (EventQueue.isDispatchThread());
            MainFrame.this._model.getDebugger().setAutomaticTraceEnabled(false);
            if (MainFrame.this._automaticTraceTimer != null) {
                MainFrame.this._automaticTraceTimer.stop();
            }
            MainFrame.this._disableStepTimer();
            if (MainFrame.this.isDebuggerReady()) {
                try {
                    if (!MainFrame.this._model.getDebugger().hasSuspendedThreads()) {
                        MainFrame.this._setThreadDependentDebugMenuItems(false);
                        MainFrame.this.removeCurrentLocationHighlight();
                        MainFrame.this._interactionsController.moveToPrompt();
                    }
                }
                catch (DebugException de) {
                    MainFrameStatics.showError(MainFrame.this, de, "Debugger Error", "Error with a thread in the debugger.");
                }
            }
        }

        @Override
        public void currThreadSet(DebugThreadData dtd) {
        }

        @Override
        public void regionAdded(Breakpoint bp) {
        }

        @Override
        public void breakpointReached(Breakpoint bp) {
            MainFrame.this.showTab(MainFrame.this._interactionsContainer, true);
        }

        @Override
        public void regionChanged(Breakpoint bp) {
        }

        @Override
        public void regionRemoved(Breakpoint bp) {
        }

        @Override
        public void watchSet(DebugWatchData w) {
        }

        @Override
        public void watchRemoved(DebugWatchData w) {
        }

        @Override
        public void threadStarted() {
        }

        @Override
        public void nonCurrThreadDied() {
        }
    }

    private static class GlassPane
    extends JComponent {
        public GlassPane() {
            this.addKeyListener(new KeyAdapter(){});
            this.addMouseListener(new MouseAdapter(){});
            super.setCursor(Cursor.getPredefinedCursor(3));
        }
    }

    private class PositionListener
    implements CaretListener {
        private volatile int _offset;
        private volatile int _line;
        private volatile int _col;

        private PositionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void caretUpdate(CaretEvent ce) {
            assert (EventQueue.isDispatchThread());
            int offset = ce.getDot();
            try {
                if (offset == this._offset + 1 && MainFrame.this._currentDefDoc.getText(this._offset, 1).charAt(0) != '\n') {
                    ++this._col;
                    ++this._offset;
                } else {
                    Element root = MainFrame.this._currentDefDoc.getDefaultRootElement();
                    int line = root.getElementIndex(offset);
                    this._line = line + 1;
                    this._col = offset - root.getElement(line).getStartOffset();
                }
            }
            catch (BadLocationException badLocationException) {
            }
            finally {
                this._offset = offset;
                this.updateLocation(this._line, this._col);
            }
        }

        public void updateLocation() {
            this._line = MainFrame.this._currentDefDoc.getCurrentLine();
            this._col = MainFrame.this._currentDefDoc.getCurrentCol();
            this.updateLocation(this._line, this._col);
        }

        private void updateLocation(int line, int col) {
            MainFrame.this._currLocationField.setText(line + ":" + col + " \t");
        }

        public int lastLine() {
            return this._line;
        }

        public int lastCol() {
            return this._col;
        }
    }

    static class MenuBar
    extends JMenuBar {
        private final MainFrame _mf;

        public MenuBar(MainFrame mf) {
            this._mf = mf;
        }

        @Override
        public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            if (this._mf.getAllowKeyEvents()) {
                return super.processKeyBinding(ks, e, condition, pressed);
            }
            return false;
        }
    }

    private static class OddDisplayManager
    implements DisplayManager<OpenDefinitionsDocument> {
        private final Icon _star;
        private final FileDisplayManager _default;

        public OddDisplayManager(FileDisplayManager fdm, Icon star, Icon junitPass, Icon junitFail) {
            this._star = star;
            this._default = fdm;
        }

        @Override
        public Icon getIcon(OpenDefinitionsDocument odd) {
            File f = null;
            try {
                f = odd.getFile();
            }
            catch (FileMovedException fileMovedException) {
                // empty catch block
            }
            if (odd.isModifiedSinceSave()) {
                return this.makeLayeredIcon(this._default.getIcon(f), this._star);
            }
            return this._default.getIcon(f);
        }

        @Override
        public String getName(OpenDefinitionsDocument doc) {
            return doc.getFileName();
        }

        private LayeredIcon makeLayeredIcon(Icon base, Icon star) {
            return new LayeredIcon(new Icon[]{base, star}, new int[]{0, 0}, new int[]{0, base.getIconHeight() / 4});
        }
    }

    private static class DJFileDisplayManager
    extends DefaultFileDisplayManager {
        private final Icon _java;
        private final Icon _dj0;
        private final Icon _dj1;
        private final Icon _dj2;
        private final Icon _dj;
        private final Icon _other;

        public DJFileDisplayManager(Icon java, Icon dj0, Icon dj1, Icon dj2, Icon dj, Icon other) {
            this._java = java;
            this._dj0 = dj0;
            this._dj1 = dj1;
            this._dj2 = dj2;
            this._dj = dj;
            this._other = other;
        }

        @Override
        public Icon getIcon(File f) {
            if (f == null) {
                return this._other;
            }
            Icon ret = null;
            if (!f.isDirectory()) {
                String name = f.getName().toLowerCase();
                if (name.endsWith(".java")) {
                    ret = this._java;
                } else if (name.endsWith(".dj")) {
                    ret = this._dj;
                } else if (name.endsWith(".dj0")) {
                    ret = this._dj0;
                } else if (name.endsWith(".dj1")) {
                    ret = this._dj1;
                } else if (name.endsWith(".dj2")) {
                    ret = this._dj2;
                }
            }
            if (ret == null && (ret = super.getIcon(f)).getIconHeight() < this._java.getIconHeight()) {
                ret = new CenteredIcon(ret, this._java.getIconWidth(), this._java.getIconHeight());
            }
            return ret;
        }
    }
}

