/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.DrJavaRestart;
import edu.rice.cs.drjava.Version;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.platform.PlatformFactory;
import edu.rice.cs.drjava.ui.MainFrame;
import edu.rice.cs.plt.concurrent.JVMBuilder;
import edu.rice.cs.plt.io.IOUtil;
import edu.rice.cs.plt.lambda.Box;
import edu.rice.cs.plt.lambda.LambdaUtil;
import edu.rice.cs.plt.lambda.Runnable1;
import edu.rice.cs.plt.lambda.SimpleBox;
import edu.rice.cs.plt.text.TextUtil;
import edu.rice.cs.util.FileOps;
import edu.rice.cs.util.Log;
import edu.rice.cs.util.swing.Utilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.TreeMap;
import java.util.jar.JarFile;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.ProgressMonitor;
import javax.swing.ProgressMonitorInputStream;
import javax.swing.border.EmptyBorder;

public class NewVersionPopup
extends JDialog {
    private JComboBox<String> _modeBox;
    private JButton _closeButton;
    private JButton _updateButton;
    private JButton _downloadButton;
    private MainFrame _mainFrame;
    private JOptionPane _versionPanel;
    private JPanel _bottomPanel;
    private static Date BUILD_TIME = Version.getBuildTime();
    private String[] _msg = null;
    private String _newestVersionString = "";
    private Action _closeAction = new AbstractAction("Close"){

        @Override
        public void actionPerformed(ActionEvent e) {
            NewVersionPopup.this.closeAction();
        }
    };
    private Action _updateAction = new AbstractAction("Automatic Update"){

        @Override
        public void actionPerformed(ActionEvent e) {
            NewVersionPopup.this.updateAction();
        }
    };
    private Action _downloadAction = new AbstractAction("Manual Download"){

        @Override
        public void actionPerformed(ActionEvent e) {
            NewVersionPopup.this.downloadAction();
        }
    };
    public static final Log LOG = new Log("version.txt", false);
    protected final Runnable1<WindowEvent> CANCEL = new Runnable1<WindowEvent>(){

        @Override
        public void run(WindowEvent e) {
            NewVersionPopup.this.closeAction();
        }
    };

    public NewVersionPopup(MainFrame parent) {
        super((Frame)parent, "Check for New Version of DrJava");
        this.setResizable(false);
        this._mainFrame = parent;
        this._mainFrame.setPopupLoc(this);
        this.setSize(500, 150);
        final ArrayList<String> choices = OptionConstants.NEW_VERSION_NOTIFICATION_CHOICES;
        int size = choices.size();
        this._modeBox = new JComboBox<String>(choices.toArray(new String[size]));
        for (int i = 0; i < size; ++i) {
            if (!DrJava.getConfig().getSetting(OptionConstants.NEW_VERSION_NOTIFICATION).equals(choices.get(i))) continue;
            this._modeBox.setSelectedIndex(i);
            break;
        }
        this._modeBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrJava.getConfig().setSetting(OptionConstants.NEW_VERSION_NOTIFICATION, choices.get(NewVersionPopup.this._modeBox.getSelectedIndex()));
                NewVersionPopup.access$102(NewVersionPopup.this, null);
                NewVersionPopup.this.updateText();
            }
        });
        this._updateButton = new JButton(this._updateAction);
        this._downloadButton = new JButton(this._downloadAction);
        this._closeButton = new JButton(this._closeAction);
        this._updateButton.setEnabled(false);
        this._downloadButton.setEnabled(false);
        this._bottomPanel = new JPanel(new BorderLayout());
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.add(this._updateButton);
        buttonPanel.add(this._downloadButton);
        buttonPanel.add(this._closeButton);
        this._bottomPanel.add((Component)buttonPanel, "Center");
        JPanel comboPanel = new JPanel();
        comboPanel.add(new JLabel("Check for: "));
        comboPanel.add(this._modeBox);
        this._bottomPanel.add((Component)comboPanel, "West");
        this.updateText();
    }

    private void updateText() {
        if (this._msg != null) {
            this._versionPanel = new JOptionPane(this._msg, 1, -1, null, new Object[0]);
            JPanel cp = new JPanel(new BorderLayout(5, 5));
            cp.setBorder(new EmptyBorder(5, 5, 5, 5));
            this.setContentPane(cp);
            cp.add((Component)this._versionPanel, "Center");
            cp.add((Component)this._bottomPanel, "South");
            this.getRootPane().setDefaultButton(this._closeButton);
            this.setTitle("Check for New Version of DrJava");
            this.pack();
            this._mainFrame.setPopupLoc(this);
            return;
        }
        this.setTitle("Checking for new versions, please wait...");
        String[] msg = new String[]{"Checking drjava.org for new versions.", "Please wait..."};
        this._versionPanel = new JOptionPane(msg, 1, -1, null, new Object[0]);
        JPanel cp = new JPanel(new BorderLayout(5, 5));
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(cp);
        cp.add((Component)this._versionPanel, "Center");
        cp.add((Component)this._bottomPanel, "South");
        this.getRootPane().setDefaultButton(this._closeButton);
        this.pack();
        this._mainFrame.setPopupLoc(this);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                NewVersionPopup.access$102(NewVersionPopup.this, NewVersionPopup.this.getMessage(null));
                NewVersionPopup.this._versionPanel = new JOptionPane(NewVersionPopup.this._msg, 1, -1, null, new Object[0]);
                JPanel cp = new JPanel(new BorderLayout(5, 5));
                cp.setBorder(new EmptyBorder(5, 5, 5, 5));
                NewVersionPopup.this.setContentPane(cp);
                cp.add((Component)NewVersionPopup.this._versionPanel, "Center");
                cp.add((Component)NewVersionPopup.this._bottomPanel, "South");
                NewVersionPopup.this.getRootPane().setDefaultButton(NewVersionPopup.this._closeButton);
                NewVersionPopup.this.setTitle("Check for New Version of DrJava");
                NewVersionPopup.this.pack();
                NewVersionPopup.this._mainFrame.setPopupLoc(NewVersionPopup.this);
            }
        });
    }

    protected void closeAction() {
        this.setVisible(false);
        this.dispose();
    }

    protected void downloadAction() {
        this.closeAction();
        this._openFileDownloadPage(this.getManualDownloadURL());
    }

    protected void abortUpdate() {
        this.abortUpdate("", false);
    }

    protected void abortUpdate(String message) {
        this.abortUpdate(message, false);
    }

    protected void abortUpdate(boolean close) {
        this.abortUpdate("", close);
    }

    protected void abortUpdate(String message, boolean close) {
        LOG.log(message);
        if (close) {
            this.closeAction();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Could not update DrJava automatically");
        if (message.length() > 0) {
            sb.append(":\n");
            sb.append(message);
        } else {
            sb.append('.');
        }
        sb.append("\nPlease download DrJava yourself.");
        JOptionPane.showMessageDialog(this, sb.toString(), "Error Updating DrJava", 0);
        this.downloadAction();
    }

    protected void updateAction() {
        JPanel cp = new JPanel(new BorderLayout(5, 5));
        cp.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(cp);
        cp.add((Component)new JOptionPane("Waiting for www.sourceforge.net ...", 1, -1, null, new Object[0]), "Center");
        JProgressBar pb = new JProgressBar(0, 100);
        pb.setIndeterminate(true);
        cp.add((Component)pb, "South");
        this.validate();
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<File> toCleanUp = new ArrayList<File>();
                try {
                    LOG.log("updateAction");
                    final File targetFile = FileOps.getDrJavaApplicationFile();
                    LOG.log("\ttargetFile = " + targetFile);
                    if (targetFile == null || targetFile.getParentFile() == null) {
                        NewVersionPopup.this.abortUpdate("Could not determine where DrJava is located on this computer.", true);
                        return;
                    }
                    String fileName = NewVersionPopup.this._newestVersionString;
                    int lastDotPos = fileName.length();
                    if (targetFile.toString().endsWith(".jar")) {
                        fileName = fileName + ".jar";
                    } else if (targetFile.toString().endsWith(".exe")) {
                        fileName = fileName + ".exe";
                    } else if (targetFile.toString().endsWith(".app")) {
                        fileName = fileName + "-osx.tar.gz";
                    } else {
                        NewVersionPopup.this.abortUpdate("Could not determine the file type to download.", true);
                        return;
                    }
                    LOG.log("\tfileName = " + fileName);
                    File destFile = FileOps.generateNewFileName(targetFile.getParentFile(), fileName.substring(0, lastDotPos), fileName.substring(lastDotPos));
                    toCleanUp.add(destFile);
                    LOG.log("Downloading to " + destFile);
                    File macTempDir = null;
                    File macTarFile = null;
                    if (fileName.endsWith("-osx.tar.gz")) {
                        macTarFile = new File("/usr/bin/tar");
                        LOG.log("Searching for " + macTarFile);
                        if (!macTarFile.exists()) {
                            String path = System.getenv("PATH");
                            for (String p : path.split(System.getProperty("path.separator"))) {
                                macTarFile = new File(p, "tar");
                                LOG.log("Searching for " + macTarFile);
                                if (macTarFile.exists()) break;
                            }
                            if (!macTarFile.exists()) {
                                NewVersionPopup.this.abortUpdate("Could not find tar on this computer.", true);
                                return;
                            }
                        }
                        macTempDir = FileOps.generateNewFileName(destFile.getParentFile(), NewVersionPopup.this._newestVersionString);
                    }
                    final File tempClassFile = File.createTempFile("drjavarestart-", ".jar");
                    toCleanUp.add(tempClassFile);
                    BufferedOutputStream tempClassOut = new BufferedOutputStream(new FileOutputStream(tempClassFile));
                    BufferedInputStream tempClassIn = new BufferedInputStream(new FileInputStream(FileOps.getDrJavaFile()));
                    IOUtil.copyInputStream(tempClassIn, tempClassOut);
                    tempClassIn.close();
                    tempClassOut.close();
                    LOG.log("Copied drjava.jar to " + tempClassFile);
                    URL fileURL = new URL(NewVersionPopup.this.getAutomaticDownloadURL() + fileName);
                    LOG.log("fileURL = " + fileURL);
                    URLConnection uc = fileURL.openConnection();
                    int length = uc.getContentLength();
                    InputStream in = uc.getInputStream();
                    ProgressMonitorInputStream pin = new ProgressMonitorInputStream(NewVersionPopup.this._mainFrame, "Downloading " + fileName + " ...", in);
                    ProgressMonitor pm = pin.getProgressMonitor();
                    pm.setMaximum(length);
                    pm.setMillisToDecideToPopup(0);
                    pm.setMillisToPopup(0);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NewVersionPopup.this.closeAction();
                        }
                    });
                    BufferedInputStream bin = new BufferedInputStream(pin);
                    BufferedOutputStream bout = new BufferedOutputStream(new FileOutputStream(destFile));
                    IOUtil.copyInputStream(bin, bout);
                    bin.close();
                    bout.close();
                    if (!destFile.exists() || destFile.length() != (long)length) {
                        NewVersionPopup.this.abortUpdate("Could not download update.");
                        return;
                    }
                    LOG.log("Downloaded to " + destFile);
                    if (fileName.endsWith("-osx.tar.gz")) {
                        macTempDir.mkdirs();
                        toCleanUp.add(macTempDir);
                        Process p = new ProcessBuilder(new String[0]).command(macTarFile.getAbsolutePath(), "xfz", destFile.getAbsolutePath()).directory(macTempDir).redirectErrorStream(true).start();
                        boolean waiting = false;
                        do {
                            try {
                                p.waitFor();
                                waiting = false;
                            }
                            catch (InterruptedException ie) {
                                NewVersionPopup.this.abortUpdate("Installation was interrupted.");
                                for (File f : toCleanUp) {
                                    IOUtil.deleteRecursively(f);
                                }
                                return;
                            }
                        } while (waiting);
                        if (p.exitValue() != 0) {
                            NewVersionPopup.this.abortUpdate("Unpacking with tar failed.");
                            return;
                        }
                        destFile.delete();
                        destFile = new File(macTempDir, "DrJava.app");
                        if (!destFile.exists() || !new File(destFile, "Contents/Resources/Java/drjava.jar").exists()) {
                            NewVersionPopup.this.abortUpdate("Downloaded file contained unexpected files.");
                            return;
                        }
                    } else {
                        JarFile jf = new JarFile(destFile);
                    }
                    toCleanUp.clear();
                    final File finalDestFile = destFile;
                    Thread restart = new Thread(){

                        @Override
                        public void run() {
                            try {
                                LOG.log("Restarting...");
                                Process p = JVMBuilder.DEFAULT.classPath(tempClassFile).start(DrJavaRestart.class.getName(), finalDestFile.getAbsolutePath(), targetFile.getAbsolutePath(), tempClassFile.getAbsolutePath());
                            }
                            catch (Exception e) {
                                LOG.log("Exception in shutdown hook: " + e);
                                tempClassFile.delete();
                                JOptionPane.showMessageDialog(null, "A new version of DrJava was downloaded. However,\nit could not be started automatically.\n\nThe new copy is now installed at:\n" + finalDestFile.getAbsolutePath() + "\n\n" + "The old copy is still installed at:\n" + targetFile.getAbsolutePath() + "\n\n" + "Please start DrJava manually.", "Error Updating DrJava", 0);
                            }
                        }
                    };
                    Runtime.getRuntime().addShutdownHook(restart);
                    Utilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            NewVersionPopup.this._mainFrame.quit();
                        }
                    });
                    Runtime.getRuntime().removeShutdownHook(restart);
                    tempClassFile.delete();
                    JOptionPane.showMessageDialog(NewVersionPopup.this._mainFrame, "A new version of DrJava was downloaded. However, you chose\nnot to restart DrJava, so the old version was not automatically\nreplaced.\n\nThe new copy is now installed at:\n" + finalDestFile.getAbsolutePath() + "\n\n" + "The old copy is still installed at:\n" + targetFile.getAbsolutePath());
                }
                catch (InterruptedIOException iie) {
                    return;
                }
                catch (IOException e) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            NewVersionPopup.this.abortUpdate("Error installing update:\n" + e.getMessage());
                        }
                    });
                }
                finally {
                    for (File f : toCleanUp) {
                        IOUtil.deleteRecursively(f);
                    }
                }
            }
        }).start();
    }

    protected String getAutomaticDownloadURL() {
        if (this._newestVersionString.indexOf("weekly") > 0) {
            return "http://www.cs.rice.edu/~javaplt/drjavarice/weekly/files/";
        }
        return "http://prdownloads.sourceforge.net/drjava/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getManualDownloadURL() {
        if (this._newestVersionString.indexOf("weekly") > 0) {
            return "http://www.cs.rice.edu/~javaplt/drjavarice/weekly/";
        }
        String DRJAVA_FILES_PAGE = "http://sourceforge.net/project/showfiles.php?group_id=44253";
        String LINK_PREFIX = "<a href=\"/project/showfiles.php?group_id=44253";
        String LINK_SUFFIX = "\">";
        BufferedReader br = null;
        try {
            URL url = new URL("http://sourceforge.net/project/showfiles.php?group_id=44253");
            InputStream urls = url.openStream();
            InputStreamReader is = new InputStreamReader(urls);
            br = new BufferedReader(is);
            while (true) {
                String line;
                if ((line = br.readLine()) != null) {
                    int suffixPos;
                    int pos = line.indexOf(this._newestVersionString);
                    if (pos < 0) continue;
                    int prePos = line.indexOf("<a href=\"/project/showfiles.php?group_id=44253");
                    if (prePos < 0 || prePos >= pos || (suffixPos = line.indexOf("\">", prePos)) < 0 || suffixPos + "\">".length() != pos) continue;
                    String versionLink = TextUtil.xmlUnescape(line.substring(prePos + "<a href=\"/project/showfiles.php?group_id=44253".length(), suffixPos));
                    String string = "http://sourceforge.net/project/showfiles.php?group_id=44253" + versionLink;
                    return string;
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            String string = "http://sourceforge.net/project/showfiles.php?group_id=44253";
            return string;
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (IOException e) {}
        }
        return "http://sourceforge.net/project/showfiles.php?group_id=44253";
    }

    private void _openFileDownloadPage(String url) {
        try {
            PlatformFactory.ONLY.openURL(new URL(url));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean checkNewVersion() {
        SimpleBox<Boolean> availableRef = new SimpleBox<Boolean>(false);
        this.getMessage(availableRef);
        return (Boolean)availableRef.value();
    }

    protected String[] getMessage(Box<Boolean> availableRef) {
        SimpleBox<String> stableString = new SimpleBox<String>("");
        SimpleBox<String> betaString = new SimpleBox<String>("");
        SimpleBox<String> devString = new SimpleBox<String>("");
        SimpleBox<String> weeklyString = new SimpleBox<String>("");
        SimpleBox<Date> stableTime = new SimpleBox<Date>(new Date(0L));
        SimpleBox<Date> betaTime = new SimpleBox<Date>(new Date(0L));
        SimpleBox<Date> devTime = new SimpleBox<Date>(new Date(0L));
        SimpleBox<Date> weeklyTime = new SimpleBox<Date>(new Date(0L));
        boolean newVersion = false;
        this._newestVersionString = "";
        if (availableRef != null) {
            availableRef.set(false);
        }
        switch (this._modeBox.getSelectedIndex()) {
            case 3: {
                if (FileOps.getDrJavaApplicationFile().toString().endsWith(".jar")) {
                    newVersion |= NewVersionPopup.checkNewWeeklyVersion(weeklyString, weeklyTime);
                }
            }
            case 2: {
                newVersion |= NewVersionPopup.checkNewDevVersion(devString, devTime);
            }
            case 1: {
                newVersion |= NewVersionPopup.checkNewBetaVersion(betaString, betaTime);
            }
            case 0: {
                this._updateButton.setEnabled(newVersion |= NewVersionPopup.checkNewStableVersion(stableString, stableTime));
                this._downloadButton.setEnabled(newVersion);
                DrJava.getConfig().setSetting(OptionConstants.LAST_NEW_VERSION_NOTIFICATION, new Date().getTime());
                if (availableRef != null) {
                    availableRef.set(newVersion);
                }
                if (newVersion) {
                    TreeMap versionSorter = new TreeMap();
                    versionSorter.put(stableTime.value(), new String[]{"stable release", (String)stableString.value()});
                    versionSorter.put(betaTime.value(), new String[]{"beta release", (String)betaString.value()});
                    versionSorter.put(devTime.value(), new String[]{"development release", (String)devString.value()});
                    versionSorter.put(weeklyTime.value(), new String[]{"weekly build", (String)weeklyString.value()});
                    String newestType = ((String[])versionSorter.get(versionSorter.lastKey()))[0];
                    this._newestVersionString = ((String[])versionSorter.get(versionSorter.lastKey()))[1];
                    return new String[]{"A new " + newestType + " has been found.", "The new version is: " + this._newestVersionString, "Do you want to download this new version?"};
                }
                if (availableRef != null) {
                    availableRef.set(false);
                }
                return new String[]{"No new version of DrJava has been found.", "You are using the newest version that matches your criterion."};
            }
        }
        this._updateButton.setEnabled(false);
        this._downloadButton.setEnabled(false);
        return new String[]{"Checking for new versions has been disabled.", "You can change this setting below."};
    }

    public static boolean checkNewStableVersion(Box<String> versionStringRef, Box<Date> buildTimeRef) {
        try {
            Date newestTime = NewVersionPopup.getBuildTime(new URL("http://www.drjava.org/LATEST_VERSION.TXT"), versionStringRef);
            if (newestTime == null) {
                return false;
            }
            if (buildTimeRef != null) {
                buildTimeRef.set(newestTime);
            }
            return BUILD_TIME.before(newestTime);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean checkNewBetaVersion(Box<String> versionStringRef, Box<Date> buildTimeRef) {
        try {
            Date newestTime = NewVersionPopup.getBuildTime(new URL("http://www.drjava.org/LATEST_BETA_VERSION.TXT"), versionStringRef);
            if (newestTime == null) {
                return false;
            }
            if (buildTimeRef != null) {
                buildTimeRef.set(newestTime);
            }
            return BUILD_TIME.before(newestTime);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean checkNewDevVersion(Box<String> versionStringRef, Box<Date> buildTimeRef) {
        try {
            Date newestTime = NewVersionPopup.getBuildTime(new URL("http://www.drjava.org/LATEST_DEV_VERSION.TXT"), versionStringRef);
            if (newestTime == null) {
                return false;
            }
            if (buildTimeRef != null) {
                buildTimeRef.set(newestTime);
            }
            return BUILD_TIME.before(newestTime);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static boolean checkNewWeeklyVersion(Box<String> versionStringRef, Box<Date> buildTimeRef) {
        try {
            Date newestTime = NewVersionPopup.getBuildTime(new URL("http://www.cs.rice.edu/~javaplt/drjavarice/weekly/LATEST_WEEKLY_VERSION.TXT"), versionStringRef);
            if (newestTime == null) {
                return false;
            }
            if (buildTimeRef != null) {
                buildTimeRef.set(newestTime);
            }
            return BUILD_TIME.before(newestTime);
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static Date getBuildTime(URL url) {
        return NewVersionPopup.getBuildTime(url, null);
    }

    public static Date getBuildTime(URL url, Box<String> versionStringRef) {
        try {
            int releasePos;
            InputStream urls = url.openStream();
            InputStreamReader is = null;
            BufferedReader br = null;
            is = new InputStreamReader(urls);
            br = new BufferedReader(is);
            String line = br.readLine();
            if (versionStringRef != null) {
                versionStringRef.set(line);
            }
            br.close();
            String DRJAVA_PREFIX = "drjava-";
            if (!line.startsWith("drjava-")) {
                return null;
            }
            line = line.substring("drjava-".length());
            String STABLE_PREFIX = "stable-";
            if (line.startsWith("stable-")) {
                line = line.substring("stable-".length());
            }
            String BETA_PREFIX = "beta-";
            if (line.startsWith("beta-")) {
                line = line.substring("beta-".length());
            }
            String WEEKLY_PREFIX = "weekly-";
            if (line.startsWith("weekly-")) {
                line = line.substring("weekly-".length());
            }
            if ((releasePos = line.indexOf("-r")) >= 0) {
                line = line.substring(0, releasePos);
            }
            return new SimpleDateFormat("yyyyMMdd z").parse(line + " GMT");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void setVisible(boolean vis) {
        assert (EventQueue.isDispatchThread());
        this.validate();
        if (vis) {
            this._mainFrame.hourglassOn();
            this._mainFrame.installModalWindowAdapter(this, LambdaUtil.NO_OP, this.CANCEL);
        } else {
            this._mainFrame.removeModalWindowAdapter(this);
            this._mainFrame.hourglassOff();
            this._mainFrame.toFront();
        }
        super.setVisible(vis);
    }

    static /* synthetic */ String[] access$102(NewVersionPopup x0, String[] x1) {
        x0._msg = x1;
        return x1;
    }
}

