/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.avail;

import edu.rice.cs.drjava.ui.avail.GUIAvailabilityListener;
import edu.rice.cs.drjava.ui.avail.GUIAvailabilityNotifier;
import java.util.HashSet;

public abstract class OrGUIAvailabilityListener
implements GUIAvailabilityListener {
    protected final HashSet<GUIAvailabilityListener.ComponentType> _components = new HashSet();
    protected final GUIAvailabilityNotifier _notifier;
    protected volatile boolean _lastValue = false;

    public OrGUIAvailabilityListener(GUIAvailabilityNotifier notifier, GUIAvailabilityListener.ComponentType ... components) {
        this._notifier = notifier;
        for (GUIAvailabilityListener.ComponentType c : components) {
            this._components.add(c);
            this._lastValue |= this._notifier.isAvailable(c);
        }
    }

    public boolean isAvailable() {
        for (GUIAvailabilityListener.ComponentType c : this._components) {
            if (!this._notifier.isAvailable(c)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void availabilityChanged(GUIAvailabilityListener.ComponentType component, boolean available) {
        boolean newValue;
        if (this._components.contains((Object)component) && this._lastValue != (newValue = this.isAvailable())) {
            this._lastValue = newValue;
            this.availabilityChanged(newValue);
        }
    }

    public abstract void availabilityChanged(boolean var1);
}

