/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.config.Option;
import edu.rice.cs.drjava.config.OptionConstants;
import edu.rice.cs.drjava.config.OptionParser;
import edu.rice.cs.util.StringOps;
import java.util.HashMap;

public class ConfigDescriptions {
    public static final HashMap<OptionParser<?>, String> CONFIG_DESCRIPTIONS = new HashMap();
    public static final HashMap<OptionParser<?>, String> CONFIG_LONG_DESCRIPTIONS = new HashMap();
    protected static final String SEPS = " \t\n-,;.(";

    public static void add(Option<?> o, String s, String l) {
        CONFIG_DESCRIPTIONS.put(o, s);
        CONFIG_LONG_DESCRIPTIONS.put(o, l);
    }

    static {
        ConfigDescriptions.add(OptionConstants.BROWSER_FILE, "Web Browser", "<html>Location of a web browser to use for Javadoc and Help links.<br>If left blank, only the Web Browser Command will be used.<br>This is not necessary if a default browser is available on your system.");
        ConfigDescriptions.add(OptionConstants.BROWSER_STRING, "Web Browser Command", "<html>Command to send to the web browser to view a web location.<br>The string <code>&lt;URL&gt;</code> will be replaced with the URL address.<br>This is not necessary if a default browser is available on your system.");
        ConfigDescriptions.add(OptionConstants.JAVAC_LOCATION, "Tools.jar Location", "Optional location of the JDK's tools.jar, which contains the compiler and debugger.");
        ConfigDescriptions.add(OptionConstants.DISPLAY_ALL_COMPILER_VERSIONS, "Display All Compiler Versions", "Display all compiler versions, even if they have the same major version.");
        ConfigDescriptions.add(OptionConstants.EXTRA_CLASSPATH, "Extra Classpath", "<html>Any directories or jar files to add to the classpath<br>of the Compiler and Interactions Pane.</html>");
        ConfigDescriptions.add(OptionConstants.LOOK_AND_FEEL, "Look and Feel", "Changes the general appearance of DrJava.");
        ConfigDescriptions.add(OptionConstants.PLASTIC_THEMES, "Plastic Theme", "Pick the theme to be used by the Plastic family of Look and Feels");
        ConfigDescriptions.add(OptionConstants.LINEENUM_ENABLED, "Show All Line Numbers", "Whether to show line numbers on the left side of the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.SHOW_SOURCE_WHEN_SWITCHING, "Show sample of source code when fast switching", "Whether to show a sample of the source code under the document's filename when fast switching documents.");
        ConfigDescriptions.add(OptionConstants.SHOW_CODE_PREVIEW_POPUPS, "Show Code Preview Popups", "<html>Whether to show a popup window with a code preview when the mouse is hovering<br>over an item in the Breakpoints, Bookmarks and Find All panes.</html>");
        ConfigDescriptions.add(OptionConstants.CLIPBOARD_HISTORY_SIZE, "Size of Clipboard History", "Determines how many entries are kept in the clipboard history.");
        ConfigDescriptions.add(OptionConstants.DIALOG_GOTOFILE_FULLY_QUALIFIED, "<html><p align=\"right\">" + StringOps.splitStringAtWordBoundaries("Display Fully-Qualified Class Names in \"Go to File\" Dialog", 40, "<br>", SEPS) + "</p></html>", "<html>Whether to also display fully-qualified class names in the \"Go to File\" dialog.<br>Enabling this option on network drives might cause the dialog to display after a slight delay.</html>");
        ConfigDescriptions.add(OptionConstants.DIALOG_COMPLETE_SCAN_CLASS_FILES, "<html><p align=\"right\">" + StringOps.splitStringAtWordBoundaries("Scan Class Files After Each Compile for Auto-Completion and Auto-Import", 40, "<br>", SEPS) + "</p></html>", "<html>Whether to scan the class files after a compile to generate class names<br>used for auto-completion and auto-import.<br>Enabling this option will slow compiles down.</html>");
        ConfigDescriptions.add(OptionConstants.DIALOG_COMPLETE_JAVAAPI, "<html><p align=\"right\">" + StringOps.splitStringAtWordBoundaries("Consider Java API Classes for Auto-Completion", 40, "<br>", SEPS) + "</p></html>", "Whether to use the names of the Java API classes for auto-completion as well.");
        ConfigDescriptions.add(OptionConstants.DISPLAY_RIGHT_MARGIN, "Display right margin", "Whether to display a line at the right margin.");
        ConfigDescriptions.add(OptionConstants.RIGHT_MARGIN_COLUMNS, "Right Margin Position", "The number of columns after which the right margin is displayed.");
        ConfigDescriptions.add(OptionConstants.FONT_MAIN, "Main Font", "The font used for most text in DrJava.");
        ConfigDescriptions.add(OptionConstants.FONT_LINE_NUMBERS, "Line Numbers Font", "<html>The font for displaying line numbers on the left side of<br>the Definitions Pane if Show All Line Numbers is enabled.<br>Cannot be displayed larger than the Main Font.</html>");
        ConfigDescriptions.add(OptionConstants.FONT_DOCLIST, "Document List Font", "The font used in the list of open documents.");
        ConfigDescriptions.add(OptionConstants.FONT_TOOLBAR, "Toolbar Font", "The font used in the toolbar buttons.");
        ConfigDescriptions.add(OptionConstants.TEXT_ANTIALIAS, "Use anti-aliased text", "Whether to graphically smooth the text.");
        ConfigDescriptions.add(OptionConstants.DEFINITIONS_NORMAL_COLOR, "Normal Color", "The default color for text in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEFINITIONS_KEYWORD_COLOR, "Keyword Color", "The color for Java keywords in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEFINITIONS_TYPE_COLOR, "Type Color", "The color for classes and types in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEFINITIONS_COMMENT_COLOR, "Comment Color", "The color for comments in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEFINITIONS_DOUBLE_QUOTED_COLOR, "Double-quoted Color", "The color for quoted strings (eg. \"...\") in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEFINITIONS_SINGLE_QUOTED_COLOR, "Single-quoted Color", "The color for quoted characters (eg. 'a') in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEFINITIONS_NUMBER_COLOR, "Number Color", "The color for numbers in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEFINITIONS_BACKGROUND_COLOR, "Background Color", "The background color of the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEFINITIONS_LINE_NUMBER_COLOR, "Line Number Color", "The color for line numbers in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEFINITIONS_LINE_NUMBER_BACKGROUND_COLOR, "Line Number Background Color", "The background color for line numbers in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEFINITIONS_MATCH_COLOR, "Brace-matching Color", "The color for matching brace highlights in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.COMPILER_ERROR_COLOR, "Compiler Error Color", "The color for compiler error highlights in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.BOOKMARK_COLOR, "Bookmark Color", "The color for bookmarks in the Definitions Pane.");
        for (int i = 0; i < OptionConstants.FIND_RESULTS_COLORS.length; ++i) {
            ConfigDescriptions.add(OptionConstants.FIND_RESULTS_COLORS[i], "Find Results Color " + (i + 1), "A color for highlighting find results in the Definitions Pane.");
        }
        ConfigDescriptions.add(OptionConstants.DEBUG_BREAKPOINT_COLOR, "Debugger Breakpoint Color", "The color for breakpoints in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEBUG_BREAKPOINT_DISABLED_COLOR, "Disabled Debugger Breakpoint Color", "The color for disabled breakpoints in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.DEBUG_THREAD_COLOR, "Debugger Location Color", "The color for the location of the current suspended thread in the Definitions Pane.");
        ConfigDescriptions.add(OptionConstants.SYSTEM_OUT_COLOR, "System.out Color", "The color for System.out in the Interactions and Console Panes.");
        ConfigDescriptions.add(OptionConstants.SYSTEM_ERR_COLOR, "System.err Color", "The color for System.err in the Interactions and Console Panes.");
        ConfigDescriptions.add(OptionConstants.SYSTEM_IN_COLOR, "System.in Color", "The color for System.in in the Interactions Pane.");
        ConfigDescriptions.add(OptionConstants.INTERACTIONS_ERROR_COLOR, "Interactions Error Color", "The color for interactions errors in the Interactions Pane.");
        ConfigDescriptions.add(OptionConstants.DEBUG_MESSAGE_COLOR, "Debug Message Color", "The color for debugger messages in the Interactions Pane.");
        ConfigDescriptions.add(OptionConstants.DRJAVA_ERRORS_BUTTON_COLOR, "DrJava Errors Button Background Color", "The background color of the \"Errors\" button used to show internal DrJava errors.");
        ConfigDescriptions.add(OptionConstants.RIGHT_MARGIN_COLOR, "Right Margin Color", "The color of the right margin line, if displayed.");
        ConfigDescriptions.add(OptionConstants.WINDOW_STORE_POSITION, "Save Main Window Position", "Whether to save and restore the size and position of the main window.");
        ConfigDescriptions.add(OptionConstants.DIALOG_CLIPBOARD_HISTORY_STORE_POSITION, "Save \"Clipboard History\" Dialog Position", "Whether to save and restore the size and position of the \"Clipboard History\" dialog.");
        ConfigDescriptions.add(OptionConstants.DIALOG_GOTOFILE_STORE_POSITION, "Save \"Go to File\" Dialog Position", "Whether to save and restore the size and position of the \"Go to File\" dialog.");
        ConfigDescriptions.add(OptionConstants.DIALOG_COMPLETE_WORD_STORE_POSITION, "Save \"Auto-Complete Word\" Dialog Position", "Whether to save and restore the size and position of the \"Auto-Complete Word\" dialog.");
        ConfigDescriptions.add(OptionConstants.DIALOG_JAROPTIONS_STORE_POSITION, "Save \"Create Jar File from Project\" Dialog Position", "Whether to save and restore the position of the \"Create Jar File from Project\" dialog.");
        ConfigDescriptions.add(OptionConstants.DIALOG_OPENJAVADOC_STORE_POSITION, "Save \"Open Javadoc\" Dialog Position", "Whether to save and restore the size and position of the \"Open Javadoc\" dialog.");
        ConfigDescriptions.add(OptionConstants.DIALOG_AUTOIMPORT_STORE_POSITION, "Save \"Auto Import\" Dialog Position", "Whether to save and restore the size and position of the \"Auto Import\" dialog.");
        ConfigDescriptions.add(OptionConstants.DIALOG_EXTERNALPROCESS_STORE_POSITION, "Save \"Execute External Process\" Dialog Position", "Whether to save and restore the position of the \"Execute External Process\" dialog.");
        ConfigDescriptions.add(OptionConstants.DIALOG_EDITEXTERNALPROCESS_STORE_POSITION, "Save \"Edit External Process\" Dialog Position", "Whether to save and restore the position of the \"Edit External Process\" dialog.");
        ConfigDescriptions.add(OptionConstants.DIALOG_OPENJAVADOC_STORE_POSITION, "Save \"Open Javadoc\" Dialog Position", "Whether to save and restore the position of the \"Open Javadoc\" dialog.");
        ConfigDescriptions.add(OptionConstants.DIALOG_TABBEDPANES_STORE_POSITION, "Save \"Tabbed Panes\" Window Position", "Whether to save and restore the position of the \"Tabbed Panes\" window.");
        ConfigDescriptions.add(OptionConstants.DETACH_TABBEDPANES, "Detach Tabbed Panes", "Whether to detach the tabbed panes and display them in a separate window.");
        ConfigDescriptions.add(OptionConstants.DIALOG_DEBUGFRAME_STORE_POSITION, "Save \"Debugger\" Window Position", "Whether to save and restore the position of the \"Debugger\" window.");
        ConfigDescriptions.add(OptionConstants.DETACH_DEBUGGER, "Detach Debugger", "Whether to detach the debugger and display it in a separate window.");
        ConfigDescriptions.add(OptionConstants.DEBUG_SOURCEPATH, "Sourcepath", "<html>Any directories in which to search for source<br>files when stepping in the Debugger.</html>");
        ConfigDescriptions.add(OptionConstants.DEBUG_STEP_JAVA, "Step Into Java Classes", "<html>Whether the Debugger should step into Java library classes,<br>including java.*, javax.*, sun.*, com.sun.*, com.apple.eawt.*, and com.apple.eio.*</html>");
        ConfigDescriptions.add(OptionConstants.DEBUG_STEP_INTERPRETER, "Step Into Interpreter Classes", "<html>Whether the Debugger should step into the classes<br>used by the Interactions Pane (DynamicJava).</html>");
        ConfigDescriptions.add(OptionConstants.DEBUG_STEP_DRJAVA, "Step Into DrJava Classes", "Whether the Debugger should step into DrJava's own class files.");
        ConfigDescriptions.add(OptionConstants.DEBUG_STEP_EXCLUDE, "Classes/Packages To Exclude", "<html>Any classes that the debuggger should not step into.<br>Should be a list of fully-qualified class names.<br>To exclude a package, add <code>packagename.*</code> to the list.</html>");
        ConfigDescriptions.add(OptionConstants.DEBUG_AUTO_IMPORT, "Auto-Import after Breakpoint/Step", "<html>Whether the Debugger should automatically import packages<br>and classes again after a breakpoint or step.</html>");
        ConfigDescriptions.add(OptionConstants.AUTO_STEP_RATE, "Auto-Step Rate in ms", "<html>A defined rate in ms at which the debugger automatically steps into/over each line of code.<br>Value entered must be an integer value. </html>");
        ConfigDescriptions.add(OptionConstants.DEBUG_EXPRESSIONS_AND_METHODS_IN_WATCHES, "Allow Expressions and Method Calls in Watches", "<html>Whether the Debugger should allow expressions and method<br>calls in watches. These may have side effects and can cause<br>delays during the debug process.</html>");
        ConfigDescriptions.add(OptionConstants.JAVADOC_API_REF_VERSION, "Java Version for \"Open Java API Javadoc\"", "Version of the Java API documentation to be used.");
        ConfigDescriptions.add(OptionConstants.JAVADOC_ACCESS_LEVEL, "Access Level", "<html>Fields and methods with access modifiers at this level<br>or higher will be included in the generated Javadoc.</html>");
        ConfigDescriptions.add(OptionConstants.JAVADOC_LINK_VERSION, "Java Version for Javadoc Links", "Version of Java for generating links to online Javadoc documentation.");
        ConfigDescriptions.add(OptionConstants.JAVADOC_1_5_LINK, "Javadoc 1.5 URL", "URL for the Java 1.5 API, for generating links to library classes.");
        ConfigDescriptions.add(OptionConstants.JAVADOC_1_6_LINK, "Javadoc 1.6 URL", "URL for the Java 1.6 API, for generating links to library classes.");
        ConfigDescriptions.add(OptionConstants.JAVADOC_1_7_LINK, "Javadoc 1.7 URL", "URL for the Java 1.7 API, for generating links to library classes.");
        ConfigDescriptions.add(OptionConstants.JUNIT_LINK, "JUnit URL", "URL for the JUnit API, for \"Open Java API Javadoc\".");
        ConfigDescriptions.add(OptionConstants.JAVADOC_ADDITIONAL_LINKS, "Additional Javadoc URLs", "<html>Additional URLs with Javadoc, for \"Open Java API Javadoc\"<br>and auto-completion.</html>");
        ConfigDescriptions.add(OptionConstants.JAVADOC_DESTINATION, "Default Destination Directory", "Optional default directory for saving Javadoc documentation.");
        ConfigDescriptions.add(OptionConstants.JAVADOC_CUSTOM_PARAMS, "Custom Javadoc Parameters", "Any extra flags or parameters to pass to Javadoc.");
        ConfigDescriptions.add(OptionConstants.QUIT_PROMPT, "Prompt Before Quit", "Whether DrJava should prompt the user before quitting.");
        ConfigDescriptions.add(OptionConstants.INTERACTIONS_RESET_PROMPT, "Prompt Before Resetting Interactions Pane", "<html>Whether DrJava should prompt the user before<br>manually resetting the interactions pane.</html>");
        ConfigDescriptions.add(OptionConstants.INTERACTIONS_EXIT_PROMPT, "Prompt if Interactions Pane Exits Unexpectedly", "<html>Whether DrJava should show a dialog box if a program<br>in the Interactions Pane exits without the user clicking Reset.</html>");
        ConfigDescriptions.add(OptionConstants.JAVADOC_PROMPT_FOR_DESTINATION, "Prompt for Javadoc Destination", "<html>Whether Javadoc should always prompt the user<br>to select a destination directory.</html>");
        ConfigDescriptions.add(OptionConstants.PROMPT_BEFORE_CLEAN, "Prompt before Cleaning Build Directory", "<html>Whether DrJava should prompt before cleaning the<br>build directory of a project</html>");
        ConfigDescriptions.add(OptionConstants.PROMPT_RENAME_LL_FILES, "Prompt to Rename Old Language Level Files When Saving", "<html>Whether DrJava should prompt the user to rename old language level files.<br>DrJava suggests to rename .dj0 and .dj1 files to .dj, and .dj2 files to .java.</html>");
        ConfigDescriptions.add(OptionConstants.ALWAYS_SAVE_BEFORE_COMPILE, "Automatically Save Before Compiling", "<html>Whether DrJava should automatically save before<br>recompiling or ask the user each time.</html>");
        ConfigDescriptions.add(OptionConstants.ALWAYS_COMPILE_BEFORE_JUNIT, "Automatically Compile Before Testing", "<html>Whether DrJava should automatically compile before<br>testing with JUnit or ask the user each time.</html>");
        ConfigDescriptions.add(OptionConstants.ALWAYS_SAVE_BEFORE_JAVADOC, "Automatically Save Before Generating Javadoc", "<html>Whether DrJava should automatically save before<br>generating Javadoc or ask the user each time.</html>");
        ConfigDescriptions.add(OptionConstants.ALWAYS_COMPILE_BEFORE_JAVADOC, "Automatically Compile Before Generating Javadoc", "<html>Whether DrJava should automatically compile before<br>generating Javadoc or ask the user each time.</html>");
        ConfigDescriptions.add(OptionConstants.WARN_BREAKPOINT_OUT_OF_SYNC, "Warn on Breakpoint if Out of Sync", "<html>Whether DrJava should warn the user if the class file<br>is out of sync before setting a breakpoint in that file.</html>");
        ConfigDescriptions.add(OptionConstants.WARN_DEBUG_MODIFIED_FILE, "Warn if Debugging Modified File", "<html>Whether DrJava should warn the user if the file being<br>debugged has been modified since its last save.</html>");
        ConfigDescriptions.add(OptionConstants.WARN_CHANGE_LAF, "Warn to Restart to Change Look and Feel", "<html>Whether DrJava should warn the user that look and feel<br>changes will not be applied until DrJava is restarted.</html>.");
        ConfigDescriptions.add(OptionConstants.WARN_CHANGE_THEME, "Warn to Restart to Change Theme", "<html>Whether DrJava should warn the user that theme<br>changes will not be applied until DrJava is restarted.</html>.");
        ConfigDescriptions.add(OptionConstants.WARN_CHANGE_DCP, "Warn to Restart to Change Default Compiler Preference", "<html>Whether DrJava should warn the user that default compiler preference<br>changes will not be applied until DrJava is restarted.</html>.");
        ConfigDescriptions.add(OptionConstants.WARN_CHANGE_MISC, "Warn to Restart to Change Preferences (other)", "<html>Whether DrJava should warn the user that preference<br>changes will not be applied until DrJava is restarted.</html>.");
        ConfigDescriptions.add(OptionConstants.WARN_CHANGE_INTERACTIONS, "Warn to Reset to Change Interactions", "<html>Whether DrJava should warn the user that preference<br>changes will not be applied until the Interactions Pane<br>is reset.</html>.");
        ConfigDescriptions.add(OptionConstants.WARN_PATH_CONTAINS_POUND, "Warn if File's Path Contains a '#' Symbol", "<html>Whether DrJava should warn the user if the file being<br>saved has a path that contains a '#' symbol.<br>Users cannot use such files in the Interactions Pane<br>because of a bug in Java.</html>");
        ConfigDescriptions.add(OptionConstants.DIALOG_DRJAVA_ERROR_POPUP_ENABLED, "Show a notification window when the first DrJava error occurs", "<html>Whether to show a notification window when the first DrJava error occurs.<br>If this is disabled, only the \"DrJava Error\" button will appear.</html>");
        ConfigDescriptions.add(OptionConstants.WARN_IF_COMPIZ, "Warn If Compiz Detected", "<html>Whether DrJava should warn the user if Compiz is running.<br>Compiz and Java Swing are incompatible and can lead to crashes.</html>");
        ConfigDescriptions.add(OptionConstants.DELETE_LL_CLASS_FILES, "Delete language level class files?", "Whether DrJava should delete class files in directories with language level files.");
        ConfigDescriptions.add(OptionConstants.NEW_VERSION_NOTIFICATION, "Check for new versions?", "Whether DrJava should check for new versions on drjava.org.");
        ConfigDescriptions.add(OptionConstants.NEW_VERSION_NOTIFICATION_DAYS, "Days between new version check", "The number of days between automatic new version checks.");
        ConfigDescriptions.add(OptionConstants.INDENT_LEVEL, "Indent Level", "The number of spaces to use for each level of indentation.");
        ConfigDescriptions.add(OptionConstants.RECENT_FILES_MAX_SIZE, "Recent Files List Size", "<html>The number of files to remember in<br>the recently used files list in the File menu.</html>");
        ConfigDescriptions.add(OptionConstants.BROWSER_HISTORY_MAX_SIZE, "Maximum Size of Browser History", "Determines how many entries are kept in the browser history.");
        ConfigDescriptions.add(OptionConstants.AUTO_CLOSE_COMMENTS, "Automatically Close Block Comments", "<html>Whether to automatically insert a closing comment tag (\"*/\")<br>when the enter key is pressed after typing a new block comment<br>tag (\"/*\" or \"/**\").</html>");
        String runWithAssertMsg = "<html>Whether to execute <code>assert</code> statements in classes running in the interactions pane.</html>";
        ConfigDescriptions.add(OptionConstants.RUN_WITH_ASSERT, "Enable Assert Statement Execution", runWithAssertMsg);
        ConfigDescriptions.add(OptionConstants.BACKUP_FILES, "Keep Emacs-style Backup Files", "<html>Whether DrJava should keep a backup copy of each file that<br>the user modifies, saved with a '~' at the end of the filename.</html>");
        ConfigDescriptions.add(OptionConstants.RESET_CLEAR_CONSOLE, "Clear Console After Interactions Reset", "Whether to clear the Console output after resetting the Interactions Pane.");
        ConfigDescriptions.add(OptionConstants.FIND_REPLACE_FOCUS_IN_DEFPANE, "Focus on the definitions pane after find/replace", "<html>Whether to focus on the definitions pane after executing a find/replace operation.<br>If this is not selected, the focus will be in the Find/Replace pane.</html>");
        ConfigDescriptions.add(OptionConstants.DRJAVA_USE_FORCE_QUIT, "Forcefully Quit DrJava", "<html>On some platforms, DrJava does not shut down properly when files are open<br>(namely tablet PCs). Check this option to force DrJava to close.</html>");
        ConfigDescriptions.add(OptionConstants.REMOTE_CONTROL_ENABLED, "Enable Remote Control", "<html>Whether DrJava should listen to a socket (see below) so it<br>can be remote controlled and told to open files.<br>(Changes will not be applied until DrJava is restarted.)</html>");
        ConfigDescriptions.add(OptionConstants.REMOTE_CONTROL_PORT, "Remote Control Port", "<html>A running instance of DrJava can be remote controlled and<br>told to open files. This specifies the port used for remote control.<br>(Changes will not be applied until DrJava is restarted.)</html>");
        ConfigDescriptions.add(OptionConstants.FOLLOW_FILE_DELAY, "Follow File Delay", "<html>The delay in milliseconds that has to elapse before DrJava will check<br>if a file that is being followed or the output of an external process has changed.</html>");
        ConfigDescriptions.add(OptionConstants.FOLLOW_FILE_LINES, "Maximum Lines in \"Follow File\" Window", "<html>The maximum number of lines to keep in a \"Follow File\"<br>or \"External Process\" pane. Enter 0 for unlimited.</html>");
        ConfigDescriptions.add(OptionConstants.MASTER_JVM_XMX, "Maximum Heap Size for Main JVM in MB", "The maximum heap the Main JVM can use. Select blank for default.");
        ConfigDescriptions.add(OptionConstants.MASTER_JVM_ARGS, "JVM Args for Main JVM", "The command-line arguments to pass to the Main JVM.");
        ConfigDescriptions.add(OptionConstants.SLAVE_JVM_XMX, "Maximum Heap Size for Interactions JVM in MB", "The maximum heap the Interactions JVM can use. Select blank for default");
        ConfigDescriptions.add(OptionConstants.SLAVE_JVM_ARGS, "JVM Args for Interactions JVM", "The command-line arguments to pass to the Interactions JVM.");
        ConfigDescriptions.add(OptionConstants.SHOW_UNCHECKED_WARNINGS, "Show Unchecked Warnings", "<html>Warn about unchecked conversions involving parameterized types.</html>");
        ConfigDescriptions.add(OptionConstants.SHOW_DEPRECATION_WARNINGS, "Show Deprecation Warnings", "<html>Warn about each use or override of a deprecated method, field, or class.</html>");
        ConfigDescriptions.add(OptionConstants.SHOW_PATH_WARNINGS, "Show Path Warnings", "<html>Warn about nonexistent members of the classpath and sourcepath.</html>");
        ConfigDescriptions.add(OptionConstants.SHOW_SERIAL_WARNINGS, "Show Serial Warnings", "<html>Warn about missing <code>serialVersionUID</code> definitions on serializable classes.</html>");
        ConfigDescriptions.add(OptionConstants.SHOW_FINALLY_WARNINGS, "Show Finally Warnings", "<html>Warn about <code>finally</code> clauses that cannot complete normally.</html>");
        ConfigDescriptions.add(OptionConstants.SHOW_FALLTHROUGH_WARNINGS, "Show Fall-Through Warnings", "<html>Warn about <code>switch</code> block cases that fall through to the next case.</html>");
        ConfigDescriptions.add(OptionConstants.COMPILER_PREFERENCE_CONTROL.evaluate(), "Compiler Preference", "Which compiler is prefered?");
        ConfigDescriptions.add(OptionConstants.FIXED_INTERACTIONS_DIRECTORY, "Interactions Working Directory", "<html>Working directory for the Interactions Pane (unless<br>a project working directory has been set).</html>");
        ConfigDescriptions.add(OptionConstants.STICKY_INTERACTIONS_DIRECTORY, "<html><p align=\"right\">" + StringOps.splitStringAtWordBoundaries("Restore last working directory of the Interactions pane on start up", 33, "<br>", SEPS), "<html>Whether to restore the last working directory of the Interaction pane on start up,<br>or to always use the value of the \"user.home\" Java property<br>(currently " + System.getProperty("user.home") + ").");
        ConfigDescriptions.add(OptionConstants.SMART_RUN_FOR_APPLETS_AND_PROGRAMS, "Smart Run Command", "<html>Whether the Run button and meni item should automatically detect<br>applets and ACM Java Task Force programs (subclasses of acm.program.Program).</html>");
        ConfigDescriptions.add(OptionConstants.HISTORY_MAX_SIZE, "Size of Interactions History", "The number of interactions to remember in the history.");
        ConfigDescriptions.add(OptionConstants.DIALOG_AUTOIMPORT_ENABLED, "Enable the \"Auto Import\" Dialog", "<html>Whether DrJava should open the \"Auto Import\" dialog when<br>an undefined class is encountered in the Interactions Pane.</html>");
        ConfigDescriptions.add(OptionConstants.INTERACTIONS_AUTO_IMPORT_CLASSES, "Classes to Auto-Import", "<html>List of classes to auto-import every time the<br>Interaction Pane is reset or started. Examples:<br><br>java.io.File<br>java.util.*</html>");
        ConfigDescriptions.add(OptionConstants.DYNAMICJAVA_ACCESS_CONTROL, "Enforce access control", "What kind of access control should DrJava enforce in the Interactions Pane?");
        ConfigDescriptions.add(OptionConstants.DYNAMICJAVA_REQUIRE_SEMICOLON, "Require Semicolon", "<html>Whether DrJava should require a semicolon at the<br>end of a statement in the Interactions Pane.</html>");
        ConfigDescriptions.add(OptionConstants.DYNAMICJAVA_REQUIRE_VARIABLE_TYPE, "Require Variable Type", "<html>Whether DrJava should require a variable type for<br>variable declarations in the Interactions Pane.</html>");
        ConfigDescriptions.add(OptionConstants.JUNIT_LOCATION_ENABLED, "Use external JUnit", "<html>If this is enabled, DrJava will use the JUnit configured<br>below under 'JUnit/ConcJUnit Location'. If it is disabled,<br>DrJava will use the JUnit that is built-in.</html>");
        ConfigDescriptions.add(OptionConstants.JUNIT_LOCATION, "JUnit/ConcJUnit Location", "<html>Optional location of the JUnit or ConcJUnit jar file.<br>(Changes will not be applied until the Interactions Pane<br>is reset.)</html>");
        ConfigDescriptions.add(OptionConstants.CONCJUNIT_CHECKS_ENABLED, "Enabled ConcJUnit Checks", "<html>The concurrent unit testing checks that should be performed.<br>'none' uses plain JUnit. ConcJUnit can also detect failures in<br>all threads ('all-threads'), detect threads that did not end in<br>time ('all-threads, join'), and threads that ended in time only<br>because they were lucky ('all-threads, nojoin, lucky).<br>The last setting requires a 'ConcJUnit Runtime Location' to be set.</html>");
        ConfigDescriptions.add(OptionConstants.RT_CONCJUNIT_LOCATION, "ConcJUnit Runtime Location", "<html>Optional location of the Java Runtime Library processed<br>to generate &quot;lucky&quot; warnings. If left blank, &quot;lucky&quot; warnings<br>will not be generated. This setting is deactivated if the path to<br>ConcJUnit has not been specified above.<br>(Changes will not be applied until the Interactions Pane is reset.)</html>");
        ConfigDescriptions.add(OptionConstants.FORCE_TEST_SUFFIX, "Require test classes in projects to end in \"Test\"", "Whether to force test classes in projects to end in \"Test\".");
        ConfigDescriptions.add(OptionConstants.LANGUAGE_LEVEL, "Language Level", "The language level DrJava currently uses.");
    }
}

