/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.drjava.ui.config;

import edu.rice.cs.drjava.DrJava;
import edu.rice.cs.drjava.config.FontOption;
import edu.rice.cs.drjava.ui.config.OptionComponent;
import edu.rice.cs.util.swing.FontChooser;
import edu.rice.cs.util.swing.SwingFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class FontOptionComponent
extends OptionComponent<Font, JPanel> {
    private final JButton _button = new JButton();
    private final JTextField _fontField;
    private final JPanel _panel;
    private volatile Font _font;

    public FontOptionComponent(FontOption opt, String text, SwingFrame parent) {
        super(opt, text, parent);
        this._button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FontOptionComponent.this.chooseFont();
            }
        });
        this._button.setText("...");
        this._button.setMaximumSize(new Dimension(10, 10));
        this._button.setMinimumSize(new Dimension(10, 10));
        this._fontField = new JTextField();
        this._fontField.setEditable(false);
        this._fontField.setBackground(Color.white);
        this._fontField.setHorizontalAlignment(0);
        this._panel = new JPanel(new BorderLayout());
        this._panel.add((Component)this._fontField, "Center");
        this._panel.add((Component)this._button, "East");
        this._font = (Font)DrJava.getConfig().getSetting(this._option);
        this._updateField(this._font);
        this.setComponent(this._panel);
    }

    public FontOptionComponent(FontOption opt, String text, SwingFrame parent, String description) {
        this(opt, text, parent);
        this.setDescription(description);
    }

    @Override
    public void setDescription(String description) {
        this._panel.setToolTipText(description);
        this._fontField.setToolTipText(description);
        this._label.setToolTipText(description);
    }

    private void _updateField(Font f) {
        this._fontField.setFont(f);
        this._fontField.setText(this._option.format(f));
    }

    public void chooseFont() {
        String oldText = this._fontField.getText();
        Font f = FontChooser.showDialog(this._parent, "Choose '" + this.getLabelText() + "'", this._font);
        if (f != null) {
            this._font = f;
            this._updateField(this._font);
            if (!oldText.equals(this._fontField.getText())) {
                this.notifyChangeListeners();
            }
        }
    }

    @Override
    public boolean updateConfig() {
        if (!this._font.equals(DrJava.getConfig().getSetting(this._option))) {
            DrJava.getConfig().setSetting(this._option, this._font);
        }
        return true;
    }

    @Override
    public void setValue(Font value) {
        this._font = value;
        this._updateField(value);
    }
}

