/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.interpreter;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.CheckerException;
import edu.rice.cs.dynamicjava.interpreter.ImportContext;
import edu.rice.cs.dynamicjava.interpreter.InterpreterException;
import edu.rice.cs.dynamicjava.interpreter.ParserException;
import edu.rice.cs.dynamicjava.interpreter.RuntimeBindings;
import edu.rice.cs.dynamicjava.interpreter.StatementChecker;
import edu.rice.cs.dynamicjava.interpreter.StatementEvaluator;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.plt.debug.DebugUtil;
import edu.rice.cs.plt.lambda.WrappedException;
import edu.rice.cs.plt.tuple.Option;
import edu.rice.cs.plt.tuple.Pair;
import java.io.StringReader;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.parser.wrapper.JavaCCParser;
import koala.dynamicjava.parser.wrapper.ParseError;
import koala.dynamicjava.tree.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Interpreter {
    private final Options _opt;
    private TypeContext _typeContext;
    private RuntimeBindings _bindings;

    public Interpreter(Options opt, TypeContext typeContext, RuntimeBindings bindings) {
        this._opt = opt;
        this._typeContext = typeContext;
        this._bindings = bindings;
        this._opt.typeSystem();
        new JavaCCParser(new StringReader(""), this._opt).parseStream();
    }

    public Interpreter(Options opt) {
        this(opt, new ImportContext(Interpreter.class.getClassLoader(), opt), RuntimeBindings.EMPTY);
    }

    public Interpreter(Options opt, ClassLoader loader) {
        this(opt, new ImportContext(loader, opt), RuntimeBindings.EMPTY);
    }

    public Option<Object> interpret(String code) throws InterpreterException {
        Iterable<Node> tree = this.parse(code);
        DebugUtil.debug.logValue("Parse result", tree);
        TypeContext tcResult = this.typeCheck(tree);
        DebugUtil.debug.log("Static phase successful");
        Pair<RuntimeBindings, Option<Object>> evalResult = this.evaluate(tree);
        this._typeContext = tcResult;
        this._bindings = evalResult.first();
        return evalResult.second();
    }

    private Iterable<Node> parse(String code) throws InterpreterException {
        try {
            return new JavaCCParser(new StringReader(code), this._opt).parseStream();
        }
        catch (ParseError e) {
            throw new ParserException(e);
        }
    }

    private TypeContext typeCheck(Iterable<Node> tree) throws InterpreterException {
        try {
            return new StatementChecker(this._typeContext, this._opt).checkList(tree);
        }
        catch (ExecutionError e) {
            throw new CheckerException(e);
        }
    }

    private Pair<RuntimeBindings, Option<Object>> evaluate(Iterable<Node> tree) throws InterpreterException {
        try {
            StatementEvaluator.Result r = new StatementEvaluator(this._bindings, this._opt).evaluateSequence(tree);
            return Pair.make(r.bindings(), r.value());
        }
        catch (WrappedException e) {
            if (e.getCause() instanceof InterpreterException) {
                throw (InterpreterException)e.getCause();
            }
            throw e;
        }
    }
}

