/*
 * Decompiled with CFR 0.152.
 */
package edu.rice.cs.dynamicjava.sourcechecker;

import edu.rice.cs.dynamicjava.Options;
import edu.rice.cs.dynamicjava.interpreter.CheckerException;
import edu.rice.cs.dynamicjava.interpreter.ClassChecker;
import edu.rice.cs.dynamicjava.interpreter.CompositeException;
import edu.rice.cs.dynamicjava.interpreter.InterpreterException;
import edu.rice.cs.dynamicjava.interpreter.StatementChecker;
import edu.rice.cs.dynamicjava.interpreter.TypeContext;
import edu.rice.cs.plt.collect.Relation;
import edu.rice.cs.plt.collect.UnindexedRelation;
import edu.rice.cs.plt.tuple.Pair;
import java.util.LinkedList;
import koala.dynamicjava.interpreter.NodeProperties;
import koala.dynamicjava.interpreter.error.ExecutionError;
import koala.dynamicjava.tree.CompilationUnit;
import koala.dynamicjava.tree.ImportDeclaration;
import koala.dynamicjava.tree.Node;
import koala.dynamicjava.tree.PackageDeclaration;
import koala.dynamicjava.tree.TypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompilationUnitChecker {
    private final TypeContext _context;
    private final Options _opt;

    public CompilationUnitChecker(TypeContext context, Options opt) {
        this._context = context;
        this._opt = opt;
    }

    public Relation<TypeDeclaration, ClassChecker> extractDeclarations(CompilationUnit u) throws InterpreterException {
        TypeContext c = this._context;
        PackageDeclaration pkg = u.getPackage();
        if (pkg != null) {
            c = c.setPackage(pkg.getName());
        }
        LinkedList<CheckerException> errors = new LinkedList<CheckerException>();
        for (ImportDeclaration imp : u.getImports()) {
            try {
                c = imp.acceptVisitor(new StatementChecker(c, this._opt));
            }
            catch (ExecutionError e) {
                errors.add(new CheckerException(e));
            }
        }
        if (!errors.isEmpty()) {
            throw new CompositeException(errors);
        }
        UnindexedRelation<TypeDeclaration, ClassChecker> results = UnindexedRelation.makeLinkedHashBased();
        ClassLoader loader = this._context.getClassLoader();
        for (Node decl : u.getDeclarations()) {
            if (decl instanceof TypeDeclaration) {
                ClassChecker checker = new ClassChecker(NodeProperties.getDJClass(decl), loader, c, this._opt);
                results.add(Pair.make((TypeDeclaration)decl, checker));
                continue;
            }
            throw new RuntimeException("Unrecognized compilation unit declaration");
        }
        return results;
    }
}

